from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class Specimen_ProcessingSchema:
    """
    A sample to be used for analysis.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A sample to be used for analysis.


        description: Textual description of procedure.

        procedure: A coded value specifying the procedure used to process the specimen.

        additive: Material used in the processing step.

        timeDateTime: A record of the time or period when the specimen processing occurred.  For
            example the time of sample fixation or the period of time the sample was in
            formalin.

        timePeriod: A record of the time or period when the specimen processing occurred.  For
            example the time of sample fixation or the period of time the sample was in
            formalin.

        """
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema

        if (
            max_recursion_limit
            and nesting_list.count("Specimen_Processing") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Specimen_Processing"]
        schema = StructType(
            [
                # Textual description of procedure.
                StructField("description", StringType(), True),
                # A coded value specifying the procedure used to process the specimen.
                StructField(
                    "procedure",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Material used in the processing step.
                StructField(
                    "additive",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A record of the time or period when the specimen processing occurred.  For
                # example the time of sample fixation or the period of time the sample was in
                # formalin.
                StructField("timeDateTime", StringType(), True),
                # A record of the time or period when the specimen processing occurred.  For
                # example the time of sample fixation or the period of time the sample was in
                # formalin.
                StructField(
                    "timePeriod",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
