from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import BooleanType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ImplementationGuide_ResourceSchema:
    """
    A set of rules of how FHIR is used to solve a particular problem. This
    resource is used to gather all the parts of an implementation guide into a
    logical whole and to publish a computable definition of all the parts.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A set of rules of how FHIR is used to solve a particular problem. This
        resource is used to gather all the parts of an implementation guide into a
        logical whole and to publish a computable definition of all the parts.


        example: Whether a resource is included in the guide as part of the rules defined by
            the guide, or just as an example of a resource that conforms to the rules
            and/or help implementers understand the intent of the guide.

        name: A human assigned name for the resource. All resources SHOULD have a name, but
            the name may be extracted from the resource (e.g. ValueSet.name).

        description: A description of the reason that a resource has been included in the
            implementation guide.

        acronym: A short code that may be used to identify the resource throughout the
            implementation guide.

        sourceUri: Where this resource is found.

        sourceReference: Where this resource is found.

        exampleFor: Another resource that this resource is an example for. This is mostly used for
            resources that are included as examples of StructureDefinitions.

        """
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema

        if (
            max_recursion_limit
            and nesting_list.count("ImplementationGuide_Resource")
            >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["ImplementationGuide_Resource"]
        schema = StructType(
            [
                # Whether a resource is included in the guide as part of the rules defined by
                # the guide, or just as an example of a resource that conforms to the rules
                # and/or help implementers understand the intent of the guide.
                StructField("example", BooleanType(), True),
                # A human assigned name for the resource. All resources SHOULD have a name, but
                # the name may be extracted from the resource (e.g. ValueSet.name).
                StructField("name", StringType(), True),
                # A description of the reason that a resource has been included in the
                # implementation guide.
                StructField("description", StringType(), True),
                # A short code that may be used to identify the resource throughout the
                # implementation guide.
                StructField("acronym", StringType(), True),
                # Where this resource is found.
                StructField("sourceUri", StringType(), True),
                # Where this resource is found.
                StructField(
                    "sourceReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Another resource that this resource is an example for. This is mostly used for
                # resources that are included as examples of StructureDefinitions.
                StructField(
                    "exampleFor",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
