from typing import List
from typing import Optional
from typing import Union

from pyspark.sql.types import ArrayType
from pyspark.sql.types import DataType
from pyspark.sql.types import StringType
from pyspark.sql.types import StructField
from pyspark.sql.types import StructType


# This file is auto-generated by generate_schema so do not edit manually
# noinspection PyPep8Naming
class ContractSchema:
    """
    A formal agreement between parties regarding the conduct of business, exchange
    of information or other matters.
    """

    # noinspection PyDefaultArgument
    @staticmethod
    def get_schema(
        max_nesting_depth: Optional[int] = 6,
        nesting_depth: int = 0,
        nesting_list: List[str] = [],
        max_recursion_limit: Optional[int] = 2,
        include_extension: Optional[bool] = False,
    ) -> Union[StructType, DataType]:
        """
        A formal agreement between parties regarding the conduct of business, exchange
        of information or other matters.


        resourceType: This is a Contract resource

        identifier: Unique identifier for this Contract.

        status: The status of the resource instance.

        issued: When this  Contract was issued.

        applies: Relevant time or time-period when this Contract is applicable.

        subject: The target entity impacted by or of interest to parties to the agreement.

        topic: The matter of concern in the context of this agreement.

        authority: A formally or informally recognized grouping of people, principals,
            organizations, or jurisdictions formed for the purpose of achieving some form
            of collective action such as the promulgation, administration and enforcement
            of contracts and policies.

        domain: Recognized governance framework or system operating with a circumscribed scope
            in accordance with specified principles, policies, processes or procedures for
            managing rights, actions, or behaviors of parties or principals relative to
            resources.

        type: Type of Contract such as an insurance policy, real estate contract, a will,
            power of attorny, Privacy or Security policy , trust framework agreement, etc.

        subType: More specific type or specialization of an overarching or more general
            contract such as auto insurance, home owner  insurance, prenupial agreement,
            Advanced-Directive, or privacy consent.

        action: Action stipulated by this Contract.

        actionReason: Reason for action stipulated by this Contract.

        decisionType: The type of decision made by a grantor with respect to an offer made by a
            grantee.

        contentDerivative: The minimal content derived from the basal information source at a specific
            stage in its lifecycle.

        securityLabel: A set of security labels that define which resources are controlled by this
            consent. If more than one label is specified, all resources must have all the
            specified labels.

        agent: An actor taking a role in an activity for which it can be assigned some degree
            of responsibility for the activity taking place.

        signer: Parties with legal standing in the Contract, including the principal parties,
            the grantor(s) and grantee(s), which are any person or organization bound by
            the contract, and any ancillary parties, which facilitate the execution of the
            contract such as a notary or witness.

        valuedItem: Contract Valued Item List.

        term: One or more Contract Provisions, which may be related and conveyed as a group,
            and may contain nested groups.

        bindingAttachment: Legally binding Contract: This is the signed and legally recognized
            representation of the Contract, which is considered the "source of truth" and
            which would be the basis for legal action related to enforcement of this
            Contract.

        bindingReference: Legally binding Contract: This is the signed and legally recognized
            representation of the Contract, which is considered the "source of truth" and
            which would be the basis for legal action related to enforcement of this
            Contract.

        friendly: The "patient friendly language" versionof the Contract in whole or in parts.
            "Patient friendly language" means the representation of the Contract and
            Contract Provisions in a manner that is readily accessible and understandable
            by a layperson in accordance with best practices for communication styles that
            ensure that those agreeing to or signing the Contract understand the roles,
            actions, obligations, responsibilities, and implication of the agreement.

        legal: List of Legal expressions or representations of this Contract.

        rule: List of Computable Policy Rule Language Representations of this Contract.

        """
        from spark_fhir_schemas.stu3.complex_types.identifier import IdentifierSchema
        from spark_fhir_schemas.stu3.complex_types.period import PeriodSchema
        from spark_fhir_schemas.stu3.complex_types.reference import ReferenceSchema
        from spark_fhir_schemas.stu3.complex_types.codeableconcept import (
            CodeableConceptSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.coding import CodingSchema
        from spark_fhir_schemas.stu3.complex_types.contract_agent import (
            Contract_AgentSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.contract_signer import (
            Contract_SignerSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.contract_valueditem import (
            Contract_ValuedItemSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.contract_term import (
            Contract_TermSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.attachment import AttachmentSchema
        from spark_fhir_schemas.stu3.complex_types.contract_friendly import (
            Contract_FriendlySchema,
        )
        from spark_fhir_schemas.stu3.complex_types.contract_legal import (
            Contract_LegalSchema,
        )
        from spark_fhir_schemas.stu3.complex_types.contract_rule import (
            Contract_RuleSchema,
        )

        if (
            max_recursion_limit
            and nesting_list.count("Contract") >= max_recursion_limit
        ) or (max_nesting_depth and nesting_depth >= max_nesting_depth):
            return StructType([StructField("id", StringType(), True)])
        # add my name to recursion list for later
        my_nesting_list: List[str] = nesting_list + ["Contract"]
        schema = StructType(
            [
                # This is a Contract resource
                StructField("resourceType", StringType(), True),
                # Unique identifier for this Contract.
                StructField(
                    "identifier",
                    IdentifierSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The status of the resource instance.
                StructField("status", StringType(), True),
                # When this  Contract was issued.
                StructField("issued", StringType(), True),
                # Relevant time or time-period when this Contract is applicable.
                StructField(
                    "applies",
                    PeriodSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The target entity impacted by or of interest to parties to the agreement.
                StructField(
                    "subject",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The matter of concern in the context of this agreement.
                StructField(
                    "topic",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # A formally or informally recognized grouping of people, principals,
                # organizations, or jurisdictions formed for the purpose of achieving some form
                # of collective action such as the promulgation, administration and enforcement
                # of contracts and policies.
                StructField(
                    "authority",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Recognized governance framework or system operating with a circumscribed scope
                # in accordance with specified principles, policies, processes or procedures for
                # managing rights, actions, or behaviors of parties or principals relative to
                # resources.
                StructField(
                    "domain",
                    ArrayType(
                        ReferenceSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Type of Contract such as an insurance policy, real estate contract, a will,
                # power of attorny, Privacy or Security policy , trust framework agreement, etc.
                StructField(
                    "type",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # More specific type or specialization of an overarching or more general
                # contract such as auto insurance, home owner  insurance, prenupial agreement,
                # Advanced-Directive, or privacy consent.
                StructField(
                    "subType",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Action stipulated by this Contract.
                StructField(
                    "action",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Reason for action stipulated by this Contract.
                StructField(
                    "actionReason",
                    ArrayType(
                        CodeableConceptSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # The type of decision made by a grantor with respect to an offer made by a
                # grantee.
                StructField(
                    "decisionType",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The minimal content derived from the basal information source at a specific
                # stage in its lifecycle.
                StructField(
                    "contentDerivative",
                    CodeableConceptSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # A set of security labels that define which resources are controlled by this
                # consent. If more than one label is specified, all resources must have all the
                # specified labels.
                StructField(
                    "securityLabel",
                    ArrayType(
                        CodingSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # An actor taking a role in an activity for which it can be assigned some degree
                # of responsibility for the activity taking place.
                StructField(
                    "agent",
                    ArrayType(
                        Contract_AgentSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Parties with legal standing in the Contract, including the principal parties,
                # the grantor(s) and grantee(s), which are any person or organization bound by
                # the contract, and any ancillary parties, which facilitate the execution of the
                # contract such as a notary or witness.
                StructField(
                    "signer",
                    ArrayType(
                        Contract_SignerSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Contract Valued Item List.
                StructField(
                    "valuedItem",
                    ArrayType(
                        Contract_ValuedItemSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # One or more Contract Provisions, which may be related and conveyed as a group,
                # and may contain nested groups.
                StructField(
                    "term",
                    ArrayType(
                        Contract_TermSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # Legally binding Contract: This is the signed and legally recognized
                # representation of the Contract, which is considered the "source of truth" and
                # which would be the basis for legal action related to enforcement of this
                # Contract.
                StructField(
                    "bindingAttachment",
                    AttachmentSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # Legally binding Contract: This is the signed and legally recognized
                # representation of the Contract, which is considered the "source of truth" and
                # which would be the basis for legal action related to enforcement of this
                # Contract.
                StructField(
                    "bindingReference",
                    ReferenceSchema.get_schema(
                        max_nesting_depth=max_nesting_depth,
                        nesting_depth=nesting_depth + 1,
                        nesting_list=my_nesting_list,
                        max_recursion_limit=max_recursion_limit,
                        include_extension=include_extension,
                    ),
                    True,
                ),
                # The "patient friendly language" versionof the Contract in whole or in parts.
                # "Patient friendly language" means the representation of the Contract and
                # Contract Provisions in a manner that is readily accessible and understandable
                # by a layperson in accordance with best practices for communication styles that
                # ensure that those agreeing to or signing the Contract understand the roles,
                # actions, obligations, responsibilities, and implication of the agreement.
                StructField(
                    "friendly",
                    ArrayType(
                        Contract_FriendlySchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # List of Legal expressions or representations of this Contract.
                StructField(
                    "legal",
                    ArrayType(
                        Contract_LegalSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
                # List of Computable Policy Rule Language Representations of this Contract.
                StructField(
                    "rule",
                    ArrayType(
                        Contract_RuleSchema.get_schema(
                            max_nesting_depth=max_nesting_depth,
                            nesting_depth=nesting_depth + 1,
                            nesting_list=my_nesting_list,
                            max_recursion_limit=max_recursion_limit,
                            include_extension=include_extension,
                        )
                    ),
                    True,
                ),
            ]
        )
        if not include_extension:
            schema.fields = [
                c
                if c.name != "extension"
                else StructField("extension", StringType(), True)
                for c in schema.fields
            ]
        return schema
