# -*- coding: utf-8 -*-
# ----  AUTO-GENERATED BY redox_lib_gen. DO NOT MODIFY MANUALLY!!  ---- #

from typing import List, Union

from pydantic import Field

from ..abstract_base import EventTypeAbstractModel, RedoxAbstractModel
from ..field_types import Number


class Administration(EventTypeAbstractModel):

    Meta: "AdministrationMeta" = Field(...)
    Patient: "AdministrationPatient" = Field(...)
    Vaccinations: List["AdministrationVaccination"] = Field(...)
    Visit: "AdministrationVisit" = Field(None)


class AdministrationMeta(RedoxAbstractModel):

    DataModel: str = Field(...)
    Destinations: List["AdministrationMetaDestination"] = Field(None)
    EventDateTime: Union[str, None] = Field(None)
    EventType: str = Field(...)
    FacilityCode: Union[str, None] = Field(None)
    Logs: List["AdministrationMetaLog"] = Field(None)
    Message: "AdministrationMetaMessage" = Field(None)
    Source: "AdministrationMetaSource" = Field(None)
    Test: Union[bool, None] = Field(None)
    Transmission: "AdministrationMetaTransmission" = Field(None)


class AdministrationMetaDestination(RedoxAbstractModel):

    ID: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class AdministrationMetaLog(RedoxAbstractModel):

    AttemptID: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)


class AdministrationMetaMessage(RedoxAbstractModel):

    ID: Union[Number, None] = Field(None)


class AdministrationMetaSource(RedoxAbstractModel):

    ID: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class AdministrationMetaTransmission(RedoxAbstractModel):

    ID: Union[Number, None] = Field(None)


class AdministrationPatient(RedoxAbstractModel):

    Consent: "AdministrationPatientConsent" = Field(None)
    Contacts: List["AdministrationPatientContact"] = Field(None)
    Demographics: "AdministrationPatientDemographics" = Field(None)
    Identifiers: List["AdministrationPatientIdentifier"] = Field(...)
    Notes: List[str] = Field(None)


class AdministrationPatientConsent(RedoxAbstractModel):

    EffectiveDate: Union[str, None] = Field(None)
    Notification: Union[str, None] = Field(None)
    Status: Union[str, None] = Field(None)


class AdministrationPatientContact(RedoxAbstractModel):

    Address: "AdministrationPatientContactAddress" = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    PhoneNumber: "AdministrationPatientContactPhoneNumber" = Field(None)
    RelationToPatient: Union[str, None] = Field(None)
    Roles: List[str] = Field(None)


class AdministrationPatientContactAddress(RedoxAbstractModel):

    City: Union[str, None] = Field(None)
    Country: Union[str, None] = Field(None)
    County: Union[str, None] = Field(None)
    State: Union[str, None] = Field(None)
    StreetAddress: Union[str, None] = Field(None)
    ZIP: Union[str, None] = Field(None)


class AdministrationPatientContactPhoneNumber(RedoxAbstractModel):

    Home: Union[str, None] = Field(None)
    Mobile: Union[str, None] = Field(None)
    Office: Union[str, None] = Field(None)


class AdministrationPatientDemographics(RedoxAbstractModel):

    Address: "AdministrationPatientDemographicsAddress" = Field(None)
    Citizenship: List[str] = Field(None)
    DOB: Union[str, None] = Field(None)
    DeathDateTime: Union[str, None] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    IsDeceased: Union[bool, None] = Field(None)
    IsHispanic: Union[bool, None] = Field(None)
    Language: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    MaritalStatus: Union[str, None] = Field(None)
    MiddleName: Union[str, None] = Field(None)
    PhoneNumber: "AdministrationPatientDemographicsPhoneNumber" = Field(None)
    Race: Union[str, None] = Field(None)
    Religion: Union[str, None] = Field(None)
    SSN: Union[str, None] = Field(None)
    Sex: Union[str, None] = Field(None)


class AdministrationPatientDemographicsAddress(RedoxAbstractModel):

    City: Union[str, None] = Field(None)
    Country: Union[str, None] = Field(None)
    County: Union[str, None] = Field(None)
    State: Union[str, None] = Field(None)
    StreetAddress: Union[str, None] = Field(None)
    ZIP: Union[str, None] = Field(None)


class AdministrationPatientDemographicsPhoneNumber(RedoxAbstractModel):

    Home: Union[str, None] = Field(None)
    Mobile: Union[str, None] = Field(None)
    Office: Union[str, None] = Field(None)


class AdministrationPatientIdentifier(RedoxAbstractModel):

    ID: str = Field(...)
    IDType: str = Field(...)


class AdministrationVaccination(RedoxAbstractModel):

    Action: str = Field(...)
    ClinicalInfo: List["AdministrationVaccinationClinicalInfo"] = Field(None)
    DateTime: str = Field(...)
    Dose: "AdministrationVaccinationDose" = Field(None)
    Location: "AdministrationVaccinationLocation" = Field(None)
    Notes: List[str] = Field(None)
    Order: "AdministrationVaccinationOrder" = Field(None)
    Product: "AdministrationVaccinationProduct" = Field(...)
    Provider: "AdministrationVaccinationProvider" = Field(None)
    RefusalReason: Union[str, None] = Field(None)
    Route: "AdministrationVaccinationRoute" = Field(None)
    Site: "AdministrationVaccinationSite" = Field(None)


class AdministrationVaccinationClinicalInfo(RedoxAbstractModel):

    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    CompletionDateTime: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    Notes: List[str] = Field(None)
    RelatedGroupID: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)
    Value: Union[str, None] = Field(None)
    ValueType: Union[str, None] = Field(None)


class AdministrationVaccinationDose(RedoxAbstractModel):

    Quantity: Union[str, None] = Field(None)
    Units: Union[str, None] = Field(None)


class AdministrationVaccinationLocation(RedoxAbstractModel):

    Department: Union[str, None] = Field(None)
    Facility: Union[str, None] = Field(None)
    Room: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class AdministrationVaccinationOrder(RedoxAbstractModel):

    EHRID: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    Provider: "AdministrationVaccinationOrderProvider" = Field(None)


class AdministrationVaccinationOrderProvider(RedoxAbstractModel):

    Address: "AdministrationVaccinationOrderProviderAddress" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "AdministrationVaccinationOrderProviderLocation" = Field(None)
    NPI: Union[str, None] = Field(None)
    PhoneNumber: "AdministrationVaccinationOrderProviderPhoneNumber" = Field(None)


class AdministrationVaccinationOrderProviderAddress(RedoxAbstractModel):

    City: Union[str, None] = Field(None)
    Country: Union[str, None] = Field(None)
    County: Union[str, None] = Field(None)
    State: Union[str, None] = Field(None)
    StreetAddress: Union[str, None] = Field(None)
    ZIP: Union[str, None] = Field(None)


class AdministrationVaccinationOrderProviderLocation(RedoxAbstractModel):

    Department: Union[str, None] = Field(None)
    Facility: Union[str, None] = Field(None)
    Room: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class AdministrationVaccinationOrderProviderPhoneNumber(RedoxAbstractModel):

    Office: Union[str, None] = Field(None)


class AdministrationVaccinationProduct(RedoxAbstractModel):

    Code: str = Field(...)
    Codeset: Union[str, None] = Field(None)
    Description: Union[str, None] = Field(None)
    ExpirationDate: Union[str, None] = Field(None)
    LotNumber: Union[str, None] = Field(None)
    Manufacturer: "AdministrationVaccinationProductManufacturer" = Field(None)


class AdministrationVaccinationProductManufacturer(RedoxAbstractModel):

    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class AdministrationVaccinationProvider(RedoxAbstractModel):

    Address: "AdministrationVaccinationProviderAddress" = Field(None)
    Credentials: List[str] = Field(None)
    EmailAddresses: List[str] = Field(None)
    FirstName: Union[str, None] = Field(None)
    ID: Union[str, None] = Field(None)
    IDType: Union[str, None] = Field(None)
    LastName: Union[str, None] = Field(None)
    Location: "AdministrationVaccinationProviderLocation" = Field(None)
    PhoneNumber: "AdministrationVaccinationProviderPhoneNumber" = Field(None)


class AdministrationVaccinationProviderAddress(RedoxAbstractModel):

    City: Union[str, None] = Field(None)
    Country: Union[str, None] = Field(None)
    County: Union[str, None] = Field(None)
    State: Union[str, None] = Field(None)
    StreetAddress: Union[str, None] = Field(None)
    ZIP: Union[str, None] = Field(None)


class AdministrationVaccinationProviderLocation(RedoxAbstractModel):

    Department: Union[str, None] = Field(None)
    Facility: Union[str, None] = Field(None)
    Room: Union[str, None] = Field(None)
    Type: Union[str, None] = Field(None)


class AdministrationVaccinationProviderPhoneNumber(RedoxAbstractModel):

    Office: Union[str, None] = Field(None)


class AdministrationVaccinationRoute(RedoxAbstractModel):

    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class AdministrationVaccinationSite(RedoxAbstractModel):

    Code: Union[str, None] = Field(None)
    Codeset: Union[str, None] = Field(None)
    Name: Union[str, None] = Field(None)


class AdministrationVisit(RedoxAbstractModel):

    AccountNumber: Union[str, None] = Field(None)
    VisitNumber: Union[str, None] = Field(None)


Administration.update_forward_refs()
AdministrationMeta.update_forward_refs()
AdministrationPatient.update_forward_refs()
AdministrationPatientContact.update_forward_refs()
AdministrationPatientDemographics.update_forward_refs()
AdministrationVaccination.update_forward_refs()
AdministrationVaccinationOrder.update_forward_refs()
AdministrationVaccinationOrderProvider.update_forward_refs()
AdministrationVaccinationProduct.update_forward_refs()
AdministrationVaccinationProvider.update_forward_refs()
