"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WaitOrder = exports.WaitOrderProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const bss_generated_1 = require("./bss.generated");
Object.defineProperty(exports, "WaitOrderProperty", { enumerable: true, get: function () { return bss_generated_1.RosWaitOrder; } });
/**
 * A ROS resource type:  `ALIYUN::BSS::WaitOrder`
 */
class WaitOrder extends ros.Resource {
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the properties of this ROS resource, which will be assigned to ROS resource.
     */
    /**
     * Create a new `ALIYUN::BSS::WaitOrder`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosWaitOrder = new bss_generated_1.RosWaitOrder(this, id, {
            cancelOnDelete: props.cancelOnDelete ? props.cancelOnDelete : true,
            orderIds: props.orderIds,
            waitForOrderProduced: props.waitForOrderProduced ? props.waitForOrderProduced : false,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosWaitOrder;
    }
}
exports.WaitOrder = WaitOrder;
//# sourceMappingURL=data:application/json;base64,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