from rest_framework.renderers import BrowsableAPIRenderer

from drf_camel_case.settings import api_settings
from drf_camel_case.util import camelize


class CamelCaseJSONRenderer(api_settings.RENDERER_CLASS):
    def render(self, data, *args, **kwargs):
        return super().render(
            camelize(data, **api_settings.JSON_UNDERSCOREIZE), *args, **kwargs
        )


class CamelCaseBrowsableAPIRenderer(BrowsableAPIRenderer):
    def render(self, data, *args, **kwargs):
        return super(CamelCaseBrowsableAPIRenderer, self).render(
            camelize(data, **api_settings.JSON_UNDERSCOREIZE), *args, **kwargs
        )
