# Generated by Django 5.0.6 on 2024-05-12 16:12

import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        ("aw", "0005_v0_0_18"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="AlertGlobal",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=100)),
                (
                    "alert_type",
                    models.PositiveSmallIntegerField(
                        choices=[(0, "E-Mail"), (1, "Plugin")], default=0
                    ),
                ),
                (
                    "jobs_all",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "condition",
                    models.PositiveSmallIntegerField(
                        choices=[(0, "Failure"), (1, "Success"), (2, "Always")],
                        default=0,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AlertGlobalJobMapping",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="AlertGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=100)),
                (
                    "alert_type",
                    models.PositiveSmallIntegerField(
                        choices=[(0, "E-Mail"), (1, "Plugin")], default=0
                    ),
                ),
                (
                    "jobs_all",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "condition",
                    models.PositiveSmallIntegerField(
                        choices=[(0, "Failure"), (1, "Success"), (2, "Always")],
                        default=0,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AlertGroupJobMapping",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="AlertPlugin",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=100)),
                ("executable", models.CharField(max_length=300)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AlertUser",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=100)),
                (
                    "alert_type",
                    models.PositiveSmallIntegerField(
                        choices=[(0, "E-Mail"), (1, "Plugin")], default=0
                    ),
                ),
                (
                    "jobs_all",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "condition",
                    models.PositiveSmallIntegerField(
                        choices=[(0, "Failure"), (1, "Success"), (2, "Always")],
                        default=0,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="AlertUserJobMapping",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="UserExtended",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "phone",
                    models.CharField(
                        blank=True, default=None, max_length=100, null=True
                    ),
                ),
                (
                    "description",
                    models.CharField(
                        blank=True, default=None, max_length=1000, null=True
                    ),
                ),
            ],
        ),
        migrations.RemoveConstraint(
            model_name="jobusercredentials",
            name="jobusercreds_user_name",
        ),
        migrations.RemoveField(
            model_name="jobexecution",
            name="user_credentials",
        ),
        migrations.AddField(
            model_name="job",
            name="credentials_category",
            field=models.CharField(blank=True, default=None, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name="jobusercredentials",
            name="category",
            field=models.CharField(blank=True, default=None, max_length=100, null=True),
        ),
        migrations.AddField(
            model_name="systemconfig",
            name="_enc_mail_pass",
            field=models.CharField(blank=True, default=None, max_length=500, null=True),
        ),
        migrations.AddField(
            model_name="systemconfig",
            name="mail_sender",
            field=models.CharField(blank=True, default=None, max_length=300, null=True),
        ),
        migrations.AddField(
            model_name="systemconfig",
            name="mail_server",
            field=models.CharField(
                blank=True, default="127.0.0.1:25", max_length=300, null=True
            ),
        ),
        migrations.AddField(
            model_name="systemconfig",
            name="mail_ssl_verify",
            field=models.BooleanField(
                choices=[(True, "Yes"), (False, "No")], default=True
            ),
        ),
        migrations.AddField(
            model_name="systemconfig",
            name="mail_transport",
            field=models.PositiveSmallIntegerField(
                choices=[(0, "Unencrypted"), (1, "SSL"), (2, "StartTLS")], default=0
            ),
        ),
        migrations.AddField(
            model_name="systemconfig",
            name="mail_user",
            field=models.CharField(blank=True, default=None, max_length=300, null=True),
        ),
        migrations.AddField(
            model_name="systemconfig",
            name="path_template",
            field=models.CharField(blank=True, default=None, max_length=500, null=True),
        ),
        migrations.AddField(
            model_name="alertglobaljobmapping",
            name="alert",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.alertglobal"
            ),
        ),
        migrations.AddField(
            model_name="alertglobaljobmapping",
            name="job",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.job"
            ),
        ),
        migrations.AddField(
            model_name="alertglobal",
            name="jobs",
            field=models.ManyToManyField(
                through="aw.AlertGlobalJobMapping", to="aw.job"
            ),
        ),
        migrations.AddField(
            model_name="alertgroup",
            name="group",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="alertgrp_fk_group",
                to="auth.group",
            ),
        ),
        migrations.AddField(
            model_name="alertgroupjobmapping",
            name="alert",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.alertgroup"
            ),
        ),
        migrations.AddField(
            model_name="alertgroupjobmapping",
            name="job",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.job"
            ),
        ),
        migrations.AddField(
            model_name="alertgroup",
            name="jobs",
            field=models.ManyToManyField(
                through="aw.AlertGroupJobMapping", to="aw.job"
            ),
        ),
        migrations.AddField(
            model_name="alertgroup",
            name="plugin",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="alertgrp_fk_plugin",
                to="aw.alertplugin",
            ),
        ),
        migrations.AddField(
            model_name="alertglobal",
            name="plugin",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="alertglob_fk_plugin",
                to="aw.alertplugin",
            ),
        ),
        migrations.AddField(
            model_name="alertuser",
            name="plugin",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="alertuser_fk_plugin",
                to="aw.alertplugin",
            ),
        ),
        migrations.AddField(
            model_name="alertuser",
            name="user",
            field=models.ForeignKey(
                editable=False,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="alertuser_fk_user",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="alertuserjobmapping",
            name="alert",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.alertuser"
            ),
        ),
        migrations.AddField(
            model_name="alertuserjobmapping",
            name="job",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.job"
            ),
        ),
        migrations.AddField(
            model_name="alertuser",
            name="jobs",
            field=models.ManyToManyField(through="aw.AlertUserJobMapping", to="aw.job"),
        ),
        migrations.AddField(
            model_name="userextended",
            name="user",
            field=models.OneToOneField(
                on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddConstraint(
            model_name="alertglobaljobmapping",
            constraint=models.UniqueConstraint(
                fields=("job", "alert"), name="alertglobjobmmap_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="alertgroupjobmapping",
            constraint=models.UniqueConstraint(
                fields=("job", "alert"), name="alertgrpjobmmap_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="alertgroup",
            constraint=models.UniqueConstraint(
                fields=("name",), name="alertgrp_name_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="alertglobal",
            constraint=models.UniqueConstraint(
                fields=("name",), name="alertglob_name_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="alertuserjobmapping",
            constraint=models.UniqueConstraint(
                fields=("job", "alert"), name="alertuserjobmmap_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="alertuser",
            constraint=models.UniqueConstraint(
                fields=("name", "user"), name="alertuser_name_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="userextended",
            constraint=models.UniqueConstraint(
                fields=("user",), name="user_extended_unique"
            ),
        ),
    ]
