# Generated by Django 5.0.2 on 2024-02-24 09:45

import aw.model.job
import django.db.models.deletion
import django.utils.timezone
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="Job",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "limit",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "verbosity",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Default"),
                            (1, "v"),
                            (2, "vv"),
                            (3, "vvv"),
                            (4, "vvvv"),
                            (5, "vvvv"),
                            (6, "vvvvvv"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "comment",
                    models.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                (
                    "mode_diff",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "mode_check",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "environment_vars",
                    models.CharField(
                        blank=True, default=None, max_length=1000, null=True
                    ),
                ),
                (
                    "tags",
                    models.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                (
                    "tags_skip",
                    models.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                (
                    "cmd_args",
                    models.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                ("name", models.CharField(max_length=150)),
                ("inventory_file", models.CharField(max_length=300)),
                ("playbook_file", models.CharField(max_length=100)),
                (
                    "schedule",
                    models.CharField(
                        blank=True,
                        default=None,
                        max_length=50,
                        null=True,
                        validators=[aw.model.job.validate_cronjob],
                    ),
                ),
                (
                    "enabled",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=True
                    ),
                ),
                (
                    "credentials_needed",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="JobCredentialsPermissionMapping",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="JobError",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("short", models.CharField(max_length=100)),
                ("med", models.TextField(max_length=1024, null=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="JobGlobalCredentials",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=100)),
                (
                    "connect_user",
                    models.CharField(
                        blank=True, default=None, max_length=100, null=True
                    ),
                ),
                ("become_user", models.CharField(default="root", max_length=100)),
                (
                    "vault_file",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
                (
                    "vault_id",
                    models.CharField(
                        blank=True, default=None, max_length=50, null=True
                    ),
                ),
                (
                    "_enc_vault_pass",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "_enc_become_pass",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "_enc_connect_pass",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "_enc_ssh_key",
                    models.CharField(
                        blank=True, default=None, max_length=5000, null=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="JobPermission",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=100)),
                (
                    "permission",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "None"),
                            (5, "Read"),
                            (10, "Execute"),
                            (15, "Write"),
                            (20, "Full"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "jobs_all",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "credentials_all",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "repositories_all",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="JobPermissionMapping",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="JobPermissionMemberGroup",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="JobPermissionMemberUser",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="JobQueue",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="JobRepositoryPermissionMapping",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
            ],
        ),
        migrations.CreateModel(
            name="JobUserCredentials",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=100)),
                (
                    "connect_user",
                    models.CharField(
                        blank=True, default=None, max_length=100, null=True
                    ),
                ),
                ("become_user", models.CharField(default="root", max_length=100)),
                (
                    "vault_file",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
                (
                    "vault_id",
                    models.CharField(
                        blank=True, default=None, max_length=50, null=True
                    ),
                ),
                (
                    "_enc_vault_pass",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "_enc_become_pass",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "_enc_connect_pass",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "_enc_ssh_key",
                    models.CharField(
                        blank=True, default=None, max_length=5000, null=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Repository",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                ("name", models.CharField(max_length=100)),
                (
                    "rtype",
                    models.PositiveSmallIntegerField(
                        choices=[(1, "Static"), (2, "Git")]
                    ),
                ),
                (
                    "time_update",
                    models.DateTimeField(blank=True, default=None, null=True),
                ),
                (
                    "status",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Waiting"),
                            (1, "Starting"),
                            (2, "Running"),
                            (3, "Failed"),
                            (4, "Finished"),
                            (5, "Stopping"),
                            (6, "Stopped"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "log_stdout",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
                (
                    "log_stderr",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
                (
                    "static_path",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "git_origin",
                    models.CharField(
                        blank=True, default=None, max_length=100, null=True
                    ),
                ),
                (
                    "git_branch",
                    models.CharField(
                        blank=True, default=None, max_length=100, null=True
                    ),
                ),
                (
                    "git_isolate",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "git_lfs",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "git_limit_depth",
                    models.PositiveIntegerField(blank=True, default=None, null=True),
                ),
                (
                    "git_hook_pre",
                    models.CharField(
                        blank=True, default=None, max_length=1000, null=True
                    ),
                ),
                (
                    "git_hook_post",
                    models.CharField(
                        blank=True, default=None, max_length=1000, null=True
                    ),
                ),
                (
                    "git_override_initialize",
                    models.CharField(
                        blank=True, default=None, max_length=1000, null=True
                    ),
                ),
                (
                    "git_override_update",
                    models.CharField(
                        blank=True, default=None, max_length=1000, null=True
                    ),
                ),
                (
                    "git_playbook_base",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="SystemConfig",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "path_run",
                    models.CharField(default="/tmp/ansible-webui", max_length=500),
                ),
                ("path_play", models.CharField(default=None, max_length=500)),
                ("path_log", models.CharField(default=None, max_length=500)),
                ("timezone", models.CharField(default="CET", max_length=300)),
                ("run_timeout", models.PositiveIntegerField(default=3600)),
                ("session_timeout", models.PositiveIntegerField(default=43200)),
                (
                    "path_ansible_config",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "path_ssh_known_hosts",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "debug",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "logo_url",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AwAPIKey",
            fields=[
                (
                    "id",
                    models.CharField(
                        editable=False,
                        max_length=150,
                        primary_key=True,
                        serialize=False,
                        unique=True,
                    ),
                ),
                ("prefix", models.CharField(editable=False, max_length=8, unique=True)),
                ("hashed_key", models.CharField(editable=False, max_length=150)),
                ("created", models.DateTimeField(auto_now_add=True, db_index=True)),
                (
                    "name",
                    models.CharField(
                        default=None,
                        help_text="A free-form name for the API key. Need not be unique. 50 characters max.",
                        max_length=50,
                    ),
                ),
                (
                    "revoked",
                    models.BooleanField(
                        blank=True,
                        default=False,
                        help_text="If the API key is revoked, clients cannot use it anymore. (This cannot be undone.)",
                    ),
                ),
                (
                    "expiry_date",
                    models.DateTimeField(
                        blank=True,
                        help_text="Once API key expires, clients cannot use it anymore.",
                        null=True,
                        verbose_name="Expires",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        editable=False,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "API key",
                "verbose_name_plural": "API keys",
                "ordering": ("-created",),
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="JobExecutionResult",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("time_start", models.DateTimeField(default=django.utils.timezone.now)),
                ("time_fin", models.DateTimeField(blank=True, default=None, null=True)),
                (
                    "failed",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "error",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="jobresult_fk_error",
                        to="aw.joberror",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="JobExecution",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("updated", models.DateTimeField(auto_now=True)),
                (
                    "limit",
                    models.CharField(
                        blank=True, default=None, max_length=500, null=True
                    ),
                ),
                (
                    "verbosity",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Default"),
                            (1, "v"),
                            (2, "vv"),
                            (3, "vvv"),
                            (4, "vvvv"),
                            (5, "vvvv"),
                            (6, "vvvvvv"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "comment",
                    models.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                (
                    "mode_diff",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "mode_check",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                (
                    "environment_vars",
                    models.CharField(
                        blank=True, default=None, max_length=1000, null=True
                    ),
                ),
                (
                    "tags",
                    models.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                (
                    "tags_skip",
                    models.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                (
                    "cmd_args",
                    models.CharField(
                        blank=True, default=None, max_length=150, null=True
                    ),
                ),
                (
                    "status",
                    models.PositiveSmallIntegerField(
                        choices=[
                            (0, "Waiting"),
                            (1, "Starting"),
                            (2, "Running"),
                            (3, "Failed"),
                            (4, "Finished"),
                            (5, "Stopping"),
                            (6, "Stopped"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "log_stdout",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
                (
                    "log_stderr",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
                (
                    "log_stdout_repo",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
                (
                    "log_stderr_repo",
                    models.CharField(
                        blank=True, default=None, max_length=300, null=True
                    ),
                ),
                (
                    "command",
                    models.CharField(
                        blank=True, default=None, max_length=1000, null=True
                    ),
                ),
                (
                    "job",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="jobexec_fk_job",
                        to="aw.job",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="jobexec_fk_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "user_credentials",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="jobexec_fk_usercreds",
                        to="aw.job",
                    ),
                ),
                (
                    "result",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="jobexec_fk_result",
                        to="aw.jobexecutionresult",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="JobExecutionResultHost",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("created", models.DateTimeField(auto_now_add=True)),
                ("hostname", models.CharField(max_length=300)),
                (
                    "unreachable",
                    models.BooleanField(
                        choices=[(True, "Yes"), (False, "No")], default=False
                    ),
                ),
                ("tasks_skipped", models.PositiveSmallIntegerField(default=0)),
                ("tasks_ok", models.PositiveSmallIntegerField(default=0)),
                ("tasks_failed", models.PositiveSmallIntegerField(default=0)),
                ("tasks_rescued", models.PositiveSmallIntegerField(default=0)),
                ("tasks_ignored", models.PositiveSmallIntegerField(default=0)),
                ("tasks_changed", models.PositiveSmallIntegerField(default=0)),
                (
                    "error",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="jobresulthost_fk_error",
                        to="aw.joberror",
                    ),
                ),
                (
                    "result",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="jobresulthost_fk_result",
                        to="aw.jobexecutionresult",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddConstraint(
            model_name="jobglobalcredentials",
            constraint=models.UniqueConstraint(fields=("name",), name="jobcreds_name"),
        ),
        migrations.AddField(
            model_name="jobexecution",
            name="credential_global",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="jobexec_fk_credglob",
                to="aw.jobglobalcredentials",
            ),
        ),
        migrations.AddField(
            model_name="jobcredentialspermissionmapping",
            name="credentials",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="aw.jobglobalcredentials",
            ),
        ),
        migrations.AddField(
            model_name="job",
            name="credentials_default",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="job_fk_creddflt",
                to="aw.jobglobalcredentials",
            ),
        ),
        migrations.AddField(
            model_name="jobpermission",
            name="credentials",
            field=models.ManyToManyField(
                through="aw.JobCredentialsPermissionMapping",
                to="aw.jobglobalcredentials",
            ),
        ),
        migrations.AddField(
            model_name="jobcredentialspermissionmapping",
            name="permission",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.jobpermission"
            ),
        ),
        migrations.AddField(
            model_name="jobpermissionmapping",
            name="job",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.job"
            ),
        ),
        migrations.AddField(
            model_name="jobpermissionmapping",
            name="permission",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.jobpermission"
            ),
        ),
        migrations.AddField(
            model_name="jobpermission",
            name="jobs",
            field=models.ManyToManyField(
                through="aw.JobPermissionMapping", to="aw.job"
            ),
        ),
        migrations.AddField(
            model_name="jobpermissionmembergroup",
            name="group",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="auth.group"
            ),
        ),
        migrations.AddField(
            model_name="jobpermissionmembergroup",
            name="permission",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.jobpermission"
            ),
        ),
        migrations.AddField(
            model_name="jobpermission",
            name="groups",
            field=models.ManyToManyField(
                through="aw.JobPermissionMemberGroup", to="auth.group"
            ),
        ),
        migrations.AddField(
            model_name="jobpermissionmemberuser",
            name="permission",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.jobpermission"
            ),
        ),
        migrations.AddField(
            model_name="jobpermissionmemberuser",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddField(
            model_name="jobpermission",
            name="users",
            field=models.ManyToManyField(
                through="aw.JobPermissionMemberUser", to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddField(
            model_name="jobqueue",
            name="job",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="jobqueue_fk_job",
                to="aw.job",
            ),
        ),
        migrations.AddField(
            model_name="jobqueue",
            name="user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="jobqueue_fk_user",
                to=settings.AUTH_USER_MODEL,
            ),
        ),
        migrations.AddField(
            model_name="jobrepositorypermissionmapping",
            name="permission",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.jobpermission"
            ),
        ),
        migrations.AddField(
            model_name="jobusercredentials",
            name="user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL
            ),
        ),
        migrations.AddField(
            model_name="jobexecution",
            name="credential_user",
            field=models.ForeignKey(
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="jobexec_fk_credusr",
                to="aw.jobusercredentials",
            ),
        ),
        migrations.AddField(
            model_name="repository",
            name="git_credentials",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="repo_fk_cred",
                to="aw.jobglobalcredentials",
            ),
        ),
        migrations.AddField(
            model_name="jobrepositorypermissionmapping",
            name="repository",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="aw.repository"
            ),
        ),
        migrations.AddField(
            model_name="jobpermission",
            name="repositories",
            field=models.ManyToManyField(
                through="aw.JobRepositoryPermissionMapping", to="aw.repository"
            ),
        ),
        migrations.AddField(
            model_name="job",
            name="repository",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="job_fk_repo",
                to="aw.repository",
            ),
        ),
        migrations.AddConstraint(
            model_name="jobcredentialspermissionmapping",
            constraint=models.UniqueConstraint(
                fields=("credentials", "permission"), name="jobcredpermmap_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="jobpermissionmapping",
            constraint=models.UniqueConstraint(
                fields=("job", "permission"), name="jobpermmap_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="jobpermissionmembergroup",
            constraint=models.UniqueConstraint(
                fields=("group", "permission"), name="jobpermmembergrp_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="jobpermissionmemberuser",
            constraint=models.UniqueConstraint(
                fields=("user", "permission"), name="jobpermmemberuser_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="jobusercredentials",
            constraint=models.UniqueConstraint(
                fields=("user", "name"), name="jobusercreds_user_name"
            ),
        ),
        migrations.AddConstraint(
            model_name="repository",
            constraint=models.UniqueConstraint(
                fields=("name",), name="repo_name_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="jobrepositorypermissionmapping",
            constraint=models.UniqueConstraint(
                fields=("repository", "permission"), name="jobrepopermmap_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="jobpermission",
            constraint=models.UniqueConstraint(
                fields=("name",), name="jobperm_name_unique"
            ),
        ),
        migrations.AddConstraint(
            model_name="job",
            constraint=models.UniqueConstraint(
                fields=("name",), name="job_name_unique"
            ),
        ),
    ]
