# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class TabMetadata(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'anchor': 'str',
        'anchor_case_sensitive': 'str',
        'anchor_horizontal_alignment': 'str',
        'anchor_ignore_if_not_present': 'str',
        'anchor_match_whole_word': 'str',
        'anchor_units': 'str',
        'anchor_x_offset': 'str',
        'anchor_y_offset': 'str',
        'bold': 'str',
        'collaborative': 'str',
        'conceal_value_on_document': 'str',
        'created_by_display_name': 'str',
        'created_by_user_id': 'str',
        'custom_tab_id': 'str',
        'disable_auto_size': 'str',
        'editable': 'str',
        'font': 'str',
        'font_color': 'str',
        'font_size': 'str',
        'height': 'str',
        'included_in_email': 'str',
        'initial_value': 'str',
        'italic': 'str',
        'items': 'list[str]',
        'last_modified': 'str',
        'last_modified_by_display_name': 'str',
        'last_modified_by_user_id': 'str',
        'locale_policy': 'LocalePolicyTab',
        'locked': 'str',
        'maximum_length': 'str',
        'merge_field': 'MergeField',
        'name': 'str',
        'numerical_value': 'str',
        'payment_item_code': 'str',
        'payment_item_description': 'str',
        'payment_item_name': 'str',
        'require_all': 'str',
        'required': 'str',
        'require_initial_on_shared_change': 'str',
        'scale_value': 'str',
        'selected': 'str',
        'shared': 'str',
        'stamp_type': 'str',
        'stamp_type_metadata': 'PropertyMetadata',
        'tab_label': 'str',
        'type': 'str',
        'underline': 'str',
        'validation_message': 'str',
        'validation_pattern': 'str',
        'width': 'str'
    }

    attribute_map = {
        'anchor': 'anchor',
        'anchor_case_sensitive': 'anchorCaseSensitive',
        'anchor_horizontal_alignment': 'anchorHorizontalAlignment',
        'anchor_ignore_if_not_present': 'anchorIgnoreIfNotPresent',
        'anchor_match_whole_word': 'anchorMatchWholeWord',
        'anchor_units': 'anchorUnits',
        'anchor_x_offset': 'anchorXOffset',
        'anchor_y_offset': 'anchorYOffset',
        'bold': 'bold',
        'collaborative': 'collaborative',
        'conceal_value_on_document': 'concealValueOnDocument',
        'created_by_display_name': 'createdByDisplayName',
        'created_by_user_id': 'createdByUserId',
        'custom_tab_id': 'customTabId',
        'disable_auto_size': 'disableAutoSize',
        'editable': 'editable',
        'font': 'font',
        'font_color': 'fontColor',
        'font_size': 'fontSize',
        'height': 'height',
        'included_in_email': 'includedInEmail',
        'initial_value': 'initialValue',
        'italic': 'italic',
        'items': 'items',
        'last_modified': 'lastModified',
        'last_modified_by_display_name': 'lastModifiedByDisplayName',
        'last_modified_by_user_id': 'lastModifiedByUserId',
        'locale_policy': 'localePolicy',
        'locked': 'locked',
        'maximum_length': 'maximumLength',
        'merge_field': 'mergeField',
        'name': 'name',
        'numerical_value': 'numericalValue',
        'payment_item_code': 'paymentItemCode',
        'payment_item_description': 'paymentItemDescription',
        'payment_item_name': 'paymentItemName',
        'require_all': 'requireAll',
        'required': 'required',
        'require_initial_on_shared_change': 'requireInitialOnSharedChange',
        'scale_value': 'scaleValue',
        'selected': 'selected',
        'shared': 'shared',
        'stamp_type': 'stampType',
        'stamp_type_metadata': 'stampTypeMetadata',
        'tab_label': 'tabLabel',
        'type': 'type',
        'underline': 'underline',
        'validation_message': 'validationMessage',
        'validation_pattern': 'validationPattern',
        'width': 'width'
    }

    def __init__(self, anchor=None, anchor_case_sensitive=None, anchor_horizontal_alignment=None, anchor_ignore_if_not_present=None, anchor_match_whole_word=None, anchor_units=None, anchor_x_offset=None, anchor_y_offset=None, bold=None, collaborative=None, conceal_value_on_document=None, created_by_display_name=None, created_by_user_id=None, custom_tab_id=None, disable_auto_size=None, editable=None, font=None, font_color=None, font_size=None, height=None, included_in_email=None, initial_value=None, italic=None, items=None, last_modified=None, last_modified_by_display_name=None, last_modified_by_user_id=None, locale_policy=None, locked=None, maximum_length=None, merge_field=None, name=None, numerical_value=None, payment_item_code=None, payment_item_description=None, payment_item_name=None, require_all=None, required=None, require_initial_on_shared_change=None, scale_value=None, selected=None, shared=None, stamp_type=None, stamp_type_metadata=None, tab_label=None, type=None, underline=None, validation_message=None, validation_pattern=None, width=None):  # noqa: E501
        """TabMetadata - a model defined in Swagger"""  # noqa: E501

        self._anchor = None
        self._anchor_case_sensitive = None
        self._anchor_horizontal_alignment = None
        self._anchor_ignore_if_not_present = None
        self._anchor_match_whole_word = None
        self._anchor_units = None
        self._anchor_x_offset = None
        self._anchor_y_offset = None
        self._bold = None
        self._collaborative = None
        self._conceal_value_on_document = None
        self._created_by_display_name = None
        self._created_by_user_id = None
        self._custom_tab_id = None
        self._disable_auto_size = None
        self._editable = None
        self._font = None
        self._font_color = None
        self._font_size = None
        self._height = None
        self._included_in_email = None
        self._initial_value = None
        self._italic = None
        self._items = None
        self._last_modified = None
        self._last_modified_by_display_name = None
        self._last_modified_by_user_id = None
        self._locale_policy = None
        self._locked = None
        self._maximum_length = None
        self._merge_field = None
        self._name = None
        self._numerical_value = None
        self._payment_item_code = None
        self._payment_item_description = None
        self._payment_item_name = None
        self._require_all = None
        self._required = None
        self._require_initial_on_shared_change = None
        self._scale_value = None
        self._selected = None
        self._shared = None
        self._stamp_type = None
        self._stamp_type_metadata = None
        self._tab_label = None
        self._type = None
        self._underline = None
        self._validation_message = None
        self._validation_pattern = None
        self._width = None
        self.discriminator = None

        if anchor is not None:
            self.anchor = anchor
        if anchor_case_sensitive is not None:
            self.anchor_case_sensitive = anchor_case_sensitive
        if anchor_horizontal_alignment is not None:
            self.anchor_horizontal_alignment = anchor_horizontal_alignment
        if anchor_ignore_if_not_present is not None:
            self.anchor_ignore_if_not_present = anchor_ignore_if_not_present
        if anchor_match_whole_word is not None:
            self.anchor_match_whole_word = anchor_match_whole_word
        if anchor_units is not None:
            self.anchor_units = anchor_units
        if anchor_x_offset is not None:
            self.anchor_x_offset = anchor_x_offset
        if anchor_y_offset is not None:
            self.anchor_y_offset = anchor_y_offset
        if bold is not None:
            self.bold = bold
        if collaborative is not None:
            self.collaborative = collaborative
        if conceal_value_on_document is not None:
            self.conceal_value_on_document = conceal_value_on_document
        if created_by_display_name is not None:
            self.created_by_display_name = created_by_display_name
        if created_by_user_id is not None:
            self.created_by_user_id = created_by_user_id
        if custom_tab_id is not None:
            self.custom_tab_id = custom_tab_id
        if disable_auto_size is not None:
            self.disable_auto_size = disable_auto_size
        if editable is not None:
            self.editable = editable
        if font is not None:
            self.font = font
        if font_color is not None:
            self.font_color = font_color
        if font_size is not None:
            self.font_size = font_size
        if height is not None:
            self.height = height
        if included_in_email is not None:
            self.included_in_email = included_in_email
        if initial_value is not None:
            self.initial_value = initial_value
        if italic is not None:
            self.italic = italic
        if items is not None:
            self.items = items
        if last_modified is not None:
            self.last_modified = last_modified
        if last_modified_by_display_name is not None:
            self.last_modified_by_display_name = last_modified_by_display_name
        if last_modified_by_user_id is not None:
            self.last_modified_by_user_id = last_modified_by_user_id
        if locale_policy is not None:
            self.locale_policy = locale_policy
        if locked is not None:
            self.locked = locked
        if maximum_length is not None:
            self.maximum_length = maximum_length
        if merge_field is not None:
            self.merge_field = merge_field
        if name is not None:
            self.name = name
        if numerical_value is not None:
            self.numerical_value = numerical_value
        if payment_item_code is not None:
            self.payment_item_code = payment_item_code
        if payment_item_description is not None:
            self.payment_item_description = payment_item_description
        if payment_item_name is not None:
            self.payment_item_name = payment_item_name
        if require_all is not None:
            self.require_all = require_all
        if required is not None:
            self.required = required
        if require_initial_on_shared_change is not None:
            self.require_initial_on_shared_change = require_initial_on_shared_change
        if scale_value is not None:
            self.scale_value = scale_value
        if selected is not None:
            self.selected = selected
        if shared is not None:
            self.shared = shared
        if stamp_type is not None:
            self.stamp_type = stamp_type
        if stamp_type_metadata is not None:
            self.stamp_type_metadata = stamp_type_metadata
        if tab_label is not None:
            self.tab_label = tab_label
        if type is not None:
            self.type = type
        if underline is not None:
            self.underline = underline
        if validation_message is not None:
            self.validation_message = validation_message
        if validation_pattern is not None:
            self.validation_pattern = validation_pattern
        if width is not None:
            self.width = width

    @property
    def anchor(self):
        """Gets the anchor of this TabMetadata.  # noqa: E501

        An optional string that is used to auto-match tabs to strings located in the documents of an envelope.  # noqa: E501

        :return: The anchor of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._anchor

    @anchor.setter
    def anchor(self, anchor):
        """Sets the anchor of this TabMetadata.

        An optional string that is used to auto-match tabs to strings located in the documents of an envelope.  # noqa: E501

        :param anchor: The anchor of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._anchor = anchor

    @property
    def anchor_case_sensitive(self):
        """Gets the anchor_case_sensitive of this TabMetadata.  # noqa: E501

        When set to **true**, the anchor string does not consider case when matching strings in the document. The default value is **true**.  # noqa: E501

        :return: The anchor_case_sensitive of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._anchor_case_sensitive

    @anchor_case_sensitive.setter
    def anchor_case_sensitive(self, anchor_case_sensitive):
        """Sets the anchor_case_sensitive of this TabMetadata.

        When set to **true**, the anchor string does not consider case when matching strings in the document. The default value is **true**.  # noqa: E501

        :param anchor_case_sensitive: The anchor_case_sensitive of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._anchor_case_sensitive = anchor_case_sensitive

    @property
    def anchor_horizontal_alignment(self):
        """Gets the anchor_horizontal_alignment of this TabMetadata.  # noqa: E501

        Specifies the alignment of anchor tabs with anchor strings. Possible values are **left** or **right**. The default value is **left**.  # noqa: E501

        :return: The anchor_horizontal_alignment of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._anchor_horizontal_alignment

    @anchor_horizontal_alignment.setter
    def anchor_horizontal_alignment(self, anchor_horizontal_alignment):
        """Sets the anchor_horizontal_alignment of this TabMetadata.

        Specifies the alignment of anchor tabs with anchor strings. Possible values are **left** or **right**. The default value is **left**.  # noqa: E501

        :param anchor_horizontal_alignment: The anchor_horizontal_alignment of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._anchor_horizontal_alignment = anchor_horizontal_alignment

    @property
    def anchor_ignore_if_not_present(self):
        """Gets the anchor_ignore_if_not_present of this TabMetadata.  # noqa: E501

        When set to **true**, this tab is ignored if anchorString is not found in the document.  # noqa: E501

        :return: The anchor_ignore_if_not_present of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._anchor_ignore_if_not_present

    @anchor_ignore_if_not_present.setter
    def anchor_ignore_if_not_present(self, anchor_ignore_if_not_present):
        """Sets the anchor_ignore_if_not_present of this TabMetadata.

        When set to **true**, this tab is ignored if anchorString is not found in the document.  # noqa: E501

        :param anchor_ignore_if_not_present: The anchor_ignore_if_not_present of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._anchor_ignore_if_not_present = anchor_ignore_if_not_present

    @property
    def anchor_match_whole_word(self):
        """Gets the anchor_match_whole_word of this TabMetadata.  # noqa: E501

        When set to **true**, the anchor string in this tab matches whole words only (strings embedded in other strings are ignored.) The default value is **true**.  # noqa: E501

        :return: The anchor_match_whole_word of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._anchor_match_whole_word

    @anchor_match_whole_word.setter
    def anchor_match_whole_word(self, anchor_match_whole_word):
        """Sets the anchor_match_whole_word of this TabMetadata.

        When set to **true**, the anchor string in this tab matches whole words only (strings embedded in other strings are ignored.) The default value is **true**.  # noqa: E501

        :param anchor_match_whole_word: The anchor_match_whole_word of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._anchor_match_whole_word = anchor_match_whole_word

    @property
    def anchor_units(self):
        """Gets the anchor_units of this TabMetadata.  # noqa: E501

        Specifies units of the X and Y offset. Units could be pixels, millimeters, centimeters, or inches.  # noqa: E501

        :return: The anchor_units of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._anchor_units

    @anchor_units.setter
    def anchor_units(self, anchor_units):
        """Sets the anchor_units of this TabMetadata.

        Specifies units of the X and Y offset. Units could be pixels, millimeters, centimeters, or inches.  # noqa: E501

        :param anchor_units: The anchor_units of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._anchor_units = anchor_units

    @property
    def anchor_x_offset(self):
        """Gets the anchor_x_offset of this TabMetadata.  # noqa: E501

        Specifies the X axis location of the tab, in anchorUnits, relative to the anchorString.  # noqa: E501

        :return: The anchor_x_offset of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._anchor_x_offset

    @anchor_x_offset.setter
    def anchor_x_offset(self, anchor_x_offset):
        """Sets the anchor_x_offset of this TabMetadata.

        Specifies the X axis location of the tab, in anchorUnits, relative to the anchorString.  # noqa: E501

        :param anchor_x_offset: The anchor_x_offset of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._anchor_x_offset = anchor_x_offset

    @property
    def anchor_y_offset(self):
        """Gets the anchor_y_offset of this TabMetadata.  # noqa: E501

        Specifies the Y axis location of the tab, in anchorUnits, relative to the anchorString.  # noqa: E501

        :return: The anchor_y_offset of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._anchor_y_offset

    @anchor_y_offset.setter
    def anchor_y_offset(self, anchor_y_offset):
        """Sets the anchor_y_offset of this TabMetadata.

        Specifies the Y axis location of the tab, in anchorUnits, relative to the anchorString.  # noqa: E501

        :param anchor_y_offset: The anchor_y_offset of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._anchor_y_offset = anchor_y_offset

    @property
    def bold(self):
        """Gets the bold of this TabMetadata.  # noqa: E501

        When set to **true**, the information in the tab is bold.  # noqa: E501

        :return: The bold of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._bold

    @bold.setter
    def bold(self, bold):
        """Sets the bold of this TabMetadata.

        When set to **true**, the information in the tab is bold.  # noqa: E501

        :param bold: The bold of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._bold = bold

    @property
    def collaborative(self):
        """Gets the collaborative of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The collaborative of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._collaborative

    @collaborative.setter
    def collaborative(self, collaborative):
        """Sets the collaborative of this TabMetadata.

          # noqa: E501

        :param collaborative: The collaborative of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._collaborative = collaborative

    @property
    def conceal_value_on_document(self):
        """Gets the conceal_value_on_document of this TabMetadata.  # noqa: E501

        When set to **true**, the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.  When an envelope is completed the information is available to the sender through the Form Data link in the DocuSign Console.  This setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.  # noqa: E501

        :return: The conceal_value_on_document of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._conceal_value_on_document

    @conceal_value_on_document.setter
    def conceal_value_on_document(self, conceal_value_on_document):
        """Sets the conceal_value_on_document of this TabMetadata.

        When set to **true**, the field appears normally while the recipient is adding or modifying the information in the field, but the data is not visible (the characters are hidden by asterisks) to any other signer or the sender.  When an envelope is completed the information is available to the sender through the Form Data link in the DocuSign Console.  This setting applies only to text boxes and does not affect list boxes, radio buttons, or check boxes.  # noqa: E501

        :param conceal_value_on_document: The conceal_value_on_document of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._conceal_value_on_document = conceal_value_on_document

    @property
    def created_by_display_name(self):
        """Gets the created_by_display_name of this TabMetadata.  # noqa: E501

        The user name of the DocuSign user who created this object.  # noqa: E501

        :return: The created_by_display_name of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._created_by_display_name

    @created_by_display_name.setter
    def created_by_display_name(self, created_by_display_name):
        """Sets the created_by_display_name of this TabMetadata.

        The user name of the DocuSign user who created this object.  # noqa: E501

        :param created_by_display_name: The created_by_display_name of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._created_by_display_name = created_by_display_name

    @property
    def created_by_user_id(self):
        """Gets the created_by_user_id of this TabMetadata.  # noqa: E501

        The userId of the DocuSign user who created this object.  # noqa: E501

        :return: The created_by_user_id of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._created_by_user_id

    @created_by_user_id.setter
    def created_by_user_id(self, created_by_user_id):
        """Sets the created_by_user_id of this TabMetadata.

        The userId of the DocuSign user who created this object.  # noqa: E501

        :param created_by_user_id: The created_by_user_id of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._created_by_user_id = created_by_user_id

    @property
    def custom_tab_id(self):
        """Gets the custom_tab_id of this TabMetadata.  # noqa: E501

        The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.  # noqa: E501

        :return: The custom_tab_id of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._custom_tab_id

    @custom_tab_id.setter
    def custom_tab_id(self, custom_tab_id):
        """Sets the custom_tab_id of this TabMetadata.

        The DocuSign generated custom tab ID for the custom tab to be applied. This can only be used when adding new tabs for a recipient. When used, the new tab inherits all the custom tab properties.  # noqa: E501

        :param custom_tab_id: The custom_tab_id of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._custom_tab_id = custom_tab_id

    @property
    def disable_auto_size(self):
        """Gets the disable_auto_size of this TabMetadata.  # noqa: E501

        When set to **true**, disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.  # noqa: E501

        :return: The disable_auto_size of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._disable_auto_size

    @disable_auto_size.setter
    def disable_auto_size(self, disable_auto_size):
        """Sets the disable_auto_size of this TabMetadata.

        When set to **true**, disables the auto sizing of single line text boxes in the signing screen when the signer enters data. If disabled users will only be able enter as much data as the text box can hold. By default this is false. This property only affects single line text boxes.  # noqa: E501

        :param disable_auto_size: The disable_auto_size of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._disable_auto_size = disable_auto_size

    @property
    def editable(self):
        """Gets the editable of this TabMetadata.  # noqa: E501

        When set to **true**, the custom tab is editable. Otherwise the custom tab cannot be modified.  # noqa: E501

        :return: The editable of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._editable

    @editable.setter
    def editable(self, editable):
        """Sets the editable of this TabMetadata.

        When set to **true**, the custom tab is editable. Otherwise the custom tab cannot be modified.  # noqa: E501

        :param editable: The editable of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._editable = editable

    @property
    def font(self):
        """Gets the font of this TabMetadata.  # noqa: E501

        The font to be used for the tab value. Supported Fonts: Arial, Arial, ArialNarrow, Calibri, CourierNew, Garamond, Georgia, Helvetica,   LucidaConsole, Tahoma, TimesNewRoman, Trebuchet, Verdana, MSGothic, MSMincho, Default.  # noqa: E501

        :return: The font of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._font

    @font.setter
    def font(self, font):
        """Sets the font of this TabMetadata.

        The font to be used for the tab value. Supported Fonts: Arial, Arial, ArialNarrow, Calibri, CourierNew, Garamond, Georgia, Helvetica,   LucidaConsole, Tahoma, TimesNewRoman, Trebuchet, Verdana, MSGothic, MSMincho, Default.  # noqa: E501

        :param font: The font of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._font = font

    @property
    def font_color(self):
        """Gets the font_color of this TabMetadata.  # noqa: E501

        The font color used for the information in the tab.  Possible values are: Black, BrightBlue, BrightRed, DarkGreen, DarkRed, Gold, Green, NavyBlue, Purple, or White.  # noqa: E501

        :return: The font_color of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._font_color

    @font_color.setter
    def font_color(self, font_color):
        """Sets the font_color of this TabMetadata.

        The font color used for the information in the tab.  Possible values are: Black, BrightBlue, BrightRed, DarkGreen, DarkRed, Gold, Green, NavyBlue, Purple, or White.  # noqa: E501

        :param font_color: The font_color of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._font_color = font_color

    @property
    def font_size(self):
        """Gets the font_size of this TabMetadata.  # noqa: E501

        The font size used for the information in the tab.  Possible values are: Size7, Size8, Size9, Size10, Size11, Size12, Size14, Size16, Size18, Size20, Size22, Size24, Size26, Size28, Size36, Size48, or Size72.  # noqa: E501

        :return: The font_size of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._font_size

    @font_size.setter
    def font_size(self, font_size):
        """Sets the font_size of this TabMetadata.

        The font size used for the information in the tab.  Possible values are: Size7, Size8, Size9, Size10, Size11, Size12, Size14, Size16, Size18, Size20, Size22, Size24, Size26, Size28, Size36, Size48, or Size72.  # noqa: E501

        :param font_size: The font_size of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._font_size = font_size

    @property
    def height(self):
        """Gets the height of this TabMetadata.  # noqa: E501

        Height of the tab in pixels.  # noqa: E501

        :return: The height of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._height

    @height.setter
    def height(self, height):
        """Sets the height of this TabMetadata.

        Height of the tab in pixels.  # noqa: E501

        :param height: The height of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._height = height

    @property
    def included_in_email(self):
        """Gets the included_in_email of this TabMetadata.  # noqa: E501

        When set to **true**, the tab is included in e-mails related to the envelope on which it exists. This applies to only specific tabs.  # noqa: E501

        :return: The included_in_email of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._included_in_email

    @included_in_email.setter
    def included_in_email(self, included_in_email):
        """Sets the included_in_email of this TabMetadata.

        When set to **true**, the tab is included in e-mails related to the envelope on which it exists. This applies to only specific tabs.  # noqa: E501

        :param included_in_email: The included_in_email of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._included_in_email = included_in_email

    @property
    def initial_value(self):
        """Gets the initial_value of this TabMetadata.  # noqa: E501

        The original value of the tab.  # noqa: E501

        :return: The initial_value of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._initial_value

    @initial_value.setter
    def initial_value(self, initial_value):
        """Sets the initial_value of this TabMetadata.

        The original value of the tab.  # noqa: E501

        :param initial_value: The initial_value of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._initial_value = initial_value

    @property
    def italic(self):
        """Gets the italic of this TabMetadata.  # noqa: E501

        When set to **true**, the information in the tab is italic.  # noqa: E501

        :return: The italic of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._italic

    @italic.setter
    def italic(self, italic):
        """Sets the italic of this TabMetadata.

        When set to **true**, the information in the tab is italic.  # noqa: E501

        :param italic: The italic of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._italic = italic

    @property
    def items(self):
        """Gets the items of this TabMetadata.  # noqa: E501

        If the tab is a list, this represents the values that are possible for the tab.  # noqa: E501

        :return: The items of this TabMetadata.  # noqa: E501
        :rtype: list[str]
        """
        return self._items

    @items.setter
    def items(self, items):
        """Sets the items of this TabMetadata.

        If the tab is a list, this represents the values that are possible for the tab.  # noqa: E501

        :param items: The items of this TabMetadata.  # noqa: E501
        :type: list[str]
        """

        self._items = items

    @property
    def last_modified(self):
        """Gets the last_modified of this TabMetadata.  # noqa: E501

        The UTC DateTime this object was last modified. This is in ISO8601 format.  # noqa: E501

        :return: The last_modified of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._last_modified

    @last_modified.setter
    def last_modified(self, last_modified):
        """Sets the last_modified of this TabMetadata.

        The UTC DateTime this object was last modified. This is in ISO8601 format.  # noqa: E501

        :param last_modified: The last_modified of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._last_modified = last_modified

    @property
    def last_modified_by_display_name(self):
        """Gets the last_modified_by_display_name of this TabMetadata.  # noqa: E501

        The User Name of the DocuSign user who last modified this object.  # noqa: E501

        :return: The last_modified_by_display_name of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by_display_name

    @last_modified_by_display_name.setter
    def last_modified_by_display_name(self, last_modified_by_display_name):
        """Sets the last_modified_by_display_name of this TabMetadata.

        The User Name of the DocuSign user who last modified this object.  # noqa: E501

        :param last_modified_by_display_name: The last_modified_by_display_name of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._last_modified_by_display_name = last_modified_by_display_name

    @property
    def last_modified_by_user_id(self):
        """Gets the last_modified_by_user_id of this TabMetadata.  # noqa: E501

        The userId of the DocuSign user who last modified this object.  # noqa: E501

        :return: The last_modified_by_user_id of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._last_modified_by_user_id

    @last_modified_by_user_id.setter
    def last_modified_by_user_id(self, last_modified_by_user_id):
        """Sets the last_modified_by_user_id of this TabMetadata.

        The userId of the DocuSign user who last modified this object.  # noqa: E501

        :param last_modified_by_user_id: The last_modified_by_user_id of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._last_modified_by_user_id = last_modified_by_user_id

    @property
    def locale_policy(self):
        """Gets the locale_policy of this TabMetadata.  # noqa: E501


        :return: The locale_policy of this TabMetadata.  # noqa: E501
        :rtype: LocalePolicyTab
        """
        return self._locale_policy

    @locale_policy.setter
    def locale_policy(self, locale_policy):
        """Sets the locale_policy of this TabMetadata.


        :param locale_policy: The locale_policy of this TabMetadata.  # noqa: E501
        :type: LocalePolicyTab
        """

        self._locale_policy = locale_policy

    @property
    def locked(self):
        """Gets the locked of this TabMetadata.  # noqa: E501

        When set to **true**, the signer cannot change the data of the custom tab.  # noqa: E501

        :return: The locked of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._locked

    @locked.setter
    def locked(self, locked):
        """Sets the locked of this TabMetadata.

        When set to **true**, the signer cannot change the data of the custom tab.  # noqa: E501

        :param locked: The locked of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._locked = locked

    @property
    def maximum_length(self):
        """Gets the maximum_length of this TabMetadata.  # noqa: E501

        The maximum number of entry characters supported by the custom tab.  # noqa: E501

        :return: The maximum_length of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._maximum_length

    @maximum_length.setter
    def maximum_length(self, maximum_length):
        """Sets the maximum_length of this TabMetadata.

        The maximum number of entry characters supported by the custom tab.  # noqa: E501

        :param maximum_length: The maximum_length of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._maximum_length = maximum_length

    @property
    def merge_field(self):
        """Gets the merge_field of this TabMetadata.  # noqa: E501


        :return: The merge_field of this TabMetadata.  # noqa: E501
        :rtype: MergeField
        """
        return self._merge_field

    @merge_field.setter
    def merge_field(self, merge_field):
        """Sets the merge_field of this TabMetadata.


        :param merge_field: The merge_field of this TabMetadata.  # noqa: E501
        :type: MergeField
        """

        self._merge_field = merge_field

    @property
    def name(self):
        """Gets the name of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The name of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TabMetadata.

          # noqa: E501

        :param name: The name of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def numerical_value(self):
        """Gets the numerical_value of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The numerical_value of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._numerical_value

    @numerical_value.setter
    def numerical_value(self, numerical_value):
        """Sets the numerical_value of this TabMetadata.

          # noqa: E501

        :param numerical_value: The numerical_value of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._numerical_value = numerical_value

    @property
    def payment_item_code(self):
        """Gets the payment_item_code of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The payment_item_code of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._payment_item_code

    @payment_item_code.setter
    def payment_item_code(self, payment_item_code):
        """Sets the payment_item_code of this TabMetadata.

          # noqa: E501

        :param payment_item_code: The payment_item_code of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._payment_item_code = payment_item_code

    @property
    def payment_item_description(self):
        """Gets the payment_item_description of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The payment_item_description of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._payment_item_description

    @payment_item_description.setter
    def payment_item_description(self, payment_item_description):
        """Sets the payment_item_description of this TabMetadata.

          # noqa: E501

        :param payment_item_description: The payment_item_description of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._payment_item_description = payment_item_description

    @property
    def payment_item_name(self):
        """Gets the payment_item_name of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The payment_item_name of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._payment_item_name

    @payment_item_name.setter
    def payment_item_name(self, payment_item_name):
        """Sets the payment_item_name of this TabMetadata.

          # noqa: E501

        :param payment_item_name: The payment_item_name of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._payment_item_name = payment_item_name

    @property
    def require_all(self):
        """Gets the require_all of this TabMetadata.  # noqa: E501

        When set to **true** and shared is true, information must be entered in this field to complete the envelope.   # noqa: E501

        :return: The require_all of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._require_all

    @require_all.setter
    def require_all(self, require_all):
        """Sets the require_all of this TabMetadata.

        When set to **true** and shared is true, information must be entered in this field to complete the envelope.   # noqa: E501

        :param require_all: The require_all of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._require_all = require_all

    @property
    def required(self):
        """Gets the required of this TabMetadata.  # noqa: E501

        When set to **true**, the signer is required to fill out this tab  # noqa: E501

        :return: The required of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._required

    @required.setter
    def required(self, required):
        """Sets the required of this TabMetadata.

        When set to **true**, the signer is required to fill out this tab  # noqa: E501

        :param required: The required of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._required = required

    @property
    def require_initial_on_shared_change(self):
        """Gets the require_initial_on_shared_change of this TabMetadata.  # noqa: E501

        Optional element for field markup. When set to **true**, the signer is required to initial when they modify a shared field.  # noqa: E501

        :return: The require_initial_on_shared_change of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._require_initial_on_shared_change

    @require_initial_on_shared_change.setter
    def require_initial_on_shared_change(self, require_initial_on_shared_change):
        """Sets the require_initial_on_shared_change of this TabMetadata.

        Optional element for field markup. When set to **true**, the signer is required to initial when they modify a shared field.  # noqa: E501

        :param require_initial_on_shared_change: The require_initial_on_shared_change of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._require_initial_on_shared_change = require_initial_on_shared_change

    @property
    def scale_value(self):
        """Gets the scale_value of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The scale_value of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._scale_value

    @scale_value.setter
    def scale_value(self, scale_value):
        """Sets the scale_value of this TabMetadata.

          # noqa: E501

        :param scale_value: The scale_value of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._scale_value = scale_value

    @property
    def selected(self):
        """Gets the selected of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The selected of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._selected

    @selected.setter
    def selected(self, selected):
        """Sets the selected of this TabMetadata.

          # noqa: E501

        :param selected: The selected of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._selected = selected

    @property
    def shared(self):
        """Gets the shared of this TabMetadata.  # noqa: E501

        When set to **true**, this custom tab is shared.  # noqa: E501

        :return: The shared of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._shared

    @shared.setter
    def shared(self, shared):
        """Sets the shared of this TabMetadata.

        When set to **true**, this custom tab is shared.  # noqa: E501

        :param shared: The shared of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._shared = shared

    @property
    def stamp_type(self):
        """Gets the stamp_type of this TabMetadata.  # noqa: E501

          # noqa: E501

        :return: The stamp_type of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._stamp_type

    @stamp_type.setter
    def stamp_type(self, stamp_type):
        """Sets the stamp_type of this TabMetadata.

          # noqa: E501

        :param stamp_type: The stamp_type of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._stamp_type = stamp_type

    @property
    def stamp_type_metadata(self):
        """Gets the stamp_type_metadata of this TabMetadata.  # noqa: E501


        :return: The stamp_type_metadata of this TabMetadata.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._stamp_type_metadata

    @stamp_type_metadata.setter
    def stamp_type_metadata(self, stamp_type_metadata):
        """Sets the stamp_type_metadata of this TabMetadata.


        :param stamp_type_metadata: The stamp_type_metadata of this TabMetadata.  # noqa: E501
        :type: PropertyMetadata
        """

        self._stamp_type_metadata = stamp_type_metadata

    @property
    def tab_label(self):
        """Gets the tab_label of this TabMetadata.  # noqa: E501

        The label string associated with the tab.  # noqa: E501

        :return: The tab_label of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._tab_label

    @tab_label.setter
    def tab_label(self, tab_label):
        """Sets the tab_label of this TabMetadata.

        The label string associated with the tab.  # noqa: E501

        :param tab_label: The tab_label of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._tab_label = tab_label

    @property
    def type(self):
        """Gets the type of this TabMetadata.  # noqa: E501

        The type of this tab. Values are: Approve, CheckBox, Company, Date, DateSigned, Decline, Email, EmailAddress, EnvelopeId, FirstName, Formula, FullName, InitialHere, InitialHereOptional, LastName, List, Note, Number, Radio, SignerAttachment, SignHere, SignHereOptional, Ssn, Text, Title, Zip5, or Zip5Dash4.  # noqa: E501

        :return: The type of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this TabMetadata.

        The type of this tab. Values are: Approve, CheckBox, Company, Date, DateSigned, Decline, Email, EmailAddress, EnvelopeId, FirstName, Formula, FullName, InitialHere, InitialHereOptional, LastName, List, Note, Number, Radio, SignerAttachment, SignHere, SignHereOptional, Ssn, Text, Title, Zip5, or Zip5Dash4.  # noqa: E501

        :param type: The type of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def underline(self):
        """Gets the underline of this TabMetadata.  # noqa: E501

        When set to **true**, the information in the tab is underlined.  # noqa: E501

        :return: The underline of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._underline

    @underline.setter
    def underline(self, underline):
        """Sets the underline of this TabMetadata.

        When set to **true**, the information in the tab is underlined.  # noqa: E501

        :param underline: The underline of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._underline = underline

    @property
    def validation_message(self):
        """Gets the validation_message of this TabMetadata.  # noqa: E501

        The message displayed if the custom tab fails input validation (either custom of embedded).  # noqa: E501

        :return: The validation_message of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._validation_message

    @validation_message.setter
    def validation_message(self, validation_message):
        """Sets the validation_message of this TabMetadata.

        The message displayed if the custom tab fails input validation (either custom of embedded).  # noqa: E501

        :param validation_message: The validation_message of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._validation_message = validation_message

    @property
    def validation_pattern(self):
        """Gets the validation_pattern of this TabMetadata.  # noqa: E501

        A regular expression used to validate input for the tab.  # noqa: E501

        :return: The validation_pattern of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._validation_pattern

    @validation_pattern.setter
    def validation_pattern(self, validation_pattern):
        """Sets the validation_pattern of this TabMetadata.

        A regular expression used to validate input for the tab.  # noqa: E501

        :param validation_pattern: The validation_pattern of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._validation_pattern = validation_pattern

    @property
    def width(self):
        """Gets the width of this TabMetadata.  # noqa: E501

        Width of the tab in pixels.  # noqa: E501

        :return: The width of this TabMetadata.  # noqa: E501
        :rtype: str
        """
        return self._width

    @width.setter
    def width(self, width):
        """Sets the width of this TabMetadata.

        Width of the tab in pixels.  # noqa: E501

        :param width: The width of this TabMetadata.  # noqa: E501
        :type: str
        """

        self._width = width

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TabMetadata, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TabMetadata):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
