# coding: utf-8

"""
    DocuSign REST API

    The DocuSign REST API provides you with a powerful, convenient, and simple Web services API for interacting with DocuSign.  # noqa: E501

    OpenAPI spec version: v2.1
    Contact: devcenter@docusign.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class SealSign(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'access_code': 'str',
        'access_code_metadata': 'PropertyMetadata',
        'add_access_code_to_email': 'str',
        'allow_system_override_for_locked_recipient': 'str',
        'client_user_id': 'str',
        'completed_count': 'str',
        'custom_fields': 'list[str]',
        'declined_date_time': 'str',
        'declined_reason': 'str',
        'delivered_date_time': 'str',
        'delivery_method': 'str',
        'delivery_method_metadata': 'PropertyMetadata',
        'designator_id': 'str',
        'designator_id_guid': 'str',
        'document_visibility': 'list[DocumentVisibility]',
        'email_notification': 'RecipientEmailNotification',
        'embedded_recipient_start_url': 'str',
        'error_details': 'ErrorDetails',
        'fax_number': 'str',
        'fax_number_metadata': 'PropertyMetadata',
        'id_check_configuration_name': 'str',
        'id_check_configuration_name_metadata': 'PropertyMetadata',
        'id_check_information_input': 'IdCheckInformationInput',
        'identity_verification': 'RecipientIdentityVerification',
        'inherit_email_notification_configuration': 'str',
        'locked_recipient_phone_auth_editable': 'str',
        'locked_recipient_sms_editable': 'str',
        'name': 'str',
        'note': 'str',
        'note_metadata': 'PropertyMetadata',
        'phone_authentication': 'RecipientPhoneAuthentication',
        'recipient_attachments': 'list[RecipientAttachment]',
        'recipient_authentication_status': 'AuthenticationStatus',
        'recipient_feature_metadata': 'list[FeatureAvailableMetadata]',
        'recipient_id': 'str',
        'recipient_id_guid': 'str',
        'recipient_signature_providers': 'list[RecipientSignatureProvider]',
        'recipient_type': 'str',
        'recipient_type_metadata': 'PropertyMetadata',
        'require_id_lookup': 'str',
        'require_id_lookup_metadata': 'PropertyMetadata',
        'role_name': 'str',
        'routing_order': 'str',
        'routing_order_metadata': 'PropertyMetadata',
        'sent_date_time': 'str',
        'signed_date_time': 'str',
        'sms_authentication': 'RecipientSMSAuthentication',
        'social_authentications': 'list[SocialAuthentication]',
        'status': 'str',
        'status_code': 'str',
        'suppress_emails': 'str',
        'tabs': 'Tabs',
        'template_locked': 'str',
        'template_required': 'str',
        'total_tab_count': 'str',
        'user_id': 'str'
    }

    attribute_map = {
        'access_code': 'accessCode',
        'access_code_metadata': 'accessCodeMetadata',
        'add_access_code_to_email': 'addAccessCodeToEmail',
        'allow_system_override_for_locked_recipient': 'allowSystemOverrideForLockedRecipient',
        'client_user_id': 'clientUserId',
        'completed_count': 'completedCount',
        'custom_fields': 'customFields',
        'declined_date_time': 'declinedDateTime',
        'declined_reason': 'declinedReason',
        'delivered_date_time': 'deliveredDateTime',
        'delivery_method': 'deliveryMethod',
        'delivery_method_metadata': 'deliveryMethodMetadata',
        'designator_id': 'designatorId',
        'designator_id_guid': 'designatorIdGuid',
        'document_visibility': 'documentVisibility',
        'email_notification': 'emailNotification',
        'embedded_recipient_start_url': 'embeddedRecipientStartURL',
        'error_details': 'errorDetails',
        'fax_number': 'faxNumber',
        'fax_number_metadata': 'faxNumberMetadata',
        'id_check_configuration_name': 'idCheckConfigurationName',
        'id_check_configuration_name_metadata': 'idCheckConfigurationNameMetadata',
        'id_check_information_input': 'idCheckInformationInput',
        'identity_verification': 'identityVerification',
        'inherit_email_notification_configuration': 'inheritEmailNotificationConfiguration',
        'locked_recipient_phone_auth_editable': 'lockedRecipientPhoneAuthEditable',
        'locked_recipient_sms_editable': 'lockedRecipientSmsEditable',
        'name': 'name',
        'note': 'note',
        'note_metadata': 'noteMetadata',
        'phone_authentication': 'phoneAuthentication',
        'recipient_attachments': 'recipientAttachments',
        'recipient_authentication_status': 'recipientAuthenticationStatus',
        'recipient_feature_metadata': 'recipientFeatureMetadata',
        'recipient_id': 'recipientId',
        'recipient_id_guid': 'recipientIdGuid',
        'recipient_signature_providers': 'recipientSignatureProviders',
        'recipient_type': 'recipientType',
        'recipient_type_metadata': 'recipientTypeMetadata',
        'require_id_lookup': 'requireIdLookup',
        'require_id_lookup_metadata': 'requireIdLookupMetadata',
        'role_name': 'roleName',
        'routing_order': 'routingOrder',
        'routing_order_metadata': 'routingOrderMetadata',
        'sent_date_time': 'sentDateTime',
        'signed_date_time': 'signedDateTime',
        'sms_authentication': 'smsAuthentication',
        'social_authentications': 'socialAuthentications',
        'status': 'status',
        'status_code': 'statusCode',
        'suppress_emails': 'suppressEmails',
        'tabs': 'tabs',
        'template_locked': 'templateLocked',
        'template_required': 'templateRequired',
        'total_tab_count': 'totalTabCount',
        'user_id': 'userId'
    }

    def __init__(self, access_code=None, access_code_metadata=None, add_access_code_to_email=None, allow_system_override_for_locked_recipient=None, client_user_id=None, completed_count=None, custom_fields=None, declined_date_time=None, declined_reason=None, delivered_date_time=None, delivery_method=None, delivery_method_metadata=None, designator_id=None, designator_id_guid=None, document_visibility=None, email_notification=None, embedded_recipient_start_url=None, error_details=None, fax_number=None, fax_number_metadata=None, id_check_configuration_name=None, id_check_configuration_name_metadata=None, id_check_information_input=None, identity_verification=None, inherit_email_notification_configuration=None, locked_recipient_phone_auth_editable=None, locked_recipient_sms_editable=None, name=None, note=None, note_metadata=None, phone_authentication=None, recipient_attachments=None, recipient_authentication_status=None, recipient_feature_metadata=None, recipient_id=None, recipient_id_guid=None, recipient_signature_providers=None, recipient_type=None, recipient_type_metadata=None, require_id_lookup=None, require_id_lookup_metadata=None, role_name=None, routing_order=None, routing_order_metadata=None, sent_date_time=None, signed_date_time=None, sms_authentication=None, social_authentications=None, status=None, status_code=None, suppress_emails=None, tabs=None, template_locked=None, template_required=None, total_tab_count=None, user_id=None):  # noqa: E501
        """SealSign - a model defined in Swagger"""  # noqa: E501

        self._access_code = None
        self._access_code_metadata = None
        self._add_access_code_to_email = None
        self._allow_system_override_for_locked_recipient = None
        self._client_user_id = None
        self._completed_count = None
        self._custom_fields = None
        self._declined_date_time = None
        self._declined_reason = None
        self._delivered_date_time = None
        self._delivery_method = None
        self._delivery_method_metadata = None
        self._designator_id = None
        self._designator_id_guid = None
        self._document_visibility = None
        self._email_notification = None
        self._embedded_recipient_start_url = None
        self._error_details = None
        self._fax_number = None
        self._fax_number_metadata = None
        self._id_check_configuration_name = None
        self._id_check_configuration_name_metadata = None
        self._id_check_information_input = None
        self._identity_verification = None
        self._inherit_email_notification_configuration = None
        self._locked_recipient_phone_auth_editable = None
        self._locked_recipient_sms_editable = None
        self._name = None
        self._note = None
        self._note_metadata = None
        self._phone_authentication = None
        self._recipient_attachments = None
        self._recipient_authentication_status = None
        self._recipient_feature_metadata = None
        self._recipient_id = None
        self._recipient_id_guid = None
        self._recipient_signature_providers = None
        self._recipient_type = None
        self._recipient_type_metadata = None
        self._require_id_lookup = None
        self._require_id_lookup_metadata = None
        self._role_name = None
        self._routing_order = None
        self._routing_order_metadata = None
        self._sent_date_time = None
        self._signed_date_time = None
        self._sms_authentication = None
        self._social_authentications = None
        self._status = None
        self._status_code = None
        self._suppress_emails = None
        self._tabs = None
        self._template_locked = None
        self._template_required = None
        self._total_tab_count = None
        self._user_id = None
        self.discriminator = None

        if access_code is not None:
            self.access_code = access_code
        if access_code_metadata is not None:
            self.access_code_metadata = access_code_metadata
        if add_access_code_to_email is not None:
            self.add_access_code_to_email = add_access_code_to_email
        if allow_system_override_for_locked_recipient is not None:
            self.allow_system_override_for_locked_recipient = allow_system_override_for_locked_recipient
        if client_user_id is not None:
            self.client_user_id = client_user_id
        if completed_count is not None:
            self.completed_count = completed_count
        if custom_fields is not None:
            self.custom_fields = custom_fields
        if declined_date_time is not None:
            self.declined_date_time = declined_date_time
        if declined_reason is not None:
            self.declined_reason = declined_reason
        if delivered_date_time is not None:
            self.delivered_date_time = delivered_date_time
        if delivery_method is not None:
            self.delivery_method = delivery_method
        if delivery_method_metadata is not None:
            self.delivery_method_metadata = delivery_method_metadata
        if designator_id is not None:
            self.designator_id = designator_id
        if designator_id_guid is not None:
            self.designator_id_guid = designator_id_guid
        if document_visibility is not None:
            self.document_visibility = document_visibility
        if email_notification is not None:
            self.email_notification = email_notification
        if embedded_recipient_start_url is not None:
            self.embedded_recipient_start_url = embedded_recipient_start_url
        if error_details is not None:
            self.error_details = error_details
        if fax_number is not None:
            self.fax_number = fax_number
        if fax_number_metadata is not None:
            self.fax_number_metadata = fax_number_metadata
        if id_check_configuration_name is not None:
            self.id_check_configuration_name = id_check_configuration_name
        if id_check_configuration_name_metadata is not None:
            self.id_check_configuration_name_metadata = id_check_configuration_name_metadata
        if id_check_information_input is not None:
            self.id_check_information_input = id_check_information_input
        if identity_verification is not None:
            self.identity_verification = identity_verification
        if inherit_email_notification_configuration is not None:
            self.inherit_email_notification_configuration = inherit_email_notification_configuration
        if locked_recipient_phone_auth_editable is not None:
            self.locked_recipient_phone_auth_editable = locked_recipient_phone_auth_editable
        if locked_recipient_sms_editable is not None:
            self.locked_recipient_sms_editable = locked_recipient_sms_editable
        if name is not None:
            self.name = name
        if note is not None:
            self.note = note
        if note_metadata is not None:
            self.note_metadata = note_metadata
        if phone_authentication is not None:
            self.phone_authentication = phone_authentication
        if recipient_attachments is not None:
            self.recipient_attachments = recipient_attachments
        if recipient_authentication_status is not None:
            self.recipient_authentication_status = recipient_authentication_status
        if recipient_feature_metadata is not None:
            self.recipient_feature_metadata = recipient_feature_metadata
        if recipient_id is not None:
            self.recipient_id = recipient_id
        if recipient_id_guid is not None:
            self.recipient_id_guid = recipient_id_guid
        if recipient_signature_providers is not None:
            self.recipient_signature_providers = recipient_signature_providers
        if recipient_type is not None:
            self.recipient_type = recipient_type
        if recipient_type_metadata is not None:
            self.recipient_type_metadata = recipient_type_metadata
        if require_id_lookup is not None:
            self.require_id_lookup = require_id_lookup
        if require_id_lookup_metadata is not None:
            self.require_id_lookup_metadata = require_id_lookup_metadata
        if role_name is not None:
            self.role_name = role_name
        if routing_order is not None:
            self.routing_order = routing_order
        if routing_order_metadata is not None:
            self.routing_order_metadata = routing_order_metadata
        if sent_date_time is not None:
            self.sent_date_time = sent_date_time
        if signed_date_time is not None:
            self.signed_date_time = signed_date_time
        if sms_authentication is not None:
            self.sms_authentication = sms_authentication
        if social_authentications is not None:
            self.social_authentications = social_authentications
        if status is not None:
            self.status = status
        if status_code is not None:
            self.status_code = status_code
        if suppress_emails is not None:
            self.suppress_emails = suppress_emails
        if tabs is not None:
            self.tabs = tabs
        if template_locked is not None:
            self.template_locked = template_locked
        if template_required is not None:
            self.template_required = template_required
        if total_tab_count is not None:
            self.total_tab_count = total_tab_count
        if user_id is not None:
            self.user_id = user_id

    @property
    def access_code(self):
        """Gets the access_code of this SealSign.  # noqa: E501

        If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.  # noqa: E501

        :return: The access_code of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._access_code

    @access_code.setter
    def access_code(self, access_code):
        """Sets the access_code of this SealSign.

        If a value is provided, the recipient must enter the value as the access code to view and sign the envelope.   Maximum Length: 50 characters and it must conform to the account's access code format setting.  If blank, but the signer `accessCode` property is set in the envelope, then that value is used.  If blank and the signer `accessCode` property is not set, then the access code is not required.  # noqa: E501

        :param access_code: The access_code of this SealSign.  # noqa: E501
        :type: str
        """

        self._access_code = access_code

    @property
    def access_code_metadata(self):
        """Gets the access_code_metadata of this SealSign.  # noqa: E501


        :return: The access_code_metadata of this SealSign.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._access_code_metadata

    @access_code_metadata.setter
    def access_code_metadata(self, access_code_metadata):
        """Sets the access_code_metadata of this SealSign.


        :param access_code_metadata: The access_code_metadata of this SealSign.  # noqa: E501
        :type: PropertyMetadata
        """

        self._access_code_metadata = access_code_metadata

    @property
    def add_access_code_to_email(self):
        """Gets the add_access_code_to_email of this SealSign.  # noqa: E501

        This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.  # noqa: E501

        :return: The add_access_code_to_email of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._add_access_code_to_email

    @add_access_code_to_email.setter
    def add_access_code_to_email(self, add_access_code_to_email):
        """Sets the add_access_code_to_email of this SealSign.

        This Optional attribute indicates that the access code will be added to the email sent to the recipient; this nullifies the Security measure of Access Code on the recipient.  # noqa: E501

        :param add_access_code_to_email: The add_access_code_to_email of this SealSign.  # noqa: E501
        :type: str
        """

        self._add_access_code_to_email = add_access_code_to_email

    @property
    def allow_system_override_for_locked_recipient(self):
        """Gets the allow_system_override_for_locked_recipient of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The allow_system_override_for_locked_recipient of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._allow_system_override_for_locked_recipient

    @allow_system_override_for_locked_recipient.setter
    def allow_system_override_for_locked_recipient(self, allow_system_override_for_locked_recipient):
        """Sets the allow_system_override_for_locked_recipient of this SealSign.

          # noqa: E501

        :param allow_system_override_for_locked_recipient: The allow_system_override_for_locked_recipient of this SealSign.  # noqa: E501
        :type: str
        """

        self._allow_system_override_for_locked_recipient = allow_system_override_for_locked_recipient

    @property
    def client_user_id(self):
        """Gets the client_user_id of this SealSign.  # noqa: E501

        Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters.   # noqa: E501

        :return: The client_user_id of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._client_user_id

    @client_user_id.setter
    def client_user_id(self, client_user_id):
        """Sets the client_user_id of this SealSign.

        Specifies whether the recipient is embedded or remote.   If the `clientUserId` property is not null then the recipient is embedded. Note that if the `ClientUserId` property is set and either `SignerMustHaveAccount` or `SignerMustLoginToSign` property of the account settings is set to  **true**, an error is generated on sending.ng.   Maximum length: 100 characters.   # noqa: E501

        :param client_user_id: The client_user_id of this SealSign.  # noqa: E501
        :type: str
        """

        self._client_user_id = client_user_id

    @property
    def completed_count(self):
        """Gets the completed_count of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The completed_count of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._completed_count

    @completed_count.setter
    def completed_count(self, completed_count):
        """Sets the completed_count of this SealSign.

          # noqa: E501

        :param completed_count: The completed_count of this SealSign.  # noqa: E501
        :type: str
        """

        self._completed_count = completed_count

    @property
    def custom_fields(self):
        """Gets the custom_fields of this SealSign.  # noqa: E501

        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.  # noqa: E501

        :return: The custom_fields of this SealSign.  # noqa: E501
        :rtype: list[str]
        """
        return self._custom_fields

    @custom_fields.setter
    def custom_fields(self, custom_fields):
        """Sets the custom_fields of this SealSign.

        An optional array of strings that allows the sender to provide custom data about the recipient. This information is returned in the envelope status but otherwise not used by DocuSign. Each customField string can be a maximum of 100 characters.  # noqa: E501

        :param custom_fields: The custom_fields of this SealSign.  # noqa: E501
        :type: list[str]
        """

        self._custom_fields = custom_fields

    @property
    def declined_date_time(self):
        """Gets the declined_date_time of this SealSign.  # noqa: E501

        The date and time the recipient declined the document.  # noqa: E501

        :return: The declined_date_time of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._declined_date_time

    @declined_date_time.setter
    def declined_date_time(self, declined_date_time):
        """Sets the declined_date_time of this SealSign.

        The date and time the recipient declined the document.  # noqa: E501

        :param declined_date_time: The declined_date_time of this SealSign.  # noqa: E501
        :type: str
        """

        self._declined_date_time = declined_date_time

    @property
    def declined_reason(self):
        """Gets the declined_reason of this SealSign.  # noqa: E501

        The reason the recipient declined the document.  # noqa: E501

        :return: The declined_reason of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._declined_reason

    @declined_reason.setter
    def declined_reason(self, declined_reason):
        """Sets the declined_reason of this SealSign.

        The reason the recipient declined the document.  # noqa: E501

        :param declined_reason: The declined_reason of this SealSign.  # noqa: E501
        :type: str
        """

        self._declined_reason = declined_reason

    @property
    def delivered_date_time(self):
        """Gets the delivered_date_time of this SealSign.  # noqa: E501

        Reserved: For DocuSign use only.  # noqa: E501

        :return: The delivered_date_time of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._delivered_date_time

    @delivered_date_time.setter
    def delivered_date_time(self, delivered_date_time):
        """Sets the delivered_date_time of this SealSign.

        Reserved: For DocuSign use only.  # noqa: E501

        :param delivered_date_time: The delivered_date_time of this SealSign.  # noqa: E501
        :type: str
        """

        self._delivered_date_time = delivered_date_time

    @property
    def delivery_method(self):
        """Gets the delivery_method of this SealSign.  # noqa: E501

        Reserved: For DocuSign use only.  # noqa: E501

        :return: The delivery_method of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._delivery_method

    @delivery_method.setter
    def delivery_method(self, delivery_method):
        """Sets the delivery_method of this SealSign.

        Reserved: For DocuSign use only.  # noqa: E501

        :param delivery_method: The delivery_method of this SealSign.  # noqa: E501
        :type: str
        """

        self._delivery_method = delivery_method

    @property
    def delivery_method_metadata(self):
        """Gets the delivery_method_metadata of this SealSign.  # noqa: E501


        :return: The delivery_method_metadata of this SealSign.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._delivery_method_metadata

    @delivery_method_metadata.setter
    def delivery_method_metadata(self, delivery_method_metadata):
        """Sets the delivery_method_metadata of this SealSign.


        :param delivery_method_metadata: The delivery_method_metadata of this SealSign.  # noqa: E501
        :type: PropertyMetadata
        """

        self._delivery_method_metadata = delivery_method_metadata

    @property
    def designator_id(self):
        """Gets the designator_id of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The designator_id of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._designator_id

    @designator_id.setter
    def designator_id(self, designator_id):
        """Sets the designator_id of this SealSign.

          # noqa: E501

        :param designator_id: The designator_id of this SealSign.  # noqa: E501
        :type: str
        """

        self._designator_id = designator_id

    @property
    def designator_id_guid(self):
        """Gets the designator_id_guid of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The designator_id_guid of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._designator_id_guid

    @designator_id_guid.setter
    def designator_id_guid(self, designator_id_guid):
        """Sets the designator_id_guid of this SealSign.

          # noqa: E501

        :param designator_id_guid: The designator_id_guid of this SealSign.  # noqa: E501
        :type: str
        """

        self._designator_id_guid = designator_id_guid

    @property
    def document_visibility(self):
        """Gets the document_visibility of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The document_visibility of this SealSign.  # noqa: E501
        :rtype: list[DocumentVisibility]
        """
        return self._document_visibility

    @document_visibility.setter
    def document_visibility(self, document_visibility):
        """Sets the document_visibility of this SealSign.

          # noqa: E501

        :param document_visibility: The document_visibility of this SealSign.  # noqa: E501
        :type: list[DocumentVisibility]
        """

        self._document_visibility = document_visibility

    @property
    def email_notification(self):
        """Gets the email_notification of this SealSign.  # noqa: E501


        :return: The email_notification of this SealSign.  # noqa: E501
        :rtype: RecipientEmailNotification
        """
        return self._email_notification

    @email_notification.setter
    def email_notification(self, email_notification):
        """Sets the email_notification of this SealSign.


        :param email_notification: The email_notification of this SealSign.  # noqa: E501
        :type: RecipientEmailNotification
        """

        self._email_notification = email_notification

    @property
    def embedded_recipient_start_url(self):
        """Gets the embedded_recipient_start_url of this SealSign.  # noqa: E501

        Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`   # noqa: E501

        :return: The embedded_recipient_start_url of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._embedded_recipient_start_url

    @embedded_recipient_start_url.setter
    def embedded_recipient_start_url(self, embedded_recipient_start_url):
        """Sets the embedded_recipient_start_url of this SealSign.

        Specifies a sender provided valid URL string for redirecting an embedded recipient. When using this option, the embedded recipient still receives an email from DocuSign, just as a remote recipient would. When the document link in the email is clicked the recipient is redirected, through DocuSign, to the supplied URL to complete their actions. When routing to the URL, the sender's system (the server responding to the URL) must request a recipient token to launch a signing session.   If set to `SIGN_AT_DOCUSIGN`, the recipient is directed to an embedded signing or viewing process directly at DocuSign. The signing or viewing action is initiated by the DocuSign system and the transaction activity and Certificate of Completion records will reflect this. In all other ways the process is identical to an embedded signing or viewing operation that is launched by any partner.  It is important to remember that in a typical embedded workflow the authentication of an embedded recipient is the responsibility of the sending application, DocuSign expects that senders will follow their own process for establishing the recipient's identity. In this workflow the recipient goes through the sending application before the embedded signing or viewing process in initiated. However, when the sending application sets `EmbeddedRecipientStartURL=SIGN_AT_DOCUSIGN`, the recipient goes directly to the embedded signing or viewing process bypassing the sending application and any authentication steps the sending application would use. In this case, DocuSign recommends that you use one of the normal DocuSign authentication features (Access Code, Phone Authentication, SMS Authentication, etc.) to verify the identity of the recipient.  If the `clientUserId` property is NOT set, and the `embeddedRecipientStartURL` is set, DocuSign will ignore the redirect URL and launch the standard signing process for the email recipient. Information can be appended to the embedded recipient start URL using merge fields. The available merge fields items are: envelopeId, recipientId, recipientName, recipientEmail, and customFields. The `customFields` property must be set fort the recipient or envelope. The merge fields are enclosed in double brackets.   *Example*:   `http://senderHost/[[mergeField1]]/ beginSigningSession? [[mergeField2]]&[[mergeField3]]`   # noqa: E501

        :param embedded_recipient_start_url: The embedded_recipient_start_url of this SealSign.  # noqa: E501
        :type: str
        """

        self._embedded_recipient_start_url = embedded_recipient_start_url

    @property
    def error_details(self):
        """Gets the error_details of this SealSign.  # noqa: E501


        :return: The error_details of this SealSign.  # noqa: E501
        :rtype: ErrorDetails
        """
        return self._error_details

    @error_details.setter
    def error_details(self, error_details):
        """Sets the error_details of this SealSign.


        :param error_details: The error_details of this SealSign.  # noqa: E501
        :type: ErrorDetails
        """

        self._error_details = error_details

    @property
    def fax_number(self):
        """Gets the fax_number of this SealSign.  # noqa: E501

        Reserved:  # noqa: E501

        :return: The fax_number of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._fax_number

    @fax_number.setter
    def fax_number(self, fax_number):
        """Sets the fax_number of this SealSign.

        Reserved:  # noqa: E501

        :param fax_number: The fax_number of this SealSign.  # noqa: E501
        :type: str
        """

        self._fax_number = fax_number

    @property
    def fax_number_metadata(self):
        """Gets the fax_number_metadata of this SealSign.  # noqa: E501


        :return: The fax_number_metadata of this SealSign.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._fax_number_metadata

    @fax_number_metadata.setter
    def fax_number_metadata(self, fax_number_metadata):
        """Sets the fax_number_metadata of this SealSign.


        :param fax_number_metadata: The fax_number_metadata of this SealSign.  # noqa: E501
        :type: PropertyMetadata
        """

        self._fax_number_metadata = fax_number_metadata

    @property
    def id_check_configuration_name(self):
        """Gets the id_check_configuration_name of this SealSign.  # noqa: E501

        Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.  # noqa: E501

        :return: The id_check_configuration_name of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._id_check_configuration_name

    @id_check_configuration_name.setter
    def id_check_configuration_name(self, id_check_configuration_name):
        """Sets the id_check_configuration_name of this SealSign.

        Specifies authentication check by name. The names used here must be the same as the authentication type names used by the account (these name can also be found in the web console sending interface in the Identify list for a recipient,) This overrides any default authentication setting.  *Example*: Your account has ID Check and SMS Authentication available and in the web console Identify list these appear as 'ID Check $' and 'SMS Auth $'. To use ID check in an envelope, the idCheckConfigurationName should be 'ID Check '. If you wanted to use SMS, it would be 'SMS Auth $' and you would need to add you would need to add phone number information to the `smsAuthentication` node.  # noqa: E501

        :param id_check_configuration_name: The id_check_configuration_name of this SealSign.  # noqa: E501
        :type: str
        """

        self._id_check_configuration_name = id_check_configuration_name

    @property
    def id_check_configuration_name_metadata(self):
        """Gets the id_check_configuration_name_metadata of this SealSign.  # noqa: E501


        :return: The id_check_configuration_name_metadata of this SealSign.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._id_check_configuration_name_metadata

    @id_check_configuration_name_metadata.setter
    def id_check_configuration_name_metadata(self, id_check_configuration_name_metadata):
        """Sets the id_check_configuration_name_metadata of this SealSign.


        :param id_check_configuration_name_metadata: The id_check_configuration_name_metadata of this SealSign.  # noqa: E501
        :type: PropertyMetadata
        """

        self._id_check_configuration_name_metadata = id_check_configuration_name_metadata

    @property
    def id_check_information_input(self):
        """Gets the id_check_information_input of this SealSign.  # noqa: E501


        :return: The id_check_information_input of this SealSign.  # noqa: E501
        :rtype: IdCheckInformationInput
        """
        return self._id_check_information_input

    @id_check_information_input.setter
    def id_check_information_input(self, id_check_information_input):
        """Sets the id_check_information_input of this SealSign.


        :param id_check_information_input: The id_check_information_input of this SealSign.  # noqa: E501
        :type: IdCheckInformationInput
        """

        self._id_check_information_input = id_check_information_input

    @property
    def identity_verification(self):
        """Gets the identity_verification of this SealSign.  # noqa: E501


        :return: The identity_verification of this SealSign.  # noqa: E501
        :rtype: RecipientIdentityVerification
        """
        return self._identity_verification

    @identity_verification.setter
    def identity_verification(self, identity_verification):
        """Sets the identity_verification of this SealSign.


        :param identity_verification: The identity_verification of this SealSign.  # noqa: E501
        :type: RecipientIdentityVerification
        """

        self._identity_verification = identity_verification

    @property
    def inherit_email_notification_configuration(self):
        """Gets the inherit_email_notification_configuration of this SealSign.  # noqa: E501

        When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account.   # noqa: E501

        :return: The inherit_email_notification_configuration of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._inherit_email_notification_configuration

    @inherit_email_notification_configuration.setter
    def inherit_email_notification_configuration(self, inherit_email_notification_configuration):
        """Sets the inherit_email_notification_configuration of this SealSign.

        When set to **true** and the envelope recipient creates a DocuSign account after signing, the Manage Account Email Notification settings are used as the default settings for the recipient's account.   # noqa: E501

        :param inherit_email_notification_configuration: The inherit_email_notification_configuration of this SealSign.  # noqa: E501
        :type: str
        """

        self._inherit_email_notification_configuration = inherit_email_notification_configuration

    @property
    def locked_recipient_phone_auth_editable(self):
        """Gets the locked_recipient_phone_auth_editable of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The locked_recipient_phone_auth_editable of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._locked_recipient_phone_auth_editable

    @locked_recipient_phone_auth_editable.setter
    def locked_recipient_phone_auth_editable(self, locked_recipient_phone_auth_editable):
        """Sets the locked_recipient_phone_auth_editable of this SealSign.

          # noqa: E501

        :param locked_recipient_phone_auth_editable: The locked_recipient_phone_auth_editable of this SealSign.  # noqa: E501
        :type: str
        """

        self._locked_recipient_phone_auth_editable = locked_recipient_phone_auth_editable

    @property
    def locked_recipient_sms_editable(self):
        """Gets the locked_recipient_sms_editable of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The locked_recipient_sms_editable of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._locked_recipient_sms_editable

    @locked_recipient_sms_editable.setter
    def locked_recipient_sms_editable(self, locked_recipient_sms_editable):
        """Sets the locked_recipient_sms_editable of this SealSign.

          # noqa: E501

        :param locked_recipient_sms_editable: The locked_recipient_sms_editable of this SealSign.  # noqa: E501
        :type: str
        """

        self._locked_recipient_sms_editable = locked_recipient_sms_editable

    @property
    def name(self):
        """Gets the name of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The name of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this SealSign.

          # noqa: E501

        :param name: The name of this SealSign.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def note(self):
        """Gets the note of this SealSign.  # noqa: E501

        Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.  # noqa: E501

        :return: The note of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._note

    @note.setter
    def note(self, note):
        """Sets the note of this SealSign.

        Specifies a note that is unique to this recipient. This note is sent to the recipient via the signing email. The note displays in the signing UI near the upper left corner of the document on the signing screen.  Maximum Length: 1000 characters.  # noqa: E501

        :param note: The note of this SealSign.  # noqa: E501
        :type: str
        """

        self._note = note

    @property
    def note_metadata(self):
        """Gets the note_metadata of this SealSign.  # noqa: E501


        :return: The note_metadata of this SealSign.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._note_metadata

    @note_metadata.setter
    def note_metadata(self, note_metadata):
        """Sets the note_metadata of this SealSign.


        :param note_metadata: The note_metadata of this SealSign.  # noqa: E501
        :type: PropertyMetadata
        """

        self._note_metadata = note_metadata

    @property
    def phone_authentication(self):
        """Gets the phone_authentication of this SealSign.  # noqa: E501


        :return: The phone_authentication of this SealSign.  # noqa: E501
        :rtype: RecipientPhoneAuthentication
        """
        return self._phone_authentication

    @phone_authentication.setter
    def phone_authentication(self, phone_authentication):
        """Sets the phone_authentication of this SealSign.


        :param phone_authentication: The phone_authentication of this SealSign.  # noqa: E501
        :type: RecipientPhoneAuthentication
        """

        self._phone_authentication = phone_authentication

    @property
    def recipient_attachments(self):
        """Gets the recipient_attachments of this SealSign.  # noqa: E501

        Reserved:  # noqa: E501

        :return: The recipient_attachments of this SealSign.  # noqa: E501
        :rtype: list[RecipientAttachment]
        """
        return self._recipient_attachments

    @recipient_attachments.setter
    def recipient_attachments(self, recipient_attachments):
        """Sets the recipient_attachments of this SealSign.

        Reserved:  # noqa: E501

        :param recipient_attachments: The recipient_attachments of this SealSign.  # noqa: E501
        :type: list[RecipientAttachment]
        """

        self._recipient_attachments = recipient_attachments

    @property
    def recipient_authentication_status(self):
        """Gets the recipient_authentication_status of this SealSign.  # noqa: E501


        :return: The recipient_authentication_status of this SealSign.  # noqa: E501
        :rtype: AuthenticationStatus
        """
        return self._recipient_authentication_status

    @recipient_authentication_status.setter
    def recipient_authentication_status(self, recipient_authentication_status):
        """Sets the recipient_authentication_status of this SealSign.


        :param recipient_authentication_status: The recipient_authentication_status of this SealSign.  # noqa: E501
        :type: AuthenticationStatus
        """

        self._recipient_authentication_status = recipient_authentication_status

    @property
    def recipient_feature_metadata(self):
        """Gets the recipient_feature_metadata of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The recipient_feature_metadata of this SealSign.  # noqa: E501
        :rtype: list[FeatureAvailableMetadata]
        """
        return self._recipient_feature_metadata

    @recipient_feature_metadata.setter
    def recipient_feature_metadata(self, recipient_feature_metadata):
        """Sets the recipient_feature_metadata of this SealSign.

          # noqa: E501

        :param recipient_feature_metadata: The recipient_feature_metadata of this SealSign.  # noqa: E501
        :type: list[FeatureAvailableMetadata]
        """

        self._recipient_feature_metadata = recipient_feature_metadata

    @property
    def recipient_id(self):
        """Gets the recipient_id of this SealSign.  # noqa: E501

        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.  # noqa: E501

        :return: The recipient_id of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._recipient_id

    @recipient_id.setter
    def recipient_id(self, recipient_id):
        """Sets the recipient_id of this SealSign.

        Unique for the recipient. It is used by the tab element to indicate which recipient is to sign the Document.  # noqa: E501

        :param recipient_id: The recipient_id of this SealSign.  # noqa: E501
        :type: str
        """

        self._recipient_id = recipient_id

    @property
    def recipient_id_guid(self):
        """Gets the recipient_id_guid of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The recipient_id_guid of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._recipient_id_guid

    @recipient_id_guid.setter
    def recipient_id_guid(self, recipient_id_guid):
        """Sets the recipient_id_guid of this SealSign.

          # noqa: E501

        :param recipient_id_guid: The recipient_id_guid of this SealSign.  # noqa: E501
        :type: str
        """

        self._recipient_id_guid = recipient_id_guid

    @property
    def recipient_signature_providers(self):
        """Gets the recipient_signature_providers of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The recipient_signature_providers of this SealSign.  # noqa: E501
        :rtype: list[RecipientSignatureProvider]
        """
        return self._recipient_signature_providers

    @recipient_signature_providers.setter
    def recipient_signature_providers(self, recipient_signature_providers):
        """Sets the recipient_signature_providers of this SealSign.

          # noqa: E501

        :param recipient_signature_providers: The recipient_signature_providers of this SealSign.  # noqa: E501
        :type: list[RecipientSignatureProvider]
        """

        self._recipient_signature_providers = recipient_signature_providers

    @property
    def recipient_type(self):
        """Gets the recipient_type of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The recipient_type of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._recipient_type

    @recipient_type.setter
    def recipient_type(self, recipient_type):
        """Sets the recipient_type of this SealSign.

          # noqa: E501

        :param recipient_type: The recipient_type of this SealSign.  # noqa: E501
        :type: str
        """

        self._recipient_type = recipient_type

    @property
    def recipient_type_metadata(self):
        """Gets the recipient_type_metadata of this SealSign.  # noqa: E501


        :return: The recipient_type_metadata of this SealSign.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._recipient_type_metadata

    @recipient_type_metadata.setter
    def recipient_type_metadata(self, recipient_type_metadata):
        """Sets the recipient_type_metadata of this SealSign.


        :param recipient_type_metadata: The recipient_type_metadata of this SealSign.  # noqa: E501
        :type: PropertyMetadata
        """

        self._recipient_type_metadata = recipient_type_metadata

    @property
    def require_id_lookup(self):
        """Gets the require_id_lookup of this SealSign.  # noqa: E501

        When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity.   # noqa: E501

        :return: The require_id_lookup of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._require_id_lookup

    @require_id_lookup.setter
    def require_id_lookup(self, require_id_lookup):
        """Sets the require_id_lookup of this SealSign.

        When set to **true**, the recipient is required to use the specified ID check method (including Phone and SMS authentication) to validate their identity.   # noqa: E501

        :param require_id_lookup: The require_id_lookup of this SealSign.  # noqa: E501
        :type: str
        """

        self._require_id_lookup = require_id_lookup

    @property
    def require_id_lookup_metadata(self):
        """Gets the require_id_lookup_metadata of this SealSign.  # noqa: E501


        :return: The require_id_lookup_metadata of this SealSign.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._require_id_lookup_metadata

    @require_id_lookup_metadata.setter
    def require_id_lookup_metadata(self, require_id_lookup_metadata):
        """Sets the require_id_lookup_metadata of this SealSign.


        :param require_id_lookup_metadata: The require_id_lookup_metadata of this SealSign.  # noqa: E501
        :type: PropertyMetadata
        """

        self._require_id_lookup_metadata = require_id_lookup_metadata

    @property
    def role_name(self):
        """Gets the role_name of this SealSign.  # noqa: E501

        Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.  # noqa: E501

        :return: The role_name of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._role_name

    @role_name.setter
    def role_name(self, role_name):
        """Sets the role_name of this SealSign.

        Optional element. Specifies the role name associated with the recipient.<br/><br/>This is required when working with template recipients.  # noqa: E501

        :param role_name: The role_name of this SealSign.  # noqa: E501
        :type: str
        """

        self._role_name = role_name

    @property
    def routing_order(self):
        """Gets the routing_order of this SealSign.  # noqa: E501

        Specifies the routing order of the recipient in the envelope.   # noqa: E501

        :return: The routing_order of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._routing_order

    @routing_order.setter
    def routing_order(self, routing_order):
        """Sets the routing_order of this SealSign.

        Specifies the routing order of the recipient in the envelope.   # noqa: E501

        :param routing_order: The routing_order of this SealSign.  # noqa: E501
        :type: str
        """

        self._routing_order = routing_order

    @property
    def routing_order_metadata(self):
        """Gets the routing_order_metadata of this SealSign.  # noqa: E501


        :return: The routing_order_metadata of this SealSign.  # noqa: E501
        :rtype: PropertyMetadata
        """
        return self._routing_order_metadata

    @routing_order_metadata.setter
    def routing_order_metadata(self, routing_order_metadata):
        """Sets the routing_order_metadata of this SealSign.


        :param routing_order_metadata: The routing_order_metadata of this SealSign.  # noqa: E501
        :type: PropertyMetadata
        """

        self._routing_order_metadata = routing_order_metadata

    @property
    def sent_date_time(self):
        """Gets the sent_date_time of this SealSign.  # noqa: E501

        The date and time the envelope was sent.  # noqa: E501

        :return: The sent_date_time of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._sent_date_time

    @sent_date_time.setter
    def sent_date_time(self, sent_date_time):
        """Sets the sent_date_time of this SealSign.

        The date and time the envelope was sent.  # noqa: E501

        :param sent_date_time: The sent_date_time of this SealSign.  # noqa: E501
        :type: str
        """

        self._sent_date_time = sent_date_time

    @property
    def signed_date_time(self):
        """Gets the signed_date_time of this SealSign.  # noqa: E501

        Reserved: For DocuSign use only.   # noqa: E501

        :return: The signed_date_time of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._signed_date_time

    @signed_date_time.setter
    def signed_date_time(self, signed_date_time):
        """Sets the signed_date_time of this SealSign.

        Reserved: For DocuSign use only.   # noqa: E501

        :param signed_date_time: The signed_date_time of this SealSign.  # noqa: E501
        :type: str
        """

        self._signed_date_time = signed_date_time

    @property
    def sms_authentication(self):
        """Gets the sms_authentication of this SealSign.  # noqa: E501


        :return: The sms_authentication of this SealSign.  # noqa: E501
        :rtype: RecipientSMSAuthentication
        """
        return self._sms_authentication

    @sms_authentication.setter
    def sms_authentication(self, sms_authentication):
        """Sets the sms_authentication of this SealSign.


        :param sms_authentication: The sms_authentication of this SealSign.  # noqa: E501
        :type: RecipientSMSAuthentication
        """

        self._sms_authentication = sms_authentication

    @property
    def social_authentications(self):
        """Gets the social_authentications of this SealSign.  # noqa: E501

         Lists the social ID type that can be used for recipient authentication.  # noqa: E501

        :return: The social_authentications of this SealSign.  # noqa: E501
        :rtype: list[SocialAuthentication]
        """
        return self._social_authentications

    @social_authentications.setter
    def social_authentications(self, social_authentications):
        """Sets the social_authentications of this SealSign.

         Lists the social ID type that can be used for recipient authentication.  # noqa: E501

        :param social_authentications: The social_authentications of this SealSign.  # noqa: E501
        :type: list[SocialAuthentication]
        """

        self._social_authentications = social_authentications

    @property
    def status(self):
        """Gets the status of this SealSign.  # noqa: E501

        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.  # noqa: E501

        :return: The status of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this SealSign.

        Indicates the envelope status. Valid values are:  * sent - The envelope is sent to the recipients.  * created - The envelope is saved as a draft and can be modified and sent later.  # noqa: E501

        :param status: The status of this SealSign.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def status_code(self):
        """Gets the status_code of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The status_code of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """Sets the status_code of this SealSign.

          # noqa: E501

        :param status_code: The status_code of this SealSign.  # noqa: E501
        :type: str
        """

        self._status_code = status_code

    @property
    def suppress_emails(self):
        """Gets the suppress_emails of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The suppress_emails of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._suppress_emails

    @suppress_emails.setter
    def suppress_emails(self, suppress_emails):
        """Sets the suppress_emails of this SealSign.

          # noqa: E501

        :param suppress_emails: The suppress_emails of this SealSign.  # noqa: E501
        :type: str
        """

        self._suppress_emails = suppress_emails

    @property
    def tabs(self):
        """Gets the tabs of this SealSign.  # noqa: E501


        :return: The tabs of this SealSign.  # noqa: E501
        :rtype: Tabs
        """
        return self._tabs

    @tabs.setter
    def tabs(self, tabs):
        """Sets the tabs of this SealSign.


        :param tabs: The tabs of this SealSign.  # noqa: E501
        :type: Tabs
        """

        self._tabs = tabs

    @property
    def template_locked(self):
        """Gets the template_locked of this SealSign.  # noqa: E501

        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.   # noqa: E501

        :return: The template_locked of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._template_locked

    @template_locked.setter
    def template_locked(self, template_locked):
        """Sets the template_locked of this SealSign.

        When set to **true**, the sender cannot change any attributes of the recipient. Used only when working with template recipients.   # noqa: E501

        :param template_locked: The template_locked of this SealSign.  # noqa: E501
        :type: str
        """

        self._template_locked = template_locked

    @property
    def template_required(self):
        """Gets the template_required of this SealSign.  # noqa: E501

        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.  # noqa: E501

        :return: The template_required of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._template_required

    @template_required.setter
    def template_required(self, template_required):
        """Sets the template_required of this SealSign.

        When set to **true**, the sender may not remove the recipient. Used only when working with template recipients.  # noqa: E501

        :param template_required: The template_required of this SealSign.  # noqa: E501
        :type: str
        """

        self._template_required = template_required

    @property
    def total_tab_count(self):
        """Gets the total_tab_count of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The total_tab_count of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._total_tab_count

    @total_tab_count.setter
    def total_tab_count(self, total_tab_count):
        """Sets the total_tab_count of this SealSign.

          # noqa: E501

        :param total_tab_count: The total_tab_count of this SealSign.  # noqa: E501
        :type: str
        """

        self._total_tab_count = total_tab_count

    @property
    def user_id(self):
        """Gets the user_id of this SealSign.  # noqa: E501

          # noqa: E501

        :return: The user_id of this SealSign.  # noqa: E501
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """Sets the user_id of this SealSign.

          # noqa: E501

        :param user_id: The user_id of this SealSign.  # noqa: E501
        :type: str
        """

        self._user_id = user_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SealSign, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SealSign):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
