import dataclasses
import enum
import typing

from mubble.bot.dispatch.context import Context
from mubble.bot.rules.abc import ABCRule
from mubble.node.source import Source

if typing.TYPE_CHECKING:
    from mubble.tools.state_storage.abc import ABCStateStorage


class StateMeta(enum.Enum):
    NO_STATE = enum.auto()
    ANY = enum.auto()


@dataclasses.dataclass(frozen=True, slots=True, repr=False)
class State[Payload](ABCRule):
    storage: "ABCStateStorage[Payload]"
    key: str | StateMeta | enum.Enum

    async def check(self, source: Source, ctx: Context) -> bool:
        state = await self.storage.get(source.from_user.id)
        if not state:
            return self.key == StateMeta.NO_STATE

        if self.key != StateMeta.ANY and self.key != state.unwrap().key:
            return False

        ctx["state"] = state.unwrap()
        return True


__all__ = ("State", "StateMeta")
