"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlbController = exports.AlbScheme = exports.AlbControllerVersion = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const fs = require("fs");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const helm_chart_1 = require("./helm-chart");
const service_account_1 = require("./service-account");
// v2 - keep this import as a separate section to reduce merge conflict when forward merging with the v2 branch.
// eslint-disable-next-line
const core_1 = require("@aws-cdk/core");
/**
 * Controller version.
 *
 * Corresponds to the image tag of 'amazon/aws-load-balancer-controller' image.
 */
class AlbControllerVersion {
    constructor(
    /**
     * The version string.
     */
    version, 
    /**
     * Whether or not its a custom version.
     */
    custom) {
        this.version = version;
        this.custom = custom;
    }
    /**
     * Specify a custom version.
     * Use this if the version you need is not available in one of the predefined versions.
     * Note that in this case, you will also need to provide an IAM policy in the controller options.
     *
     * @param version The version number.
     */
    static of(version) {
        return new AlbControllerVersion(version, true);
    }
}
exports.AlbControllerVersion = AlbControllerVersion;
_a = JSII_RTTI_SYMBOL_1;
AlbControllerVersion[_a] = { fqn: "@aws-cdk/aws-eks.AlbControllerVersion", version: "1.175.0" };
/**
 * v2.0.0
 */
AlbControllerVersion.V2_0_0 = new AlbControllerVersion('v2.0.0', false);
/**
 * v2.0.1
 */
AlbControllerVersion.V2_0_1 = new AlbControllerVersion('v2.0.1', false);
/**
 * v2.1.0
 */
AlbControllerVersion.V2_1_0 = new AlbControllerVersion('v2.1.0', false);
/**
 * v2.1.1
 */
AlbControllerVersion.V2_1_1 = new AlbControllerVersion('v2.1.1', false);
/**
 * v2.1.2
 */
AlbControllerVersion.V2_1_2 = new AlbControllerVersion('v2.1.2', false);
/**
 * v2.1.3
 */
AlbControllerVersion.V2_1_3 = new AlbControllerVersion('v2.1.3', false);
/**
 * v2.0.0
 */
AlbControllerVersion.V2_2_0 = new AlbControllerVersion('v2.2.0', false);
/**
 * v2.2.1
 */
AlbControllerVersion.V2_2_1 = new AlbControllerVersion('v2.2.1', false);
/**
 * v2.2.2
 */
AlbControllerVersion.V2_2_2 = new AlbControllerVersion('v2.2.2', false);
/**
 * v2.2.3
 */
AlbControllerVersion.V2_2_3 = new AlbControllerVersion('v2.2.3', false);
/**
 * v2.2.4
 */
AlbControllerVersion.V2_2_4 = new AlbControllerVersion('v2.2.4', false);
/**
 * v2.3.0
 */
AlbControllerVersion.V2_3_0 = new AlbControllerVersion('v2.3.0', false);
/**
 * v2.3.1
 */
AlbControllerVersion.V2_3_1 = new AlbControllerVersion('v2.3.1', false);
/**
 * v2.4.1
 */
AlbControllerVersion.V2_4_1 = new AlbControllerVersion('v2.4.1', false);
/**
 * ALB Scheme.
 *
 * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.3/guide/ingress/annotations/#scheme
 */
var AlbScheme;
(function (AlbScheme) {
    /**
     * The nodes of an internal load balancer have only private IP addresses.
     * The DNS name of an internal load balancer is publicly resolvable to the private IP addresses of the nodes.
     * Therefore, internal load balancers can only route requests from clients with access to the VPC for the load balancer.
     */
    AlbScheme["INTERNAL"] = "internal";
    /**
     * An internet-facing load balancer has a publicly resolvable DNS name, so it can route requests from clients over the internet
     * to the EC2 instances that are registered with the load balancer.
     */
    AlbScheme["INTERNET_FACING"] = "internet-facing";
})(AlbScheme = exports.AlbScheme || (exports.AlbScheme = {}));
/**
 * Construct for installing the AWS ALB Contoller on EKS clusters.
 *
 * Use the factory functions `get` and `getOrCreate` to obtain/create instances of this controller.
 *
 * @see https://kubernetes-sigs.github.io/aws-load-balancer-controller
 *
 */
class AlbController extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_AlbControllerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AlbController);
            }
            throw error;
        }
        const namespace = 'kube-system';
        const serviceAccount = new service_account_1.ServiceAccount(this, 'alb-sa', { namespace, name: 'aws-load-balancer-controller', cluster: props.cluster });
        if (props.version.custom && !props.policy) {
            throw new Error("'albControllerOptions.policy' is required when using a custom controller version");
        }
        // https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/deploy/installation/#iam-permissions
        const policy = props.policy ?? JSON.parse(fs.readFileSync(path.join(__dirname, 'addons', `alb-iam_policy-${props.version.version}.json`), 'utf8'));
        for (const statement of policy.Statement) {
            serviceAccount.addToPrincipalPolicy(iam.PolicyStatement.fromJson(statement));
        }
        // https://kubernetes-sigs.github.io/aws-load-balancer-controller/v2.2/deploy/installation/#add-controller-to-cluster
        const chart = new helm_chart_1.HelmChart(this, 'Resource', {
            cluster: props.cluster,
            chart: 'aws-load-balancer-controller',
            repository: 'https://aws.github.io/eks-charts',
            namespace,
            release: 'aws-load-balancer-controller',
            // latest at the time of writing. We intentionally don't
            // want to expose this since helm here is just an implementation detail
            // for installing a specific version of the controller itself.
            // https://github.com/aws/eks-charts/blob/v0.0.65/stable/aws-load-balancer-controller/Chart.yaml
            version: '1.2.7',
            wait: true,
            timeout: core_1.Duration.minutes(15),
            values: {
                clusterName: props.cluster.clusterName,
                serviceAccount: {
                    create: false,
                    name: serviceAccount.serviceAccountName,
                },
                region: core_1.Stack.of(this).region,
                vpcId: props.cluster.vpc.vpcId,
                image: {
                    repository: props.repository ?? '602401143452.dkr.ecr.us-west-2.amazonaws.com/amazon/aws-load-balancer-controller',
                    tag: props.version.version,
                },
            },
        });
        // the controller relies on permissions deployed using these resources.
        chart.node.addDependency(serviceAccount);
        chart.node.addDependency(props.cluster.openIdConnectProvider);
        chart.node.addDependency(props.cluster.awsAuth);
    }
    /**
     * Create the controller construct associated with this cluster and scope.
     *
     * Singleton per stack/cluster.
     */
    static create(scope, props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_eks_AlbControllerProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.create);
            }
            throw error;
        }
        const stack = core_1.Stack.of(scope);
        const uid = AlbController.uid(props.cluster);
        return new AlbController(stack, uid, props);
    }
    static uid(cluster) {
        return `${core_1.Names.nodeUniqueId(cluster.node)}-AlbController`;
    }
}
exports.AlbController = AlbController;
_b = JSII_RTTI_SYMBOL_1;
AlbController[_b] = { fqn: "@aws-cdk/aws-eks.AlbController", version: "1.175.0" };
//# sourceMappingURL=data:application/json;base64,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