# DeViSE (deep visual-semantic embedding) Search
In many corners of Wellcome's image collections, digital images exist without any associated metadata (ie titles, descriptions, lettering etc). This is a problem in the context of search, exploration and discovery of visual material; almost all modern image search algorithms rely on comparison of a user's query to images' associated text records. Uncaptioned images are therefore 'dark' from the perspective of the search box, and captions are required to be thorough, complete descriptions if we want to capture a diverse range of possible queries.

We respond to the problem by creating a _shared latent space_ between text and images. The idea of the shared space comes from Google's 2012 paper [_DeViSE: A Deep Visual-Semantic Embedding Model_](https://static.googleusercontent.com/media/research.google.com/en//pubs/archive/41473.pdf). However, here we extend the concept to encode not only the distinct Imagenet categories against the word vectors of their classes, but a continuum of images against a similarly continuously-populated space of captions, using an NLI-trained sentence embedding model inspired by Facebook Research's work on [_InferSent_](https://github.com/facebookresearch/InferSent).  
Apart from the various visual embedding backbones tested here (VGG16, Resnet34, etc), all of the networks in this project were written by hand in PyTorch and trained on an AWS p2.xlarge instance.

After the training is complete and all images have been embedded in the shared space, a search index is created using [_nmslib_](https://github.com/nmslib/nmslib).  
The combination of an intentionally compact sentence-embedding network and a hierarchical, graph based search index makes returning results for a query incredibly fast.

[These notebooks](notebooks/) document the research that led us to the process and results above. They're technical, and they assume a basic knowledge of lots of machine learning concepts. If they feel like too much, take a look at our [Stacks post]() on the technique for a gentler, more visual introduction. The DeViSE-search principle is also demonstrated in a [labs web app](http://labs.wellcomecollection.org/devise/index.html).