/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.fixed;

import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.common.TextWritingException;
import com.univocity.parsers.fixed.FieldAlignment;
import com.univocity.parsers.fixed.FixedWidthFormat;
import com.univocity.parsers.fixed.FixedWidthWriterSettings;
import com.univocity.parsers.fixed.Lookup;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;

public class FixedWidthWriter
extends AbstractWriter<FixedWidthWriterSettings> {
    private boolean ignoreLeading;
    private boolean ignoreTrailing;
    private int[] fieldLengths;
    private FieldAlignment[] fieldAlignments;
    private char[] fieldPaddings;
    private char padding;
    private char defaultPadding;
    private int length;
    private FieldAlignment alignment;
    private Lookup[] lookaheadFormats;
    private Lookup[] lookbehindFormats;
    private char[] lookupChars;
    private Lookup lookbehindFormat;
    private int[] rootLengths;
    private FieldAlignment[] rootAlignments;
    private char[] rootPaddings;
    private boolean defaultHeaderPadding;
    private FieldAlignment defaultHeaderAlignment;

    public FixedWidthWriter(FixedWidthWriterSettings settings) {
        this((Writer)null, settings);
    }

    public FixedWidthWriter(Writer writer, FixedWidthWriterSettings settings) {
        super(writer, settings);
    }

    public FixedWidthWriter(File file, FixedWidthWriterSettings settings) {
        super(file, settings);
    }

    public FixedWidthWriter(File file, String encoding, FixedWidthWriterSettings settings) {
        super(file, encoding, settings);
    }

    public FixedWidthWriter(File file, Charset encoding, FixedWidthWriterSettings settings) {
        super(file, encoding, settings);
    }

    public FixedWidthWriter(OutputStream output, FixedWidthWriterSettings settings) {
        super(output, settings);
    }

    public FixedWidthWriter(OutputStream output, String encoding, FixedWidthWriterSettings settings) {
        super(output, encoding, settings);
    }

    public FixedWidthWriter(OutputStream output, Charset encoding, FixedWidthWriterSettings settings) {
        super(output, encoding, settings);
    }

    @Override
    protected final void initialize(FixedWidthWriterSettings settings) {
        FixedWidthFormat format = (FixedWidthFormat)settings.getFormat();
        this.defaultPadding = this.padding = format.getPadding();
        this.ignoreLeading = settings.getIgnoreLeadingWhitespaces();
        this.ignoreTrailing = settings.getIgnoreTrailingWhitespaces();
        this.fieldLengths = settings.getFieldLengths();
        this.fieldAlignments = settings.getFieldAlignments();
        this.fieldPaddings = settings.getFieldPaddings();
        this.lookaheadFormats = settings.getLookaheadFormats();
        this.lookbehindFormats = settings.getLookbehindFormats();
        this.defaultHeaderPadding = settings.getUseDefaultPaddingForHeaders();
        this.defaultHeaderAlignment = settings.getDefaultAlignmentForHeaders();
        super.enableNewlineAfterRecord(settings.getWriteLineSeparatorAfterRecord());
        if (this.lookaheadFormats != null || this.lookbehindFormats != null) {
            this.lookupChars = new char[Lookup.calculateMaxLookupLength(this.lookaheadFormats, this.lookbehindFormats)];
            this.rootLengths = this.fieldLengths;
            this.rootAlignments = this.fieldAlignments;
            this.rootPaddings = this.fieldPaddings;
        } else {
            this.lookupChars = null;
            this.rootLengths = null;
            this.rootAlignments = null;
            this.rootPaddings = null;
        }
    }

    @Override
    protected void processRow(Object[] row) {
        if (row.length > 0 && this.lookaheadFormats != null || this.lookbehindFormats != null) {
            int i2;
            int end;
            String value = String.valueOf(row[0]);
            if (value.length() >= this.lookupChars.length) {
                end = this.lookupChars.length;
            } else {
                end = value.length();
                for (int i3 = this.lookupChars.length - 1; i3 > end; --i3) {
                    this.lookupChars[i3] = '\u0000';
                }
            }
            value.getChars(0, end, this.lookupChars, 0);
            boolean matched = false;
            if (this.lookaheadFormats != null) {
                for (i2 = 0; i2 < this.lookaheadFormats.length; ++i2) {
                    if (!this.lookaheadFormats[i2].matches(this.lookupChars)) continue;
                    this.fieldLengths = this.lookaheadFormats[i2].lengths;
                    this.fieldAlignments = this.lookaheadFormats[i2].alignments;
                    this.fieldPaddings = this.lookaheadFormats[i2].paddings;
                    matched = true;
                    break;
                }
                if (this.lookbehindFormats != null && matched) {
                    this.lookbehindFormat = null;
                    for (i2 = 0; i2 < this.lookbehindFormats.length; ++i2) {
                        if (!this.lookbehindFormats[i2].matches(this.lookupChars)) continue;
                        this.lookbehindFormat = this.lookbehindFormats[i2];
                        break;
                    }
                }
            } else {
                for (i2 = 0; i2 < this.lookbehindFormats.length; ++i2) {
                    if (!this.lookbehindFormats[i2].matches(this.lookupChars)) continue;
                    this.lookbehindFormat = this.lookbehindFormats[i2];
                    matched = true;
                    this.fieldLengths = this.rootLengths;
                    this.fieldAlignments = this.rootAlignments;
                    this.fieldPaddings = this.rootPaddings;
                    break;
                }
            }
            if (!matched) {
                if (this.lookbehindFormat == null) {
                    if (this.rootLengths == null) {
                        throw new TextWritingException("Cannot write with the given configuration. No default field lengths defined and no lookahead/lookbehind value match '" + new String(this.lookupChars) + '\'', this.getRecordCount(), row);
                    }
                    this.fieldLengths = this.rootLengths;
                    this.fieldAlignments = this.rootAlignments;
                    this.fieldPaddings = this.rootPaddings;
                } else {
                    this.fieldLengths = this.lookbehindFormat.lengths;
                    this.fieldAlignments = this.lookbehindFormat.alignments;
                    this.fieldPaddings = this.lookbehindFormat.paddings;
                }
            }
        }
        int lastIndex = this.fieldLengths.length < row.length ? this.fieldLengths.length : row.length;
        for (int i4 = 0; i4 < lastIndex; ++i4) {
            this.length = this.fieldLengths[i4];
            this.alignment = this.fieldAlignments[i4];
            this.padding = this.fieldPaddings[i4];
            if (this.writingHeaders) {
                if (this.defaultHeaderPadding) {
                    this.padding = this.defaultPadding;
                }
                if (this.defaultHeaderAlignment != null) {
                    this.alignment = this.defaultHeaderAlignment;
                }
            }
            String nextElement = this.getStringValue(row[i4]);
            this.processElement(nextElement);
            this.appendValueToRow();
        }
    }

    private void append(String element) {
        int start = 0;
        if (this.ignoreLeading) {
            start = FixedWidthWriter.skipLeadingWhitespace(this.whitespaceRangeStart, element);
        }
        int padCount = this.alignment.calculatePadding(this.length, element.length() - start);
        this.length -= padCount;
        this.appender.fill(this.padding, padCount);
        if (this.ignoreTrailing) {
            int i2 = start;
            while (i2 < element.length() && this.length > 0) {
                while (i2 < element.length() && this.length-- > 0) {
                    char nextChar = element.charAt(i2);
                    this.appender.appendIgnoringWhitespace(nextChar);
                    ++i2;
                }
                if (this.length == -1 && this.appender.whitespaceCount() > 0) {
                    for (int j = i2; j < element.length(); ++j) {
                        if (element.charAt(j) <= ' ') continue;
                        this.appender.resetWhitespaceCount();
                        break;
                    }
                    if (this.appender.whitespaceCount() > 0) {
                        this.length = 0;
                    }
                }
                this.length += this.appender.whitespaceCount();
                this.appendValueToRow();
            }
        } else {
            for (int i3 = start; i3 < element.length() && this.length-- > 0; ++i3) {
                char nextChar = element.charAt(i3);
                this.appender.append(nextChar);
            }
        }
    }

    private void processElement(String element) {
        if (element != null) {
            this.append(element);
        }
        this.appender.fill(this.padding, this.length);
    }
}

