/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.fixed;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.ParsingContextWrapper;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.input.EOFException;
import com.univocity.parsers.common.input.LookaheadCharInputReader;
import com.univocity.parsers.fixed.FieldAlignment;
import com.univocity.parsers.fixed.FixedWidthFormat;
import com.univocity.parsers.fixed.FixedWidthParserSettings;
import com.univocity.parsers.fixed.Lookup;

public class FixedWidthParser
extends AbstractParser<FixedWidthParserSettings> {
    private int[] lengths;
    private int[] rootLengths;
    private FieldAlignment[] alignments;
    private FieldAlignment[] rootAlignments;
    private char[] paddings;
    private char[] rootPaddings;
    private final Lookup[] lookaheadFormats;
    private final Lookup[] lookbehindFormats;
    private Lookup lookupFormat;
    private Lookup lookbehindFormat;
    private int maxLookupLength;
    private final boolean ignoreLeadingWhitespace;
    private final boolean ignoreTrailingWhitespace;
    private final boolean skipToNewLine;
    private final boolean recordEndsOnNewLine;
    private final boolean skipEmptyLines;
    private boolean useDefaultPadding;
    private final char defaultPadding;
    private char padding;
    private FieldAlignment alignment;
    private final char newLine;
    private int length;
    private boolean initializeLookaheadInput = false;
    private LookaheadCharInputReader lookaheadInput;

    public FixedWidthParser(FixedWidthParserSettings settings) {
        super(settings);
        this.ignoreLeadingWhitespace = settings.getIgnoreLeadingWhitespaces();
        this.ignoreTrailingWhitespace = settings.getIgnoreTrailingWhitespaces();
        this.skipToNewLine = settings.getSkipTrailingCharsUntilNewline();
        this.recordEndsOnNewLine = settings.getRecordEndsOnNewline();
        this.skipEmptyLines = settings.getSkipEmptyLines();
        this.lengths = settings.getFieldLengths();
        this.alignments = settings.getFieldAlignments();
        this.paddings = settings.getFieldPaddings();
        this.lookaheadFormats = settings.getLookaheadFormats();
        this.lookbehindFormats = settings.getLookbehindFormats();
        if (this.lookaheadFormats != null || this.lookbehindFormats != null) {
            this.initializeLookaheadInput = true;
            this.rootLengths = this.lengths;
            this.rootAlignments = this.alignments;
            this.rootPaddings = this.paddings;
            this.maxLookupLength = Lookup.calculateMaxLookupLength(this.lookaheadFormats, this.lookbehindFormats);
            this.context = new ParsingContextWrapper(this.context){

                @Override
                public String[] headers() {
                    return FixedWidthParser.this.lookupFormat != null ? ((FixedWidthParser)FixedWidthParser.this).lookupFormat.fieldNames : super.headers();
                }
            };
        }
        FixedWidthFormat format = (FixedWidthFormat)settings.getFormat();
        this.defaultPadding = this.padding = format.getPadding();
        this.newLine = format.getNormalizedNewline();
        this.useDefaultPadding = settings.getUseDefaultPaddingForHeaders() && settings.isHeaderExtractionEnabled();
    }

    @Override
    protected void parseRecord() {
        int i2;
        if (this.ch == this.newLine && this.skipEmptyLines) {
            return;
        }
        boolean matched = false;
        if (this.lookaheadFormats != null || this.lookbehindFormats != null) {
            if (this.initializeLookaheadInput) {
                this.initializeLookaheadInput = false;
                this.lookaheadInput = new LookaheadCharInputReader(this.input, this.newLine, this.whitespaceRangeStart);
                this.input = this.lookaheadInput;
            }
            this.lookaheadInput.lookahead(this.maxLookupLength);
            if (this.lookaheadFormats != null) {
                for (i2 = 0; i2 < this.lookaheadFormats.length; ++i2) {
                    if (!this.lookaheadInput.matches(this.ch, this.lookaheadFormats[i2].value)) continue;
                    this.lengths = this.lookaheadFormats[i2].lengths;
                    this.lookupFormat = this.lookaheadFormats[i2];
                    matched = true;
                    break;
                }
                if (this.lookbehindFormats != null && matched) {
                    this.lookbehindFormat = null;
                    for (i2 = 0; i2 < this.lookbehindFormats.length; ++i2) {
                        if (!this.lookaheadInput.matches(this.ch, this.lookbehindFormats[i2].value)) continue;
                        this.lookbehindFormat = this.lookbehindFormats[i2];
                        break;
                    }
                }
            } else {
                for (i2 = 0; i2 < this.lookbehindFormats.length; ++i2) {
                    if (!this.lookaheadInput.matches(this.ch, this.lookbehindFormats[i2].value)) continue;
                    this.lookbehindFormat = this.lookbehindFormats[i2];
                    matched = true;
                    this.lengths = this.rootLengths;
                    break;
                }
            }
            if (!matched) {
                if (this.lookbehindFormat == null) {
                    if (this.rootLengths == null) {
                        throw new TextParsingException(this.context, "Cannot process input with the given configuration. No default field lengths defined and no lookahead/lookbehind value match '" + this.lookaheadInput.getLookahead(this.ch) + '\'');
                    }
                    this.lengths = this.rootLengths;
                    this.alignments = this.rootAlignments;
                    this.paddings = this.rootPaddings;
                    this.lookupFormat = null;
                } else {
                    this.lengths = this.lookbehindFormat.lengths;
                    this.alignments = this.lookbehindFormat.alignments;
                    this.paddings = this.lookbehindFormat.paddings;
                    this.lookupFormat = this.lookbehindFormat;
                }
            }
        }
        for (i2 = 0; i2 < this.lengths.length; ++i2) {
            this.length = this.lengths[i2];
            if (this.paddings != null) {
                char c = this.padding = this.useDefaultPadding ? this.defaultPadding : this.paddings[i2];
            }
            if (this.alignments != null) {
                this.alignment = this.alignments[i2];
            }
            this.skipPadding();
            if (this.ignoreLeadingWhitespace) {
                this.skipWhitespace();
            }
            if (this.recordEndsOnNewLine) {
                this.readValueUntilNewLine();
                if (this.ch == this.newLine) {
                    this.output.valueParsed();
                    this.useDefaultPadding = false;
                    return;
                }
            } else if (this.length > 0) {
                this.readValue();
                if (i2 + 1 < this.lengths.length) {
                    this.ch = this.input.nextChar();
                }
            }
            this.output.valueParsed();
        }
        if (this.skipToNewLine) {
            this.skipToNewLine();
        }
        this.useDefaultPadding = false;
    }

    private void skipToNewLine() {
        try {
            while (this.ch != this.newLine) {
                this.ch = this.input.nextChar();
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    private void skipPadding() {
        while (this.ch == this.padding && this.length-- > 0) {
            this.ch = this.input.nextChar();
        }
    }

    private void skipWhitespace() {
        while ((this.ch <= ' ' && this.whitespaceRangeStart < this.ch || this.ch == this.padding) && this.length-- > 0) {
            this.ch = this.input.nextChar();
        }
    }

    private void readValueUntilNewLine() {
        if (this.ignoreTrailingWhitespace) {
            if (this.alignment == FieldAlignment.RIGHT) {
                while (this.length-- > 0 && this.ch != this.newLine) {
                    this.output.appender.appendIgnoringWhitespace(this.ch);
                    this.ch = this.input.nextChar();
                }
            } else {
                while (this.length-- > 0 && this.ch != this.newLine) {
                    this.output.appender.appendIgnoringWhitespaceAndPadding(this.ch, this.padding);
                    this.ch = this.input.nextChar();
                }
            }
        } else if (this.alignment == FieldAlignment.RIGHT) {
            while (this.length-- > 0 && this.ch != this.newLine) {
                this.output.appender.append(this.ch);
                this.ch = this.input.nextChar();
            }
        } else {
            while (this.length-- > 0 && this.ch != this.newLine) {
                this.output.appender.appendIgnoringPadding(this.ch, this.padding);
                this.ch = this.input.nextChar();
            }
        }
    }

    private void readValue() {
        --this.length;
        if (this.ignoreTrailingWhitespace) {
            if (this.alignment == FieldAlignment.RIGHT) {
                this.output.appender.appendIgnoringWhitespace(this.ch);
                while (this.length-- > 0) {
                    this.ch = this.input.nextChar();
                    this.output.appender.appendIgnoringWhitespace(this.ch);
                }
            } else {
                this.output.appender.appendIgnoringWhitespaceAndPadding(this.ch, this.padding);
                while (this.length-- > 0) {
                    this.ch = this.input.nextChar();
                    this.output.appender.appendIgnoringWhitespaceAndPadding(this.ch, this.padding);
                }
            }
        } else if (this.alignment == FieldAlignment.RIGHT) {
            this.output.appender.append(this.ch);
            while (this.length-- > 0) {
                this.ch = this.input.nextChar();
                this.output.appender.append(this.ch);
            }
        } else {
            this.output.appender.appendIgnoringPadding(this.ch, this.padding);
            while (this.length-- > 0) {
                this.ch = this.input.nextChar();
                this.output.appender.appendIgnoringPadding(this.ch, this.padding);
            }
        }
    }
}

