/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.fixed;

import com.univocity.parsers.annotations.FixedWidth;
import com.univocity.parsers.annotations.helpers.AnnotationHelper;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.fixed.FieldAlignment;
import com.univocity.parsers.fixed.FixedWidthFormat;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class FixedWidthFields
implements Cloneable {
    private List<Integer> fieldLengths = new ArrayList<Integer>();
    private List<String> fieldNames = new ArrayList<String>();
    private List<FieldAlignment> fieldAlignment = new ArrayList<FieldAlignment>();
    private List<Character> fieldPadding = new ArrayList<Character>();
    private boolean noNames = true;

    public FixedWidthFields(LinkedHashMap<String, Integer> fields) {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("Map of fields and their lengths cannot be null/empty");
        }
        for (Map.Entry<String, Integer> entry : fields.entrySet()) {
            String fieldName = entry.getKey();
            Integer fieldLength = entry.getValue();
            this.addField(fieldName, fieldLength);
        }
    }

    public FixedWidthFields(String[] headers, int[] lengths) {
        if (headers == null || headers.length == 0) {
            throw new IllegalArgumentException("Headers cannot be null/empty");
        }
        if (lengths == null || lengths.length == 0) {
            throw new IllegalArgumentException("Field lengths cannot be null/empty");
        }
        if (headers.length != lengths.length) {
            throw new IllegalArgumentException("Sequence of headers and their respective lengths must match. Got " + headers.length + " headers but " + lengths.length + " lengths");
        }
        for (int i2 = 0; i2 < headers.length; ++i2) {
            this.addField(headers[i2], lengths[i2]);
        }
    }

    public FixedWidthFields(int ... fieldLengths) {
        for (int i2 = 0; i2 < fieldLengths.length; ++i2) {
            this.addField(fieldLengths[i2]);
        }
    }

    public FixedWidthFields(Class beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("Class must not be null.");
        }
        List<Field> fieldSequence = AnnotationHelper.getFieldSequence(beanClass, true);
        if (fieldSequence.isEmpty()) {
            throw new IllegalArgumentException("Can't derive fixed-width fields from class '" + beanClass.getName() + "'. No @Parsed annotations found.");
        }
        LinkedHashSet<String> fieldNamesWithoutConfig = new LinkedHashSet<String>();
        for (Field field : fieldSequence) {
            if (field == null) continue;
            String fieldName = AnnotationHelper.getHeaderName(field);
            FixedWidth fw = AnnotationHelper.findAnnotation(field, FixedWidth.class);
            if (fw == null) {
                fieldNamesWithoutConfig.add(field.getName());
                continue;
            }
            if (fieldName == null) {
                this.addField(fw.value(), fw.alignment(), fw.padding());
                continue;
            }
            this.addField(fieldName, fw.value(), fw.alignment(), fw.padding());
        }
        if (fieldNamesWithoutConfig.size() > 0) {
            throw new IllegalArgumentException("Can't derive fixed-width fields from class '" + beanClass.getName() + "'. " + "The following fields don't have a @FixedWidth annotation: " + fieldNamesWithoutConfig);
        }
    }

    public FixedWidthFields addField(int length) {
        return this.addField(null, length, FieldAlignment.LEFT, '\u0000');
    }

    public FixedWidthFields addField(int length, FieldAlignment alignment) {
        return this.addField(null, length, alignment, '\u0000');
    }

    public FixedWidthFields addField(String name, int length) {
        return this.addField(name, length, FieldAlignment.LEFT, '\u0000');
    }

    public FixedWidthFields addField(String name, int length, FieldAlignment alignment) {
        return this.addField(name, length, alignment, '\u0000');
    }

    public FixedWidthFields addField(int length, char padding) {
        return this.addField(null, length, FieldAlignment.LEFT, padding);
    }

    public FixedWidthFields addField(int length, FieldAlignment alignment, char padding) {
        return this.addField(null, length, alignment, padding);
    }

    public FixedWidthFields addField(String name, int length, char padding) {
        return this.addField(name, length, FieldAlignment.LEFT, padding);
    }

    public FixedWidthFields addField(String name, int length, FieldAlignment alignment, char padding) {
        this.validateLength(name, length);
        this.fieldLengths.add(length);
        this.fieldNames.add(name);
        this.fieldPadding.add(Character.valueOf(padding));
        if (name != null) {
            this.noNames = false;
        }
        this.fieldAlignment.add(alignment);
        return this;
    }

    private void validateLength(String name, int length) {
        if (length < 1) {
            if (name == null) {
                throw new IllegalArgumentException("Invalid field length: " + length + " for field at index " + this.fieldLengths.size());
            }
            throw new IllegalArgumentException("Invalid field length: " + length + " for field " + name);
        }
    }

    public int getFieldsPerRecord() {
        return this.fieldLengths.size();
    }

    public String[] getFieldNames() {
        if (this.noNames) {
            return null;
        }
        return this.fieldNames.toArray(new String[this.fieldNames.size()]);
    }

    public int[] getFieldLengths() {
        return ArgumentUtils.toIntArray(this.fieldLengths);
    }

    public void setFieldLength(String name, int newLength) {
        if (name == null) {
            throw new IllegalArgumentException("Field name cannot be null");
        }
        int index = this.fieldNames.indexOf(name);
        if (index == -1) {
            throw new IllegalArgumentException("Cannot find field with name '" + name + '\'');
        }
        this.validateLength(name, newLength);
        this.fieldLengths.set(index, newLength);
    }

    public void setFieldLength(int position, int newLength) {
        this.validateIndex(position);
        this.validateLength("at index " + position, newLength);
        this.fieldLengths.set(position, newLength);
    }

    public void setAlignment(FieldAlignment alignment, int ... positions) {
        for (int position : positions) {
            this.setAlignment(position, alignment);
        }
    }

    public void setAlignment(FieldAlignment alignment, String ... names) {
        for (String name : names) {
            int position = this.indexOf(name);
            this.setAlignment(position, alignment);
        }
    }

    private void validateIndex(int position) {
        if (position < 0 && position >= this.fieldLengths.size()) {
            throw new IllegalArgumentException("No field defined at index " + position);
        }
    }

    public int indexOf(String fieldName) {
        if (this.noNames) {
            throw new IllegalArgumentException("No field names defined");
        }
        if (fieldName == null || fieldName.trim().isEmpty()) {
            throw new IllegalArgumentException("Field name cannot be null/empty");
        }
        fieldName = ArgumentUtils.normalize(fieldName);
        int i2 = 0;
        for (String name : this.fieldNames) {
            if ((name = ArgumentUtils.normalize(name)).equals(fieldName)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    private void setAlignment(int position, FieldAlignment alignment) {
        if (alignment == null) {
            throw new IllegalArgumentException("Alignment cannot be null");
        }
        this.validateIndex(position);
        this.fieldAlignment.set(position, alignment);
    }

    public FieldAlignment getAlignment(int position) {
        this.validateIndex(position);
        return this.fieldAlignment.get(position);
    }

    public FieldAlignment getAlignment(String fieldName) {
        int index = this.indexOf(fieldName);
        if (index == -1) {
            throw new IllegalArgumentException("Field '" + fieldName + "' does not exist. Available field names are: " + this.fieldNames);
        }
        return this.getAlignment(index);
    }

    public FieldAlignment[] getFieldAlignments() {
        return this.fieldAlignment.toArray(new FieldAlignment[this.fieldAlignment.size()]);
    }

    public char[] getFieldPaddings() {
        return ArgumentUtils.toCharArray(this.fieldPadding);
    }

    char[] getFieldPaddings(FixedWidthFormat format) {
        char[] out = this.getFieldPaddings();
        for (int i2 = 0; i2 < out.length; ++i2) {
            if (out[i2] != '\u0000') continue;
            out[i2] = format.getPadding();
        }
        return out;
    }

    public void setPadding(char padding, int ... positions) {
        for (int position : positions) {
            this.setPadding(position, padding);
        }
    }

    public void setPadding(char padding, String ... names) {
        for (String name : names) {
            int position = this.indexOf(name);
            this.setPadding(position, padding);
        }
    }

    private void setPadding(int position, char padding) {
        if (padding == '\u0000') {
            throw new IllegalArgumentException("Cannot use the null character as padding");
        }
        this.validateIndex(position);
        this.fieldPadding.set(position, Character.valueOf(padding));
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        int i2 = 0;
        for (Integer length : this.fieldLengths) {
            out.append("\n\t\t").append(i2 + 1).append('\t');
            if (i2 < this.fieldNames.size()) {
                out.append(this.fieldNames.get(i2));
            }
            out.append("length: ").append(length);
            out.append(", align: ").append((Object)this.fieldAlignment.get(i2));
            out.append(", padding: ").append(this.fieldPadding.get(i2));
            ++i2;
        }
        return out.toString();
    }

    static void setHeadersIfPossible(FixedWidthFields fieldLengths, CommonSettings settings) {
        int[] lengths;
        String[] headers;
        if (fieldLengths != null && settings.getHeaders() == null && (headers = fieldLengths.getFieldNames()) != null && (lengths = fieldLengths.getFieldLengths()).length == headers.length) {
            settings.setHeaders(headers);
        }
    }

    protected FixedWidthFields clone() {
        try {
            FixedWidthFields out = (FixedWidthFields)super.clone();
            out.fieldLengths = new ArrayList<Integer>(this.fieldLengths);
            out.fieldNames = new ArrayList<String>(this.fieldNames);
            out.fieldAlignment = new ArrayList<FieldAlignment>(this.fieldAlignment);
            out.fieldPadding = new ArrayList<Character>(this.fieldPadding);
            return out;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException(e);
        }
    }
}

