/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.NoopCharAppender;
import java.util.Arrays;

public class ParserOutput {
    protected int column = 0;
    protected final String[] parsedValues;
    private final CharAppender[] appenders;
    protected final CommonParserSettings<?> settings;
    private final boolean skipEmptyLines;
    private final String nullValue;
    public CharAppender appender;
    private final CharAppender appenderInstance;
    private boolean columnsToExtractInitialized;
    private boolean columnsReordered;
    private String[] selectedHeaders;
    private String[] headers;
    private int[] selectedIndexes;
    private long currentRecord;
    public boolean trim = false;
    String[] parsedHeaders;
    private final AbstractParser<?> parser;

    public ParserOutput(CommonParserSettings<?> settings) {
        this(null, settings);
    }

    public ParserOutput(AbstractParser<?> parser, CommonParserSettings<?> settings) {
        this.parser = parser;
        this.appender = this.appenderInstance = settings.newCharAppender();
        this.parsedValues = new String[settings.getMaxColumns()];
        this.appenders = new CharAppender[settings.getMaxColumns() + 1];
        Arrays.fill(this.appenders, this.appender);
        this.settings = settings;
        this.skipEmptyLines = settings.getSkipEmptyLines();
        this.nullValue = settings.getNullValue();
        this.columnsToExtractInitialized = false;
        this.currentRecord = 0L;
        if (settings.getHeaders() != null) {
            this.initializeHeaders();
        }
    }

    protected void initializeHeaders() {
        this.columnsToExtractInitialized = true;
        this.columnsReordered = false;
        this.selectedIndexes = null;
        this.appender = this.appenderInstance;
        Arrays.fill(this.appenders, this.appender);
        this.headers = this.settings.getHeaders();
        if (this.headers != null) {
            this.headers = (String[])this.headers.clone();
            this.initializeColumnsToExtract(this.headers);
        } else if (this.column > 0) {
            this.initializeColumnsToExtract(Arrays.copyOf(this.parsedValues, this.column));
            this.parsedHeaders = new String[this.column];
            System.arraycopy(this.parsedValues, 0, this.parsedHeaders, 0, this.column);
            if (this.settings.isHeaderExtractionEnabled()) {
                this.headers = (String[])this.parsedHeaders.clone();
            }
        }
    }

    public String[] rowParsed() {
        if (this.column > 0) {
            if (!this.columnsToExtractInitialized) {
                this.initializeHeaders();
                if (this.settings.isHeaderExtractionEnabled()) {
                    Arrays.fill(this.parsedValues, null);
                    this.column = 0;
                    this.appender = this.appenders[0];
                    return null;
                }
                if (!this.columnsReordered && this.selectedIndexes != null) {
                    String[] out = new String[this.column];
                    for (int i2 = 0; i2 < this.selectedIndexes.length; ++i2) {
                        int index = this.selectedIndexes[i2];
                        if (index >= this.column) continue;
                        out[index] = this.parsedValues[index];
                    }
                    return out;
                }
            }
            ++this.currentRecord;
            if (this.columnsReordered) {
                String[] reorderedValues = new String[this.selectedIndexes.length];
                for (int i3 = 0; i3 < this.selectedIndexes.length; ++i3) {
                    int index = this.selectedIndexes[i3];
                    reorderedValues[i3] = index >= this.column || index == -1 ? this.nullValue : this.parsedValues[index];
                }
                this.column = 0;
                this.appender = this.appenders[0];
                return reorderedValues;
            }
            String[] out = new String[this.column];
            System.arraycopy(this.parsedValues, 0, out, 0, this.column);
            this.column = 0;
            this.appender = this.appenders[0];
            return out;
        }
        if (!this.skipEmptyLines) {
            if (!this.columnsToExtractInitialized) {
                this.initializeHeaders();
            }
            ++this.currentRecord;
            if (this.columnsReordered) {
                Object[] out = new String[this.selectedIndexes.length];
                Arrays.fill(out, this.nullValue);
                return out;
            }
            return ArgumentUtils.EMPTY_STRING_ARRAY;
        }
        return null;
    }

    FieldSelector getFieldSelector() {
        return this.settings.getFieldSelector();
    }

    private void initializeColumnsToExtract(String[] values) {
        FieldSelector selector = this.settings.getFieldSelector();
        if (selector != null) {
            this.selectedIndexes = selector.getFieldIndexes(values);
            if (this.selectedIndexes != null) {
                Arrays.fill(this.appenders, NoopCharAppender.getInstance());
                for (int i2 = 0; i2 < this.selectedIndexes.length; ++i2) {
                    int index = this.selectedIndexes[i2];
                    if (index == -1) continue;
                    this.appenders[index] = this.appender;
                }
                this.columnsReordered = this.settings.isColumnReorderingEnabled();
                if (!this.columnsReordered && values.length < this.appenders.length) {
                    Arrays.fill(this.appenders, values.length, this.appenders.length, this.appender);
                }
                this.appender = this.appenders[0];
            }
        }
    }

    public String[] getHeaders() {
        if (this.parser != null) {
            this.parser.extractHeadersIfRequired();
        }
        return this.headers;
    }

    public int[] getSelectedIndexes() {
        return this.selectedIndexes;
    }

    public boolean isColumnReorderingEnabled() {
        return this.columnsReordered;
    }

    public int getCurrentColumn() {
        return this.column;
    }

    public void emptyParsed() {
        this.parsedValues[this.column++] = this.nullValue;
        this.appender = this.appenders[this.column];
    }

    public void valueParsed() {
        if (this.trim) {
            this.appender.updateWhitespace();
        }
        this.parsedValues[this.column++] = this.appender.getAndReset();
        this.appender = this.appenders[this.column];
    }

    public void valueParsed(String value) {
        this.parsedValues[this.column++] = value;
        this.appender = this.appenders[this.column];
    }

    public long getCurrentRecord() {
        return this.currentRecord;
    }

    public final void discardValues() {
        this.column = 0;
        this.appender = this.appenders[0];
    }

    final void reset() {
        this.columnsToExtractInitialized = false;
        this.currentRecord = 0L;
        this.column = 0;
        this.headers = null;
    }
}

