/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.Context;
import com.univocity.parsers.common.ConversionProcessor;
import com.univocity.parsers.common.DataProcessingException;
import com.univocity.parsers.common.NoopProcessorErrorHandler;
import com.univocity.parsers.common.ProcessorErrorHandler;
import com.univocity.parsers.common.RetryableErrorHandler;
import com.univocity.parsers.common.fields.FieldConversionMapping;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.conversions.Conversion;
import java.util.HashMap;
import java.util.Map;

public abstract class DefaultConversionProcessor
implements ConversionProcessor {
    private Map<Class<?>, Conversion[]> conversionsByType;
    private FieldConversionMapping conversions;
    private boolean conversionsInitialized;
    private int[] fieldIndexes;
    private boolean fieldsReordered;
    ProcessorErrorHandler errorHandler = NoopProcessorErrorHandler.instance;
    Context context;

    @Override
    public final FieldSet<Integer> convertIndexes(Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldIndexes(conversions);
    }

    @Override
    public final void convertAll(Conversion ... conversions) {
        this.getConversions().applyConversionsOnAllFields(conversions);
    }

    @Override
    public final FieldSet<String> convertFields(Conversion ... conversions) {
        return this.getConversions().applyConversionsOnFieldNames(conversions);
    }

    private FieldConversionMapping getConversions() {
        if (this.conversions == null) {
            this.conversions = new FieldConversionMapping();
        }
        return this.conversions;
    }

    protected void initializeConversions(String[] row, Context context) {
        String[] contextHeaders;
        this.conversionsInitialized = true;
        this.fieldIndexes = null;
        this.fieldsReordered = false;
        this.conversionsInitialized = false;
        String[] stringArray = contextHeaders = context == null ? null : context.headers();
        if (contextHeaders != null && contextHeaders.length > 0) {
            this.getConversions().prepareExecution(false, contextHeaders);
        } else {
            this.getConversions().prepareExecution(false, row);
        }
        if (context != null) {
            this.fieldIndexes = context.extractedFieldIndexes();
            this.fieldsReordered = context.columnsReordered();
        }
    }

    public final Object[] applyConversions(String[] row, Context context) {
        boolean keepRow = true;
        Object[] objectRow = new Object[row.length];
        boolean[] convertedFlags = this.conversionsByType != null ? new boolean[row.length] : null;
        System.arraycopy(row, 0, objectRow, 0, row.length);
        if (this.conversions != null) {
            if (!this.conversionsInitialized) {
                this.initializeConversions(row, context);
            }
            int length = !this.fieldsReordered && this.fieldIndexes == null ? objectRow.length : this.fieldIndexes.length;
            for (int i2 = 0; i2 < length; ++i2) {
                try {
                    if (!this.fieldsReordered) {
                        if (this.fieldIndexes == null) {
                            objectRow[i2] = this.conversions.applyConversions(i2, row[i2], convertedFlags);
                            continue;
                        }
                        int index = this.fieldIndexes[i2];
                        objectRow[index] = this.conversions.applyConversions(index, row[index], convertedFlags);
                        continue;
                    }
                    objectRow[i2] = this.conversions.applyConversions(this.fieldIndexes[i2], row[i2], convertedFlags);
                    continue;
                }
                catch (Throwable ex) {
                    keepRow = this.handleConversionError(ex, objectRow, i2);
                }
            }
        }
        if (keepRow && convertedFlags != null) {
            keepRow = this.applyConversionsByType(false, objectRow, convertedFlags);
        }
        if (keepRow) {
            return objectRow;
        }
        return null;
    }

    public final boolean reverseConversions(boolean executeInReverseOrder, Object[] row, String[] headers, int[] indexesToWrite) {
        boolean[] convertedFlags;
        boolean keepRow = true;
        boolean[] blArray = convertedFlags = this.conversionsByType != null ? new boolean[row.length] : null;
        if (this.conversions != null) {
            if (!this.conversionsInitialized) {
                this.conversionsInitialized = true;
                this.conversions.prepareExecution(true, headers != null ? headers : new String[row.length]);
                this.fieldIndexes = indexesToWrite;
            }
            int last = this.fieldIndexes == null ? row.length : this.fieldIndexes.length;
            for (int i2 = 0; i2 < last; ++i2) {
                try {
                    if (this.fieldIndexes == null || this.fieldIndexes[i2] == -1) {
                        row[i2] = this.conversions.reverseConversions(executeInReverseOrder, i2, row[i2], convertedFlags);
                        continue;
                    }
                    int index = this.fieldIndexes[i2];
                    row[index] = this.conversions.reverseConversions(executeInReverseOrder, index, row[index], convertedFlags);
                    continue;
                }
                catch (Throwable ex) {
                    keepRow = this.handleConversionError(ex, row, i2);
                }
            }
        }
        if (keepRow && convertedFlags != null) {
            keepRow = this.applyConversionsByType(true, row, convertedFlags);
        }
        return keepRow;
    }

    private boolean applyConversionsByType(boolean reverse, Object[] row, boolean[] convertedFlags) {
        boolean keepRow = true;
        for (int i2 = 0; i2 < row.length; ++i2) {
            if (convertedFlags[i2]) continue;
            try {
                row[i2] = this.applyTypeConversion(reverse, row[i2]);
                continue;
            }
            catch (Throwable ex) {
                keepRow = this.handleConversionError(ex, row, i2);
            }
        }
        return keepRow;
    }

    protected final boolean handleConversionError(Throwable ex, Object[] row, int column) {
        DataProcessingException error = this.toDataProcessingException(ex, row, column);
        if (column > -1 && this.errorHandler instanceof RetryableErrorHandler) {
            ((RetryableErrorHandler)this.errorHandler).prepareToRun();
        }
        error.markAsHandled(this.errorHandler);
        this.errorHandler.handleError(error, row, this.context);
        if (column > -1 && this.errorHandler instanceof RetryableErrorHandler) {
            Object defaultValue;
            RetryableErrorHandler retry = (RetryableErrorHandler)this.errorHandler;
            row[column] = defaultValue = retry.getDefaultValue();
            return !retry.isRecordSkipped();
        }
        return false;
    }

    protected DataProcessingException toDataProcessingException(Throwable ex, Object[] row, int column) {
        DataProcessingException error;
        if (ex instanceof DataProcessingException) {
            error = (DataProcessingException)ex;
            error.setRow(row);
            error.setColumnIndex(column);
        } else {
            error = new DataProcessingException("Error processing data conversions", column, row, ex);
        }
        error.markAsNonFatal();
        error.setContext(this.context);
        return error;
    }

    @Override
    public final void convertType(Class<?> type, Conversion ... conversions) {
        ArgumentUtils.noNulls("Type to convert", type);
        ArgumentUtils.noNulls("Sequence of conversions to apply over data of type " + type.getSimpleName(), conversions);
        if (this.conversionsByType == null) {
            this.conversionsByType = new HashMap();
        }
        this.conversionsByType.put(type, conversions);
    }

    private Object applyTypeConversion(boolean revert, Object input) {
        if (this.conversionsByType == null || input == null) {
            return input;
        }
        Conversion[] conversionSequence = this.conversionsByType.get(input.getClass());
        if (conversionSequence == null) {
            return input;
        }
        if (revert) {
            for (int i2 = 0; i2 < conversionSequence.length; ++i2) {
                input = conversionSequence[i2].revert(input);
            }
        } else {
            for (int i3 = 0; i3 < conversionSequence.length; ++i3) {
                input = conversionSequence[i3].execute(input);
            }
        }
        return input;
    }
}

