/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.DocumentableNode;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ModifierSet;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.WithDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.List;

public final class ConstructorDeclaration
extends BodyDeclaration
implements DocumentableNode,
WithDeclaration {
    private int modifiers;
    private List<TypeParameter> typeParameters;
    private NameExpr name;
    private List<Parameter> parameters;
    private List<NameExpr> throws_;
    private BlockStmt block;

    public ConstructorDeclaration() {
    }

    public ConstructorDeclaration(int modifiers, String name) {
        this.setModifiers(modifiers);
        this.setName(name);
    }

    public ConstructorDeclaration(int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, String name, List<Parameter> parameters, List<NameExpr> throws_, BlockStmt block) {
        super(annotations);
        this.setModifiers(modifiers);
        this.setTypeParameters(typeParameters);
        this.setName(name);
        this.setParameters(parameters);
        this.setThrows(throws_);
        this.setBlock(block);
    }

    public ConstructorDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers, List<AnnotationExpr> annotations, List<TypeParameter> typeParameters, String name, List<Parameter> parameters, List<NameExpr> throws_, BlockStmt block) {
        super(beginLine, beginColumn, endLine, endColumn, annotations);
        this.setModifiers(modifiers);
        this.setTypeParameters(typeParameters);
        this.setName(name);
        this.setParameters(parameters);
        this.setThrows(throws_);
        this.setBlock(block);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public BlockStmt getBlock() {
        return this.block;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getName() {
        return this.name == null ? null : this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public List<NameExpr> getThrows() {
        return this.throws_;
    }

    public List<TypeParameter> getTypeParameters() {
        return this.typeParameters;
    }

    public void setBlock(BlockStmt block) {
        this.block = block;
        this.setAsParentNodeOf(this.block);
    }

    public void setModifiers(int modifiers) {
        this.modifiers = modifiers;
    }

    public void setName(String name) {
        this.name = new NameExpr(name);
    }

    @Override
    public void setJavaDoc(JavadocComment javadocComment) {
    }

    public void setNameExpr(NameExpr name) {
        this.name = name;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        this.setAsParentNodeOf(this.parameters);
    }

    public void setThrows(List<NameExpr> throws_) {
        this.throws_ = throws_;
        this.setAsParentNodeOf(this.throws_);
    }

    public void setTypeParameters(List<TypeParameter> typeParameters) {
        this.typeParameters = typeParameters;
        this.setAsParentNodeOf(this.typeParameters);
    }

    @Override
    public JavadocComment getJavaDoc() {
        return null;
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        StringBuffer sb = new StringBuffer();
        if (includingModifiers) {
            AccessSpecifier accessSpecifier = ModifierSet.getAccessSpecifier(this.getModifiers());
            sb.append(accessSpecifier.getCodeRepresenation());
            sb.append(accessSpecifier == AccessSpecifier.DEFAULT ? "" : " ");
        }
        sb.append(this.getName());
        sb.append("(");
        boolean firstParam = true;
        for (Parameter param : this.parameters) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            sb.append(param.toStringWithoutComments());
        }
        sb.append(")");
        if (includingThrows && !this.getThrows().isEmpty()) {
            sb.append(" throws ");
            boolean firstThrow = true;
            for (NameExpr thr : this.getThrows()) {
                if (firstThrow) {
                    firstThrow = false;
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toStringWithoutComments());
            }
        }
        return sb.toString();
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true);
    }
}

