/*
 * Decompiled with CFR 0.152.
 */
package AndroidProjectRepresentation;

import AndroidProjectRepresentation.CodeEntity;
import AndroidProjectRepresentation.Variable;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class MethodOfAPI
extends CodeEntity
implements Serializable {
    public static final String unknownType = "UnknownType";
    public String referenceClass = "UnknownType";
    public String returnType = "UnknownType";
    public String method = "UnknownType";
    public List<Variable> args = new ArrayList<Variable>();
    public Expression reference = new MethodCallExpr();

    public MethodOfAPI(String apis, String met, List<Variable> args) {
        this.referenceClass = apis;
        this.method = met;
        this.returnType = unknownType;
        this.args = args;
        this.reference = new MethodCallExpr();
    }

    public MethodOfAPI(String referenceClass) {
        this.referenceClass = referenceClass;
        this.returnType = unknownType;
        this.args = new ArrayList<Variable>();
        this.reference = new MethodCallExpr();
    }

    public MethodOfAPI() {
        this.referenceClass = unknownType;
        this.returnType = unknownType;
        this.args = new ArrayList<Variable>();
        this.reference = new MethodCallExpr();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        MethodOfAPI ne = (MethodOfAPI)obj;
        return this.returnType.equals(ne.returnType) && this.referenceClass.equals(ne.referenceClass) && (this.method == null || ((MethodOfAPI)obj).method == null || this.method.equals(ne.method));
    }

    public String toJSONString() {
        String api = this.returnType + "__" + this.referenceClass + "__" + this.method + "__" + "(";
        for (Variable v : this.args) {
            api = api + "--" + v.type + (v.arrayCount > 0 ? "[]" : "");
        }
        return api + ")";
    }

    public static MethodOfAPI fromJSONString(String representation) {
        MethodOfAPI moa = new MethodOfAPI();
        String[] x = representation.split("__");
        if (x.length >= 3) {
            String[] args;
            moa.returnType = x[0];
            moa.referenceClass = x[1];
            moa.method = x[2];
            for (String arg : args = x[3].substring(x[3].indexOf("(") + 1, x[3].indexOf(")")).split("--")) {
                if (arg.equals("")) continue;
                moa.args.add(Variable.fromJSONString(arg));
            }
        }
        return moa;
    }

    public int hashCode() {
        return this.referenceClass != null ? this.referenceClass.hashCode() + (this.method != null ? this.method.hashCode() : 0) : (this.method != null ? this.method.hashCode() : 0);
    }

    public String toString() {
        String s = this.returnType + " Class " + this.referenceClass + " Method " + this.method;
        s = s + "(";
        for (int i2 = 0; i2 < this.args.size(); ++i2) {
            s = s + this.args.get((int)i2).type;
            if (i2 + 1 == this.args.size()) continue;
            s = s + ",";
        }
        return s + ")";
    }
}

