/*
 * Decompiled with CFR 0.152.
 */
package AndroidProjectRepresentation;

import AndroidProjectRepresentation.ClassInfo;
import AndroidProjectRepresentation.CodeEntity;
import AndroidProjectRepresentation.JSONSerializable;
import AndroidProjectRepresentation.MethodOfAPI;
import AndroidProjectRepresentation.Variable;
import Metrics.CyclomaticCalculator;
import Metrics.SourceCodeLineCounter;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.ModifierSet;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.type.ReferenceType;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class MethodInfo
extends CodeEntity
implements Serializable,
JSONSerializable {
    public Set<MethodOfAPI> externalApi = new HashSet<MethodOfAPI>();
    public Set<MethodOfAPI> androidApi = new HashSet<MethodOfAPI>();
    public Set<MethodOfAPI> javaApi = new HashSet<MethodOfAPI>();
    public Set<MethodOfAPI> unknownApi = new HashSet<MethodOfAPI>();
    public Set<String> modifiers = new HashSet<String>();
    public Set<Variable> declaredVars = new HashSet<Variable>();
    public Set<Variable> args = new HashSet<Variable>();
    public String returnType = "";
    public boolean isStatic = false;
    public boolean isSynchronized = false;
    public boolean isFinal = false;
    public int linesOfCode = 0;
    public int cyclomaticComplexity = 0;
    public String accessModifier = "public";
    public String methodName = "";
    public ClassInfo ci = null;

    public MethodInfo() {
    }

    public MethodInfo(MethodDeclaration n) {
        this.methodName = n.getName();
        if (n.getParameters() != null) {
            for (Parameter m : n.getParameters()) {
                int isArray = m.getType() instanceof ReferenceType ? ((ReferenceType)m.getType()).getArrayCount() : 0;
                this.args.add(new Variable(m.getId().getName(), m.getType().toStringWithoutComments(), isArray));
            }
        }
        this.setModifiers(n.getModifiers());
        this.cyclomaticComplexity = CyclomaticCalculator.cyclomaticAndAPI(n, this);
        try {
            this.linesOfCode = SourceCodeLineCounter.getNumberOfLines(n.getBody().toStringWithoutComments()) - 2;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String idFromMethodDeclaration(MethodDeclaration n, String outterClassName, String parentClassName, String pack, String hash) {
        String metId = pack + "." + (outterClassName.equals("") ? "" : outterClassName + ".") + parentClassName + "->" + n.getName() + "|" + hash;
        return metId;
    }

    public static String idFromConstructorDeclaration(ConstructorDeclaration n, String outterClassName, String parentClassName, String pack, String hash) {
        String out = "";
        String metId = pack + "." + (outterClassName.equals("") ? "" : outterClassName + ".") + parentClassName + "-><init>|" + hash;
        return metId;
    }

    public static JSONObject getMethodMetric(String methodId, String metricName, Number value, String valueText, String methodInvokedId) {
        JSONObject jo = new JSONObject();
        jo.put("mm_method", methodId);
        jo.put("mm_metric", metricName);
        jo.put("mm_value", value);
        jo.put("mm_value_text", valueText);
        if (methodInvokedId != null) {
            jo.put("mm_method_invoked", methodInvokedId);
        }
        return jo;
    }

    public JSONObject methodInfoToJSON(String classID) {
        JSONObject metric;
        String api;
        JSONObject method = new JSONObject();
        method.put("method_id", this.getMethodID());
        method.put("method_name", this.methodName);
        method.put("method_non_acc_mod", (this.isSynchronized ? "--synchronized" : "") + (this.isFinal ? "--final" : "") + (this.isStatic ? "--static" : ""));
        method.put("method_acc_modifier", this.accessModifier);
        method.put("method_class", classID);
        JSONArray methodMetrics = new JSONArray();
        methodMetrics.add(MethodInfo.getMethodMetric(this.getMethodID(), "loc", this.linesOfCode, "", null));
        methodMetrics.add(MethodInfo.getMethodMetric(this.getMethodID(), "cc", this.cyclomaticComplexity, "", null));
        methodMetrics.add(MethodInfo.getMethodMetric(this.getMethodID(), "nr_args", this.args.size(), "", null));
        for (MethodOfAPI methodOfAPI : this.externalApi) {
            api = methodOfAPI.toJSONString();
            metric = MethodInfo.getMethodMetric(this.getMethodID(), "externalapi", 0, api, null);
            methodMetrics.add(metric);
        }
        for (MethodOfAPI methodOfAPI : this.androidApi) {
            api = methodOfAPI.toJSONString();
            metric = MethodInfo.getMethodMetric(this.getMethodID(), "androidapi", 0, api, null);
            methodMetrics.add(metric);
        }
        for (MethodOfAPI methodOfAPI : this.javaApi) {
            api = methodOfAPI.toJSONString();
            metric = MethodInfo.getMethodMetric(this.getMethodID(), "javaapi", 0, api, null);
            methodMetrics.add(metric);
        }
        method.put("method_metrics", methodMetrics);
        JSONArray vars = new JSONArray();
        for (Variable v : this.declaredVars) {
            vars.add(v.toJSONObject(""));
        }
        method.put("method_declared_vars", vars);
        JSONArray jSONArray = new JSONArray();
        for (Variable v : this.args) {
            jSONArray.add(v.toJSONObject(""));
        }
        method.put("method_args", jSONArray);
        return method;
    }

    public String getMethodID() {
        String metId = this.ci != null ? this.ci.getSimpleClassID() + "." + this.methodName : this.methodName;
        metId = metId + "(";
        for (Variable v : this.args) {
            metId = metId + "--" + v.type;
        }
        metId = metId + ")";
        return metId;
    }

    public boolean isInArgs(String varName) {
        if (varName == null) {
            return false;
        }
        for (Variable v : this.args) {
            if (v == null || v.varName == null || !varName.equals(v.varName)) continue;
            return true;
        }
        return false;
    }

    public boolean isInDeclaredVars(String var) {
        if (var == null) {
            return false;
        }
        for (Variable v : this.declaredVars) {
            if (v == null || v.varName == null || !var.equals(v.varName)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.methodName.hashCode() + new Integer(this.args.size()).hashCode();
    }

    public void addRespectiveAPI(MethodOfAPI x) {
        if (!this.declaredVars.contains(new Variable(x.referenceClass, ""))) {
            if (this.ci.classVariables.containsKey(x.referenceClass)) {
                this.unknownApi.add(new MethodOfAPI(this.ci.classVariables.get((Object)x.referenceClass).type, x.method, x.args));
                return;
            }
            for (Variable v : this.args) {
                if (!v.varName.equals(x.referenceClass)) continue;
                this.unknownApi.add(new MethodOfAPI(v.type, x.method, x.args));
                return;
            }
        } else {
            for (Variable v : this.declaredVars) {
                if (!v.varName.equals(x.referenceClass)) continue;
                this.unknownApi.add(new MethodOfAPI(v.type, x.method, x.args));
                return;
            }
        }
        this.unknownApi.add(x);
    }

    public Set<String> getApisUsed() {
        HashSet<String> l = new HashSet<String>();
        for (MethodOfAPI s : this.androidApi) {
            l.add(s.referenceClass);
        }
        for (MethodOfAPI s : this.javaApi) {
            l.add(s.referenceClass);
        }
        for (MethodOfAPI s : this.externalApi) {
            l.add(s.referenceClass);
        }
        return l;
    }

    @Override
    public JSONObject toJSONObject(String classID) {
        return this.methodInfoToJSON(classID);
    }

    @Override
    public JSONSerializable fromJSONObject(JSONObject jo) {
        JSONArray methodMetrics;
        MethodInfo mi = new MethodInfo();
        mi.methodName = (String)jo.get("method_name");
        if (jo.containsKey("method_non_acc_mod") && jo.get("method_non_acc_mod") != null) {
            mi.isFinal = ((String)jo.get("method_non_acc_mod")).contains("final");
            mi.isSynchronized = ((String)jo.get("method_non_acc_mod")).contains("ynchronized");
            mi.isStatic = ((String)jo.get("method_non_acc_mod")).contains("static");
        }
        mi.accessModifier = (String)jo.get("method_acc_modifier");
        if (jo.containsKey("method_declared_vars") && !(methodMetrics = (JSONArray)jo.get("method_declared_vars")).isEmpty()) {
            for (Object ob : methodMetrics) {
                JSONObject metric = (JSONObject)ob;
                if (!metric.containsKey("var_type")) continue;
                Variable v = (Variable)new Variable().fromJSONObject(metric);
                mi.declaredVars.add(v);
            }
        }
        if (jo.containsKey("method_args")) {
            JSONArray args = (JSONArray)jo.get("method_args");
            for (Object o : args) {
                mi.args.add((Variable)new Variable().fromJSONObject((JSONObject)o));
            }
        }
        if (jo.containsKey("method_metrics") && !(methodMetrics = (JSONArray)jo.get("method_metrics")).isEmpty()) {
            for (Object o : methodMetrics) {
                MethodOfAPI moa;
                String x;
                String apis;
                String[] splits;
                JSONObject mt = (JSONObject)o;
                if (!((JSONObject)o).containsKey("mm_metric")) continue;
                if (((JSONObject)o).get("mm_metric").equals("loc")) {
                    try {
                        mi.linesOfCode = (Integer)((JSONObject)o).get("mm_value");
                    }
                    catch (ClassCastException e) {
                        mi.linesOfCode = ((Long)((JSONObject)o).get("mm_value")).intValue();
                    }
                }
                if (((JSONObject)o).get("mm_metric").equals("cc")) {
                    try {
                        mi.cyclomaticComplexity = (Integer)((JSONObject)o).get("mm_value");
                    }
                    catch (ClassCastException e) {
                        mi.cyclomaticComplexity = ((Long)((JSONObject)o).get("mm_value")).intValue();
                    }
                }
                if (((JSONObject)o).get("mm_metric").equals("androidapi") && (splits = (apis = (String)((JSONObject)o).get("mm_value_text")).split(x = "\\__")).length > 2) {
                    new MethodOfAPI();
                    moa = MethodOfAPI.fromJSONString(apis);
                    mi.androidApi.add(moa);
                }
                if (((JSONObject)o).get("mm_metric").equals("javaapi") && (splits = (apis = (String)((JSONObject)o).get("mm_value_text")).split(x = "\\__")).length > 2) {
                    new MethodOfAPI();
                    moa = MethodOfAPI.fromJSONString(apis);
                    mi.javaApi.add(moa);
                }
                if (!((JSONObject)o).get("mm_metric").equals("externalapi") || (splits = (apis = (String)((JSONObject)o).get("mm_value_text")).split(x = "\\__")).length <= 2) continue;
                new MethodOfAPI();
                moa = MethodOfAPI.fromJSONString(apis);
                mi.externalApi.add(moa);
            }
        }
        return mi;
    }

    @Override
    public JSONObject fromJSONFile(String pathToJSONFile) {
        JSONParser parser = new JSONParser();
        JSONObject ja = new JSONObject();
        try {
            Object obj = parser.parse(new FileReader(pathToJSONFile));
            JSONObject jsonObject = (JSONObject)obj;
            if (jsonObject.containsKey("method_id")) {
                return jsonObject;
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return ja;
    }

    public void setModifiers(int modifiers) {
        this.isStatic = ModifierSet.isStatic(modifiers);
        this.isSynchronized = ModifierSet.isSynchronized(modifiers);
        this.isFinal = ModifierSet.isFinal(modifiers);
        this.accessModifier = ModifierSet.isPublic(modifiers) ? "public" : (ModifierSet.isProtected(modifiers) ? "protected" : (ModifierSet.isPrivate(modifiers) ? "private" : ""));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        MethodInfo ne = (MethodInfo)obj;
        return ne.getMethodID().equals(ne.getMethodID());
    }

    public String toString() {
        return "MethodInfo{externalApi=" + this.externalApi + ", androidApi=" + this.androidApi + ", javaApi=" + this.javaApi + ", unknownApi=" + this.unknownApi + ", declaredVars=" + this.declaredVars + ", args=" + this.args + ", isStatic=" + this.isStatic + ", isSynchronized=" + this.isSynchronized + ", isFinal=" + this.isFinal + ", linesOfCode=" + this.linesOfCode + ", cyclomaticComplexity=" + this.cyclomaticComplexity + ", accessModifier='" + this.accessModifier + '\'' + ", methodName='" + this.methodName + '\'' + ", ci=" + this.ci + '}';
    }
}

