/*
 * Decompiled with CFR 0.152.
 */
package AndroidProjectRepresentation;

import AndroidProjectRepresentation.CodeEntity;
import AndroidProjectRepresentation.JSONSerializable;
import AndroidProjectRepresentation.MethodInfo;
import AndroidProjectRepresentation.NameExpression;
import AndroidProjectRepresentation.Variable;
import com.github.javaparser.ast.body.ModifierSet;
import java.io.FileReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class ClassInfo
extends CodeEntity
implements Serializable,
JSONSerializable {
    public Set<String> allModifiers = new HashSet<String>();
    public Set<String> typeParams = new HashSet<String>();
    public boolean isInterface = false;
    public boolean isFinal = false;
    public boolean isAbstract = false;
    public String accessModifier = "public";
    public String classPackage = "";
    public String className = "";
    public String extendedClass = "";
    public String outClass = "";
    public Set<NameExpression> classImports = new HashSet<NameExpression>();
    public Map<String, MethodInfo> classMethods = new HashMap<String, MethodInfo>();
    public Map<String, Variable> classVariables = new HashMap<String, Variable>();
    public Set<String> parentClasses = new HashSet<String>();
    public Set<String> interfacesImplemented = new HashSet<String>();
    public String appID = "";

    public int hashCode() {
        return this.className.hashCode();
    }

    public void setModifiers(int modifiers) {
        this.isAbstract = ModifierSet.isAbstract(modifiers);
        this.isFinal = ModifierSet.isFinal(modifiers);
        this.accessModifier = ModifierSet.isPublic(modifiers) ? "public" : (ModifierSet.isProtected(modifiers) ? "protected" : (ModifierSet.isPrivate(modifiers) ? "private" : "protected"));
    }

    public void setModifiers(List<String> modifiers) {
        modifiers.forEach(x -> this.setModifier((String)x));
    }

    public void setModifier(String mod) {
        if (mod.toLowerCase().equals("public")) {
            this.accessModifier = "public";
        } else if (mod.toLowerCase().equals("private")) {
            this.accessModifier = "private";
        } else if (mod.toLowerCase().equals("protected")) {
            this.accessModifier = "protected";
        } else {
            this.allModifiers.add(mod);
        }
    }

    public ClassInfo(String appID) {
        this.appID = appID;
        this.allModifiers = new HashSet<String>();
        this.outClass = "";
        this.extendedClass = "";
        this.classPackage = "";
        this.className = "";
    }

    public static JSONObject getClassMetric(String classID, String metricName, Number value, String valueText) {
        JSONObject jo = new JSONObject();
        jo.put("cm_class", classID);
        jo.put("cm_metric", metricName);
        jo.put("cm_value", value);
        jo.put("cm_value_text", valueText);
        return jo;
    }

    /*
     * WARNING - void declaration
     */
    public JSONObject classInfoToJSON(String appID) {
        void var6_13;
        JSONObject jo = new JSONObject();
        jo.put("class_id", this.getClassID());
        jo.put("class_app", appID);
        jo.put("class_is_interface", this.isInterface);
        jo.put("class_non_acc_mod", (this.isFinal ? "final" : "") + (this.isAbstract ? "--abstract" : ""));
        jo.put("class_name", this.className);
        jo.put("class_outterclass", this.outClass);
        jo.put("class_package", this.classPackage);
        jo.put("class_superclass", this.extendedClass);
        jo.put("class_acc_modifier", this.accessModifier);
        JSONArray imports = new JSONArray();
        for (NameExpression nameExpression : this.classImports) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put("import_name", nameExpression.qualifier + "." + nameExpression.name);
            jSONObject.put("import_class", this.getClassID());
            imports.add(jSONObject);
        }
        jo.put("class_imports", imports);
        JSONArray methods = new JSONArray();
        for (MethodInfo methodInfo : this.classMethods.values()) {
            JSONObject m = methodInfo.methodInfoToJSON(this.getClassID());
            methods.add(m);
        }
        jo.put("class_methods", methods);
        JSONArray jSONArray = new JSONArray();
        for (Variable v : this.classVariables.values()) {
            JSONObject var = new JSONObject();
            var.put("var_type", v.type);
            var.put("var_array", v.arrayCount);
            var.put("var_isStatic", v.isStatic);
            var.put("var_isFinal", v.isFinal);
            var.put("var_isVolatile", v.isVolatile);
            var.put("var_isTransient", v.isTransient);
            jSONArray.add(var);
        }
        jo.put("class_vars", jSONArray);
        String string = "";
        for (String s : this.interfacesImplemented) {
            String string2 = (String)var6_13 + s + "--";
        }
        jo.put("class_implemented_ifaces", var6_13);
        return jo;
    }

    public String getFullClassName() {
        String s = this.outClass.equals("") ? "" : this.outClass + ".";
        return this.classPackage + "." + s + this.className;
    }

    public MethodInfo getMethod(String methodName) {
        for (String s : this.classMethods.keySet()) {
            if (!s.contains(methodName)) continue;
            MethodInfo m = this.classMethods.get(s);
            String mm = methodName.replaceAll("\\(.*?\\)", "");
            String mic = m.methodName.replaceAll("\\(.*?\\)", "");
            if (!m.getMethodID().contains(methodName) || !mm.equals(mic)) continue;
            return m;
        }
        return null;
    }

    protected String getSimpleClassID() {
        String s = this.outClass.equals("") ? "" : this.outClass + ".";
        return this.classPackage + "." + s + this.className;
    }

    public String getClassID() {
        String s = this.outClass.equals("") ? "" : this.outClass + ".";
        return this.appID + "--" + this.classPackage + "." + s + this.className;
    }

    @Override
    public JSONObject toJSONObject(String appID) {
        return this.classInfoToJSON(appID);
    }

    @Override
    public JSONSerializable fromJSONObject(JSONObject jo) {
        JSONObject job;
        JSONArray jj;
        ClassInfo classe = new ClassInfo("");
        classe.appID = (String)jo.get("class_app");
        classe.className = (String)jo.get("class_name");
        classe.classPackage = (String)jo.get("class_package");
        classe.isInterface = (Boolean)jo.get("class_is_interface");
        classe.isAbstract = ((String)jo.get("class_non_acc_mod")).contains("abstract");
        classe.isFinal = ((String)jo.get("class_non_acc_mod")).contains("final");
        classe.extendedClass = (String)jo.get("class_superclass");
        classe.accessModifier = (String)jo.get("class_acc_modifier");
        classe.outClass = (String)jo.get("class_outterclass");
        for (String s : ((String)jo.get("class_implemented_ifaces")).split("--")) {
            classe.interfacesImplemented.add(s);
        }
        for (Object o : (JSONArray)jo.get("class_imports")) {
            String[] imp;
            JSONObject job2 = (JSONObject)o;
            if (!job2.containsKey("import_name") || (imp = ((String)job2.get("import_name")).split("\\.")).length <= 1) continue;
            classe.classImports.add(new NameExpression(((String)job2.get("import_name")).replace("." + imp[imp.length - 1], ""), imp[imp.length - 1]));
        }
        if (jo.containsKey("class_methods")) {
            jj = (JSONArray)jo.get("class_methods");
            if (!jo.isEmpty()) {
                for (Object o : jj) {
                    job = (JSONObject)o;
                    if (!job.containsKey("method_id")) continue;
                    MethodInfo mi = new MethodInfo();
                    mi = (MethodInfo)new MethodInfo().fromJSONObject(job);
                    mi.ci = classe;
                    classe.classMethods.put(mi.getMethodID(), mi);
                }
            }
        }
        if (jo.containsKey("class_vars") && !(jj = (JSONArray)jo.get("class_vars")).isEmpty()) {
            for (Object o : jj) {
                job = (JSONObject)o;
                if (!job.containsKey("var_type")) continue;
                Variable v = (Variable)new Variable().fromJSONObject(job);
                classe.classVariables.put(v.varName, v);
            }
        }
        return classe;
    }

    @Override
    public JSONObject fromJSONFile(String pathToJSONFile) {
        JSONParser parser = new JSONParser();
        JSONObject ja = new JSONObject();
        try {
            Object obj = parser.parse(new FileReader(pathToJSONFile));
            JSONObject jsonObject = (JSONObject)obj;
            if (jsonObject.containsKey("class_id")) {
                return jsonObject;
            }
        }
        catch (Exception var5) {
            var5.printStackTrace();
        }
        return ja;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        ClassInfo ne = (ClassInfo)obj;
        return this.classPackage.equals(ne.classPackage) && (this.extendedClass == null || ne.extendedClass == null || this.extendedClass.equals(ne.extendedClass)) && this.className.equals(ne.className);
    }
}

