/*
 * Decompiled with CFR 0.152.
 */
package greenlab.org.ebugslocator.detectors;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiVariable;
import greenlab.org.ebugslocator.checkers.ResourceChecker;
import greenlab.org.ebugslocator.detectors.MediaLeakDetector;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;

public class SensorLeakDetector
extends Detector
implements Detector.JavaPsiScanner {
    private static final Class<? extends Detector> DETECTOR_CLASS = MediaLeakDetector.class;
    private static final EnumSet<Scope> DETECTOR_SCOPE = Scope.JAVA_FILE_SCOPE;
    private static final Implementation IMPLEMENTATION = new Implementation(DETECTOR_CLASS, DETECTOR_SCOPE);
    private static final String ISSUE_ID = "SensorLeak";
    private static final String ISSUE_DESCRIPTION = "Keeping the sensor active without using it";
    private static final String ISSUE_EXPLANATION = "Detailed explanation";
    private static final Category ISSUE_CATEGORY = Category.PERFORMANCE;
    private static final int ISSUE_PRIORITY = 5;
    private static final Severity ISSUE_SEVERITY = Severity.WARNING;
    public static final Issue ISSUE = Issue.create((String)"SensorLeak", (String)"Keeping the sensor active without using it", (String)"Detailed explanation", (Category)ISSUE_CATEGORY, (int)5, (Severity)ISSUE_SEVERITY, (Implementation)IMPLEMENTATION);
    private static final String mSensorManagerClass = "android.hardware.SensorManager";
    private static final String mAcquireMethod = "registerListener";
    private static final String mReleaseMethod = "unregisterListener";

    public List<Class<? extends PsiElement>> getApplicablePsiTypes() {
        return Arrays.asList(PsiClass.class, PsiMethod.class, PsiMethodCallExpression.class, PsiVariable.class);
    }

    public JavaElementVisitor createPsiVisitor(JavaContext context) {
        return new SensorChecker(context, context.getDriver().getPhase(), ISSUE, mSensorManagerClass, mAcquireMethod, mReleaseMethod);
    }

    public void beforeCheckProject(Context context) {
        if (context.getDriver().getPhase() == 1) {
            SensorChecker.clear();
        }
        super.beforeCheckProject(context);
    }

    public void afterCheckProject(Context context) {
        if (context.getDriver().getPhase() == 1) {
            context.getDriver().requestRepeat((Detector)this, DETECTOR_SCOPE);
        } else if (context.getDriver().getPhase() == 2) {
            context.getDriver().requestRepeat((Detector)this, DETECTOR_SCOPE);
        }
        super.afterCheckProject(context);
    }

    private class SensorChecker
    extends ResourceChecker {
        public SensorChecker(JavaContext context, int phase, Issue issue, String resourceType, String acquireMethod, String releaseMethod) {
            super(context, phase, issue, resourceType, acquireMethod, releaseMethod);
        }
    }
}

