/*
 * Decompiled with CFR 0.152.
 */
package greenlab.org.ebugslocator.checkers;

import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import greenlab.org.ebugslocator.utils.Reporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ResourceChecker
extends JavaElementVisitor {
    private static final String mActivityClass = "android.app.Activity";
    private static final String mServiceClass = "android.app.Service";
    private static final List<String> mActivityExtends = Arrays.asList("android.accounts.AccountAuthenticatorActivity", "android.app.ActivityGroup", "android.app.AliasActivity", "android.app.ExpandableListActivity", "android.app.ListActivity", "android.app.LauncherActivity", "android.preference.PreferenceActivity", "android.app.NativeActivity", "android.app.FragmentActivity", "android.support.v4.app.FragmentActivity", "android.support.v7.app.AppCompatActivity", "android.app.TabActivity", "android.app.Fragment");
    private static final List<String> mServiceExtends = Arrays.asList("android.inputmethodservice.AbstractInputMethodService", "android.accessibilityservice.AccessibilityService", "android.service.autofill.AutofillService", "android.telecom.CallScreeningService", "android.service.media.CameraPrewarmService", "android.service.carrier.CarrierMessagingService", "android.service.carrier.CarrierService", "android.service.chooser.ChooserTargetService", "android.service.notification.ConditionProviderService", "android.telecom.ConnectionService", "android.app.admin.DeviceAdminService", "android.service.dreams.DreamService", "android.nfc.cardemulation.HostApduService", "android.nfc.cardemulation.HostNfcFService", "android.telecom.InCallService", "android.app.IntentService", "android.app.job.JobService", "android.service.media.MediaBrowserService", "android.media.midi.MidiDeviceService", "android.service.notification.NotificationListenerService", "android.nfc.cardemulation.OffHostApduService", "android.printservice.PrintService", "android.speech.RecognitionService", "android.widget.RemoteViewsService", "android.location.SettingInjectorService", "android.service.textservice.SpellCheckerService", "android.speech.tts.TextToSpeechService", "android.service.quicksettings.TileService", "android.media.tv.TvInputService", "android.telephony.VisualVoicemailService", "android.service.voice.VoiceInteractionService", "android.service.voice.VoiceInteractionSessionService", "android.net.VpnService", "android.service.vr.VrListenerService", "android.service.wallpaper.WallpaperService", "android.inputmethodservice.InputMethodService");
    private static Map<String, Set<String>> callStack = new HashMap<String, Set<String>>();
    private static List<String> resourceVars = new ArrayList<String>();
    private static ResourceUsage usageDetails = new ResourceUsage();
    private final JavaContext mContext;
    private Issue ISSUE;
    private int phase;
    private String resourceType;
    private String acquireMethod;
    private String releaseMethod;

    public ResourceChecker(JavaContext context, int phase, Issue issue, String resourceType, String acquireMethod, String releaseMethod) {
        this.mContext = context;
        this.phase = phase;
        this.ISSUE = issue;
        this.resourceType = resourceType;
        this.acquireMethod = acquireMethod;
        this.releaseMethod = releaseMethod;
    }

    private void updateCallStack(String className, String methodName, String callName) {
        String fullCallName = className + "." + callName;
        if (callStack.keySet().contains(methodName)) {
            callStack.get(methodName).add(fullCallName);
        } else {
            HashSet<String> calls = new HashSet<String>();
            calls.add(fullCallName);
            callStack.put(methodName, calls);
        }
    }

    private boolean isResourceVar(String varName) {
        for (String var : resourceVars) {
            if (!var.equals(varName)) continue;
            return true;
        }
        return false;
    }

    private String getFullyQualifiedName(String visitingClass, String visitingMethod, String varName) {
        if (varName.equals("")) {
            return visitingClass + "." + visitingMethod;
        }
        if (visitingMethod.equals("")) {
            return visitingClass + "." + varName;
        }
        return visitingClass + "." + visitingMethod + "." + varName;
    }

    private boolean isCalleeReachable(Set<String> calledMethods, String callee, Set<String> visited) {
        if (calledMethods == null) {
            return false;
        }
        for (String m : calledMethods) {
            if (visited.contains(m)) continue;
            visited.add(m);
            if (m.matches(callee)) {
                return true;
            }
            boolean check = this.isCalleeReachable(callStack.get(m), callee, visited);
            if (!check) continue;
            return true;
        }
        return false;
    }

    private String getParentMethodName(PsiElement node) {
        PsiElement parent;
        for (parent = node; !(parent instanceof PsiMethod) && parent != null; parent = parent.getParent()) {
        }
        if (parent == null) {
            return "";
        }
        return ((PsiMethod)parent).getName();
    }

    private String getParentClassName(PsiElement node) {
        PsiElement parent;
        for (parent = node; !(parent instanceof PsiClass) && parent != null; parent = parent.getParent()) {
        }
        if (parent == null) {
            return "";
        }
        return ((PsiClass)parent).getQualifiedName();
    }

    private boolean flowCheck() {
        if (usageDetails.getReleaseClass().equals(usageDetails.getAcquireClass())) {
            return true;
        }
        String releaseMethod = usageDetails.getReleaseMethod();
        String acquireMethod = usageDetails.getAcquireMethod();
        for (String caller : callStack.keySet()) {
            Set<String> calledMethods = callStack.get(caller);
            if (!calledMethods.contains(acquireMethod)) continue;
            return this.isCalleeReachable(calledMethods, releaseMethod, new HashSet<String>());
        }
        return false;
    }

    private void checkAndReport(PsiMethodCallExpression expression) {
        boolean isResourceMethod;
        String visitingClass = this.getParentClassName((PsiElement)expression);
        String qualifiedName = expression.getMethodExpression().getElement().getText().replace("this.", "");
        String methodName = expression.getMethodExpression().getReferenceName();
        String varName = this.getFullyQualifiedName(visitingClass, "", qualifiedName.split("\\.")[0]);
        boolean bl = isResourceMethod = methodName.matches(this.releaseMethod) || methodName.matches(this.acquireMethod);
        if (usageDetails.getVarName().equals(varName) && isResourceMethod) {
            if (usageDetails.getReleaseMethod().equals("") && !usageDetails.getAcquireMethod().equals("")) {
                Reporter.reportIssue(this.mContext, this.ISSUE, (PsiExpression)expression);
            } else if (ResourceChecker.usageDetails.isActivity) {
                boolean checkRelease;
                boolean bl2 = checkRelease = usageDetails.releaseMethodEndsWith("onPause") || usageDetails.releaseMethodEndsWith("onStop");
                if (methodName.matches(this.releaseMethod) && !checkRelease) {
                    boolean check;
                    Set<String> methodsFromOnStop = callStack.get(usageDetails.getAcquireClass() + ".onStop");
                    Set<String> methodsFromOnPause = callStack.get(usageDetails.getAcquireClass() + ".onPause");
                    boolean bl3 = check = this.isCalleeReachable(methodsFromOnStop, usageDetails.getReleaseMethod(), new HashSet<String>()) || this.isCalleeReachable(methodsFromOnPause, usageDetails.getReleaseMethod(), new HashSet<String>());
                    if (!check) {
                        Reporter.reportIssue(this.mContext, this.ISSUE, (PsiExpression)expression);
                    }
                }
            } else if (ResourceChecker.usageDetails.isService) {
                if (!this.flowCheck()) {
                    Reporter.reportIssue(this.mContext, this.ISSUE, (PsiExpression)expression);
                }
            } else if (!this.flowCheck()) {
                Reporter.reportIssue(this.mContext, this.ISSUE, (PsiExpression)expression);
            }
        }
    }

    public static void clear() {
        callStack.clear();
        usageDetails.clear();
    }

    public void visitClass(PsiClass element) {
        if (this.phase == 1) {
            for (PsiClassType extendedClass : element.getExtendsListTypes()) {
                if (!ResourceChecker.usageDetails.isActivity) {
                    ResourceChecker.usageDetails.isActivity = mActivityExtends.contains(extendedClass.getCanonicalText());
                    continue;
                }
                if (ResourceChecker.usageDetails.isService) continue;
                ResourceChecker.usageDetails.isService = mServiceExtends.contains(extendedClass.getCanonicalText());
            }
        }
        super.visitClass(element);
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        if (this.phase == 2) {
            String visitingClass = this.getParentClassName((PsiElement)expression);
            String visitingMethod = this.getParentMethodName((PsiElement)expression);
            String qualifiedName = expression.getMethodExpression().getElement().getText().replace("this.", "");
            String varName = this.getFullyQualifiedName(visitingClass, "", qualifiedName.split("\\.")[0]);
            String methodName = expression.getMethodExpression().getReferenceName();
            this.updateCallStack(visitingClass, visitingClass + "." + visitingMethod, qualifiedName);
            if (this.isResourceVar(varName)) {
                if (methodName.matches(this.acquireMethod)) {
                    usageDetails.setAcquireMethod(this.getFullyQualifiedName(visitingClass, visitingMethod, ""));
                    usageDetails.setAcquireClass(visitingClass);
                } else if (methodName.matches(this.releaseMethod)) {
                    usageDetails.setReleaseClass(visitingClass);
                    usageDetails.setReleaseMethod(this.getFullyQualifiedName(visitingClass, visitingMethod, ""));
                }
            }
        } else if (this.phase == 3) {
            this.checkAndReport(expression);
        }
        super.visitMethodCallExpression(expression);
    }

    public void visitVariable(PsiVariable variable) {
        PsiType varType;
        if (this.phase == 1 && (varType = variable.getType()) != null && varType.getCanonicalText().equals(this.resourceType)) {
            String visitingClass = this.getParentClassName((PsiElement)variable);
            String visitingMethod = this.getParentMethodName((PsiElement)variable);
            String qualifiedName = this.getFullyQualifiedName(visitingClass, visitingMethod, variable.getName());
            resourceVars.add(qualifiedName);
            usageDetails.setVarName(qualifiedName);
        }
        super.visitVariable(variable);
    }

    private static class ResourceUsage {
        private String varName;
        private String acquireClass;
        private String acquireMethod;
        private String releaseClass;
        private String releaseMethod;
        public boolean isActivity;
        public boolean isService;

        public ResourceUsage() {
            this.varName = "";
            this.acquireClass = "";
            this.acquireMethod = "";
            this.releaseClass = "";
            this.releaseMethod = "";
            this.isActivity = false;
            this.isService = false;
        }

        public ResourceUsage(String varName, String acquireClass, String acquireMethod, String releaseClass, String releaseMethod) {
            this.varName = varName;
            this.acquireClass = acquireClass;
            this.acquireMethod = acquireMethod;
            this.releaseClass = releaseClass;
            this.releaseMethod = releaseMethod;
            this.isActivity = false;
            this.isService = false;
        }

        public String getVarName() {
            return this.varName;
        }

        public void setVarName(String varName) {
            this.varName = varName;
        }

        public String getAcquireMethod() {
            return this.acquireMethod;
        }

        public void setAcquireMethod(String acquireMethod) {
            this.acquireMethod = acquireMethod;
        }

        public String getReleaseMethod() {
            return this.releaseMethod;
        }

        public boolean releaseMethodEndsWith(String suffix) {
            String[] split;
            for (String s : split = this.releaseMethod.split("\\|")) {
                if (!s.endsWith(suffix)) continue;
                return true;
            }
            return false;
        }

        public String getAcquireClass() {
            return this.acquireClass;
        }

        public void setAcquireClass(String acquireClass) {
            this.acquireClass = acquireClass;
        }

        public String getReleaseClass() {
            return this.releaseClass;
        }

        public void setReleaseClass(String releaseClass) {
            this.releaseClass = releaseClass;
        }

        public void setReleaseMethod(String releaseMethod) {
            this.releaseMethod = this.releaseMethod.equals("") ? releaseMethod : this.releaseMethod + "|" + releaseMethod;
        }

        public void clear() {
            this.acquireMethod = "";
            this.releaseMethod = "";
            this.isActivity = false;
            this.isService = false;
        }

        public String toString() {
            String res = "[Activity: " + this.isActivity + "]\n[Service: " + this.isService + "]\n";
            res = res + "\tvarName => " + this.varName + "\n";
            res = res + "\tAcq Class => " + this.acquireClass + "\n";
            res = res + "\tRel Class => " + this.releaseClass + "\n";
            res = res + "\tAcq Method => " + this.acquireMethod + "\n";
            res = res + "\tRel Method => " + this.releaseMethod + "\n";
            return res;
        }
    }
}

