/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher.util;

import com.google.common.flogger.GoogleLogger;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class FileUtil {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();

    public static void cleanupDirectory(Path directoryPath) {
        ((GoogleLogger.Api)logger.atFine()).log("Cleaning up directory %s", directoryPath.toAbsolutePath());
        try {
            FileUtil.deleteRecursively(directoryPath);
            if (Files.exists(directoryPath, new LinkOption[0])) {
                throw new RuntimeException("Failed to delete directory " + directoryPath.toAbsolutePath());
            }
            Files.createDirectories(directoryPath, new FileAttribute[0]);
            if (!Files.exists(directoryPath, new LinkOption[0])) {
                throw new RuntimeException("Failed to create directory " + directoryPath.toAbsolutePath());
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to cleanup directory " + directoryPath.toAbsolutePath(), e);
        }
    }

    public static void deleteRecursively(Path filePath) throws IOException {
        if (Files.isDirectory(filePath, new LinkOption[0])) {
            try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(filePath);){
                for (Path childFilePath : directoryStream) {
                    FileUtil.deleteRecursively(childFilePath);
                }
            }
        }
        Files.deleteIfExists(filePath);
    }
}

