/*
 * Decompiled with CFR 0.152.
 */
package androidx.test.tools.crawler.launcher;

import androidx.test.tools.crawler.common.base.Logger;
import androidx.test.tools.crawler.launcher.exceptions.LogcatRecordingException;
import androidx.test.tools.crawler.launcher.util.AdbExecutor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class LogcatRecorder
extends Thread {
    private final AdbExecutor adbExecutor;
    private final Path logcatOutputPath;
    private byte[] logcat = new byte[0];

    LogcatRecorder(AdbExecutor adbExecutor, Path outputDirectoryPath, String appPackageName) {
        this.adbExecutor = adbExecutor;
        this.logcatOutputPath = outputDirectoryPath.resolve(appPackageName + "-logcat.txt");
    }

    @Override
    public void run() {
        this.adbExecutor.execute("logcat", "-c");
        this.logcat = this.adbExecutor.execute("logcat", "-v", "time");
        Logger.atInfo().log("Writing logcat to %s", this.logcatOutputPath.toAbsolutePath());
        try {
            Files.write(this.logcatOutputPath, this.logcat, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new LogcatRecordingException("Failed to write logcat to file " + this.logcatOutputPath.toAbsolutePath(), e);
        }
    }

    public byte[] getLogcat() {
        return this.logcat;
    }
}

