/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/TypeParameterBoundIsNotArrayChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "frontend.java"})
public final class TypeParameterBoundIsNotArrayChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        List<TypeParameterDescriptor> list2;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (!(declarationDescriptor instanceof CallableDescriptor)) {
            declarationDescriptor = null;
        }
        if ((list2 = (CallableDescriptor)declarationDescriptor) == null || (list2 = list2.getTypeParameters()) == null) {
            DeclarationDescriptor declarationDescriptor2 = descriptor2;
            if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
                declarationDescriptor2 = null;
            }
            ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor2;
            list2 = classDescriptor2 != null ? classDescriptor2.getDeclaredTypeParameters() : null;
        }
        if (list2 == null) {
            return;
        }
        Intrinsics.checkExpressionValueIsNotNull(list2, "(descriptor as? Callable\u2026                ?: return");
        List<TypeParameterDescriptor> typeParameters2 = list2;
        Iterator<TypeParameterDescriptor> iterator2 = typeParameters2.iterator();
        while (iterator2.hasNext()) {
            boolean bl;
            TypeParameterDescriptor typeParameter;
            block9: {
                TypeParameterDescriptor typeParameterDescriptor = typeParameter = iterator2.next();
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                List<KotlinType> list3 = typeParameterDescriptor.getUpperBounds();
                Intrinsics.checkExpressionValueIsNotNull(list3, "typeParameter.upperBounds");
                Iterable $receiver$iv = list3;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        if (!(KotlinBuiltIns.isArray(it) || KotlinBuiltIns.isPrimitiveArray(it))) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameter);
            if (psiElement == null) {
                psiElement = declaration;
            }
            PsiElement element = psiElement;
            context.getTrace().report(ErrorsJvm.UPPER_BOUND_CANNOT_BE_ARRAY.on(element));
        }
    }
}

