/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmNameAnnotationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkDeclaration", "annotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "isRenamableFunction", "", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "frontend.java"})
public final class JvmNameAnnotationChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(context, "context");
        AnnotationDescriptor jvmNameAnnotation = DescriptorUtils.findJvmNameAnnotation(descriptor2);
        if (jvmNameAnnotation != null) {
            this.checkDeclaration(descriptor2, jvmNameAnnotation, context.getTrace());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDeclaration(DeclarationDescriptor descriptor2, AnnotationDescriptor annotation2, DiagnosticSink diagnosticHolder) {
        block7: {
            KtAnnotationEntry annotationEntry;
            block9: {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                block8: {
                    String value;
                    KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
                    if (ktAnnotationEntry == null) {
                        return;
                    }
                    annotationEntry = ktAnnotationEntry;
                    if (descriptor2 instanceof FunctionDescriptor && !this.isRenamableFunction((FunctionDescriptor)descriptor2)) {
                        diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
                    }
                    if ((value = DescriptorUtils.getJvmName(descriptor2)) == null || !Name.isValidIdentifier(value)) {
                        diagnosticHolder.report(ErrorsJvm.ILLEGAL_JVM_NAME.on((KtAnnotationEntry)((PsiElement)annotationEntry)));
                    }
                    if (!(descriptor2 instanceof CallableMemberDescriptor)) break block7;
                    if (!DescriptorUtils.isOverride((CallableMemberDescriptor)descriptor2) && !ModalityKt.isOverridable((CallableMemberDescriptor)descriptor2)) break block8;
                    diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
                    break block7;
                }
                DeclarationDescriptor declarationDescriptor = ((CallableMemberDescriptor)descriptor2).getContainingDeclaration();
                Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration");
                if (InlineClassManglingRulesKt.isInlineClassThatRequiresMangling(declarationDescriptor)) break block9;
                List<ValueParameterDescriptor> list2 = ((CallableMemberDescriptor)descriptor2).getValueParameters();
                Intrinsics.checkExpressionValueIsNotNull(list2, "descriptor.valueParameters");
                Iterable iterable = $receiver$iv = (Iterable)list2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    KotlinType kotlinType2;
                    void it;
                    ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    void v3 = it;
                    Intrinsics.checkExpressionValueIsNotNull(v3, "it");
                    Intrinsics.checkExpressionValueIsNotNull(v3.getType(), "it.type");
                    collection.add(kotlinType2);
                }
                if (!InlineClassManglingRulesKt.requiresFunctionNameMangling((List)destination$iv$iv)) break block7;
            }
            diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_NAME.on(annotationEntry));
        }
    }

    private final boolean isRenamableFunction(FunctionDescriptor descriptor2) {
        DeclarationDescriptor declarationDescriptor = descriptor2.getContainingDeclaration();
        Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "descriptor.containingDeclaration");
        DeclarationDescriptor containingDescriptor = declarationDescriptor;
        return containingDescriptor instanceof PackageFragmentDescriptor || containingDescriptor instanceof ClassDescriptor;
    }
}

