/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.ArgumentTypeResolver;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ExplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.ImplicitSmartCasts;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SingleSmartCast;
import org.jetbrains.kotlin.resolve.calls.smartcasts.SmartCastResult;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nJ&\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0002J<\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J>\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000e\u001a\u00020\u0006\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager;", "", "()V", "getSmartCastReceiverResult", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager$ReceiverSmartCastResult;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "receiverParameterType", "Lorg/jetbrains/kotlin/types/KotlinType;", "context", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "getSmartCastReceiverResultWithGivenNullability", "getSmartCastVariants", "", "receiverToCast", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "dataFlowValueFactory", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "getSmartCastVariantsExcludingReceiver", "", "Companion", "ReceiverSmartCastResult", "frontend"})
public final class SmartCastManager {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final List<KotlinType> getSmartCastVariants(@NotNull ReceiverValue receiverToCast, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule, @NotNull DataFlowInfo dataFlowInfo, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull DataFlowValueFactory dataFlowValueFactory) {
        Intrinsics.checkParameterIsNotNull(receiverToCast, "receiverToCast");
        Intrinsics.checkParameterIsNotNull(bindingContext, "bindingContext");
        Intrinsics.checkParameterIsNotNull(containingDeclarationOrModule, "containingDeclarationOrModule");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        Intrinsics.checkParameterIsNotNull(dataFlowValueFactory, "dataFlowValueFactory");
        Collection<KotlinType> variants = this.getSmartCastVariantsExcludingReceiver(bindingContext, containingDeclarationOrModule, dataFlowInfo, receiverToCast, languageVersionSettings, dataFlowValueFactory);
        ArrayList<KotlinType> result2 = new ArrayList<KotlinType>(variants.size() + 1);
        result2.add(receiverToCast.getType());
        result2.addAll(variants);
        return result2;
    }

    @NotNull
    public final Collection<KotlinType> getSmartCastVariantsExcludingReceiver(@NotNull ResolutionContext<?> context, @NotNull ReceiverValue receiverToCast) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        Intrinsics.checkParameterIsNotNull(receiverToCast, "receiverToCast");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        BindingContext bindingContext = bindingTrace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "context.trace.bindingContext");
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        LanguageVersionSettings languageVersionSettings = context.languageVersionSettings;
        Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "context.languageVersionSettings");
        DataFlowValueFactory dataFlowValueFactory = context.dataFlowValueFactory;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowValueFactory, "context.dataFlowValueFactory");
        return this.getSmartCastVariantsExcludingReceiver(bindingContext, declarationDescriptor, dataFlowInfo, receiverToCast, languageVersionSettings, dataFlowValueFactory);
    }

    private final Collection<KotlinType> getSmartCastVariantsExcludingReceiver(BindingContext bindingContext, DeclarationDescriptor containingDeclarationOrModule, DataFlowInfo dataFlowInfo, ReceiverValue receiverToCast, LanguageVersionSettings languageVersionSettings, DataFlowValueFactory dataFlowValueFactory) {
        DataFlowValue dataFlowValue2 = dataFlowValueFactory.createDataFlowValue(receiverToCast, bindingContext, containingDeclarationOrModule);
        return dataFlowInfo.getCollectedTypes(dataFlowValue2, languageVersionSettings);
    }

    @Nullable
    public final ReceiverSmartCastResult getSmartCastReceiverResult(@NotNull ReceiverValue receiverArgument, @NotNull KotlinType receiverParameterType, @NotNull ResolutionContext<?> context) {
        Intrinsics.checkParameterIsNotNull(receiverArgument, "receiverArgument");
        Intrinsics.checkParameterIsNotNull(receiverParameterType, "receiverParameterType");
        Intrinsics.checkParameterIsNotNull(context, "context");
        ReceiverSmartCastResult receiverSmartCastResult = this.getSmartCastReceiverResultWithGivenNullability(receiverArgument, receiverParameterType, context);
        if (receiverSmartCastResult != null) {
            ReceiverSmartCastResult receiverSmartCastResult2;
            ReceiverSmartCastResult it = receiverSmartCastResult2 = receiverSmartCastResult;
            return it;
        }
        KotlinType kotlinType2 = TypeUtils.makeNullable(receiverParameterType);
        Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNullable(receiverParameterType)");
        KotlinType nullableParameterType = kotlinType2;
        return this.getSmartCastReceiverResultWithGivenNullability(receiverArgument, nullableParameterType, context) == null ? null : ReceiverSmartCastResult.SMARTCAST_NEEDED_OR_NOT_NULL_EXPECTED;
    }

    private final ReceiverSmartCastResult getSmartCastReceiverResultWithGivenNullability(ReceiverValue receiverArgument, KotlinType receiverParameterType, ResolutionContext<?> context) {
        ReceiverSmartCastResult receiverSmartCastResult;
        if (ArgumentTypeResolver.isSubtypeOfForArgumentType(receiverArgument.getType(), receiverParameterType)) {
            receiverSmartCastResult = ReceiverSmartCastResult.OK;
        } else {
            boolean bl;
            block5: {
                Iterable $receiver$iv = this.getSmartCastVariantsExcludingReceiver(context, receiverArgument);
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(it, receiverParameterType)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            receiverSmartCastResult = bl ? ReceiverSmartCastResult.SMARTCAST_NEEDED_OR_NOT_NULL_EXPECTED : null;
        }
        return receiverSmartCastResult;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager$ReceiverSmartCastResult;", "", "(Ljava/lang/String;I)V", "OK", "SMARTCAST_NEEDED_OR_NOT_NULL_EXPECTED", "frontend"})
    public static final class ReceiverSmartCastResult
    extends Enum<ReceiverSmartCastResult> {
        public static final /* enum */ ReceiverSmartCastResult OK;
        public static final /* enum */ ReceiverSmartCastResult SMARTCAST_NEEDED_OR_NOT_NULL_EXPECTED;
        private static final /* synthetic */ ReceiverSmartCastResult[] $VALUES;

        static {
            ReceiverSmartCastResult[] receiverSmartCastResultArray = new ReceiverSmartCastResult[2];
            ReceiverSmartCastResult[] receiverSmartCastResultArray2 = receiverSmartCastResultArray;
            receiverSmartCastResultArray[0] = OK = new ReceiverSmartCastResult();
            receiverSmartCastResultArray[1] = SMARTCAST_NEEDED_OR_NOT_NULL_EXPECTED = new ReceiverSmartCastResult();
            $VALUES = receiverSmartCastResultArray;
        }

        public static ReceiverSmartCastResult[] values() {
            return (ReceiverSmartCastResult[])$VALUES.clone();
        }

        public static ReceiverSmartCastResult valueOf(String string) {
            return Enum.valueOf(ReceiverSmartCastResult.class, string);
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JV\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ@\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bJ:\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000bH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastManager$Companion;", "", "()V", "checkAndRecordPossibleCast", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/SmartCastResult;", "dataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "additionalPredicate", "Lkotlin/Function1;", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "call", "Lorg/jetbrains/kotlin/psi/Call;", "recordExpressionType", "recordCastOrError", "", "type", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "frontend"})
    public static final class Companion {
        private final void recordCastOrError(KtExpression expression2, KotlinType type2, BindingTrace trace, DataFlowValue dataFlowValue2, Call call2, boolean recordExpressionType) {
            block11: {
                block8: {
                    ExplicitSmartCasts explicitSmartCasts;
                    KtExpression ktExpression;
                    WritableSlice<KtExpression, ExplicitSmartCasts> writableSlice;
                    BindingTrace bindingTrace;
                    block10: {
                        SingleSmartCast newSmartCast;
                        block9: {
                            KotlinType oldType;
                            if (KotlinBuiltIns.isNullableNothing(type2)) {
                                return;
                            }
                            if (!dataFlowValue2.isStable()) break block8;
                            if (dataFlowValue2.getKind() == DataFlowValue.Kind.LEGACY_STABLE_LOCAL_DELEGATED_PROPERTY) {
                                trace.report(Errors.DEPRECATED_SMARTCAST.on((KtExpression)((PsiElement)expression2), type2, expression2.getText(), dataFlowValue2.getKind().getDescription()));
                            }
                            ExplicitSmartCasts oldSmartCasts = (ExplicitSmartCasts)trace.get(BindingContext.SMARTCAST, expression2);
                            newSmartCast = new SingleSmartCast(call2, type2);
                            if (oldSmartCasts != null && (oldType = oldSmartCasts.type(call2)) != null && Intrinsics.areEqual(oldType, type2) ^ true) {
                                throw (Throwable)((Object)new AssertionError((Object)("Rewriting key " + call2 + " for smart cast on " + expression2.getText())));
                            }
                            bindingTrace = trace;
                            writableSlice = BindingContext.SMARTCAST;
                            ktExpression = expression2;
                            explicitSmartCasts = oldSmartCasts;
                            if (explicitSmartCasts == null) break block9;
                            ExplicitSmartCasts explicitSmartCasts2 = explicitSmartCasts;
                            KtExpression ktExpression2 = ktExpression;
                            WritableSlice<KtExpression, ExplicitSmartCasts> writableSlice2 = writableSlice;
                            BindingTrace bindingTrace2 = bindingTrace;
                            ExplicitSmartCasts it = explicitSmartCasts2;
                            ExplicitSmartCasts explicitSmartCasts3 = it.plus(newSmartCast);
                            bindingTrace = bindingTrace2;
                            writableSlice = writableSlice2;
                            ktExpression = ktExpression2;
                            explicitSmartCasts = explicitSmartCasts3;
                            if (explicitSmartCasts != null) break block10;
                        }
                        explicitSmartCasts = newSmartCast;
                    }
                    bindingTrace.record(writableSlice, ktExpression, explicitSmartCasts);
                    if (recordExpressionType) {
                        trace.recordType(expression2, type2);
                    }
                    break block11;
                }
                trace.report(Errors.SMARTCAST_IMPOSSIBLE.on((KtExpression)((PsiElement)expression2), type2, expression2.getText(), dataFlowValue2.getKind().getDescription()));
            }
        }

        @Nullable
        public final SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue2, @NotNull KotlinType expectedType, @Nullable KtExpression expression2, @NotNull ResolutionContext<?> c, @Nullable Call call2, boolean recordExpressionType) {
            Intrinsics.checkParameterIsNotNull(dataFlowValue2, "dataFlowValue");
            Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
            Intrinsics.checkParameterIsNotNull(c, "c");
            return this.checkAndRecordPossibleCast(dataFlowValue2, expectedType, null, expression2, c, call2, recordExpressionType);
        }

        @Nullable
        public final SmartCastResult checkAndRecordPossibleCast(@NotNull DataFlowValue dataFlowValue2, @NotNull KotlinType expectedType, @Nullable Function1<? super KotlinType, Boolean> additionalPredicate, @Nullable KtExpression expression2, @NotNull ResolutionContext<?> c, @Nullable Call call2, boolean recordExpressionType) {
            Intrinsics.checkParameterIsNotNull(dataFlowValue2, "dataFlowValue");
            Intrinsics.checkParameterIsNotNull(expectedType, "expectedType");
            Intrinsics.checkParameterIsNotNull(c, "c");
            Call call3 = call2;
            KtExpression calleeExpression = call3 != null ? call3.getCalleeExpression() : null;
            DataFlowInfo dataFlowInfo = c.dataFlowInfo;
            LanguageVersionSettings languageVersionSettings = c.languageVersionSettings;
            Intrinsics.checkExpressionValueIsNotNull(languageVersionSettings, "c.languageVersionSettings");
            for (KotlinType possibleType : dataFlowInfo.getCollectedTypes(dataFlowValue2, languageVersionSettings)) {
                block10: {
                    ImplicitSmartCasts implicitSmartCasts;
                    KtExpression ktExpression;
                    WritableSlice<KtExpression, ImplicitSmartCasts> writableSlice;
                    BindingTrace bindingTrace;
                    block12: {
                        ImplicitSmartCasts newSmartCasts;
                        block11: {
                            KotlinType oldType;
                            ReceiverValue receiver2;
                            block9: {
                                if (!ArgumentTypeResolver.isSubtypeOfForArgumentType(possibleType, expectedType) || additionalPredicate != null && !additionalPredicate.invoke(possibleType).booleanValue()) continue;
                                if (expression2 == null) break block9;
                                BindingTrace bindingTrace2 = c.trace;
                                Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "c.trace");
                                this.recordCastOrError(expression2, possibleType, bindingTrace2, dataFlowValue2, call2, recordExpressionType);
                                break block10;
                            }
                            if (calleeExpression == null || !dataFlowValue2.isStable()) break block10;
                            IdentifierInfo identifierInfo = dataFlowValue2.getIdentifierInfo();
                            if (!(identifierInfo instanceof IdentifierInfo.Receiver)) {
                                identifierInfo = null;
                            }
                            IdentifierInfo.Receiver receiver3 = (IdentifierInfo.Receiver)identifierInfo;
                            ReceiverValue receiverValue = receiver2 = receiver3 != null ? receiver3.getValue() : null;
                            if (!(receiver2 instanceof ImplicitReceiver)) break block10;
                            ImplicitSmartCasts oldSmartCasts = (ImplicitSmartCasts)c.trace.get(BindingContext.IMPLICIT_RECEIVER_SMARTCAST, calleeExpression);
                            newSmartCasts = new ImplicitSmartCasts((ImplicitReceiver)receiver2, possibleType);
                            if (oldSmartCasts != null && (oldType = oldSmartCasts.getReceiverTypes().get(receiver2)) != null && Intrinsics.areEqual(oldType, possibleType) ^ true) {
                                throw (Throwable)((Object)new AssertionError((Object)("Rewriting key " + receiver2 + " for implicit smart cast on " + calleeExpression.getText() + ": " + "was " + oldType + ", now " + possibleType)));
                            }
                            bindingTrace = c.trace;
                            writableSlice = BindingContext.IMPLICIT_RECEIVER_SMARTCAST;
                            ktExpression = calleeExpression;
                            implicitSmartCasts = oldSmartCasts;
                            if (implicitSmartCasts == null) break block11;
                            ImplicitSmartCasts implicitSmartCasts2 = implicitSmartCasts;
                            KtExpression ktExpression2 = ktExpression;
                            WritableSlice<KtExpression, ImplicitSmartCasts> writableSlice2 = writableSlice;
                            BindingTrace bindingTrace3 = bindingTrace;
                            ImplicitSmartCasts it = implicitSmartCasts2;
                            ImplicitSmartCasts implicitSmartCasts3 = it.plus(newSmartCasts);
                            bindingTrace = bindingTrace3;
                            writableSlice = writableSlice2;
                            ktExpression = ktExpression2;
                            implicitSmartCasts = implicitSmartCasts3;
                            if (implicitSmartCasts != null) break block12;
                        }
                        implicitSmartCasts = newSmartCasts;
                    }
                    bindingTrace.record(writableSlice, ktExpression, implicitSmartCasts);
                }
                return new SmartCastResult(possibleType, dataFlowValue2.isStable());
            }
            if (!c.dataFlowInfo.getCollectedNullability(dataFlowValue2).canBeNull() && !expectedType.isMarkedNullable()) {
                boolean immanentlyNotNull = !dataFlowValue2.getImmanentNullability().canBeNull();
                KotlinType kotlinType2 = TypeUtils.makeNullable(expectedType);
                Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "TypeUtils.makeNullable(expectedType)");
                KotlinType nullableExpectedType = kotlinType2;
                if (ArgumentTypeResolver.isSubtypeOfForArgumentType(dataFlowValue2.getType(), nullableExpectedType) && (additionalPredicate == null || additionalPredicate.invoke(dataFlowValue2.getType()).booleanValue())) {
                    if (!immanentlyNotNull && expression2 != null) {
                        KotlinType kotlinType3 = dataFlowValue2.getType();
                        BindingTrace bindingTrace = c.trace;
                        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "c.trace");
                        this.recordCastOrError(expression2, kotlinType3, bindingTrace, dataFlowValue2, call2, recordExpressionType);
                    }
                    return new SmartCastResult(dataFlowValue2.getType(), immanentlyNotNull || dataFlowValue2.isStable());
                }
                return this.checkAndRecordPossibleCast(dataFlowValue2, nullableExpectedType, expression2, c, call2, recordExpressionType);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

