/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.com.google.common.collect.ImmutableSet;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a(\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005\u001a(\u0010\f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\n\u0010\u000e\u001a\u00020\u000b*\u00020\u0003\u00a8\u0006\u000f"}, d2={"checkModConvention", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "modifier", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "shouldWarnAboutDeprecatedModFromBuiltIns", "", "warnAboutDeprecatedOrForbiddenMod", "reportOn", "isOperatorMod", "frontend"})
public final class OperatorCallCheckerKt {
    public static final boolean isOperatorMod(@NotNull FunctionDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "receiver$0");
        return $receiver.isOperator() && ((ImmutableSet)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.values()).contains($receiver.getName());
    }

    public static final boolean shouldWarnAboutDeprecatedModFromBuiltIns(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkParameterIsNotNull(languageVersionSettings, "languageVersionSettings");
        return languageVersionSettings.supportsFeature(LanguageFeature.OperatorRem) && languageVersionSettings.getApiVersion().compareTo(ApiVersion.KOTLIN_1_1) >= 0;
    }

    private static final void checkModConvention(FunctionDescriptor descriptor2, LanguageVersionSettings languageVersionSettings, DiagnosticSink diagnosticHolder, PsiElement modifier) {
        if (!OperatorCallCheckerKt.isOperatorMod(descriptor2)) {
            return;
        }
        if (KotlinBuiltIns.isUnderKotlinPackage(descriptor2)) {
            if (OperatorCallCheckerKt.shouldWarnAboutDeprecatedModFromBuiltIns(languageVersionSettings)) {
                OperatorCallCheckerKt.warnAboutDeprecatedOrForbiddenMod(descriptor2, diagnosticHolder, modifier, languageVersionSettings);
            }
        } else if (languageVersionSettings.supportsFeature(LanguageFeature.OperatorRem)) {
            OperatorCallCheckerKt.warnAboutDeprecatedOrForbiddenMod(descriptor2, diagnosticHolder, modifier, languageVersionSettings);
        }
    }

    private static final void warnAboutDeprecatedOrForbiddenMod(FunctionDescriptor descriptor2, DiagnosticSink diagnosticHolder, PsiElement reportOn, LanguageVersionSettings languageVersionSettings) {
        Name newNameConvention;
        DiagnosticFactory2<PsiElement, FunctionDescriptor, String> diagnosticFactory = languageVersionSettings.supportsFeature(LanguageFeature.ProhibitOperatorMod) ? Errors.FORBIDDEN_BINARY_MOD_AS_REM : Errors.DEPRECATED_BINARY_MOD_AS_REM;
        Name name = newNameConvention = (Name)OperatorConventions.REM_TO_MOD_OPERATION_NAMES.inverse().get(descriptor2.getName());
        if (name == null) {
            Intrinsics.throwNpe();
        }
        diagnosticHolder.report(diagnosticFactory.on(reportOn, descriptor2, name.asString()));
    }

    public static final /* synthetic */ void access$checkModConvention(FunctionDescriptor descriptor2, LanguageVersionSettings languageVersionSettings, DiagnosticSink diagnosticHolder, PsiElement modifier) {
        OperatorCallCheckerKt.checkModConvention(descriptor2, languageVersionSettings, diagnosticHolder, modifier);
    }
}

