/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.psi.IfNotParsed;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtExpressionImpl;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtBinaryExpression
extends KtExpressionImpl
implements KtOperationExpression {
    public KtBinaryExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data2) {
        return visitor2.visitBinaryExpression(this, data2);
    }

    @IfNotParsed
    @Nullable
    public KtExpression getLeft() {
        for (ASTNode node = this.getOperationReference().getNode().getTreePrev(); node != null; node = node.getTreePrev()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtExpression)) continue;
            return (KtExpression)psi;
        }
        return null;
    }

    @IfNotParsed
    @Nullable
    public KtExpression getRight() {
        for (ASTNode node = this.getOperationReference().getNode().getTreeNext(); node != null; node = node.getTreeNext()) {
            PsiElement psi = node.getPsi();
            if (!(psi instanceof KtExpression)) continue;
            return (KtExpression)psi;
        }
        return null;
    }

    @Override
    @NotNull
    public KtOperationReferenceExpression getOperationReference() {
        return (KtOperationReferenceExpression)this.findChildByType(KtNodeTypes.OPERATION_REFERENCE);
    }

    @NotNull
    public IElementType getOperationToken() {
        return this.getOperationReference().getReferencedNameElementType();
    }
}

