/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.impl.VirtualFileBoundJavaClass;
import org.jetbrains.kotlin.load.kotlin.KotlinBinaryClassCache;
import org.jetbrains.kotlin.load.kotlin.KotlinClassFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder;", "()V", "classFileName", "", "jClass", "Lorg/jetbrains/kotlin/load/java/structure/JavaClass;", "findKotlinClassOrContent", "Lorg/jetbrains/kotlin/load/kotlin/KotlinClassFinder$Result;", "javaClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findVirtualFileWithHeader", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "SERVICE", "frontend.java"})
public abstract class VirtualFileFinder
implements KotlinClassFinder {
    public static final SERVICE SERVICE = new SERVICE(null);

    @Nullable
    public abstract VirtualFile findVirtualFileWithHeader(@NotNull ClassId var1);

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        VirtualFile virtualFile2 = this.findVirtualFileWithHeader(classId);
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile file2 = virtualFile2;
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, file2, null, 2, null);
    }

    @Override
    @Nullable
    public KotlinClassFinder.Result findKotlinClassOrContent(@NotNull JavaClass javaClass) {
        Object object;
        Intrinsics.checkParameterIsNotNull(javaClass, "javaClass");
        JavaClass javaClass2 = javaClass;
        if (!(javaClass2 instanceof VirtualFileBoundJavaClass)) {
            javaClass2 = null;
        }
        if ((object = (VirtualFileBoundJavaClass)javaClass2) == null || (object = object.getVirtualFile()) == null) {
            return null;
        }
        Object file2 = object;
        if (javaClass.getOuterClass() != null) {
            VirtualFile $receiver$iv;
            VirtualFile virtualFile2 = ((VirtualFile)file2).getParent();
            if (virtualFile2 == null) {
                Intrinsics.throwNpe();
            }
            VirtualFile virtualFile3 = $receiver$iv = virtualFile2.findChild(this.classFileName(javaClass) + ".class");
            if (virtualFile3 == null) {
                String string;
                String string2 = string = "Virtual file not found for " + javaClass;
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            file2 = virtualFile3;
        }
        return KotlinBinaryClassCache.Companion.getKotlinBinaryClassOrClassFileContent$default(KotlinBinaryClassCache.Companion, (VirtualFile)file2, null, 2, null);
    }

    private final String classFileName(JavaClass jClass) {
        String string = jClass.getName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "jClass.name.asString()");
        String simpleName2 = string;
        JavaClass javaClass = jClass.getOuterClass();
        if (javaClass == null) {
            return simpleName2;
        }
        JavaClass outerClass2 = javaClass;
        return this.classFileName(outerClass2) + "$" + simpleName2;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder$SERVICE;", "", "()V", "getInstance", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "frontend.java"})
    public static final class SERVICE {
        @NotNull
        public final VirtualFileFinder getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull(project, "project");
            VirtualFileFinderFactory virtualFileFinderFactory = VirtualFileFinderFactory.SERVICE.getInstance(project);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope(project);
            Intrinsics.checkExpressionValueIsNotNull(globalSearchScope, "GlobalSearchScope.allScope(project)");
            return virtualFileFinderFactory.create(globalSearchScope);
        }

        private SERVICE() {
        }

        public /* synthetic */ SERVICE(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

