/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.psi.KtExpression;

public final class ErrorReportingUtils {
    private ErrorReportingUtils() {
    }

    @NotNull
    public static RuntimeException reportErrorWithLocation(@NotNull KtExpression selector, @NotNull RuntimeException e) {
        return ErrorReportingUtils.reportErrorWithLocation(e, PsiDiagnosticUtils.atLocation(selector));
    }

    @NotNull
    private static RuntimeException reportErrorWithLocation(@NotNull RuntimeException e, @NotNull String location2) {
        throw new RuntimeException(e.getMessage() + " at " + location2, e);
    }

    @NotNull
    public static String message(@NotNull PsiElement expression2, @NotNull String messageText) {
        return messageText + " at " + PsiDiagnosticUtils.atLocation(expression2) + ".";
    }

    @NotNull
    public static String message(@NotNull DeclarationDescriptor descriptor2, @NotNull String explainingMessage) {
        return explainingMessage + " at " + DiagnosticUtils.atLocation(descriptor2) + ".";
    }

    @NotNull
    public static String message(@NotNull PsiElement element) {
        return "Error at " + PsiDiagnosticUtils.atLocation(element) + ".";
    }
}

