/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.util.io.KeyDescriptor;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/FileKeyDescriptor;", "Lorg/jetbrains/kotlin/com/intellij/util/io/KeyDescriptor;", "Ljava/io/File;", "()V", "getHashCode", "", "value", "isEqual", "", "val1", "val2", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "kotlin-build-common"})
public final class FileKeyDescriptor
implements KeyDescriptor<File> {
    public static final FileKeyDescriptor INSTANCE;

    @Override
    @NotNull
    public File read(@NotNull DataInput input) {
        Intrinsics.checkParameterIsNotNull(input, "input");
        return new File(input.readUTF());
    }

    @Override
    public void save(@NotNull DataOutput output, @NotNull File value) {
        Intrinsics.checkParameterIsNotNull(output, "output");
        Intrinsics.checkParameterIsNotNull(value, "value");
        output.writeUTF(value.getCanonicalPath());
    }

    public int getHashCode(@Nullable File value) {
        return FileUtil.FILE_HASHING_STRATEGY.computeHashCode(value);
    }

    public boolean isEqual(@Nullable File val1, @Nullable File val2) {
        return FileUtil.FILE_HASHING_STRATEGY.equals(val1, val2);
    }

    private FileKeyDescriptor() {
    }

    static {
        FileKeyDescriptor fileKeyDescriptor;
        INSTANCE = fileKeyDescriptor = new FileKeyDescriptor();
    }
}

