/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.openapi.util.Condition;
import org.jetbrains.kotlin.com.intellij.openapi.util.Factory;
import org.jetbrains.kotlin.com.intellij.util.ArrayFactory;
import org.jetbrains.kotlin.com.intellij.util.Function;
import org.jetbrains.kotlin.com.intellij.util.Processor;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentIntKeyWeakValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentIntObjectHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentIntObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentList;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentLongObjectHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentLongObjectMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentSoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakKeyWeakValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentWeakValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtilRt;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyIterable;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.FilteringIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.ImmutableList;
import org.jetbrains.kotlin.com.intellij.util.containers.LockFreeCopyOnWriteArrayList;
import org.jetbrains.kotlin.com.intellij.util.containers.SoftHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.SoftKeySoftValueHashMap;
import org.jetbrains.kotlin.com.intellij.util.containers.Stack;
import org.jetbrains.kotlin.com.intellij.util.containers.WeakHashMap;

public class ContainerUtil
extends ContainerUtilRt {
    @NotNull
    @Contract(pure=true)
    public static <K, V> HashMap<K, V> newHashMap() {
        HashMap hashMap = ContainerUtilRt.newHashMap();
        if (hashMap == null) {
            ContainerUtil.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        LinkedHashMap linkedHashMap = ContainerUtilRt.newLinkedHashMap();
        if (linkedHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(14);
        }
        return linkedHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap() {
        THashMap tHashMap = new THashMap();
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(21);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newTroveMap(@NotNull TObjectHashingStrategy<K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(22);
        }
        THashMap tHashMap = new THashMap(strategy);
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(23);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> canonicalStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.CANONICAL;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(26);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> TObjectHashingStrategy<T> identityStrategy() {
        TObjectHashingStrategy tObjectHashingStrategy = TObjectHashingStrategy.IDENTITY;
        if (tObjectHashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(27);
        }
        return tObjectHashingStrategy;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        IdentityHashMap identityHashMap = new IdentityHashMap();
        if (identityHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(28);
        }
        return identityHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedList<T> newLinkedList() {
        LinkedList linkedList = ContainerUtilRt.newLinkedList();
        if (linkedList == null) {
            ContainerUtil.$$$reportNull$$$0(29);
        }
        return linkedList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayList() {
        ArrayList arrayList = ContainerUtilRt.newArrayList();
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(34);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(35);
        }
        ArrayList<E> arrayList = ContainerUtilRt.newArrayList(array);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(36);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ArrayList<E> newArrayList(@NotNull Iterable<? extends E> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(37);
        }
        ArrayList<? extends E> arrayList = ContainerUtilRt.newArrayList(iterable);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(38);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> ArrayList<T> newArrayListWithCapacity(int size) {
        ArrayList arrayList = ContainerUtilRt.newArrayListWithCapacity(size);
        if (arrayList == null) {
            ContainerUtil.$$$reportNull$$$0(39);
        }
        return arrayList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newArrayList(final @NotNull T[] elements, final int start, final int end) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(40);
        }
        if (start < 0 || start > end || end > elements.length) {
            throw new IllegalArgumentException("start:" + start + " end:" + end + " length:" + elements.length);
        }
        AbstractList abstractList = new AbstractList<T>(){
            private final int size;
            {
                this.size = end - start;
            }

            @Override
            public T get(int index2) {
                if (index2 < 0 || index2 >= this.size) {
                    throw new IndexOutOfBoundsException("index:" + index2 + " size:" + this.size);
                }
                return elements[start + index2];
            }

            @Override
            public int size() {
                return this.size;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(41);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList() {
        SmartList smartList = new SmartList();
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(61);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> newSmartList(T element) {
        SmartList<T> smartList = new SmartList<T>(element);
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(62);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet() {
        HashSet hashSet = ContainerUtilRt.newHashSet();
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(65);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(67);
        }
        HashSet<T> hashSet = ContainerUtilRt.newHashSet(elements);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(68);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> HashSet<T> newHashSet(@NotNull Iterable<? extends T> iterable) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(69);
        }
        HashSet<? extends T> hashSet = ContainerUtilRt.newHashSet(iterable);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(70);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newHashOrEmptySet(@Nullable Iterable<? extends T> iterable) {
        boolean empty = iterable == null || iterable instanceof Collection && ((Collection)iterable).isEmpty();
        Set<Object> set = empty ? Collections.emptySet() : ContainerUtilRt.newHashSet(iterable);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(73);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet() {
        LinkedHashSet linkedHashSet = ContainerUtilRt.newLinkedHashSet();
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(74);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> LinkedHashSet<T> newLinkedHashSet(@NotNull Iterable<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(75);
        }
        LinkedHashSet<? extends T> linkedHashSet = ContainerUtilRt.newLinkedHashSet(elements);
        if (linkedHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(76);
        }
        return linkedHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet() {
        THashSet tHashSet = new THashSet();
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(79);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(80);
        }
        THashSet<T> tHashSet = new THashSet<T>(strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(81);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(T ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(82);
        }
        THashSet<T> tHashSet = ContainerUtil.newTroveSet(Arrays.asList(elements));
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(83);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull TObjectHashingStrategy<T> strategy, T ... elements) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(84);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(85);
        }
        THashSet<T> tHashSet = new THashSet<T>(Arrays.asList(elements), strategy);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(86);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> THashSet<T> newTroveSet(@NotNull Collection<? extends T> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(90);
        }
        THashSet<? extends T> tHashSet = new THashSet<T>(elements);
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(91);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K> THashSet<K> newIdentityTroveSet() {
        THashSet tHashSet = new THashSet(ContainerUtil.identityStrategy());
        if (tHashSet == null) {
            ContainerUtil.$$$reportNull$$$0(92);
        }
        return tHashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> THashMap<K, V> newIdentityTroveMap() {
        THashMap tHashMap = new THashMap(ContainerUtil.identityStrategy());
        if (tHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(96);
        }
        return tHashMap;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> newConcurrentSet() {
        Set set = Collections.newSetFromMap(ContainerUtil.newConcurrentMap());
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(103);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
        if (concurrentHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(104);
        }
        return concurrentHashMap;
    }

    @Contract(pure=true)
    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentHashMap(initialCapacity, loadFactor, concurrencyLevel);
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> reverse(final @NotNull List<? extends E> elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(105);
        }
        if (elements.isEmpty()) {
            List list2 = ContainerUtilRt.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(106);
            }
            return list2;
        }
        AbstractList abstractList = new AbstractList<E>(){

            @Override
            public E get(int index2) {
                return elements.get(elements.size() - 1 - index2);
            }

            @Override
            public int size() {
                return elements.size();
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(107);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> Set<E> immutableSet(E ... elements) {
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(117);
        }
        switch (elements.length) {
            case 0: {
                Set set = Collections.emptySet();
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(118);
                }
                return set;
            }
            case 1: {
                Set<E> set = Collections.singleton(elements[0]);
                if (set == null) {
                    ContainerUtil.$$$reportNull$$$0(119);
                }
                return set;
            }
        }
        Set<E> set = Collections.unmodifiableSet(new THashSet<E>(Arrays.asList(elements)));
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(120);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableList(E ... array) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(121);
        }
        ImmutableListBackedByArray immutableListBackedByArray = new ImmutableListBackedByArray(array);
        if (immutableListBackedByArray == null) {
            ContainerUtil.$$$reportNull$$$0(122);
        }
        return immutableListBackedByArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <E> ImmutableList<E> immutableSingletonList(E element) {
        ImmutableList<E> immutableList = ImmutableList.singleton(element);
        if (immutableList == null) {
            ContainerUtil.$$$reportNull$$$0(123);
        }
        return immutableList;
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> appendix) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(148);
        }
        if (appendix == null) {
            ContainerUtil.$$$reportNull$$$0(149);
        }
        ContainerUtil.addAll(collection, appendix.iterator());
    }

    public static <T> void addAll(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> iterator2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(150);
        }
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(151);
        }
        while (iterator2.hasNext()) {
            T o = iterator2.next();
            collection.add(o);
        }
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterable<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(152);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(153);
        }
        ContainerUtil.addAllNotNull(collection, elements.iterator());
    }

    public static <T> void addAllNotNull(@NotNull Collection<? super T> collection, @NotNull Iterator<? extends T> elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(154);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(155);
        }
        while (elements.hasNext()) {
            T o = elements.next();
            if (o == null) continue;
            collection.add(o);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterator<T> emptyIterator() {
        EmptyIterator emptyIterator = EmptyIterator.getInstance();
        if (emptyIterator == null) {
            ContainerUtil.$$$reportNull$$$0(174);
        }
        return emptyIterator;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> emptyIterable() {
        EmptyIterable emptyIterable = EmptyIterable.getInstance();
        if (emptyIterable == null) {
            ContainerUtil.$$$reportNull$$$0(175);
        }
        return emptyIterable;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T find(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(176);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(177);
        }
        for (T element : array) {
            if (!condition.value(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> boolean process(@NotNull Iterable<? extends T> iterable, @NotNull Processor<? super T> processor2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(178);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(179);
        }
        for (T t : iterable) {
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull List<? extends T> list2, @NotNull Processor<? super T> processor2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(180);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(181);
        }
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            T t = list2.get(i);
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean process(@NotNull T[] iterable, @NotNull Processor<? super T> processor2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(182);
        }
        if (processor2 == null) {
            ContainerUtil.$$$reportNull$$$0(183);
        }
        for (T t : iterable) {
            if (processor2.process(t)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    @Contract(pure=true)
    public static <T, V extends T> V find(@NotNull Iterable<? extends V> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(186);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(187);
        }
        return ContainerUtilRt.find(iterable, condition);
    }

    @Nullable
    public static <T, V extends T> V find(@NotNull Iterator<? extends V> iterator2, @NotNull Condition<? super T> condition) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(192);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(193);
        }
        return ContainerUtilRt.find(iterator2, condition);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull T[] array, @NotNull Class<? super V> aClass2, @NotNull Function<? super T, ? extends V> mapper) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(216);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(217);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(218);
        }
        V[] VArray = ContainerUtil.map2Array(Arrays.asList(array), aClass2, mapper);
        if (VArray == null) {
            ContainerUtil.$$$reportNull$$$0(219);
        }
        return VArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> V[] map2Array(@NotNull Collection<? extends T> collection, @NotNull Class<? super V> aClass2, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(220);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(221);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(222);
        }
        List<V> list2 = ContainerUtil.map2List(collection, mapper);
        Object[] array = (Object[])Array.newInstance(aClass2, list2.size());
        Object[] objectArray = list2.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(223);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(228);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(229);
        }
        List<? super T> list2 = ContainerUtil.findAll(collection, condition);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(230);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull T[] collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(234);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(235);
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(236);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> filter(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(237);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(238);
        }
        List<? super T> list2 = ContainerUtil.findAll(collection, condition);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(239);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> findAll(@NotNull Collection<? extends T> collection, @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(243);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(244);
        }
        if (collection.isEmpty()) {
            List<T> list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                ContainerUtil.$$$reportNull$$$0(245);
            }
            return list2;
        }
        SmartList<T> result2 = new SmartList<T>();
        for (T t : collection) {
            if (!condition.value(t)) continue;
            result2.add(t);
        }
        SmartList<T> smartList = result2;
        if (smartList == null) {
            ContainerUtil.$$$reportNull$$$0(246);
        }
        return smartList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> skipNulls(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(247);
        }
        List<Object> list2 = ContainerUtil.findAll(collection, Condition.NOT_NULL);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(248);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] findAllAsArray(@NotNull T[] collection, @NotNull Condition<? super T> instanceOf) {
        List<Object> list2;
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(258);
        }
        if (instanceOf == null) {
            ContainerUtil.$$$reportNull$$$0(259);
        }
        if ((list2 = ContainerUtil.findAll(collection, instanceOf)).size() == collection.length) {
            if (collection == null) {
                ContainerUtil.$$$reportNull$$$0(260);
            }
            return collection;
        }
        Object[] array = (Object[])Array.newInstance(collection.getClass().getComponentType(), list2.size());
        Object[] objectArray = list2.toArray(array);
        if (objectArray == null) {
            ContainerUtil.$$$reportNull$$$0(261);
        }
        return objectArray;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(@NotNull T[] arrays, @NotNull Condition<? super T> condition) {
        if (arrays == null) {
            ContainerUtil.$$$reportNull$$$0(274);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(275);
        }
        Iterable<? super T> iterable = ContainerUtil.iterate(Arrays.asList(arrays), condition);
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(276);
        }
        return iterable;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Iterable<T> iterate(final @NotNull Collection<? extends T> collection, final @NotNull Condition<? super T> condition) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(277);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(278);
        }
        if (collection.isEmpty()) {
            Iterable<T> iterable = ContainerUtil.emptyIterable();
            if (iterable == null) {
                ContainerUtil.$$$reportNull$$$0(279);
            }
            return iterable;
        }
        Iterable iterable = new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                Iterator iterator2 = new Iterator<T>(){
                    private final Iterator<? extends T> impl;
                    private T next;
                    {
                        this.impl = collection.iterator();
                        this.next = this.findNext();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public T next() {
                        Object result2 = this.next;
                        this.next = this.findNext();
                        return result2;
                    }

                    @Nullable
                    private T findNext() {
                        while (this.impl.hasNext()) {
                            Object each = this.impl.next();
                            if (!condition.value(each)) continue;
                            return each;
                        }
                        return null;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
                if (iterator2 == null) {
                    7.$$$reportNull$$$0(0);
                }
                return iterator2;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$7", "iterator"));
            }
        };
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(280);
        }
        return iterable;
    }

    public static <E> void swapElements(@NotNull List<E> list2, int index1, int index2) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(286);
        }
        E e1 = list2.get(index1);
        E e2 = list2.get(index2);
        list2.set(index1, e2);
        list2.set(index2, e1);
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAll(@NotNull C collection, A ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(292);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(293);
        }
        for (A element : elements) {
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(294);
        }
        return c;
    }

    @NotNull
    public static <T, A extends T, C extends Collection<T>> C addAllNotNull(@NotNull C collection, A ... elements) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(295);
        }
        if (elements == null) {
            ContainerUtil.$$$reportNull$$$0(296);
        }
        for (A element : elements) {
            if (element == null) continue;
            collection.add(element);
        }
        C c = collection;
        if (c == null) {
            ContainerUtil.$$$reportNull$$$0(297);
        }
        return c;
    }

    @Contract(pure=true)
    public static <T, U extends T> U findInstance(@NotNull Iterable<? extends T> iterable, @NotNull Class<? extends U> aClass2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(302);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(303);
        }
        return ContainerUtil.findInstance(iterable.iterator(), aClass2);
    }

    public static <T, U extends T> U findInstance(@NotNull Iterator<? extends T> iterator2, @NotNull Class<? extends U> aClass2) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(304);
        }
        if (aClass2 == null) {
            ContainerUtil.$$$reportNull$$$0(305);
        }
        return (U)ContainerUtil.find(iterator2, FilteringIterator.instanceOf(aClass2));
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull V[] array, @NotNull Function<? super V, ? extends Collection<? extends T>> fun) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(308);
        }
        if (fun == null) {
            ContainerUtil.$$$reportNull$$$0(309);
        }
        List<T> list2 = ContainerUtil.concat(Arrays.asList(array), fun);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(310);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> concat(final @NotNull List<? extends T> list1, final @NotNull List<? extends T> list2) {
        if (list1 == null) {
            ContainerUtil.$$$reportNull$$$0(319);
        }
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(320);
        }
        if (list1.isEmpty() && list2.isEmpty()) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                ContainerUtil.$$$reportNull$$$0(321);
            }
            return list3;
        }
        if (list1.isEmpty()) {
            List<T> list4 = list2;
            if (list4 == null) {
                ContainerUtil.$$$reportNull$$$0(322);
            }
            return list4;
        }
        if (list2.isEmpty()) {
            List<T> list5 = list1;
            if (list5 == null) {
                ContainerUtil.$$$reportNull$$$0(323);
            }
            return list5;
        }
        final int size1 = list1.size();
        final int size = size1 + list2.size();
        AbstractList abstractList = new AbstractList<T>(){

            @Override
            public T get(int index2) {
                if (index2 < size1) {
                    return list1.get(index2);
                }
                return list2.get(index2 - size1);
            }

            @Override
            public int size() {
                return size;
            }
        };
        if (abstractList == null) {
            ContainerUtil.$$$reportNull$$$0(324);
        }
        return abstractList;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<T> concat(@NotNull Iterable<? extends V> list2, @NotNull Function<? super V, ? extends Collection<? extends T>> listGenerator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(340);
        }
        if (listGenerator == null) {
            ContainerUtil.$$$reportNull$$$0(341);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (V v2 : list2) {
            result2.addAll(listGenerator.fun(v2));
        }
        List<T> list3 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list3 == null) {
            ContainerUtil.$$$reportNull$$$0(342);
        }
        return list3;
    }

    @Contract(pure=true)
    public static <T> boolean intersects(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(343);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(344);
        }
        if (collection1.size() <= collection2.size()) {
            for (T t : collection1) {
                if (!collection2.contains(t)) continue;
                return true;
            }
        } else {
            for (T t : collection2) {
                if (!collection1.contains(t)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Collection<T> intersection(@NotNull Collection<? extends T> collection1, @NotNull Collection<? extends T> collection2) {
        if (collection1 == null) {
            ContainerUtil.$$$reportNull$$$0(345);
        }
        if (collection2 == null) {
            ContainerUtil.$$$reportNull$$$0(346);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : collection1) {
            if (!collection2.contains(t)) continue;
            result2.add(t);
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(347);
        }
        return list2;
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items) {
        return ContainerUtil.getFirstItem(items, null);
    }

    @Nullable
    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable List<? extends T> items) {
        return items == null || items.isEmpty() ? null : (T)items.get(0);
    }

    @Contract(pure=true)
    public static <T> T getFirstItem(@Nullable Collection<? extends T> items, @Nullable T defaultResult) {
        return items == null || items.isEmpty() ? defaultResult : items.iterator().next();
    }

    @NotNull
    @Contract(pure=true)
    public static <T, U> Iterator<U> mapIterator(final @NotNull Iterator<? extends T> iterator2, final @NotNull Function<? super T, ? extends U> mapper) {
        if (iterator2 == null) {
            ContainerUtil.$$$reportNull$$$0(354);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(355);
        }
        Iterator iterator3 = new Iterator<U>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            public U next() {
                return mapper.fun(iterator2.next());
            }

            @Override
            public void remove() {
                iterator2.remove();
            }
        };
        if (iterator3 == null) {
            ContainerUtil.$$$reportNull$$$0(356);
        }
        return iterator3;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> T[] toArray(@Nullable Collection<T> c, @NotNull ArrayFactory<? extends T> factory2) {
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(363);
        }
        T[] TArray = c != null ? c.toArray(factory2.create(c.size())) : factory2.create(0);
        if (TArray == null) {
            ContainerUtil.$$$reportNull$$$0(364);
        }
        return TArray;
    }

    public static <T> void sort(@NotNull List<T> list2, @NotNull Comparator<? super T> comparator) {
        int size;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(374);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(375);
        }
        if ((size = list2.size()) < 2) {
            return;
        }
        if (size == 2) {
            T t1;
            T t0 = list2.get(0);
            if (comparator.compare(t0, t1 = list2.get(1)) > 0) {
                list2.set(0, t1);
                list2.set(1, t0);
            }
        } else if (size < 10) {
            for (int i = 0; i < size; ++i) {
                for (int j = 0; j < i; ++j) {
                    T tj;
                    T ti = list2.get(i);
                    if (comparator.compare(ti, tj = list2.get(j)) >= 0) continue;
                    list2.set(i, tj);
                    list2.set(j, ti);
                }
            }
        } else {
            Collections.sort(list2, comparator);
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Iterable<? extends T> iterable, @NotNull Function<? super T, ? extends V> mapping2) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(387);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(388);
        }
        ArrayList<T> result2 = new ArrayList<T>();
        for (T t : iterable) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(389);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(390);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(391);
        }
        List<? extends V> list2 = ContainerUtilRt.map2List(collection, mapping2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(392);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping2) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(393);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(394);
        }
        List<? extends V> list2 = ContainerUtil.mapNotNull(Arrays.asList(array), mapping2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(395);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> mapNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapping2) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(404);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(405);
        }
        List<? extends V> list2 = ContainerUtilRt.mapNotNull(collection, mapping2);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(406);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map(@NotNull T[] array, @NotNull Function<? super T, ? extends V> mapping2) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(409);
        }
        if (mapping2 == null) {
            ContainerUtil.$$$reportNull$$$0(410);
        }
        ArrayList<T> result2 = new ArrayList<T>(array.length);
        for (T t : array) {
            result2.add(mapping2.fun(t));
        }
        List<T> list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(411);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> set(T ... items) {
        if (items == null) {
            ContainerUtil.$$$reportNull$$$0(417);
        }
        HashSet<T> hashSet = ContainerUtil.newHashSet(items);
        if (hashSet == null) {
            ContainerUtil.$$$reportNull$$$0(418);
        }
        return hashSet;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> createMaybeSingletonList(@Nullable T element) {
        List<T> list2 = element == null ? ContainerUtil.emptyList() : Collections.singletonList(element);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(425);
        }
        return list2;
    }

    public static <T, V> V getOrCreate(@NotNull Map<T, V> result2, T key, @NotNull Factory<? extends V> factory2) {
        V value;
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(430);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(431);
        }
        if ((value = result2.get(key)) == null) {
            value = factory2.create();
            result2.put(key, value);
        }
        return value;
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull T[] iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(435);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(436);
        }
        return ContainerUtil.and(Arrays.asList(iterable), condition);
    }

    @Contract(pure=true)
    public static <T> boolean and(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(437);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(438);
        }
        for (T t : iterable) {
            if (condition.value(t)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static <T> boolean exists(@NotNull T[] array, @NotNull Condition<? super T> condition) {
        if (array == null) {
            ContainerUtil.$$$reportNull$$$0(439);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(440);
        }
        for (T t : array) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static <T> boolean or(@NotNull Iterable<? extends T> iterable, @NotNull Condition<? super T> condition) {
        if (iterable == null) {
            ContainerUtil.$$$reportNull$$$0(445);
        }
        if (condition == null) {
            ContainerUtil.$$$reportNull$$$0(446);
        }
        for (T t : iterable) {
            if (!condition.value(t)) continue;
            return true;
        }
        return false;
    }

    public static <T> void quickSort(@NotNull List<? extends T> list2, @NotNull Comparator<? super T> comparator) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(456);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(457);
        }
        ContainerUtil.quickSort(list2, comparator, 0, list2.size());
    }

    private static <T> void quickSort(@NotNull List<? extends T> x, @NotNull Comparator<? super T> comparator, int off, int len) {
        int c;
        int a;
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(458);
        }
        if (comparator == null) {
            ContainerUtil.$$$reportNull$$$0(459);
        }
        if (len < 7) {
            for (int i = off; i < len + off; ++i) {
                for (int j = i; j > off && comparator.compare(x.get(j), x.get(j - 1)) < 0; --j) {
                    ContainerUtil.swapElements(x, j, j - 1);
                }
            }
            return;
        }
        int m = off + (len >> 1);
        if (len > 7) {
            int l = off;
            int n = off + len - 1;
            if (len > 40) {
                int s = len / 8;
                l = ContainerUtil.med3(x, comparator, l, l + s, l + 2 * s);
                m = ContainerUtil.med3(x, comparator, m - s, m, m + s);
                n = ContainerUtil.med3(x, comparator, n - 2 * s, n - s, n);
            }
            m = ContainerUtil.med3(x, comparator, l, m, n);
        }
        T v2 = x.get(m);
        int b = a = off;
        int d = c = off + len - 1;
        while (true) {
            if (b <= c && comparator.compare(x.get(b), v2) <= 0) {
                if (comparator.compare(x.get(b), v2) == 0) {
                    ContainerUtil.swapElements(x, a++, b);
                }
                ++b;
                continue;
            }
            while (c >= b && comparator.compare(v2, x.get(c)) <= 0) {
                if (comparator.compare(x.get(c), v2) == 0) {
                    ContainerUtil.swapElements(x, c, d--);
                }
                --c;
            }
            if (b > c) break;
            ContainerUtil.swapElements(x, b++, c--);
        }
        int n = off + len;
        int s = Math.min(a - off, b - a);
        ContainerUtil.vecswap(x, off, b - s, s);
        s = Math.min(d - c, n - d - 1);
        ContainerUtil.vecswap(x, b, n - s, s);
        s = b - a;
        if (s > 1) {
            ContainerUtil.quickSort(x, comparator, off, s);
        }
        if ((s = d - c) > 1) {
            ContainerUtil.quickSort(x, comparator, n - s, s);
        }
    }

    private static <T> int med3(@NotNull List<? extends T> x, Comparator<? super T> comparator, int a, int b, int c) {
        if (x == null) {
            ContainerUtil.$$$reportNull$$$0(460);
        }
        return comparator.compare(x.get(a), x.get(b)) < 0 ? (comparator.compare(x.get(b), x.get(c)) < 0 ? b : (comparator.compare(x.get(a), x.get(c)) < 0 ? c : a)) : (comparator.compare(x.get(c), x.get(b)) < 0 ? b : (comparator.compare(x.get(c), x.get(a)) < 0 ? c : a));
    }

    private static <T> void vecswap(List<T> x, int a, int b, int n) {
        int i = 0;
        while (i < n) {
            ContainerUtil.swapElements(x, a, b);
            ++i;
            ++a;
            ++b;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static <E> List<E> flatten(@NotNull Iterable<? extends Collection<? extends E>> collections) {
        if (collections == null) {
            ContainerUtil.$$$reportNull$$$0(468);
        }
        ArrayList result2 = new ArrayList();
        for (Collection<E> collection : collections) {
            result2.addAll(collection);
        }
        List list2 = result2.isEmpty() ? ContainerUtil.emptyList() : result2;
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(469);
        }
        return list2;
    }

    @Contract(pure=true)
    public static <T> boolean containsIdentity(@NotNull Iterable<? extends T> list2, T element) {
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(476);
        }
        for (T t : list2) {
            if (t != element) continue;
            return true;
        }
        return false;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> Stack<T> newStack() {
        Stack stack = ContainerUtilRt.newStack();
        if (stack == null) {
            ContainerUtil.$$$reportNull$$$0(490);
        }
        return stack;
    }

    @NotNull
    @Contract(pure=true)
    public static <T> List<T> emptyList() {
        List list2 = ContainerUtilRt.emptyList();
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(495);
        }
        return list2;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> List<T> createLockFreeCopyOnWriteList() {
        ConcurrentList<T> concurrentList = ContainerUtil.createConcurrentList();
        if (concurrentList == null) {
            ContainerUtil.$$$reportNull$$$0(497);
        }
        return concurrentList;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectMap() {
        ConcurrentIntObjectHashMap concurrentIntObjectHashMap = new ConcurrentIntObjectHashMap();
        if (concurrentIntObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(500);
        }
        return concurrentIntObjectHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentLongObjectMap<V> createConcurrentLongObjectMap() {
        ConcurrentLongObjectHashMap concurrentLongObjectHashMap = new ConcurrentLongObjectHashMap();
        if (concurrentLongObjectHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(503);
        }
        return concurrentLongObjectHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakValueMap() {
        ConcurrentWeakValueHashMap concurrentWeakValueHashMap = new ConcurrentWeakValueHashMap();
        if (concurrentWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(505);
        }
        return concurrentWeakValueHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <V> ConcurrentIntObjectMap<V> createConcurrentIntObjectWeakValueMap() {
        ConcurrentIntKeyWeakValueHashMap concurrentIntKeyWeakValueHashMap = new ConcurrentIntKeyWeakValueHashMap();
        if (concurrentIntKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(506);
        }
        return concurrentIntKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(value="_,_,_,_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap(int initialCapacity, float loadFactor, int concurrencyLevel, @NotNull TObjectHashingStrategy<? super K> hashingStrategy) {
        if (hashingStrategy == null) {
            ContainerUtil.$$$reportNull$$$0(507);
        }
        ConcurrentWeakKeySoftValueHashMap concurrentWeakKeySoftValueHashMap = new ConcurrentWeakKeySoftValueHashMap(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
        if (concurrentWeakKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(508);
        }
        return concurrentWeakKeySoftValueHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeySoftValueMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeySoftValueMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(511);
        }
        return concurrentMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
        if (concurrentMap == null) {
            ContainerUtil.$$$reportNull$$$0(512);
        }
        return concurrentMap;
    }

    @NotNull
    @Contract(value="_ -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap(@NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(513);
        }
        ConcurrentWeakKeyWeakValueHashMap concurrentWeakKeyWeakValueHashMap = new ConcurrentWeakKeyWeakValueHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), strategy);
        if (concurrentWeakKeyWeakValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(514);
        }
        return concurrentWeakKeyWeakValueHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentSoftValueMap() {
        ConcurrentSoftValueHashMap concurrentSoftValueHashMap = new ConcurrentSoftValueHashMap();
        if (concurrentSoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(515);
        }
        return concurrentSoftValueHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        ConcurrentWeakHashMap concurrentWeakHashMap = new ConcurrentWeakHashMap(0.75f);
        if (concurrentWeakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(517);
        }
        return concurrentWeakHashMap;
    }

    @NotNull
    @Contract(value=" -> new", pure=true)
    public static <T> ConcurrentList<T> createConcurrentList() {
        LockFreeCopyOnWriteArrayList lockFreeCopyOnWriteArrayList = new LockFreeCopyOnWriteArrayList();
        if (lockFreeCopyOnWriteArrayList == null) {
            ContainerUtil.$$$reportNull$$$0(524);
        }
        return lockFreeCopyOnWriteArrayList;
    }

    public static <T> void addIfNotNull(@NotNull Collection<? super T> result2, @Nullable T element) {
        if (result2 == null) {
            ContainerUtil.$$$reportNull$$$0(528);
        }
        ContainerUtilRt.addIfNotNull(result2, element);
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> List<V> map2List(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(532);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(533);
        }
        List<? extends V> list2 = ContainerUtilRt.map2List(collection, mapper);
        if (list2 == null) {
            ContainerUtil.$$$reportNull$$$0(534);
        }
        return list2;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull T[] collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(537);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(538);
        }
        Set<? extends V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(539);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2Set(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(540);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(541);
        }
        Set<? extends V> set = ContainerUtilRt.map2Set(collection, mapper);
        if (set == null) {
            ContainerUtil.$$$reportNull$$$0(542);
        }
        return set;
    }

    @NotNull
    @Contract(pure=true)
    public static <T, V> Set<V> map2SetNotNull(@NotNull Collection<? extends T> collection, @NotNull Function<? super T, ? extends V> mapper) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(547);
        }
        if (mapper == null) {
            ContainerUtil.$$$reportNull$$$0(548);
        }
        if (collection.isEmpty()) {
            Set set = Collections.emptySet();
            if (set == null) {
                ContainerUtil.$$$reportNull$$$0(549);
            }
            return set;
        }
        HashSet set = new HashSet(collection.size());
        for (T t : collection) {
            V value = mapper.fun(t);
            if (value == null) continue;
            set.add(value);
        }
        Set set2 = set.isEmpty() ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(550);
        }
        return set2;
    }

    @NotNull
    public static <T> T[] copyAndClear(@NotNull Collection<? extends T> collection, @NotNull ArrayFactory<? extends T> factory2, boolean clear) {
        if (collection == null) {
            ContainerUtil.$$$reportNull$$$0(557);
        }
        if (factory2 == null) {
            ContainerUtil.$$$reportNull$$$0(558);
        }
        int size = collection.size();
        T[] a = factory2.create(size);
        if (size > 0) {
            a = collection.toArray(a);
            if (clear) {
                collection.clear();
            }
        }
        if (a == null) {
            ContainerUtil.$$$reportNull$$$0(559);
        }
        return a;
    }

    @Contract(value="null -> true", pure=true)
    public static <T> boolean isEmpty(@Nullable Collection<? extends T> collection) {
        return ContainerUtilRt.isEmpty(collection);
    }

    @NotNull
    @Contract(pure=true)
    public static <T> Set<T> notNullize(@Nullable Set<T> set) {
        Set set2 = set == null ? Collections.emptySet() : set;
        if (set2 == null) {
            ContainerUtil.$$$reportNull$$$0(566);
        }
        return set2;
    }

    @Contract(pure=true)
    public static <T extends Comparable<T>> int compareLexicographically(@NotNull List<? extends T> o1, @NotNull List<? extends T> o2) {
        if (o1 == null) {
            ContainerUtil.$$$reportNull$$$0(570);
        }
        if (o2 == null) {
            ContainerUtil.$$$reportNull$$$0(571);
        }
        for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
            int result2 = Comparing.compare((Comparable)o1.get(i), (Comparable)o2.get(i));
            if (result2 == 0) continue;
            return result2;
        }
        return o1.size() < o2.size() ? -1 : (o1.size() == o2.size() ? 0 : 1);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftKeySoftValueMap() {
        SoftKeySoftValueHashMap softKeySoftValueHashMap = new SoftKeySoftValueHashMap(true);
        if (softKeySoftValueHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(579);
        }
        return softKeySoftValueHashMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createSoftMap() {
        SoftHashMap softHashMap = new SoftHashMap(4);
        if (softHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(582);
        }
        return softHashMap;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        Map<K, V> map2 = ContainerUtil.createWeakMap(4);
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(585);
        }
        return map2;
    }

    @Contract(value="_ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity) {
        Map map2 = ContainerUtil.createWeakMap(initialCapacity, 0.8f, ContainerUtil.canonicalStrategy());
        if (map2 == null) {
            ContainerUtil.$$$reportNull$$$0(586);
        }
        return map2;
    }

    @Contract(value="_, _, _ -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap(int initialCapacity, float loadFactor, @NotNull TObjectHashingStrategy<? super K> strategy) {
        if (strategy == null) {
            ContainerUtil.$$$reportNull$$$0(587);
        }
        WeakHashMap weakHashMap = new WeakHashMap(initialCapacity, loadFactor, strategy);
        if (weakHashMap == null) {
            ContainerUtil.$$$reportNull$$$0(588);
        }
        return weakHashMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 3: 
            case 12: 
            case 16: 
            case 108: 
            case 168: 
            case 240: 
            case 488: 
            case 535: 
            case 575: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 5: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entries";
                break;
            }
            case 8: 
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 9: 
            case 165: 
            case 169: 
            case 314: 
            case 317: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 22: 
            case 80: 
            case 84: 
            case 87: 
            case 461: 
            case 513: 
            case 583: 
            case 587: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyType";
                break;
            }
            case 35: 
            case 121: 
            case 176: 
            case 210: 
            case 213: 
            case 216: 
            case 270: 
            case 306: 
            case 308: 
            case 393: 
            case 396: 
            case 409: 
            case 439: 
            case 529: 
            case 552: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 37: 
            case 69: 
            case 178: 
            case 182: 
            case 186: 
            case 188: 
            case 302: 
            case 387: 
            case 401: 
            case 435: 
            case 437: 
            case 441: 
            case 443: 
            case 445: 
            case 447: 
            case 560: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable";
                break;
            }
            case 45: 
            case 49: 
            case 53: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 71: 
            case 151: 
            case 156: 
            case 159: 
            case 171: 
            case 184: 
            case 190: 
            case 192: 
            case 287: 
            case 304: 
            case 354: 
            case 357: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 94: 
            case 127: 
            case 148: 
            case 150: 
            case 152: 
            case 154: 
            case 196: 
            case 199: 
            case 202: 
            case 205: 
            case 208: 
            case 220: 
            case 224: 
            case 228: 
            case 231: 
            case 234: 
            case 237: 
            case 243: 
            case 247: 
            case 249: 
            case 252: 
            case 255: 
            case 258: 
            case 262: 
            case 265: 
            case 267: 
            case 277: 
            case 290: 
            case 292: 
            case 295: 
            case 298: 
            case 300: 
            case 390: 
            case 404: 
            case 525: 
            case 532: 
            case 537: 
            case 540: 
            case 543: 
            case 547: 
            case 551: 
            case 557: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 109: 
            case 133: 
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map2";
                break;
            }
            case 111: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 112: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set2";
                break;
            }
            case 124: 
            case 146: 
            case 180: 
            case 194: 
            case 281: 
            case 286: 
            case 311: 
            case 313: 
            case 316: 
            case 340: 
            case 373: 
            case 374: 
            case 377: 
            case 380: 
            case 383: 
            case 456: 
            case 465: 
            case 476: 
            case 477: 
            case 480: 
            case 482: 
            case 484: 
            case 486: 
            case 568: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 128: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grouper";
                break;
            }
            case 132: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map1";
                break;
            }
            case 138: 
            case 142: 
            case 319: 
            case 478: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list1";
                break;
            }
            case 139: 
            case 143: 
            case 320: 
            case 479: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list2";
                break;
            }
            case 140: 
            case 144: 
            case 375: 
            case 378: 
            case 381: 
            case 386: 
            case 457: 
            case 459: 
            case 466: 
            case 574: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 141: 
            case 179: 
            case 181: 
            case 183: 
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendix";
                break;
            }
            case 163: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueConvertor";
                break;
            }
            case 166: 
            case 170: 
            case 172: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyConvertor";
                break;
            }
            case 177: 
            case 187: 
            case 193: 
            case 195: 
            case 229: 
            case 232: 
            case 235: 
            case 238: 
            case 244: 
            case 266: 
            case 275: 
            case 278: 
            case 301: 
            case 436: 
            case 438: 
            case 440: 
            case 442: 
            case 444: 
            case 446: 
            case 448: 
            case 481: 
            case 483: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 189: 
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalTo";
                break;
            }
            case 197: 
            case 200: 
            case 203: 
            case 206: 
            case 211: 
            case 214: 
            case 218: 
            case 222: 
            case 226: 
            case 355: 
            case 530: 
            case 533: 
            case 538: 
            case 541: 
            case 544: 
            case 548: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
            case 217: 
            case 221: 
            case 303: 
            case 305: 
            case 307: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 225: 
            case 473: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 241: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyFilter";
                break;
            }
            case 250: 
            case 253: 
            case 256: 
            case 259: 
            case 263: 
            case 288: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instanceOf";
                break;
            }
            case 268: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyValues";
                break;
            }
            case 272: 
            case 291: 
            case 562: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumeration";
                break;
            }
            case 274: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrays";
                break;
            }
            case 283: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable1";
                break;
            }
            case 284: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterable2";
                break;
            }
            case 309: 
            case 474: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 325: 
            case 333: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterables";
                break;
            }
            case 329: 
            case 331: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterators";
                break;
            }
            case 335: 
            case 338: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lists";
                break;
            }
            case 341: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listGenerator";
                break;
            }
            case 343: 
            case 345: 
            case 348: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection1";
                break;
            }
            case 344: 
            case 346: 
            case 349: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection2";
                break;
            }
            case 351: 
            case 353: 
            case 417: 
            case 452: 
            case 454: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 358: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 360: 
            case 472: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 361: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 363: 
            case 367: 
            case 371: 
            case 431: 
            case 558: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 365: 
            case 369: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c1";
                break;
            }
            case 366: 
            case 370: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c2";
                break;
            }
            case 376: 
            case 385: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 388: 
            case 391: 
            case 394: 
            case 397: 
            case 402: 
            case 405: 
            case 410: 
            case 413: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 398: 
            case 414: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyArray";
                break;
            }
            case 412: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arr";
                break;
            }
            case 419: 
            case 420: 
            case 421: 
            case 422: 
            case 423: 
            case 427: 
            case 430: 
            case 432: 
            case 527: 
            case 528: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 424: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 428: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 433: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defValue";
                break;
            }
            case 449: {
                objectArray2 = objectArray3;
                objectArray3[0] = "next";
                break;
            }
            case 458: 
            case 460: {
                objectArray2 = objectArray3;
                objectArray3[0] = "x";
                break;
            }
            case 463: 
            case 468: 
            case 470: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collections";
                break;
            }
            case 485: 
            case 487: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 491: 
            case 493: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initial";
                break;
            }
            case 498: 
            case 554: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 507: 
            case 509: 
            case 518: 
            case 520: 
            case 522: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 555: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sample";
                break;
            }
            case 569: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 570: 
            case 572: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o1";
                break;
            }
            case 571: 
            case 573: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "ar";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashMap";
                break;
            }
            case 11: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeMap";
                break;
            }
            case 14: 
            case 15: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashMap";
                break;
            }
            case 21: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "newTroveMap";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "newEnumMap";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "canonicalStrategy";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "identityStrategy";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityHashMap";
                break;
            }
            case 29: 
            case 31: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedList";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayList";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "newArrayListWithCapacity";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "newUnmodifiableList";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 50: 
            case 51: 
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyList";
                break;
            }
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptySet";
                break;
            }
            case 58: 
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "unmodifiableOrEmptyMap";
                break;
            }
            case 61: 
            case 62: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "newSmartList";
                break;
            }
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashSet";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "newHashOrEmptySet";
                break;
            }
            case 74: 
            case 76: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "newLinkedHashSet";
                break;
            }
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "newTroveSet";
                break;
            }
            case 92: 
            case 93: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityTroveSet";
                break;
            }
            case 96: {
                objectArray = objectArray2;
                objectArray2[1] = "newIdentityTroveMap";
                break;
            }
            case 97: 
            case 99: 
            case 101: 
            case 102: {
                objectArray = objectArray2;
                objectArray2[1] = "newTreeSet";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentSet";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "newConcurrentMap";
                break;
            }
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "reverse";
                break;
            }
            case 110: 
            case 113: 
            case 116: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSet";
                break;
            }
            case 122: 
            case 125: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableList";
                break;
            }
            case 123: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableSingletonList";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "immutableMapBuilder";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray2;
                objectArray2[1] = "groupBy";
                break;
            }
            case 134: 
            case 347: 
            case 350: {
                objectArray = objectArray2;
                objectArray2[1] = "intersection";
                break;
            }
            case 137: {
                objectArray = objectArray2;
                objectArray2[1] = "diff";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeSortedLists";
                break;
            }
            case 147: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 157: 
            case 158: 
            case 289: {
                objectArray = objectArray2;
                objectArray2[1] = "collect";
                break;
            }
            case 160: 
            case 161: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSet";
                break;
            }
            case 164: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromKeys";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "newMapFromValues";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "classify";
                break;
            }
            case 174: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterator";
                break;
            }
            case 175: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIterable";
                break;
            }
            case 198: 
            case 201: 
            case 209: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Map";
                break;
            }
            case 204: 
            case 207: {
                objectArray = objectArray2;
                objectArray2[1] = "map2MapNotNull";
                break;
            }
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Array";
                break;
            }
            case 230: 
            case 233: 
            case 239: 
            case 242: {
                objectArray = objectArray2;
                objectArray2[1] = "filter";
                break;
            }
            case 236: 
            case 245: 
            case 246: 
            case 251: 
            case 264: {
                objectArray = objectArray2;
                objectArray2[1] = "findAll";
                break;
            }
            case 248: {
                objectArray = objectArray2;
                objectArray2[1] = "skipNulls";
                break;
            }
            case 254: 
            case 257: 
            case 260: 
            case 261: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllAsArray";
                break;
            }
            case 269: {
                objectArray = objectArray2;
                objectArray2[1] = "stringMap";
                break;
            }
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: {
                objectArray = objectArray2;
                objectArray2[1] = "iterate";
                break;
            }
            case 282: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateBackward";
                break;
            }
            case 285: {
                objectArray = objectArray2;
                objectArray2[1] = "zip";
                break;
            }
            case 294: {
                objectArray = objectArray2;
                objectArray2[1] = "addAll";
                break;
            }
            case 297: {
                objectArray = objectArray2;
                objectArray2[1] = "addAllNotNull";
                break;
            }
            case 310: 
            case 312: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: {
                objectArray = objectArray2;
                objectArray2[1] = "concat";
                break;
            }
            case 315: {
                objectArray = objectArray2;
                objectArray2[1] = "append";
                break;
            }
            case 318: {
                objectArray = objectArray2;
                objectArray2[1] = "prepend";
                break;
            }
            case 330: 
            case 332: {
                objectArray = objectArray2;
                objectArray2[1] = "concatIterators";
                break;
            }
            case 352: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstItems";
                break;
            }
            case 356: {
                objectArray = objectArray2;
                objectArray2[1] = "mapIterator";
                break;
            }
            case 359: {
                objectArray = objectArray2;
                objectArray2[1] = "filterIterator";
                break;
            }
            case 362: {
                objectArray = objectArray2;
                objectArray2[1] = "subtract";
                break;
            }
            case 364: 
            case 368: 
            case 553: 
            case 556: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 372: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeCollectionsToArray";
                break;
            }
            case 379: 
            case 382: 
            case 384: {
                objectArray = objectArray2;
                objectArray2[1] = "sorted";
                break;
            }
            case 389: 
            case 392: 
            case 411: 
            case 415: 
            case 416: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: {
                objectArray = objectArray2;
                objectArray2[1] = "mapNotNull";
                break;
            }
            case 408: {
                objectArray = objectArray2;
                objectArray2[1] = "packNullables";
                break;
            }
            case 418: {
                objectArray = objectArray2;
                objectArray2[1] = "set";
                break;
            }
            case 425: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonList";
                break;
            }
            case 426: {
                objectArray = objectArray2;
                objectArray2[1] = "createMaybeSingletonSet";
                break;
            }
            case 429: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreate";
                break;
            }
            case 434: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrElse";
                break;
            }
            case 450: 
            case 451: {
                objectArray = objectArray2;
                objectArray2[1] = "unfold";
                break;
            }
            case 453: {
                objectArray = objectArray2;
                objectArray2[1] = "dropTail";
                break;
            }
            case 455: {
                objectArray = objectArray2;
                objectArray2[1] = "list";
                break;
            }
            case 462: {
                objectArray = objectArray2;
                objectArray2[1] = "singleton";
                break;
            }
            case 464: 
            case 469: {
                objectArray = objectArray2;
                objectArray2[1] = "flatten";
                break;
            }
            case 467: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicatesFromSorted";
                break;
            }
            case 471: {
                objectArray = objectArray2;
                objectArray2[1] = "flattenIterables";
                break;
            }
            case 475: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
            case 489: {
                objectArray = objectArray2;
                objectArray2[1] = "reverseMap";
                break;
            }
            case 490: 
            case 492: 
            case 494: {
                objectArray = objectArray2;
                objectArray2[1] = "newStack";
                break;
            }
            case 495: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyList";
                break;
            }
            case 496: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyCOWList";
                break;
            }
            case 497: 
            case 499: {
                objectArray = objectArray2;
                objectArray2[1] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 500: 
            case 501: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectMap";
                break;
            }
            case 502: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectSoftValueMap";
                break;
            }
            case 503: 
            case 504: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentLongObjectMap";
                break;
            }
            case 505: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakValueMap";
                break;
            }
            case 506: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentIntObjectWeakValueMap";
                break;
            }
            case 508: 
            case 511: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 510: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 512: 
            case 514: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 515: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftValueMap";
                break;
            }
            case 516: 
            case 519: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentSoftMap";
                break;
            }
            case 517: 
            case 521: 
            case 523: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakMap";
                break;
            }
            case 524: 
            case 526: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentList";
                break;
            }
            case 531: 
            case 534: 
            case 536: {
                objectArray = objectArray2;
                objectArray2[1] = "map2List";
                break;
            }
            case 539: 
            case 542: {
                objectArray = objectArray2;
                objectArray2[1] = "map2Set";
                break;
            }
            case 545: 
            case 546: {
                objectArray = objectArray2;
                objectArray2[1] = "map2LinkedSet";
                break;
            }
            case 549: 
            case 550: {
                objectArray = objectArray2;
                objectArray2[1] = "map2SetNotNull";
                break;
            }
            case 559: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAndClear";
                break;
            }
            case 561: {
                objectArray = objectArray2;
                objectArray2[1] = "toCollection";
                break;
            }
            case 563: 
            case 564: {
                objectArray = objectArray2;
                objectArray2[1] = "toList";
                break;
            }
            case 565: 
            case 566: 
            case 567: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
            case 576: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 577: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeySoftValueMap";
                break;
            }
            case 578: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyWeakValueMap";
                break;
            }
            case 579: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftKeySoftValueMap";
                break;
            }
            case 580: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftValueMap";
                break;
            }
            case 581: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakValueMap";
                break;
            }
            case 582: 
            case 584: {
                objectArray = objectArray2;
                objectArray2[1] = "createSoftMap";
                break;
            }
            case 585: 
            case 586: 
            case 588: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
            case 589: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakSet";
                break;
            }
            case 590: {
                objectArray = objectArray2;
                objectArray2[1] = "createIntKeyWeakValueMap";
                break;
            }
            case 591: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakKeyIntValueMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "ar";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "newHashMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newTreeMap";
                break;
            }
            case 16: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashMap";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "newTroveMap";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "newEnumMap";
                break;
            }
            case 30: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedList";
                break;
            }
            case 35: 
            case 37: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "newArrayList";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyCollection";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyList";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptySet";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "unmodifiableOrEmptyMap";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "newSmartList";
                break;
            }
            case 67: 
            case 69: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "newHashSet";
                break;
            }
            case 75: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "newLinkedHashSet";
                break;
            }
            case 80: 
            case 82: 
            case 84: 
            case 85: 
            case 87: 
            case 88: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "newTroveSet";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "newIdentityTroveSet";
                break;
            }
            case 98: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "newTreeSet";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "reverse";
                break;
            }
            case 108: 
            case 109: 
            case 111: 
            case 112: 
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "immutableSet";
                break;
            }
            case 121: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "immutableList";
                break;
            }
            case 127: 
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "groupBy";
                break;
            }
            case 131: 
            case 432: 
            case 433: {
                objectArray = objectArray;
                objectArray[2] = "getOrElse";
                break;
            }
            case 132: 
            case 133: 
            case 345: 
            case 346: 
            case 348: 
            case 349: {
                objectArray = objectArray;
                objectArray[2] = "intersection";
                break;
            }
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "diff";
                break;
            }
            case 138: 
            case 139: 
            case 140: 
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "processSortedListsInOrder";
                break;
            }
            case 142: 
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "mergeSortedLists";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "subList";
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 290: 
            case 291: 
            case 292: 
            case 293: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 295: 
            case 296: {
                objectArray = objectArray;
                objectArray[2] = "addAllNotNull";
                break;
            }
            case 156: 
            case 287: 
            case 288: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 159: {
                objectArray = objectArray;
                objectArray[2] = "collectSet";
                break;
            }
            case 162: 
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromKeys";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "newMapFromValues";
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                objectArray = objectArray;
                objectArray[2] = "fillMapWithValues";
                break;
            }
            case 171: 
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "classify";
                break;
            }
            case 176: 
            case 177: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "findLast";
                break;
            }
            case 196: 
            case 197: 
            case 199: 
            case 200: 
            case 208: {
                objectArray = objectArray;
                objectArray[2] = "map2Map";
                break;
            }
            case 202: 
            case 203: 
            case 205: 
            case 206: {
                objectArray = objectArray;
                objectArray[2] = "map2MapNotNull";
                break;
            }
            case 210: 
            case 211: 
            case 213: 
            case 214: 
            case 216: 
            case 217: 
            case 218: 
            case 220: 
            case 221: 
            case 222: 
            case 224: 
            case 225: 
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "map2Array";
                break;
            }
            case 228: 
            case 229: 
            case 231: 
            case 232: 
            case 237: 
            case 238: 
            case 240: 
            case 241: {
                objectArray = objectArray;
                objectArray[2] = "filter";
                break;
            }
            case 234: 
            case 235: 
            case 243: 
            case 244: 
            case 249: 
            case 250: 
            case 262: 
            case 263: {
                objectArray = objectArray;
                objectArray[2] = "findAll";
                break;
            }
            case 247: {
                objectArray = objectArray;
                objectArray[2] = "skipNulls";
                break;
            }
            case 252: 
            case 253: 
            case 255: 
            case 256: 
            case 258: 
            case 259: {
                objectArray = objectArray;
                objectArray[2] = "findAllAsArray";
                break;
            }
            case 265: 
            case 266: {
                objectArray = objectArray;
                objectArray[2] = "all";
                break;
            }
            case 267: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicates";
                break;
            }
            case 268: {
                objectArray = objectArray;
                objectArray[2] = "stringMap";
                break;
            }
            case 270: 
            case 272: 
            case 274: 
            case 275: 
            case 277: 
            case 278: {
                objectArray = objectArray;
                objectArray[2] = "iterate";
                break;
            }
            case 281: {
                objectArray = objectArray;
                objectArray[2] = "iterateBackward";
                break;
            }
            case 283: 
            case 284: {
                objectArray = objectArray;
                objectArray[2] = "zip";
                break;
            }
            case 286: {
                objectArray = objectArray;
                objectArray[2] = "swapElements";
                break;
            }
            case 298: 
            case 299: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 300: 
            case 301: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: {
                objectArray = objectArray;
                objectArray[2] = "findInstance";
                break;
            }
            case 308: 
            case 309: 
            case 311: 
            case 319: 
            case 320: 
            case 325: 
            case 333: 
            case 335: 
            case 338: 
            case 340: 
            case 341: {
                objectArray = objectArray;
                objectArray[2] = "concat";
                break;
            }
            case 313: 
            case 314: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 316: 
            case 317: {
                objectArray = objectArray;
                objectArray[2] = "prepend";
                break;
            }
            case 329: 
            case 331: {
                objectArray = objectArray;
                objectArray[2] = "concatIterators";
                break;
            }
            case 343: 
            case 344: {
                objectArray = objectArray;
                objectArray[2] = "intersects";
                break;
            }
            case 351: {
                objectArray = objectArray;
                objectArray[2] = "getFirstItems";
                break;
            }
            case 353: {
                objectArray = objectArray;
                objectArray[2] = "iterateAndGetLastItem";
                break;
            }
            case 354: 
            case 355: {
                objectArray = objectArray;
                objectArray[2] = "mapIterator";
                break;
            }
            case 357: 
            case 358: {
                objectArray = objectArray;
                objectArray[2] = "filterIterator";
                break;
            }
            case 360: 
            case 361: {
                objectArray = objectArray;
                objectArray[2] = "subtract";
                break;
            }
            case 363: 
            case 365: 
            case 366: 
            case 367: 
            case 551: 
            case 552: 
            case 554: 
            case 555: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 369: 
            case 370: 
            case 371: {
                objectArray = objectArray;
                objectArray[2] = "mergeCollectionsToArray";
                break;
            }
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 385: 
            case 386: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 377: 
            case 378: 
            case 380: 
            case 381: 
            case 383: {
                objectArray = objectArray;
                objectArray[2] = "sorted";
                break;
            }
            case 387: 
            case 388: 
            case 390: 
            case 391: 
            case 409: 
            case 410: 
            case 412: 
            case 413: 
            case 414: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 393: 
            case 394: 
            case 396: 
            case 397: 
            case 398: 
            case 401: 
            case 402: 
            case 404: 
            case 405: {
                objectArray = objectArray;
                objectArray[2] = "mapNotNull";
                break;
            }
            case 407: {
                objectArray = objectArray;
                objectArray[2] = "packNullables";
                break;
            }
            case 417: {
                objectArray = objectArray;
                objectArray[2] = "set";
                break;
            }
            case 419: {
                objectArray = objectArray;
                objectArray[2] = "putIfAbsent";
                break;
            }
            case 420: 
            case 421: 
            case 422: {
                objectArray = objectArray;
                objectArray[2] = "putIfNotNull";
                break;
            }
            case 423: 
            case 424: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 427: 
            case 428: 
            case 430: 
            case 431: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 435: 
            case 436: 
            case 437: 
            case 438: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 439: 
            case 440: 
            case 441: 
            case 442: {
                objectArray = objectArray;
                objectArray[2] = "exists";
                break;
            }
            case 443: 
            case 444: 
            case 445: 
            case 446: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
            case 447: 
            case 448: {
                objectArray = objectArray;
                objectArray[2] = "count";
                break;
            }
            case 449: {
                objectArray = objectArray;
                objectArray[2] = "unfold";
                break;
            }
            case 452: {
                objectArray = objectArray;
                objectArray[2] = "dropTail";
                break;
            }
            case 454: {
                objectArray = objectArray;
                objectArray[2] = "list";
                break;
            }
            case 456: 
            case 457: 
            case 458: 
            case 459: {
                objectArray = objectArray;
                objectArray[2] = "quickSort";
                break;
            }
            case 460: {
                objectArray = objectArray;
                objectArray[2] = "med3";
                break;
            }
            case 461: {
                objectArray = objectArray;
                objectArray[2] = "singleton";
                break;
            }
            case 463: 
            case 468: {
                objectArray = objectArray;
                objectArray[2] = "flatten";
                break;
            }
            case 465: 
            case 466: {
                objectArray = objectArray;
                objectArray[2] = "removeDuplicatesFromSorted";
                break;
            }
            case 470: {
                objectArray = objectArray;
                objectArray[2] = "flattenIterables";
                break;
            }
            case 472: 
            case 473: 
            case 474: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 476: {
                objectArray = objectArray;
                objectArray[2] = "containsIdentity";
                break;
            }
            case 477: {
                objectArray = objectArray;
                objectArray[2] = "indexOfIdentity";
                break;
            }
            case 478: 
            case 479: {
                objectArray = objectArray;
                objectArray[2] = "equalsIdentity";
                break;
            }
            case 480: 
            case 481: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 482: 
            case 483: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 484: 
            case 485: {
                objectArray = objectArray;
                objectArray[2] = "findLastInstance";
                break;
            }
            case 486: 
            case 487: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOfInstance";
                break;
            }
            case 488: {
                objectArray = objectArray;
                objectArray[2] = "reverseMap";
                break;
            }
            case 491: 
            case 493: {
                objectArray = objectArray;
                objectArray[2] = "newStack";
                break;
            }
            case 498: {
                objectArray = objectArray;
                objectArray[2] = "createLockFreeCopyOnWriteList";
                break;
            }
            case 507: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeySoftValueMap";
                break;
            }
            case 509: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftKeySoftValueMap";
                break;
            }
            case 513: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 518: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentSoftMap";
                break;
            }
            case 520: 
            case 522: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentWeakMap";
                break;
            }
            case 525: {
                objectArray = objectArray;
                objectArray[2] = "createConcurrentList";
                break;
            }
            case 527: 
            case 528: {
                objectArray = objectArray;
                objectArray[2] = "addIfNotNull";
                break;
            }
            case 529: 
            case 530: 
            case 532: 
            case 533: 
            case 535: {
                objectArray = objectArray;
                objectArray[2] = "map2List";
                break;
            }
            case 537: 
            case 538: 
            case 540: 
            case 541: {
                objectArray = objectArray;
                objectArray[2] = "map2Set";
                break;
            }
            case 543: 
            case 544: {
                objectArray = objectArray;
                objectArray[2] = "map2LinkedSet";
                break;
            }
            case 547: 
            case 548: {
                objectArray = objectArray;
                objectArray[2] = "map2SetNotNull";
                break;
            }
            case 557: 
            case 558: {
                objectArray = objectArray;
                objectArray[2] = "copyAndClear";
                break;
            }
            case 560: {
                objectArray = objectArray;
                objectArray[2] = "toCollection";
                break;
            }
            case 562: {
                objectArray = objectArray;
                objectArray[2] = "toList";
                break;
            }
            case 568: 
            case 569: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 570: 
            case 571: 
            case 572: 
            case 573: 
            case 574: {
                objectArray = objectArray;
                objectArray[2] = "compareLexicographically";
                break;
            }
            case 575: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 583: {
                objectArray = objectArray;
                objectArray[2] = "createSoftMap";
                break;
            }
            case 587: {
                objectArray = objectArray;
                objectArray[2] = "createWeakMap";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 46: 
            case 47: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 70: 
            case 72: 
            case 73: 
            case 74: 
            case 76: 
            case 78: 
            case 79: 
            case 81: 
            case 83: 
            case 86: 
            case 89: 
            case 91: 
            case 92: 
            case 93: 
            case 95: 
            case 96: 
            case 97: 
            case 99: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 106: 
            case 107: 
            case 110: 
            case 113: 
            case 116: 
            case 118: 
            case 119: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 129: 
            case 130: 
            case 134: 
            case 137: 
            case 145: 
            case 147: 
            case 157: 
            case 158: 
            case 160: 
            case 161: 
            case 164: 
            case 167: 
            case 173: 
            case 174: 
            case 175: 
            case 198: 
            case 201: 
            case 204: 
            case 207: 
            case 209: 
            case 212: 
            case 215: 
            case 219: 
            case 223: 
            case 227: 
            case 230: 
            case 233: 
            case 236: 
            case 239: 
            case 242: 
            case 245: 
            case 246: 
            case 248: 
            case 251: 
            case 254: 
            case 257: 
            case 260: 
            case 261: 
            case 264: 
            case 269: 
            case 271: 
            case 273: 
            case 276: 
            case 279: 
            case 280: 
            case 282: 
            case 285: 
            case 289: 
            case 294: 
            case 297: 
            case 310: 
            case 312: 
            case 315: 
            case 318: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 326: 
            case 327: 
            case 328: 
            case 330: 
            case 332: 
            case 334: 
            case 336: 
            case 337: 
            case 339: 
            case 342: 
            case 347: 
            case 350: 
            case 352: 
            case 356: 
            case 359: 
            case 362: 
            case 364: 
            case 368: 
            case 372: 
            case 379: 
            case 382: 
            case 384: 
            case 389: 
            case 392: 
            case 395: 
            case 399: 
            case 400: 
            case 403: 
            case 406: 
            case 408: 
            case 411: 
            case 415: 
            case 416: 
            case 418: 
            case 425: 
            case 426: 
            case 429: 
            case 434: 
            case 450: 
            case 451: 
            case 453: 
            case 455: 
            case 462: 
            case 464: 
            case 467: 
            case 469: 
            case 471: 
            case 475: 
            case 489: 
            case 490: 
            case 492: 
            case 494: 
            case 495: 
            case 496: 
            case 497: 
            case 499: 
            case 500: 
            case 501: 
            case 502: 
            case 503: 
            case 504: 
            case 505: 
            case 506: 
            case 508: 
            case 510: 
            case 511: 
            case 512: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 519: 
            case 521: 
            case 523: 
            case 524: 
            case 526: 
            case 531: 
            case 534: 
            case 536: 
            case 539: 
            case 542: 
            case 545: 
            case 546: 
            case 549: 
            case 550: 
            case 553: 
            case 556: 
            case 559: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: 
            case 567: 
            case 576: 
            case 577: 
            case 578: 
            case 579: 
            case 580: 
            case 581: 
            case 582: 
            case 584: 
            case 585: 
            case 586: 
            case 588: 
            case 589: 
            case 590: 
            case 591: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImmutableListBackedByArray<E>
    extends ImmutableList<E> {
        private final E[] myStore;

        private ImmutableListBackedByArray(@NotNull E[] array) {
            if (array == null) {
                ImmutableListBackedByArray.$$$reportNull$$$0(0);
            }
            this.myStore = array;
        }

        @Override
        public E get(int index2) {
            return this.myStore[index2];
        }

        @Override
        public int size() {
            return this.myStore.length;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "array", "org/jetbrains/kotlin/com/intellij/util/containers/ContainerUtil$ImmutableListBackedByArray", "<init>"));
        }
    }
}

