/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang;

import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.Language;
import org.jetbrains.kotlin.com.intellij.lang.LanguageUtil;
import org.jetbrains.kotlin.com.intellij.lang.MetaLanguage;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.openapi.util.KeyedExtensionCollector;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class LanguageExtension<T>
extends KeyedExtensionCollector<T, Language> {
    private final T myDefaultImplementation;
    private final Key<T> IN_LANGUAGE_CACHE;

    public LanguageExtension(@NonNls String epName) {
        this(epName, null);
    }

    public LanguageExtension(@NonNls String epName, @Nullable T defaultImplementation) {
        super(epName);
        this.myDefaultImplementation = defaultImplementation;
        this.IN_LANGUAGE_CACHE = Key.create("EXTENSIONS_IN_LANGUAGE_" + epName);
    }

    @Override
    @NotNull
    protected String keyToString(@NotNull Language key) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(0);
        }
        String string = key.getID();
        if (string == null) {
            LanguageExtension.$$$reportNull$$$0(1);
        }
        return string;
    }

    public T forLanguage(@NotNull Language l) {
        T cached;
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(2);
        }
        if ((cached = l.getUserData(this.IN_LANGUAGE_CACHE)) != null) {
            return cached;
        }
        T result2 = this.findForLanguage(l);
        if (result2 == null) {
            return null;
        }
        result2 = l.putUserDataIfAbsent(this.IN_LANGUAGE_CACHE, result2);
        return result2;
    }

    protected T findForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(3);
        }
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List extensions = this.forKey(l);
            if (extensions.isEmpty()) continue;
            return extensions.get(0);
        }
        return this.myDefaultImplementation;
    }

    @NotNull
    public List<T> allForLanguage(@NotNull Language language) {
        if (language == null) {
            LanguageExtension.$$$reportNull$$$0(4);
        }
        boolean copyList = true;
        List result2 = null;
        for (Language l = language; l != null; l = l.getBaseLanguage()) {
            List list2 = this.forKey(l);
            if (result2 == null) {
                result2 = list2;
                continue;
            }
            if (list2.isEmpty()) continue;
            if (copyList) {
                result2 = ContainerUtil.newArrayList(ContainerUtil.concat(result2, list2));
                copyList = false;
                continue;
            }
            result2.addAll(list2);
        }
        List list3 = result2;
        if (list3 == null) {
            LanguageExtension.$$$reportNull$$$0(5);
        }
        return list3;
    }

    @Override
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        Collection<MetaLanguage> metaLanguages;
        if (stringKey == null) {
            LanguageExtension.$$$reportNull$$$0(6);
        }
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(7);
        }
        if ((metaLanguages = LanguageUtil.matchingMetaLanguages(key)).isEmpty()) {
            List list2 = super.buildExtensions(stringKey, key);
            if (list2 == null) {
                LanguageExtension.$$$reportNull$$$0(8);
            }
            return list2;
        }
        THashSet<String> allKeys = new THashSet<String>();
        allKeys.add(stringKey);
        for (MetaLanguage language : metaLanguages) {
            allKeys.add(this.keyToString(language));
        }
        List list3 = this.buildExtensions(allKeys);
        if (list3 == null) {
            LanguageExtension.$$$reportNull$$$0(9);
        }
        return list3;
    }

    @NotNull
    public List<T> allForLanguageOrAny(@NotNull Language l) {
        if (l == null) {
            LanguageExtension.$$$reportNull$$$0(10);
        }
        List<T> forLanguage = this.allForLanguage(l);
        if (l == Language.ANY) {
            List<T> list2 = forLanguage;
            if (list2 == null) {
                LanguageExtension.$$$reportNull$$$0(11);
            }
            return list2;
        }
        List<T> list3 = ContainerUtil.concat(forLanguage, this.allForLanguage(Language.ANY));
        if (list3 == null) {
            LanguageExtension.$$$reportNull$$$0(12);
        }
        return list3;
    }

    @Override
    public void addExplicitExtension(@NotNull Language key, @NotNull T t) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(13);
        }
        if (t == null) {
            LanguageExtension.$$$reportNull$$$0(14);
        }
        key.putUserData(this.IN_LANGUAGE_CACHE, null);
        super.addExplicitExtension(key, t);
    }

    @Override
    public void removeExplicitExtension(@NotNull Language key, @NotNull T t) {
        if (key == null) {
            LanguageExtension.$$$reportNull$$$0(15);
        }
        if (t == null) {
            LanguageExtension.$$$reportNull$$$0(16);
        }
        key.putUserData(this.IN_LANGUAGE_CACHE, null);
        super.removeExplicitExtension(key, t);
    }

    protected T getDefaultImplementation() {
        return this.myDefaultImplementation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/lang/LanguageExtension";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringKey";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/lang/LanguageExtension";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "keyToString";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "buildExtensions";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "allForLanguageOrAny";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "keyToString";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forLanguage";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findForLanguage";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildExtensions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "allForLanguageOrAny";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addExplicitExtension";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeExplicitExtension";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

