/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.codeInsight;

import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExternalAnnotationsManager;
import org.jetbrains.kotlin.com.intellij.codeInsight.InferredAnnotationsManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Comparing;
import org.jetbrains.kotlin.com.intellij.psi.HierarchicalMethodSignature;
import org.jetbrains.kotlin.com.intellij.psi.JavaPsiFacade;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotation;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiArrayInitializerMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiClass;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLocalVariable;
import org.jetbrains.kotlin.com.intellij.psi.PsiMember;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierList;
import org.jetbrains.kotlin.com.intellij.psi.PsiModifierListOwner;
import org.jetbrains.kotlin.com.intellij.psi.PsiNameValuePair;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameterList;
import org.jetbrains.kotlin.com.intellij.psi.PsiResolveHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.InheritanceUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtilCore;
import org.jetbrains.kotlin.com.intellij.util.BitUtil;
import org.jetbrains.kotlin.com.intellij.util.Consumer;
import org.jetbrains.kotlin.com.intellij.util.Processors;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentFactoryMap;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class AnnotationUtil {
    private static final String[] SIMPLE_NAMES = new String[]{"NotNull", "Nullable", "NonNls", "PropertyKey", "TestOnly", "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(0);
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(1);
        }
        if (annotationNames.length == 0) {
            return null;
        }
        HashSet<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : ContainerUtil.newHashSet(annotationNames);
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(2);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(3);
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames, boolean skipExternal) {
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(4);
        }
        if (listOwner == null) {
            return null;
        }
        PsiAnnotation annotation2 = AnnotationUtil.findOwnAnnotation(listOwner, annotationNames);
        if (annotation2 != null) {
            return annotation2;
        }
        return skipExternal ? null : AnnotationUtil.findNonCodeAnnotation(listOwner, annotationNames);
    }

    private static PsiAnnotation findOwnAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        PsiModifierList list2;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(5);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(6);
        }
        if ((list2 = listOwner.getModifierList()) == null) {
            return null;
        }
        for (PsiAnnotation annotation2 : list2.getAnnotations()) {
            if (!annotationNames.contains(annotation2.getQualifiedName())) continue;
            return annotation2;
        }
        return null;
    }

    private static PsiAnnotation findNonCodeAnnotation(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotationNames) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(7);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(8);
        }
        if (listOwner instanceof PsiLocalVariable) {
            return null;
        }
        Map map2 = (Map)CachedValuesManager.getCachedValue(listOwner, () -> {
            if (listOwner == null) {
                AnnotationUtil.$$$reportNull$$$0(71);
            }
            ConcurrentMap<Collection, PsiAnnotation> value = ConcurrentFactoryMap.createMap(annotationNames1 -> {
                if (listOwner == null) {
                    AnnotationUtil.$$$reportNull$$$0(72);
                }
                PsiUtilCore.ensureValid(listOwner);
                Project project = listOwner.getProject();
                ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation2 = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                    if (annotation2 == null) continue;
                    return annotation2;
                }
                InferredAnnotationsManager inferredAnnotationsManager = InferredAnnotationsManager.getInstance(project);
                for (String annotationName : annotationNames1) {
                    PsiAnnotation annotation3 = inferredAnnotationsManager.findInferredAnnotation(listOwner, annotationName);
                    if (annotation3 == null) continue;
                    return annotation3;
                }
                return null;
            });
            return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
        });
        return (PsiAnnotation)map2.get(annotationNames);
    }

    @NotNull
    public static <T extends PsiModifierListOwner> List<T> getSuperAnnotationOwners(@NotNull T element) {
        if (element == null) {
            AnnotationUtil.$$$reportNull$$$0(13);
        }
        List list2 = (List)CachedValuesManager.getCachedValue(element, () -> {
            List<Object> list2;
            if (element == null) {
                AnnotationUtil.$$$reportNull$$$0(70);
            }
            LinkedHashSet<PsiModifierListOwner> result2 = ContainerUtil.newLinkedHashSet();
            if (element instanceof PsiMethod) {
                AnnotationUtil.collectSuperMethods(result2, ((PsiMethod)element).getHierarchicalMethodSignature(), element, JavaPsiFacade.getInstance(element.getProject()).getResolveHelper());
            } else if (element instanceof PsiClass) {
                InheritanceUtil.processSupers((PsiClass)element, false, Processors.cancelableCollectProcessor(result2));
            } else if (element instanceof PsiParameter) {
                AnnotationUtil.collectSuperParameters(result2, (PsiParameter)element);
            }
            if (result2.isEmpty()) {
                list2 = Collections.emptyList();
            } else {
                PsiModifierListOwner[] array = result2.toArray(new PsiModifierListOwner[0]);
                list2 = Arrays.asList(array);
            }
            return CachedValueProvider.Result.create(list2, PsiModificationTracker.MODIFICATION_COUNT);
        });
        if (list2 == null) {
            AnnotationUtil.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        PsiAnnotation directAnnotation;
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(15);
        }
        if (annotationNames == null) {
            AnnotationUtil.$$$reportNull$$$0(16);
        }
        if ((directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames)) != null) {
            return directAnnotation;
        }
        for (PsiModifierListOwner superOwner : AnnotationUtil.getSuperAnnotationOwners(listOwner)) {
            PsiAnnotation annotation2 = AnnotationUtil.findAnnotation(superOwner, annotationNames);
            if (annotation2 == null) continue;
            return annotation2;
        }
        return null;
    }

    private static void collectSuperParameters(@NotNull Set<? super PsiModifierListOwner> result2, @NotNull PsiParameter parameter) {
        block7: {
            PsiElement scope;
            Consumer<PsiMethod> forEachSuperMethod;
            block6: {
                PsiElement parent2;
                if (result2 == null) {
                    AnnotationUtil.$$$reportNull$$$0(17);
                }
                if (parameter == null) {
                    AnnotationUtil.$$$reportNull$$$0(18);
                }
                if (!((parent2 = parameter.getParent()) instanceof PsiParameterList)) {
                    return;
                }
                int index2 = ((PsiParameterList)parent2).getParameterIndex(parameter);
                forEachSuperMethod = method -> {
                    PsiParameter[] superParameters;
                    if (result2 == null) {
                        AnnotationUtil.$$$reportNull$$$0(69);
                    }
                    if (index2 < (superParameters = method.getParameterList().getParameters()).length) {
                        result2.add(superParameters[index2]);
                    }
                };
                scope = parent2.getParent();
                if (!(scope instanceof PsiLambdaExpression)) break block6;
                PsiMethod method2 = LambdaUtil.getFunctionalInterfaceMethod(((PsiLambdaExpression)scope).getFunctionalInterfaceType());
                if (method2 == null) break block7;
                forEachSuperMethod.consume(method2);
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners(method2)) {
                    forEachSuperMethod.consume(superMethod);
                }
                break block7;
            }
            if (scope instanceof PsiMethod) {
                for (PsiMethod superMethod : AnnotationUtil.getSuperAnnotationOwners((PsiMethod)scope)) {
                    forEachSuperMethod.consume(superMethod);
                }
            }
        }
    }

    private static void collectSuperMethods(@NotNull Set<? super PsiModifierListOwner> result2, @NotNull HierarchicalMethodSignature signature2, @NotNull PsiElement place, @NotNull PsiResolveHelper resolveHelper) {
        if (result2 == null) {
            AnnotationUtil.$$$reportNull$$$0(19);
        }
        if (signature2 == null) {
            AnnotationUtil.$$$reportNull$$$0(20);
        }
        if (place == null) {
            AnnotationUtil.$$$reportNull$$$0(21);
        }
        if (resolveHelper == null) {
            AnnotationUtil.$$$reportNull$$$0(22);
        }
        for (HierarchicalMethodSignature superSignature : signature2.getSuperSignatures()) {
            PsiMethod superMethod = superSignature.getMethod();
            if (!resolveHelper.isAccessible(superMethod, place, null) || !result2.add(superMethod)) continue;
            AnnotationUtil.collectSuperMethods(result2, superSignature, place, resolveHelper);
        }
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull Collection<String> annotations2, int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(23);
        }
        if (annotations2 == null) {
            AnnotationUtil.$$$reportNull$$$0(24);
        }
        return annotations2.stream().anyMatch(annotation2 -> {
            if (listOwner == null) {
                AnnotationUtil.$$$reportNull$$$0(68);
            }
            return AnnotationUtil.isAnnotated(listOwner, annotation2, flags, null);
        });
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFqn, int flags) {
        if (listOwner == null) {
            AnnotationUtil.$$$reportNull$$$0(25);
        }
        if (annotationFqn == null) {
            AnnotationUtil.$$$reportNull$$$0(26);
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFqn, flags, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NotNull String annotationFQN, int flags, @Nullable Set<? super PsiMember> processed) {
        block18: {
            block19: {
                Project project;
                if (listOwner == null) {
                    AnnotationUtil.$$$reportNull$$$0(27);
                }
                if (annotationFQN == null) {
                    AnnotationUtil.$$$reportNull$$$0(28);
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation2 = modifierList.findAnnotation(annotationFQN);
                if (annotation2 != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 8)) {
                    PsiType type2 = null;
                    if (listOwner instanceof PsiMethod) {
                        type2 = ((PsiMethod)listOwner).getReturnType();
                    } else if (listOwner instanceof PsiVariable) {
                        type2 = ((PsiVariable)listOwner).getType();
                    }
                    if (type2 != null && type2.hasAnnotation(annotationFQN)) {
                        return true;
                    }
                }
                if (BitUtil.isSet(flags, 2) && ExternalAnnotationsManager.getInstance(project = listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (BitUtil.isSet(flags, 4) && InferredAnnotationsManager.getInstance(project = listOwner.getProject()).findInferredAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!BitUtil.isSet(flags, 1)) break block18;
                if (!(listOwner instanceof PsiMethod)) break block19;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet<PsiMember>();
                }
                if (!processed.add(method)) {
                    return false;
                }
                for (PsiMethod superMethod : method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, flags, processed)) continue;
                    return true;
                }
                break block18;
            }
            if (!(listOwner instanceof PsiClass)) break block18;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet<PsiMember>();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, flags, processed)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiNameValuePair findDeclaredAttribute(@NotNull PsiAnnotation annotation2, @Nullable(value="null means 'value'") String attributeName) {
        if (annotation2 == null) {
            AnnotationUtil.$$$reportNull$$$0(48);
        }
        if ("value".equals(attributeName)) {
            attributeName = null;
        }
        for (PsiNameValuePair attribute : annotation2.getParameterList().getAttributes()) {
            String name = attribute.getName();
            if (!Comparing.equal(name, attributeName) && (attributeName != null || !"value".equals(name))) continue;
            return attribute;
        }
        return null;
    }

    @NotNull
    public static List<PsiAnnotationMemberValue> arrayAttributeValues(@Nullable PsiAnnotationMemberValue attributeValue) {
        if (attributeValue instanceof PsiArrayInitializerMemberValue) {
            List<PsiAnnotationMemberValue> list2 = Arrays.asList(((PsiArrayInitializerMemberValue)attributeValue).getInitializers());
            if (list2 == null) {
                AnnotationUtil.$$$reportNull$$$0(66);
            }
            return list2;
        }
        List<PsiAnnotationMemberValue> list3 = ContainerUtil.createMaybeSingletonList(attributeValue);
        if (list3 == null) {
            AnnotationUtil.$$$reportNull$$$0(67);
        }
        return list3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationNames";
                break;
            }
            case 5: 
            case 7: 
            case 15: 
            case 23: 
            case 25: 
            case 27: 
            case 46: 
            case 56: 
            case 58: 
            case 60: 
            case 62: 
            case 64: 
            case 68: 
            case 71: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listOwner";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 13: 
            case 38: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 19: 
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveHelper";
                break;
            }
            case 24: 
            case 32: 
            case 53: 
            case 57: 
            case 59: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFqn";
                break;
            }
            case 28: 
            case 31: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationFQN";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elt";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pair";
                break;
            }
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 39: 
            case 40: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrValue";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationClass";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterList";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueMap";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations1";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations2";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "simpleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/codeInsight/AnnotationUtil";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findAnnotations";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperAnnotationOwners";
                break;
            }
            case 35: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllAnnotations";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAnnotationMap";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "arrayAttributeValues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotation";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findOwnAnnotation";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findNonCodeAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotations";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuperAnnotationOwners";
                break;
            }
            case 15: 
            case 16: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "findAnnotationInHierarchy";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperParameters";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "collectSuperMethods";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatingApplicable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkAnnotatedUsingPatterns";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationMethod";
                break;
            }
            case 34: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getAllAnnotations";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isInsideAnnotation";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isInferredAnnotation";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isExternalAnnotation";
                break;
            }
            case 41: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getStringAttributeValue";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getBooleanAttributeValue";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getLongAttributeValue";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredStringAttributeValue";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaredAttribute";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "fillValueMap";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "equal";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "buildAnnotationMap";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "isJetbrainsAnnotation";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isAnnotated$4";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectSuperParameters$3";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSuperAnnotationOwners$2";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findNonCodeAnnotation$1";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 35: 
            case 37: 
            case 54: 
            case 66: 
            case 67: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

