/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.AccessorKind;
import org.jetbrains.kotlin.codegen.ArgumentGenerator;
import org.jetbrains.kotlin.codegen.AsmUtil;
import org.jetbrains.kotlin.codegen.CallBasedArgumentGenerator;
import org.jetbrains.kotlin.codegen.CallableMethod;
import org.jetbrains.kotlin.codegen.ClassBodyCodegen;
import org.jetbrains.kotlin.codegen.ClassBuilder;
import org.jetbrains.kotlin.codegen.ClosureCodegen;
import org.jetbrains.kotlin.codegen.DefaultParameterValueLoader;
import org.jetbrains.kotlin.codegen.DefaultParameterValueSubstitutor;
import org.jetbrains.kotlin.codegen.DelegationFieldsInfo;
import org.jetbrains.kotlin.codegen.ExpressionCodegen;
import org.jetbrains.kotlin.codegen.FieldInfo;
import org.jetbrains.kotlin.codegen.FunctionCodegen;
import org.jetbrains.kotlin.codegen.FunctionGenerationStrategy;
import org.jetbrains.kotlin.codegen.JvmCodegenUtil;
import org.jetbrains.kotlin.codegen.MemberCodegen;
import org.jetbrains.kotlin.codegen.ObjectSuperCallArgumentGenerator;
import org.jetbrains.kotlin.codegen.OwnerKind;
import org.jetbrains.kotlin.codegen.SamCodegenUtil;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.binding.MutableClosure;
import org.jetbrains.kotlin.codegen.context.ConstructorContext;
import org.jetbrains.kotlin.codegen.context.FieldOwnerContext;
import org.jetbrains.kotlin.codegen.context.MethodContext;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDelegatedSuperTypeEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.kotlin.resolve.jvm.InlineClassManglingRulesKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOrigin;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.JvmDeclarationOriginKt;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterKind;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodParameterSignature;
import org.jetbrains.kotlin.resolve.jvm.jvmSignature.JvmMethodSignature;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.commons.InstructionAdapter;

public class ConstructorCodegen {
    private final ClassDescriptor descriptor;
    private final FieldOwnerContext<?> context;
    private final FunctionCodegen functionCodegen;
    private final MemberCodegen<?> memberCodegen;
    private final ClassBodyCodegen classBodyCodegen;
    private final GenerationState state;
    private final OwnerKind kind;
    private final ClassBuilder v;
    private final Type classAsmType;
    private final KtPureClassOrObject myClass;
    private final BindingContext bindingContext;
    private final KotlinTypeMapper typeMapper;

    public ConstructorCodegen(@NotNull ClassDescriptor descriptor2, @NotNull FieldOwnerContext<?> context, @NotNull FunctionCodegen codegen, @NotNull MemberCodegen<?> memberCodegen, @NotNull ClassBodyCodegen classBodyCodegen, @NotNull GenerationState state2, @NotNull OwnerKind kind, @NotNull ClassBuilder v2, @NotNull Type type2, @NotNull KtPureClassOrObject myClass, @NotNull BindingContext bindingContext) {
        this.descriptor = descriptor2;
        this.context = context;
        this.functionCodegen = codegen;
        this.memberCodegen = memberCodegen;
        this.classBodyCodegen = classBodyCodegen;
        this.state = state2;
        this.kind = kind;
        this.v = v2;
        this.classAsmType = type2;
        this.myClass = myClass;
        this.bindingContext = bindingContext;
        this.typeMapper = state2.getTypeMapper();
    }

    public void generatePrimaryConstructor(final DelegationFieldsInfo delegationFieldsInfo, final Type superClassAsmType) {
        if (JvmCodegenUtil.isJvmInterface(this.descriptor)) {
            return;
        }
        final ClassConstructorDescriptor constructorDescriptor = this.descriptor.getUnsubstitutedPrimaryConstructor();
        if (constructorDescriptor == null) {
            return;
        }
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor, this.typeMapper);
        final KtPrimaryConstructor primaryConstructor2 = this.myClass.getPrimaryConstructor();
        JvmDeclarationOrigin origin = JvmDeclarationOriginKt.OtherOrigin(primaryConstructor2 != null ? primaryConstructor2 : this.myClass.getPsiOrParent(), constructorDescriptor);
        this.functionCodegen.generateMethod(origin, constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
                ConstructorCodegen.this.generatePrimaryConstructorImpl(constructorDescriptor, codegen, delegationFieldsInfo, primaryConstructor2, superClassAsmType);
            }
        });
        OwnerKind ownerKindForDefault = this.context.getContextKind() == OwnerKind.ERASED_INLINE_CLASS ? OwnerKind.ERASED_INLINE_CLASS : OwnerKind.IMPLEMENTATION;
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorDescriptor, ownerKindForDefault, DefaultParameterValueLoader.DEFAULT, null);
        this.registerAccessorForHiddenConstructorIfNeeded(constructorDescriptor);
        new DefaultParameterValueSubstitutor(this.state).generatePrimaryConstructorOverloadsIfNeeded(constructorDescriptor, this.v, this.memberCodegen, this.kind, this.myClass);
    }

    private void registerAccessorForHiddenConstructorIfNeeded(ClassConstructorDescriptor descriptor2) {
        if (!InlineClassManglingRulesKt.shouldHideConstructorDueToInlineClassTypeValueParameters(descriptor2)) {
            return;
        }
        this.context.getAccessor(descriptor2, AccessorKind.NORMAL, null, null);
    }

    public void generateSecondaryConstructor(final @NotNull ClassConstructorDescriptor constructorDescriptor, final @NotNull Type superClassAsmType) {
        if (!DescriptorUtils.canHaveDeclaredConstructors(this.descriptor)) {
            return;
        }
        ConstructorContext constructorContext = this.context.intoConstructor(constructorDescriptor, this.typeMapper);
        KtSecondaryConstructor constructor = (KtSecondaryConstructor)DescriptorToSourceUtils.descriptorToDeclaration(constructorDescriptor);
        this.functionCodegen.generateMethod(JvmDeclarationOriginKt.OtherOrigin(constructor, constructorDescriptor), constructorDescriptor, constructorContext, new FunctionGenerationStrategy.CodegenBased(this.state){

            @Override
            public void doGenerateBody(@NotNull ExpressionCodegen codegen, @NotNull JvmMethodSignature signature2) {
                ConstructorCodegen.this.generateSecondaryConstructorImpl(constructorDescriptor, codegen, superClassAsmType);
            }
        });
        OwnerKind ownerKindForDefault = this.context.getContextKind() == OwnerKind.ERASED_INLINE_CLASS ? OwnerKind.ERASED_INLINE_CLASS : OwnerKind.IMPLEMENTATION;
        this.functionCodegen.generateDefaultIfNeeded(constructorContext, constructorDescriptor, ownerKindForDefault, DefaultParameterValueLoader.DEFAULT, null);
        new DefaultParameterValueSubstitutor(this.state).generateOverloadsIfNeeded(constructor, constructorDescriptor, constructorDescriptor, this.kind, this.v, this.memberCodegen);
        this.registerAccessorForHiddenConstructorIfNeeded(constructorDescriptor);
    }

    private void generateDelegatorToConstructorCall(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ClassConstructorDescriptor constructorDescriptor, @Nullable ResolvedCall<ConstructorDescriptor> delegationConstructorCall, @NotNull Type superClassAsmType) {
        MethodContext codegenContext = codegen.context;
        assert (codegenContext instanceof ConstructorContext) : "Constructor context expected: " + codegenContext;
        assert (!((ConstructorContext)codegenContext).isThisInitialized()) : "Delegating constructor call is already generated for " + ((ConstructorContext)codegenContext).getConstructorDescriptor();
        if (delegationConstructorCall == null) {
            this.genSimpleSuperCall(iv, superClassAsmType);
        } else {
            this.generateDelegationConstructorCall(iv, codegen, constructorDescriptor, delegationConstructorCall);
        }
        ((ConstructorContext)codegenContext).setThisInitialized(true);
    }

    private void generatePrimaryConstructorImpl(@NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen, @NotNull DelegationFieldsInfo fieldsInfo, @Nullable KtPrimaryConstructor primaryConstructor2, @NotNull Type superClassAsmType) {
        InstructionAdapter iv = codegen.v;
        ConstructorCodegen.markLineNumberForConstructor(constructorDescriptor, primaryConstructor2, codegen);
        if (OwnerKind.ERASED_INLINE_CLASS == this.kind) {
            Type t = this.typeMapper.mapType(constructorDescriptor.getContainingDeclaration());
            iv.load(0, t);
            iv.areturn(t);
            return;
        }
        this.generateClosureInitialization(iv);
        this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor, BindingContextUtils.getDelegationConstructorCall(this.bindingContext, constructorDescriptor), superClassAsmType);
        for (KtSuperTypeListEntry specifier : this.myClass.getSuperTypeListEntries()) {
            if (!(specifier instanceof KtDelegatedSuperTypeEntry)) continue;
            this.genCallToDelegatorByExpressionSpecifier(iv, codegen, (KtDelegatedSuperTypeEntry)specifier, fieldsInfo);
        }
        int curParam = 0;
        List<ValueParameterDescriptor> parameters2 = constructorDescriptor.getValueParameters();
        for (KtParameter parameter : this.classBodyCodegen.getPrimaryConstructorParameters()) {
            if (parameter.hasValOrVar()) {
                VariableDescriptor descriptor2 = parameters2.get(curParam);
                Type type2 = this.typeMapper.mapType(descriptor2);
                iv.load(0, this.classAsmType);
                iv.load(codegen.myFrameMap.getIndex(descriptor2), type2);
                PropertyDescriptor propertyDescriptor2 = this.bindingContext.get(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter);
                assert (propertyDescriptor2 != null) : "Property descriptor is not found for primary constructor parameter: " + parameter;
                iv.putfield(this.classAsmType.getInternalName(), this.context.getFieldName(propertyDescriptor2, false), type2.getDescriptor());
            }
            ++curParam;
        }
        if (!DescriptorUtils.isObject(this.descriptor)) {
            this.memberCodegen.generateInitializers(() -> codegen);
        }
        iv.visitInsn(177);
    }

    private void generateSecondaryConstructorImpl(@NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull ExpressionCodegen codegen, @NotNull Type superClassAsmType) {
        InstructionAdapter iv = codegen.v;
        KtSecondaryConstructor constructor = (KtSecondaryConstructor)DescriptorToSourceUtils.descriptorToDeclaration(constructorDescriptor);
        ConstructorCodegen.markLineNumberForConstructor(constructorDescriptor, constructor, codegen);
        ResolvedCall<ConstructorDescriptor> constructorDelegationCall = BindingContextUtils.getDelegationConstructorCall(this.bindingContext, constructorDescriptor);
        ConstructorDescriptor delegateConstructor = constructorDelegationCall == null ? null : constructorDelegationCall.getResultingDescriptor();
        this.generateDelegatorToConstructorCall(iv, codegen, constructorDescriptor, constructorDelegationCall, superClassAsmType);
        if (!this.isSameClassConstructor(delegateConstructor)) {
            this.generateClosureInitialization(iv);
            this.memberCodegen.generateInitializers(() -> codegen);
        }
        assert (constructor != null);
        if (constructor.hasBody()) {
            codegen.gen(constructor.getBodyExpression(), Type.VOID_TYPE);
        }
        if (OwnerKind.ERASED_INLINE_CLASS == this.kind) {
            iv.areturn(this.typeMapper.mapType(constructorDescriptor.getContainingDeclaration()));
        } else {
            iv.visitInsn(177);
        }
    }

    private void genCallToDelegatorByExpressionSpecifier(InstructionAdapter iv, ExpressionCodegen codegen, KtDelegatedSuperTypeEntry specifier, DelegationFieldsInfo fieldsInfo) {
        KtExpression expression2 = specifier.getDelegateExpression();
        DelegationFieldsInfo.Field fieldInfo = fieldsInfo.getInfo(specifier);
        if (fieldInfo == null) {
            return;
        }
        if (fieldInfo.generateField) {
            iv.load(0, this.classAsmType);
            fieldInfo.getStackValue().store(codegen.gen(expression2), iv);
        }
    }

    private boolean isSameClassConstructor(@Nullable ConstructorDescriptor delegatingConstructor) {
        return delegatingConstructor != null && delegatingConstructor.getContainingDeclaration() == this.descriptor;
    }

    private void generateClosureInitialization(@NotNull InstructionAdapter iv) {
        MutableClosure closure = this.context.closure;
        if (closure != null) {
            List<FieldInfo> argsFromClosure = ClosureCodegen.calculateConstructorParameters(this.typeMapper, this.state.getLanguageVersionSettings(), closure, this.classAsmType);
            int k = 1;
            for (FieldInfo info : argsFromClosure) {
                k = AsmUtil.genAssignInstanceFieldFromParam(info, k, iv);
            }
        }
    }

    private void generateDelegationConstructorCall(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ClassConstructorDescriptor constructorDescriptor, @NotNull ResolvedCall<ConstructorDescriptor> delegationConstructorCall) {
        if (OwnerKind.ERASED_INLINE_CLASS != this.kind) {
            iv.load(0, AsmTypes.OBJECT_TYPE);
        }
        ConstructorDescriptor delegateConstructor = SamCodegenUtil.resolveSamAdapter(codegen.getConstructorDescriptor(delegationConstructorCall));
        KotlinTypeMapper typeMapper = this.state.getTypeMapper();
        CallableMethod delegateConstructorCallable = typeMapper.mapToCallableMethod(delegateConstructor, false, this.kind);
        CallableMethod callable = typeMapper.mapToCallableMethod(constructorDescriptor, false, this.kind);
        List<JvmMethodParameterSignature> delegatingParameters = delegateConstructorCallable.getValueParameters();
        List<JvmMethodParameterSignature> parameters2 = callable.getValueParameters();
        ArgumentGenerator argumentGenerator = this.isSameClassConstructor(delegateConstructor) ? ConstructorCodegen.generateThisCallImplicitArguments(iv, codegen, delegateConstructor, delegateConstructorCallable, delegatingParameters, parameters2) : this.generateSuperCallImplicitArguments(iv, codegen, constructorDescriptor, delegateConstructor, delegationConstructorCall, delegateConstructorCallable, delegatingParameters, parameters2);
        codegen.invokeMethodWithArguments(delegateConstructorCallable, delegationConstructorCall, StackValue.none(), codegen.defaultCallGenerator, argumentGenerator);
    }

    private void genSimpleSuperCall(InstructionAdapter iv, Type superClassAsmType) {
        iv.load(0, superClassAsmType);
        if (this.descriptor.getKind() == ClassKind.ENUM_CLASS || this.descriptor.getKind() == ClassKind.ENUM_ENTRY) {
            iv.load(1, AsmTypes.JAVA_STRING_TYPE);
            iv.load(2, Type.INT_TYPE);
            iv.invokespecial(superClassAsmType.getInternalName(), "<init>", "(Ljava/lang/String;I)V", false);
        } else {
            iv.invokespecial(superClassAsmType.getInternalName(), "<init>", "()V", false);
        }
    }

    @NotNull
    private static ArgumentGenerator generateThisCallImplicitArguments(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor delegatingConstructor, @NotNull CallableMethod delegatingCallable, @NotNull List<JvmMethodParameterSignature> delegatingParameters, @NotNull List<JvmMethodParameterSignature> parameters2) {
        int index2;
        int offset2 = 1;
        for (index2 = 0; index2 < delegatingParameters.size(); ++index2) {
            JvmMethodParameterKind delegatingKind = delegatingParameters.get(index2).getKind();
            if (delegatingKind == JvmMethodParameterKind.VALUE) {
                assert (index2 == parameters2.size() || parameters2.get(index2).getKind() == JvmMethodParameterKind.VALUE) : "Delegating constructor has not enough implicit parameters";
                break;
            }
            assert (index2 < parameters2.size() && parameters2.get(index2).getKind() == delegatingKind) : "Constructors of the same class should have the same set of implicit arguments";
            JvmMethodParameterSignature parameter = parameters2.get(index2);
            iv.load(offset2, parameter.getAsmType());
            offset2 += parameter.getAsmType().getSize();
        }
        assert (index2 == parameters2.size() || parameters2.get(index2).getKind() == JvmMethodParameterKind.VALUE) : "Delegating constructor has not enough parameters";
        return new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, delegatingConstructor.getValueParameters(), delegatingCallable.getValueParameterTypes());
    }

    @NotNull
    private ArgumentGenerator generateSuperCallImplicitArguments(@NotNull InstructionAdapter iv, @NotNull ExpressionCodegen codegen, @NotNull ConstructorDescriptor constructorDescriptor, @NotNull ConstructorDescriptor superConstructor, @NotNull ResolvedCall<ConstructorDescriptor> superConstructorCall, @NotNull CallableMethod superCallable, @NotNull List<JvmMethodParameterSignature> superParameters, @NotNull List<JvmMethodParameterSignature> parameters2) {
        int offset2 = 1;
        int superIndex = 0;
        for (JvmMethodParameterSignature parameter : parameters2) {
            if (superIndex >= superParameters.size()) break;
            JvmMethodParameterKind superKind = superParameters.get(superIndex).getKind();
            JvmMethodParameterKind kind = parameter.getKind();
            Type type2 = parameter.getAsmType();
            if (superKind == JvmMethodParameterKind.VALUE && kind == JvmMethodParameterKind.SUPER_CALL_PARAM) break;
            if (superKind == JvmMethodParameterKind.OUTER) {
                assert (kind == JvmMethodParameterKind.OUTER || kind == JvmMethodParameterKind.SUPER_CALL_PARAM) : String.format("Non-outer parameter incorrectly mapped to outer for %s: %s vs %s", constructorDescriptor, parameters2, superParameters);
                ClassDescriptor outerForSuper = (ClassDescriptor)superConstructor.getContainingDeclaration().getContainingDeclaration();
                StackValue outer = codegen.generateThisOrOuter(outerForSuper, true, true);
                outer.put(outer.type, codegen.v);
                ++superIndex;
            } else if (kind == JvmMethodParameterKind.SUPER_CALL_PARAM || kind == JvmMethodParameterKind.ENUM_NAME_OR_ORDINAL) {
                iv.load(offset2, type2);
                ++superIndex;
            }
            offset2 += type2.getSize();
        }
        if (DescriptorUtils.isAnonymousObject(this.descriptor)) {
            List<JvmMethodParameterSignature> superValues = superParameters.subList(superIndex, superParameters.size());
            return new ObjectSuperCallArgumentGenerator(superValues, iv, superConstructor.getValueParameters(), codegen.typeMapper, offset2, superConstructorCall);
        }
        return new CallBasedArgumentGenerator(codegen, codegen.defaultCallGenerator, superConstructor.getValueParameters(), superCallable.getValueParameterTypes());
    }

    private static void markLineNumberForConstructor(@NotNull ClassConstructorDescriptor descriptor2, @Nullable KtConstructor constructor, @NotNull ExpressionCodegen codegen) {
        if (constructor == null) {
            MemberCodegen.markLineNumberForDescriptor(descriptor2.getContainingDeclaration(), codegen.v);
        } else if (constructor.hasBody() && (!(constructor instanceof KtSecondaryConstructor) || ((KtSecondaryConstructor)constructor).hasImplicitDelegationCall())) {
            List<Object> statements;
            KtBlockExpression bodyExpression = constructor.getBodyExpression();
            List<Object> list2 = statements = bodyExpression != null ? bodyExpression.getStatements() : Collections.emptyList();
            if (!statements.isEmpty()) {
                codegen.markStartLineNumber((KtElement)statements.iterator().next());
            } else {
                codegen.markStartLineNumber((KtElement)((Object)(bodyExpression != null ? bodyExpression : constructor)));
            }
        } else {
            codegen.markStartLineNumber(constructor);
        }
    }
}

