/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KClassValue
extends ConstantValue<ClassLiteralValue> {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final ClassId getClassId() {
        return ((ClassLiteralValue)this.getValue()).getClassId();
    }

    public final int getArrayDimensions() {
        return ((ClassLiteralValue)this.getValue()).getArrayNestedness();
    }

    @Override
    @NotNull
    public KotlinType getType(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        Annotations annotations2 = Annotations.Companion.getEMPTY();
        ClassDescriptor classDescriptor2 = module2.getBuiltIns().getKClass();
        Intrinsics.checkExpressionValueIsNotNull(classDescriptor2, "module.builtIns.kClass");
        return KotlinTypeFactory.simpleNotNullType(annotations2, classDescriptor2, CollectionsKt.listOf(new TypeProjectionImpl(this.getArgumentType(module2))));
    }

    @NotNull
    public final KotlinType getArgumentType(@NotNull ModuleDescriptor module2) {
        Intrinsics.checkParameterIsNotNull(module2, "module");
        ClassDescriptor classDescriptor2 = FindClassInModuleKt.findClassAcrossModuleDependencies(module2, this.getClassId());
        if (classDescriptor2 == null) {
            SimpleType simpleType2 = ErrorUtils.createErrorType("Unresolved type: " + this.getClassId() + " (arrayDimensions=" + this.getArrayDimensions() + ')');
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "ErrorUtils.createErrorTy\u2026sions=$arrayDimensions)\")");
            return simpleType2;
        }
        ClassDescriptor descriptor2 = classDescriptor2;
        SimpleType simpleType3 = descriptor2.getDefaultType();
        Intrinsics.checkExpressionValueIsNotNull(simpleType3, "descriptor.defaultType");
        KotlinType type2 = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType3);
        int n = this.getArrayDimensions();
        int n2 = 0;
        int n3 = n;
        while (n2 < n3) {
            int it = n2++;
            SimpleType simpleType4 = module2.getBuiltIns().getArrayType(Variance.INVARIANT, type2);
            Intrinsics.checkExpressionValueIsNotNull(simpleType4, "module.builtIns.getArray\u2026Variance.INVARIANT, type)");
            type2 = simpleType4;
        }
        return type2;
    }

    public KClassValue(@NotNull ClassLiteralValue value) {
        Intrinsics.checkParameterIsNotNull(value, "value");
        super(value);
    }

    public KClassValue(@NotNull ClassId classId, int arrayDimensions) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        this(new ClassLiteralValue(classId, arrayDimensions));
    }

    public static final class Companion {
        @Nullable
        public final ConstantValue<?> create(@NotNull KotlinType argumentType) {
            ConstantValue constantValue;
            Intrinsics.checkParameterIsNotNull(argumentType, "argumentType");
            if (KotlinTypeKt.isError(argumentType)) {
                return null;
            }
            KotlinType type2 = argumentType;
            int arrayDimensions = 0;
            while (KotlinBuiltIns.isArray(type2)) {
                Intrinsics.checkExpressionValueIsNotNull(CollectionsKt.single(type2.getArguments()).getType(), "type.arguments.single().type");
                ++arrayDimensions;
            }
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof ClassDescriptor) {
                ClassId classId = DescriptorUtilsKt.getClassId(descriptor2);
                if (classId == null) {
                    return null;
                }
                ClassId classId2 = classId;
                constantValue = new KClassValue(classId2, arrayDimensions);
            } else if (descriptor2 instanceof TypeParameterDescriptor) {
                ClassId classId = ClassId.topLevel(KotlinBuiltIns.FQ_NAMES.any.toSafe());
                Intrinsics.checkExpressionValueIsNotNull(classId, "ClassId.topLevel(KotlinB\u2026ns.FQ_NAMES.any.toSafe())");
                constantValue = new KClassValue(classId, 0);
            } else {
                constantValue = null;
            }
            return constantValue;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

