/*
 * Decompiled with CFR 0.152.
 */
package javaslang.match.generator;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javaslang.match.annotation.Unapply;
import javaslang.match.generator.ImportManager;
import javaslang.match.model.ClassModel;
import javaslang.match.model.MethodModel;
import javaslang.match.model.TypeParameterModel;

public class Generator {
    public static String generate(String derivedClassName, ClassModel classModel) {
        List<MethodModel> methodModels = classModel.getMethods().stream().filter(method -> method.isAnnotatedWith(Unapply.class)).collect(Collectors.toList());
        String _package = classModel.getPackageName();
        ImportManager im = ImportManager.forClass(classModel, "javaslang.API.Match");
        String methods2 = Generator.generate(im, classModel, methodModels);
        return (_package.isEmpty() ? "" : "package " + _package + ";\n\n") + im.getImports() + "\n\n// GENERATED BY JAVASLANG <<>> derived from " + classModel.getFullQualifiedName() + "\n\npublic final class " + derivedClassName + " {\n\n    private " + derivedClassName + "() {\n    }\n\n" + methods2 + "}\n";
    }

    private static String generate(ImportManager im, ClassModel classModel, List<MethodModel> methodModels) {
        StringBuilder builder = new StringBuilder();
        for (MethodModel methodModel : methodModels) {
            Generator.generate(im, classModel, methodModel, builder);
            builder.append("\n");
        }
        return builder.toString();
    }

    private static void generate(ImportManager im, ClassModel classModel, MethodModel methodModel, StringBuilder builder) {
        String method;
        String body;
        String paramTypeName = im.getType(methodModel.getParameter(0).getType());
        String name = methodModel.getName();
        int arity = Integer.parseInt(methodModel.getReturnType().getClassName().substring("Tuple".length()));
        if (arity == 0) {
            body = Generator.pattern(im, 0) + ".of(" + paramTypeName + ".class)";
        } else {
            String args = IntStream.rangeClosed(1, arity).mapToObj(i -> "p" + i).collect(Collectors.joining(", "));
            String unapplyRef = classModel.getFullQualifiedName() + "::" + name;
            body = String.format("%s.of(%s, %s, %s)", Generator.pattern(im, arity), paramTypeName + ".class", args, unapplyRef);
        }
        List<String> typeArgs = methodModel.getTypeParameters().stream().map(typeParameterModel -> Generator.mapToName(im, typeParameterModel)).collect(Collectors.toList());
        List<String> upperBoundArgs = Generator.deriveUpperBounds(typeArgs, methodModel.getReturnType().getTypeParameters().size());
        String returnType2 = Generator.genReturnType(im, methodModel, upperBoundArgs, arity);
        if (arity == 0 && methodModel.getTypeParameters().size() == 0) {
            method = String.format("final %s %s = %s;", returnType2, name, body);
        } else {
            String generics = Generator.genGenerics(im, methodModel, typeArgs, upperBoundArgs);
            String params = Generator.genParams(im, upperBoundArgs, arity);
            method = String.format("%s %s %s(%s) {\n        return %s;\n    }", generics, returnType2, name, params, body);
        }
        builder.append("    public static ").append(method).append("\n");
    }

    private static List<String> deriveUpperBounds(List<String> typeArgs, int count2) {
        ArrayList<String> result2 = new ArrayList<String>();
        HashSet<String> knownTypeArgs = new HashSet<String>(typeArgs);
        for (int i = 0; i < count2; ++i) {
            String typeArg = "_" + (i + 1);
            while (knownTypeArgs.contains(typeArg)) {
                typeArg = "_" + typeArg;
            }
            result2.add(typeArg);
            knownTypeArgs.add(typeArg);
        }
        return result2;
    }

    private static String genGenerics(ImportManager im, MethodModel methodModel, List<String> typeParameters2, List<String> upperBoundArgs) {
        List<TypeParameterModel> returnTypeArgs = methodModel.getReturnType().getTypeParameters();
        if (typeParameters2.size() + returnTypeArgs.size() == 0) {
            return "";
        }
        ArrayList<String> result2 = new ArrayList<String>(typeParameters2);
        for (int i = 0; i < returnTypeArgs.size(); ++i) {
            String returnTypeArg = Generator.mapToName(im, returnTypeArgs.get(i));
            result2.add(upperBoundArgs.get(i) + " extends " + returnTypeArg);
        }
        return result2.stream().collect(Collectors.joining(", ", "<", ">"));
    }

    private static String genReturnType(ImportManager im, MethodModel methodModel, List<String> upperBoundArgs, int arity) {
        ArrayList<String> resultTypes = new ArrayList<String>();
        String type2 = Generator.mapToName(im, methodModel.getParameter(0).getType());
        resultTypes.add(type2);
        resultTypes.addAll(upperBoundArgs);
        return Generator.pattern(im, arity) + resultTypes.stream().collect(Collectors.joining(", ", "<", ">"));
    }

    private static String genParams(ImportManager im, List<String> upperBoundArgs, int arity) {
        String patternType = im.getType("javaslang", "API.Match.Pattern");
        return IntStream.range(0, arity).mapToObj(i -> patternType + "<" + (String)upperBoundArgs.get(i) + ", ?> p" + (i + 1)).collect(Collectors.joining(", "));
    }

    private static String mapToName(ImportManager im, TypeParameterModel typeParameterModel) {
        if (typeParameterModel.isType()) {
            return Generator.mapToName(im, typeParameterModel.asType());
        }
        if (typeParameterModel.isTypeVar()) {
            return typeParameterModel.asTypeVar();
        }
        throw new IllegalStateException("Unhandled type parameter: " + typeParameterModel.toString());
    }

    private static String mapToName(ImportManager im, ClassModel classModel) {
        List<TypeParameterModel> typeParameters2 = classModel.getTypeParameters();
        String simpleName2 = im.getType(classModel);
        if (typeParameters2.size() == 0) {
            return simpleName2;
        }
        return simpleName2 + classModel.getTypeParameters().stream().map(typeParam -> Generator.mapToName(im, typeParam)).collect(Collectors.joining(", ", "<", ">"));
    }

    private static String pattern(ImportManager im, int arity) {
        return im.getType("javaslang", "API.Match.Pattern" + arity);
    }
}

