/*
 * Decompiled with CFR 0.152.
 */
package jInst;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;

public class ResourceLoader {
    private static String defaultJVMConventionsLocation = "JVMConventions.cfg";
    private static String defaultAnaDroidConventionsLocation = "AnaDroidConventions.cfg";

    public String retrieveConfigJVMConventions(String propName) {
        InputStream i = this.getClass().getResourceAsStream(defaultJVMConventionsLocation);
        return new BufferedReader(new InputStreamReader(i, StandardCharsets.UTF_8)).lines().collect(Collectors.toList()).stream().filter(it -> it.startsWith(propName)).findFirst().get().split("=")[1];
    }

    public String retrieveConfigAnaDroidConventions(String propName) {
        InputStream i = this.getClass().getResourceAsStream(defaultAnaDroidConventionsLocation);
        return new BufferedReader(new InputStreamReader(i, StandardCharsets.UTF_8)).lines().collect(Collectors.toList()).stream().filter(it -> it.startsWith(propName)).findFirst().get().split("=")[1];
    }

    public static List<String> readFilesWithNIO(String filePath) {
        Path p = Paths.get(filePath, new String[0]);
        List<String> l = null;
        try {
            l = Files.readAllLines(p, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return l;
    }
}

