/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TLongArrayList
implements Serializable,
Cloneable {
    protected transient long[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 4;

    public TLongArrayList() {
    }

    public TLongArrayList(int capacity) {
        this._data = new long[capacity];
        this._pos = 0;
    }

    public TLongArrayList(long[] values2) {
        this(Math.max(values2.length, 4));
        this.add(values2);
    }

    public void ensureCapacity(int capacity) {
        if (this._data == null) {
            this._data = new long[Math.max(4, capacity)];
        }
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            long[] tmp = new long[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data != null && this._data.length > this.size()) {
            long[] tmp = new long[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(long val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(long[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(long[] vals, int offset2, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset2, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset2, long value) {
        if (offset2 == this._pos) {
            this.add(value);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset2, this._data, offset2 + 1, this._pos - offset2);
        this._data[offset2] = value;
        ++this._pos;
    }

    public void insert(int offset2, long[] values2) {
        this.insert(offset2, values2, 0, values2.length);
    }

    public void insert(int offset2, long[] values2, int valOffset, int len) {
        if (offset2 == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset2, this._data, offset2 + len, this._pos - offset2);
        System.arraycopy(values2, valOffset, this._data, offset2, len);
        this._pos += len;
    }

    public long get(int offset2) {
        if (offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        return this._data[offset2];
    }

    public long getQuick(int offset2) {
        return this._data[offset2];
    }

    public void set(int offset2, long val) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        this._data[offset2] = val;
    }

    public long getSet(int offset2, long val) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        long old = this._data[offset2];
        this._data[offset2] = val;
        return old;
    }

    public void set(int offset2, long[] values2) {
        this.set(offset2, values2, 0, values2.length);
    }

    public void set(int offset2, long[] values2, int valOffset, int length) {
        if (offset2 < 0 || offset2 + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, values2, valOffset, length);
    }

    public void setQuick(int offset2, long val) {
        this._data[offset2] = val;
    }

    public void clear() {
        this._data = null;
        this._pos = 0;
    }

    public void clear(int capacity) {
        this._data = new long[capacity];
        this._pos = 0;
    }

    public void reset() {
        this.fill(0L);
        this._pos = 0;
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public long remove(int offset2) {
        long old = this.get(offset2);
        this.remove(offset2, 1);
        return old;
    }

    public void remove(int offset2, int length) {
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        if (offset2 == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset2) {
            System.arraycopy(this._data, offset2 + length, this._data, offset2, this._pos - (offset2 + length));
        }
        this._pos -= length;
    }

    public void transformValues(TLongFunction function2) {
        int i = this._pos;
        while (i-- > 0) {
            this._data[i] = function2.execute(this._data[i]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from;
        for (int j = to - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    private void swap(int i, int j) {
        long tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TLongArrayList clone = null;
        try {
            clone = (TLongArrayList)super.clone();
            clone._data = this._data == null ? null : (long[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public long[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public long[] toNativeArray(int offset2, int len) {
        long[] rv = new long[len];
        this.toNativeArray(rv, offset2, len);
        return rv;
    }

    public void toNativeArray(long[] dest, int offset2, int len) {
        if (len == 0) {
            return;
        }
        if (offset2 < 0 || offset2 >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        System.arraycopy(this._data, offset2, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TLongArrayList) {
            TLongArrayList that = (TLongArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return h;
    }

    public boolean forEach(TLongProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TLongProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, 0, this._pos);
        }
    }

    public void sort(int fromIndex, int toIndex) {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, fromIndex, toIndex);
        }
    }

    public void fill(long val) {
        if (!this.isEmpty()) {
            Arrays.fill(this._data, 0, this._pos, val);
        }
    }

    public void fill(int fromIndex, int toIndex, long val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        if (!this.isEmpty()) {
            Arrays.fill(this._data, fromIndex, toIndex, val);
        }
    }

    public int binarySearch(long value) {
        return this.binarySearch(value, 0, this._pos);
    }

    public int binarySearch(long value, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = this._data[mid];
            if (midVal < value) {
                low = mid + 1;
                continue;
            }
            if (midVal > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(long value) {
        return this.indexOf(0, value);
    }

    public int indexOf(int offset2, long value) {
        for (int i = offset2; i < this._pos; ++i) {
            if (this._data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long value) {
        return this.lastIndexOf(this._pos, value);
    }

    public int lastIndexOf(int offset2, long value) {
        int i = offset2;
        while (i-- > 0) {
            if (this._data[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(long value) {
        return this.lastIndexOf(value) >= 0;
    }

    public TLongArrayList grep(TLongProcedure condition) {
        TLongArrayList list2 = new TLongArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!condition.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public TLongArrayList inverseGrep(TLongProcedure condition) {
        TLongArrayList list2 = new TLongArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (condition.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public long max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        long max = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            max = Math.max(max, this._data[this._pos]);
        }
        return max;
    }

    public long min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        long min = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            min = Math.min(min, this._data[this._pos]);
        }
        return min;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TLongProcedure(){

            public boolean execute(long val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream stream2) throws IOException {
        stream2.defaultWriteObject();
        stream2.writeInt(this.size());
        SerializationProcedure writeProcedure = new SerializationProcedure(stream2);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream2) throws IOException, ClassNotFoundException {
        stream2.defaultReadObject();
        int size = stream2.readInt();
        this._data = new long[size];
        while (size-- > 0) {
            long val = stream2.readLong();
            this.add(val);
        }
    }
}

