/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TByteHash;
import gnu.trove.TByteHashingStrategy;
import gnu.trove.TByteIterator;
import gnu.trove.TByteProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;

public class TByteHashSet
extends TByteHash {
    public TByteHashSet() {
    }

    public TByteHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TByteHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TByteHashSet(byte[] array) {
        this(array.length);
        this.addAll(array);
    }

    public TByteHashSet(TByteHashingStrategy strategy) {
        super(strategy);
    }

    public TByteHashSet(int initialCapacity, TByteHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TByteHashSet(int initialCapacity, float loadFactor, TByteHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TByteHashSet(byte[] array, TByteHashingStrategy strategy) {
        this(array.length, strategy);
        this.addAll(array);
    }

    public TByteIterator iterator() {
        return new TByteIterator(this);
    }

    public boolean add(byte val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = val;
        this._states[index2] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        byte[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new byte[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            byte o = oldSet[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._states[index2] = 1;
        }
    }

    public byte[] toArray() {
        byte[] result2 = new byte[this.size()];
        byte[] set = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = states.length;
            int j = 0;
            while (i-- > 0) {
                if (states[i] != 1) continue;
                result2[j++] = set[i];
            }
        }
        return result2;
    }

    public void clear() {
        super.clear();
        byte[] set = this._set;
        byte[] states = this._states;
        if (states != null) {
            int i = set.length;
            while (i-- > 0) {
                set[i] = 0;
                states[i] = 0;
            }
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TByteHashSet)) {
            return false;
        }
        final TByteHashSet that = (TByteHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TByteProcedure(){

            public final boolean execute(byte value) {
                return that.contains(value);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(byte val) {
        int index2 = this.index(val);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public boolean containsAll(byte[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(byte[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(byte[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(byte[] array) {
        Arrays.sort(array);
        byte[] set = this._set;
        byte[] states = this._states;
        boolean changed = false;
        if (set != null) {
            int i = set.length;
            while (i-- > 0) {
                if (states[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
                this.remove(set[i]);
                changed = true;
            }
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream2) throws IOException {
        stream2.defaultWriteObject();
        stream2.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream2);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream2) throws IOException, ClassNotFoundException {
        stream2.defaultReadObject();
        int size = stream2.readInt();
        this.setUp(size);
        while (size-- > 0) {
            byte val = stream2.readByte();
            this.add(val);
        }
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEach(new TByteProcedure(){

            public boolean execute(byte value) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(value);
                return true;
            }
        });
        sb.append(']');
        sb.insert(0, '[');
        return sb.toString();
    }

    private final class HashProcedure
    implements TByteProcedure {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        public final boolean execute(byte key) {
            this.h += TByteHashSet.this._hashingStrategy.computeHashCode(key);
            return true;
        }
    }
}

