/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.comments;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.comments.LineComment;

public abstract class Comment
extends Node {
    private String content;
    private Node commentedNode;

    public Comment() {
    }

    public Comment(String content) {
        this.content = content;
    }

    @Deprecated
    public Comment(int beginLine, int beginColumn, int endLine, int endColumn, String content) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), content);
    }

    public Comment(Range range, String content) {
        super(range);
        this.content = content;
    }

    public final String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isLineComment() {
        return false;
    }

    public LineComment asLineComment() {
        if (this.isLineComment()) {
            return (LineComment)this;
        }
        throw new UnsupportedOperationException("Not a line comment");
    }

    public Node getCommentedNode() {
        return this.commentedNode;
    }

    public void setCommentedNode(Node commentedNode) {
        if (commentedNode == null) {
            this.commentedNode = null;
            return;
        }
        if (commentedNode == this) {
            throw new IllegalArgumentException();
        }
        if (commentedNode instanceof Comment) {
            throw new IllegalArgumentException();
        }
        this.commentedNode = commentedNode;
    }

    public boolean isOrphan() {
        return this.commentedNode == null;
    }
}

