/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast.body;

import com.github.javaparser.Position;
import com.github.javaparser.Range;
import com.github.javaparser.ast.AccessSpecifier;
import com.github.javaparser.ast.DocumentableNode;
import com.github.javaparser.ast.NamedNode;
import com.github.javaparser.ast.NodeWithModifiers;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.TypedNode;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ModifierSet;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.WithDeclaration;
import com.github.javaparser.ast.comments.JavadocComment;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.internal.Utils;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import java.util.List;

public final class MethodDeclaration
extends BodyDeclaration
implements DocumentableNode,
WithDeclaration,
NamedNode,
TypedNode,
NodeWithModifiers {
    private int modifiers;
    private List<TypeParameter> typeParameters;
    private Type type;
    private NameExpr name;
    private List<Parameter> parameters;
    private int arrayCount;
    private List<ReferenceType> throws_;
    private BlockStmt body;
    private boolean isDefault = false;

    public MethodDeclaration() {
    }

    public MethodDeclaration(int modifiers2, Type type2, String name) {
        this.setModifiers(modifiers2);
        this.setType(type2);
        this.setName(name);
    }

    public MethodDeclaration(int modifiers2, Type type2, String name, List<Parameter> parameters2) {
        this.setModifiers(modifiers2);
        this.setType(type2);
        this.setName(name);
        this.setParameters(parameters2);
    }

    public MethodDeclaration(int modifiers2, List<AnnotationExpr> annotations2, List<TypeParameter> typeParameters2, Type type2, String name, List<Parameter> parameters2, int arrayCount, List<ReferenceType> throws_, BlockStmt body) {
        super(annotations2);
        this.setModifiers(modifiers2);
        this.setTypeParameters(typeParameters2);
        this.setType(type2);
        this.setName(name);
        this.setParameters(parameters2);
        this.setArrayCount(arrayCount);
        this.setThrows(throws_);
        this.setBody(body);
    }

    @Deprecated
    public MethodDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, int modifiers2, List<AnnotationExpr> annotations2, List<TypeParameter> typeParameters2, Type type2, String name, List<Parameter> parameters2, int arrayCount, List<ReferenceType> throws_, BlockStmt body) {
        this(new Range(Position.pos(beginLine, beginColumn), Position.pos(endLine, endColumn)), modifiers2, annotations2, typeParameters2, type2, name, parameters2, arrayCount, throws_, body);
    }

    public MethodDeclaration(Range range, int modifiers2, List<AnnotationExpr> annotations2, List<TypeParameter> typeParameters2, Type type2, String name, List<Parameter> parameters2, int arrayCount, List<ReferenceType> throws_, BlockStmt body) {
        super(range, annotations2);
        this.setModifiers(modifiers2);
        this.setTypeParameters(typeParameters2);
        this.setType(type2);
        this.setName(name);
        this.setParameters(parameters2);
        this.setArrayCount(arrayCount);
        this.setThrows(throws_);
        this.setBody(body);
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v2, A arg) {
        return v2.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v2, A arg) {
        v2.visit(this, arg);
    }

    public int getArrayCount() {
        return this.arrayCount;
    }

    public BlockStmt getBody() {
        return this.body;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public String getName() {
        return this.name.getName();
    }

    public NameExpr getNameExpr() {
        return this.name;
    }

    public List<Parameter> getParameters() {
        this.parameters = Utils.ensureNotNull(this.parameters);
        return this.parameters;
    }

    public List<ReferenceType> getThrows() {
        this.throws_ = Utils.ensureNotNull(this.throws_);
        return this.throws_;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public List<TypeParameter> getTypeParameters() {
        this.typeParameters = Utils.ensureNotNull(this.typeParameters);
        return this.typeParameters;
    }

    public void setArrayCount(int arrayCount) {
        this.arrayCount = arrayCount;
    }

    public void setBody(BlockStmt body) {
        this.body = body;
        this.setAsParentNodeOf(this.body);
    }

    public void setModifiers(int modifiers2) {
        this.modifiers = modifiers2;
    }

    public void setName(String name) {
        this.setNameExpr(new NameExpr(name));
    }

    public void setNameExpr(NameExpr name) {
        this.name = name;
        this.setAsParentNodeOf(this.name);
    }

    public void setParameters(List<Parameter> parameters2) {
        this.parameters = parameters2;
        this.setAsParentNodeOf(this.parameters);
    }

    public void setThrows(List<ReferenceType> throws_) {
        this.throws_ = throws_;
        this.setAsParentNodeOf(this.throws_);
    }

    @Override
    public void setType(Type type2) {
        this.type = type2;
        this.setAsParentNodeOf(this.type);
    }

    public void setTypeParameters(List<TypeParameter> typeParameters2) {
        this.typeParameters = typeParameters2;
        this.setAsParentNodeOf(typeParameters2);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    @Override
    public String getDeclarationAsString() {
        return this.getDeclarationAsString(true, true, true);
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows) {
        return this.getDeclarationAsString(includingModifiers, includingThrows, true);
    }

    @Override
    public String getDeclarationAsString(boolean includingModifiers, boolean includingThrows, boolean includingParameterName) {
        StringBuilder sb = new StringBuilder();
        if (includingModifiers) {
            AccessSpecifier accessSpecifier = ModifierSet.getAccessSpecifier(this.getModifiers());
            sb.append(accessSpecifier.getCodeRepresenation());
            sb.append(accessSpecifier == AccessSpecifier.DEFAULT ? "" : " ");
            if (ModifierSet.isStatic(this.getModifiers())) {
                sb.append("static ");
            }
            if (ModifierSet.isAbstract(this.getModifiers())) {
                sb.append("abstract ");
            }
            if (ModifierSet.isFinal(this.getModifiers())) {
                sb.append("final ");
            }
            if (ModifierSet.isNative(this.getModifiers())) {
                sb.append("native ");
            }
            if (ModifierSet.isSynchronized(this.getModifiers())) {
                sb.append("synchronized ");
            }
        }
        sb.append(this.getType().toStringWithoutComments());
        sb.append(" ");
        sb.append(this.getName());
        sb.append("(");
        boolean firstParam = true;
        for (Parameter param : this.getParameters()) {
            if (firstParam) {
                firstParam = false;
            } else {
                sb.append(", ");
            }
            if (includingParameterName) {
                sb.append(param.toStringWithoutComments());
                continue;
            }
            sb.append(param.getType().toStringWithoutComments());
            if (!param.isVarArgs()) continue;
            sb.append("...");
        }
        sb.append(")");
        if (includingThrows) {
            boolean firstThrow = true;
            for (ReferenceType thr : this.getThrows()) {
                if (firstThrow) {
                    firstThrow = false;
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(thr.toStringWithoutComments());
            }
        }
        return sb.toString();
    }

    @Override
    public JavadocComment getJavaDoc() {
        if (this.getComment() instanceof JavadocComment) {
            return (JavadocComment)this.getComment();
        }
        return null;
    }
}

