/*
 * Decompiled with CFR 0.152.
 */
package AndroidProjectRepresentation;

import AndroidProjectRepresentation.AppInfo;
import AndroidProjectRepresentation.ClassInfo;
import AndroidProjectRepresentation.JSONSerializable;
import AndroidProjectRepresentation.MethodInfo;
import AndroidProjectRepresentation.MethodOfAPI;
import AndroidProjectRepresentation.NameExpression;
import AndroidProjectRepresentation.ProjectInfo;
import AndroidProjectRepresentation.Variable;
import Metrics.APIEvaluator;
import Metrics.CyclomaticCalculator;
import Metrics.SourceCodeLineCounter;
import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.ImportDeclaration;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import com.github.javaparser.ast.stmt.ExpressionStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.ReferenceType;
import com.github.javaparser.ast.visitor.VoidVisitorAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.simple.JSONObject;

public class APICallUtil
extends VoidVisitorAdapter
implements Serializable,
JSONSerializable {
    public static ProjectInfo proj = new ProjectInfo();
    public static Map<String, ClassInfo> processedClasses = new HashMap<String, ClassInfo>();

    public APICallUtil() {
    }

    public APICallUtil(ProjectInfo pi) {
        proj = pi;
    }

    public void addClassToApp(String app, ClassInfo ci) {
        if (app == null || app == "") {
            APICallUtil.proj.getCurrentApp().allJavaClasses.add(ci);
        }
    }

    private String metId(MethodDeclaration m) {
        return m.getModifiers() + m.getName() + (m.getParameters() != null ? m.getParameters().toString() : Integer.valueOf(m.getModifiers()));
    }

    private String metId(ConstructorDeclaration m) {
        return m.getModifiers() + m.getName() + (m.getParameters() != null ? m.getParameters().toString() : Integer.valueOf(m.getModifiers()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processJavaFile(String javaFilePath) throws IOException, ParseException {
        CompilationUnit cu;
        File file2 = new File(javaFilePath);
        try (FileInputStream in = new FileInputStream(file2);){
            cu = JavaParser.parse(in, null, false);
        }
        for (Node n : cu.getChildrenNodes()) {
            if (!(n instanceof ClassOrInterfaceDeclaration)) continue;
            this.visit((ClassOrInterfaceDeclaration)n, (Object)cu);
        }
        this.distributeMethods(cu);
    }

    private void distributeMethods(CompilationUnit cu) {
        Map<String, MethodInfo> map2 = new APIEvaluator().eval(cu);
        for (AppInfo a : APICallUtil.proj.apps) {
            for (ClassInfo c : a.allJavaClasses) {
                for (MethodInfo m : c.classMethods.values()) {
                    String metID = m.getMethodID();
                    if (!map2.containsKey(metID)) continue;
                    m.unknownApi = map2.get((Object)metID).unknownApi;
                    m.declaredVars = map2.get((Object)metID).declaredVars;
                    m.args = map2.get((Object)metID).args;
                }
                APICallUtil.MethodClassifier(c);
            }
        }
    }

    public static boolean hasMatchingBrackets(String s) {
        if (s == null) {
            return false;
        }
        int counter = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '(') {
                ++counter;
                continue;
            }
            if (s.charAt(i) != ')') continue;
            if (counter == 0) {
                return false;
            }
            --counter;
        }
        return counter == 0;
    }

    private static boolean apimakesSense(String cl, String method) {
        return APICallUtil.hasMatchingBrackets(cl) && APICallUtil.hasMatchingBrackets(method);
    }

    private static void MethodClassifier(ClassInfo thisClass) {
        if (thisClass.classMethods.size() > 0) {
            for (MethodInfo m : thisClass.classMethods.values()) {
                Iterator<MethodOfAPI> it = m.unknownApi.iterator();
                while (it.hasNext()) {
                    MethodOfAPI ss = it.next();
                    String s = ss.referenceClass;
                    if (s == null || s.equals("")) {
                        it.remove();
                        continue;
                    }
                    String[] x = s.split("<|,");
                    boolean added = false;
                    if (x.length > 1) {
                        for (String st : x) {
                            st = st.replaceAll(">", "").replace(" ", "");
                            if (s.equals("super")) {
                                st = thisClass.extendedClass;
                            }
                            if (APICallUtil.isPrimitiveType(st)) continue;
                            if (APICallUtil.isAndroidApi(st, thisClass)) {
                                MethodOfAPI moa = new MethodOfAPI(APICallUtil.getCorrespondantImport(st, thisClass).equals("") ? st : APICallUtil.getCorrespondantImport(st, thisClass) + "." + st, ss.method, ss.args);
                                m.androidApi.add(moa);
                                added = true;
                                continue;
                            }
                            if (APICallUtil.isJavaApi(st, thisClass)) {
                                m.javaApi.add(new MethodOfAPI(APICallUtil.getCorrespondantImport(st, thisClass).equals("") ? st : APICallUtil.getCorrespondantImport(st, thisClass) + "." + st, ss.method, ss.args));
                                added = true;
                                continue;
                            }
                            m.externalApi.add(new MethodOfAPI(APICallUtil.getCorrespondantImport(st, thisClass).equals("") ? st : APICallUtil.getCorrespondantImport(st, thisClass) + "." + st, ss.method, ss.args));
                            added = true;
                        }
                        if (!added) continue;
                        added = false;
                        it.remove();
                        continue;
                    }
                    if (s.equals("super")) {
                        s = thisClass.extendedClass;
                    }
                    if (!APICallUtil.isPrimitiveType(s)) {
                        if (APICallUtil.isAndroidApi(s, thisClass)) {
                            m.androidApi.add(new MethodOfAPI(APICallUtil.getCorrespondantImport(s, thisClass).equals("") ? s : APICallUtil.getCorrespondantImport(s, thisClass) + "." + s, ss.method, ss.args));
                            it.remove();
                            continue;
                        }
                        if (APICallUtil.isJavaApi(s, thisClass)) {
                            m.javaApi.add(new MethodOfAPI(APICallUtil.getCorrespondantImport(s, thisClass).equals("") ? s : APICallUtil.getCorrespondantImport(s, thisClass) + "." + s, ss.method, ss.args));
                            it.remove();
                            continue;
                        }
                        m.externalApi.add(new MethodOfAPI(APICallUtil.getCorrespondantImport(s, thisClass).equals("") ? s : APICallUtil.getCorrespondantImport(s, thisClass) + "." + s, ss.method, ss.args));
                        it.remove();
                        continue;
                    }
                    it.remove();
                }
            }
        }
    }

    private static boolean isJavaApi(String s, ClassInfo thisClass) {
        return APICallUtil.getCorrespondantImport(s, thisClass).startsWith("java") || s.equals("Integer") || s.equals("Double") || s.equals("Byte") || s.equals("Short") || s.equals("Long") || s.equals("Float") || s.equals("Character") || s.equals("Boolean") || s.equals("String") || s.startsWith("System");
    }

    private static boolean isPrimitiveType(String s) {
        return s.equals("int") || s.equals("double") || s.equals("byte") || s.equals("short") || s.equals("long") || s.equals("float") || s.equals("char") || s.equals("boolean");
    }

    private static boolean isAndroidApi(String s, ClassInfo ci) {
        return APICallUtil.getCorrespondantImport(s, ci).startsWith("android") || APICallUtil.getCorrespondantImport(s, ci).startsWith("com.google.android") || APICallUtil.getCorrespondantImport(s, ci).startsWith("org.apache.http") || APICallUtil.getCorrespondantImport(s, ci).startsWith("org.xml") || APICallUtil.getCorrespondantImport(s, ci).startsWith("org.w3c.dom") || APICallUtil.getCorrespondantImport(s, ci).startsWith("com.android.internal") || APICallUtil.getCorrespondantImport(s, ci).startsWith("dalvik");
    }

    private static String getCorrespondantImport(String apiReference, ClassInfo ci) {
        String s = "";
        for (NameExpression importDec : ci.classImports) {
            if (!importDec.name.equals(apiReference)) continue;
            return importDec.qualifier;
        }
        return s;
    }

    public static Set<String> getClassesUsed(MethodDeclaration md) {
        ArrayList<String> list2 = new ArrayList<String>();
        for (Statement st : md.getBody().getStmts()) {
            if (!(st instanceof ExpressionStmt) || !(((ExpressionStmt)st).getExpression() instanceof MethodCallExpr) || ((MethodCallExpr)((ExpressionStmt)st).getExpression()).getScope() == null) continue;
            list2.add(((MethodCallExpr)((ExpressionStmt)st).getExpression()).getScope().toString());
        }
        return new HashSet<String>();
    }

    public MethodInfo getMethodOfClass(String method, String fullClassName) {
        MethodInfo m = new MethodInfo();
        for (ClassInfo ci : APICallUtil.proj.getCurrentApp().allJavaClasses) {
            String z2 = ci.getFullClassName();
            if (!ci.getFullClassName().equals(fullClassName) || ci.getMethod(method) == null) continue;
            return ci.getMethod(method);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serializeAPICallUtil(APICallUtil acu, String path2) {
        FileOutputStream fout = null;
        ObjectOutputStream oos = null;
        try {
            fout = new FileOutputStream(path2);
            oos = new ObjectOutputStream(fout);
            oos.writeObject(acu);
        }
        catch (Exception exception) {
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException iOException) {}
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static APICallUtil deserializeAPiCallUtil(String filename) {
        APICallUtil acu = null;
        FileInputStream fin = null;
        ObjectInputStream ois = null;
        try {
            fin = new FileInputStream(filename);
            ois = new ObjectInputStream(fin);
            acu = (APICallUtil)ois.readObject();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fin != null) {
                try {
                    fin.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return acu;
    }

    @Override
    public JSONObject toJSONObject(String requiredId) {
        return proj.toJSONObject(requiredId);
    }

    @Override
    public JSONSerializable fromJSONObject(JSONObject jo) {
        return new APICallUtil((ProjectInfo)proj.fromJSONObject(jo));
    }

    @Override
    public JSONObject fromJSONFile(String pathToJSONFile) {
        JSONObject jo = proj.fromJSONFile(pathToJSONFile);
        return jo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(proj.toString());
        return sb.toString();
    }

    @Override
    public void visit(MethodDeclaration n, Object arg) {
        MethodInfo mi = new MethodInfo();
        if (n.getParameters() != null) {
            for (Parameter m : n.getParameters()) {
                int isArray = m.getType() instanceof ReferenceType ? ((ReferenceType)m.getType()).getArrayCount() : 0;
                mi.args.add(new Variable(m.getId().getName(), m.getType().toStringWithoutComments(), isArray));
            }
        }
        mi.ci = processedClasses.get(String.valueOf(this.getRespectiveClass(n)));
        mi.methodName = n.getName();
        mi.setModifiers(n.getModifiers());
        mi.cyclomaticComplexity = CyclomaticCalculator.cyclomaticAndAPI(n, mi);
        try {
            mi.linesOfCode = n.getBody() != null ? SourceCodeLineCounter.getNumberOfLines(n.getBody().toStringWithoutComments()) - 2 : 0;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        mi.ci.classMethods.put(this.metId(n), mi);
        super.visit(n, arg);
    }

    private Node getRespectiveClass(Node n) {
        Node x;
        if (n instanceof MethodDeclaration && n.getParentNode() instanceof ObjectCreationExpr) {
            return (ObjectCreationExpr)n.getParentNode();
        }
        for (x = n.getParentNode(); x != null && !(x instanceof ClassOrInterfaceDeclaration); x = x.getParentNode()) {
        }
        return (ClassOrInterfaceDeclaration)x;
    }

    @Override
    public void visit(ObjectCreationExpr n, Object arg) {
        CompilationUnit cu = (CompilationUnit)arg;
        if (n.getAnonymousClassBody() != null) {
            ClassInfo thisClass = new ClassInfo(APICallUtil.proj.getCurrentApp().appID);
            thisClass.extendedClass = null;
            thisClass.outClass = ((ClassOrInterfaceDeclaration)this.getRespectiveClass(n.getParentNode())).getName();
            APICallUtil.proj.allPackagesOfProject.add(cu.getPackage().getName().toString());
            thisClass.classPackage = cu.getPackage().getName().toString();
            thisClass.className = n.getType().toStringWithoutComments();
            thisClass.isInterface = false;
            thisClass.setModifiers(4);
            if (cu.getImports() != null) {
                for (ImportDeclaration id : cu.getImports()) {
                    NameExpression ne = new NameExpression(((QualifiedNameExpr)id.getName()).getQualifier().toString(), ((QualifiedNameExpr)id.getName()).getName());
                    thisClass.classImports.add(ne);
                }
            }
            for (Node x : n.getChildrenNodes()) {
                if (!(x instanceof FieldDeclaration)) continue;
                for (VariableDeclarator vd : ((FieldDeclaration)x).getVariables()) {
                    Variable cv = new Variable();
                    cv.arrayCount = vd.getId().getArrayCount();
                    cv.type = ((FieldDeclaration)x).getType().toString();
                    cv.varName = vd.getId().getName();
                    cv.setModifiers(((FieldDeclaration)x).getModifiers());
                    thisClass.classVariables.put(cv.varName, cv);
                }
            }
            APICallUtil.proj.getCurrentApp().allJavaClasses.add(thisClass);
            processedClasses.put(String.valueOf(n.hashCode()), thisClass);
        }
        super.visit(n, arg);
    }

    @Override
    public void visit(ClassOrInterfaceDeclaration n, Object arg) {
        CompilationUnit cu = (CompilationUnit)arg;
        ClassInfo thisClass = new ClassInfo(APICallUtil.proj.getCurrentApp().appID);
        thisClass.extendedClass = n.getExtends() == null ? null : n.getExtends().get(0).getName();
        APICallUtil.proj.allPackagesOfProject.add(cu.getPackage().getName().toString());
        thisClass.classPackage = cu.getPackage().getName().toString();
        thisClass.className = n.getName();
        thisClass.isInterface = n.isInterface();
        thisClass.setModifiers(n.getModifiers());
        if (cu.getImports() != null) {
            for (ImportDeclaration importDeclaration : cu.getImports()) {
                NameExpression ne = new NameExpression(((QualifiedNameExpr)importDeclaration.getName()).getQualifier().toString(), ((QualifiedNameExpr)importDeclaration.getName()).getName());
                thisClass.classImports.add(ne);
            }
        }
        if (n.getImplements() != null) {
            String ifaceDef = "";
            for (ClassOrInterfaceType cit : n.getImplements()) {
                if (cit.getScope() != null) {
                    ifaceDef = APICallUtil.getCorrespondantImport(cit.getScope().toStringWithoutComments(), thisClass);
                }
                thisClass.interfacesImplemented.add(ifaceDef + "." + cit.getName());
            }
        }
        for (Node node : n.getChildrenNodes()) {
            if (!(node instanceof FieldDeclaration)) continue;
            for (VariableDeclarator vd : ((FieldDeclaration)node).getVariables()) {
                Variable cv = new Variable();
                cv.arrayCount = vd.getId().getArrayCount();
                cv.type = ((FieldDeclaration)node).getType().toString();
                cv.varName = vd.getId().getName();
                cv.setModifiers(((FieldDeclaration)node).getModifiers());
                thisClass.classVariables.put(cv.varName, cv);
            }
        }
        APICallUtil.proj.getCurrentApp().allJavaClasses.add(thisClass);
        processedClasses.put(String.valueOf(n.hashCode()), thisClass);
        super.visit(n, arg);
    }
}

