"use strict";
/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
// Imports
const aws_cdk_lib_1 = require("aws-cdk-lib");
const lib_1 = require("../lib");
const kms = require("aws-cdk-lib/aws-kms");
const s3 = require("aws-cdk-lib/aws-s3");
const core_1 = require("@aws-solutions-constructs/core");
const defaults = require("@aws-solutions-constructs/core");
// Setup
const app = new aws_cdk_lib_1.App();
const stack = new aws_cdk_lib_1.Stack(app, core_1.generateIntegStackName(__filename));
stack.templateOptions.description = 'Integration Test for aws-s3-sqs with standard Queue';
// For S3 to SQS bucket notification a customer managed CMK must be used:
const encryptionKeyProps = {
    enableKeyRotation: true
};
const kmsKey = new kms.Key(stack, 'ImportedEncryptionKey', encryptionKeyProps);
// Configure notification filter
const filter = {
    prefix: 'the/place',
    suffix: '*.mp3'
};
// Define construct properties so that a new queue myQueue is created
const props = {
    queueProps: {
        queueName: `myQueue`,
        encryptionMasterKey: kmsKey
    },
    deadLetterQueueProps: {
        queueName: `myDLQueue`
    },
    s3EventTypes: [s3.EventType.OBJECT_REMOVED],
    s3EventFilters: [filter],
    bucketProps: {
        removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
    },
    logS3AccessLogs: false
};
const construct = new lib_1.S3ToSqs(stack, 'test-s3-sqs', props);
const s3Bucket = construct.s3Bucket;
defaults.addCfnSuppressRules(s3Bucket, [
    { id: 'W35',
        reason: 'This S3 bucket is created for unit/ integration testing purposes only.' },
]);
// Synth
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuY3JlYXRpbmdOZXdRdWV1ZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImludGVnLmNyZWF0aW5nTmV3UXVldWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBOzs7Ozs7Ozs7OztHQVdHOztBQUVILFVBQVU7QUFDViw2Q0FBd0Q7QUFDeEQsZ0NBQStDO0FBQy9DLDJDQUEyQztBQUMzQyx5Q0FBeUM7QUFDekMseURBQXdFO0FBQ3hFLDJEQUEyRDtBQUUzRCxRQUFRO0FBQ1IsTUFBTSxHQUFHLEdBQUcsSUFBSSxpQkFBRyxFQUFFLENBQUM7QUFDdEIsTUFBTSxLQUFLLEdBQUcsSUFBSSxtQkFBSyxDQUFDLEdBQUcsRUFBRSw2QkFBc0IsQ0FBQyxVQUFVLENBQUMsQ0FBQyxDQUFDO0FBQ2pFLEtBQUssQ0FBQyxlQUFlLENBQUMsV0FBVyxHQUFHLHFEQUFxRCxDQUFDO0FBRTFGLHlFQUF5RTtBQUN6RSxNQUFNLGtCQUFrQixHQUFpQjtJQUN2QyxpQkFBaUIsRUFBRSxJQUFJO0NBQ3hCLENBQUM7QUFDRixNQUFNLE1BQU0sR0FBRyxJQUFJLEdBQUcsQ0FBQyxHQUFHLENBQUMsS0FBSyxFQUFFLHVCQUF1QixFQUFFLGtCQUFrQixDQUFDLENBQUM7QUFFL0UsZ0NBQWdDO0FBQ2hDLE1BQU0sTUFBTSxHQUE2QjtJQUN2QyxNQUFNLEVBQUUsV0FBVztJQUNuQixNQUFNLEVBQUUsT0FBTztDQUNoQixDQUFDO0FBRUYscUVBQXFFO0FBQ3JFLE1BQU0sS0FBSyxHQUFpQjtJQUMxQixVQUFVLEVBQUU7UUFDVixTQUFTLEVBQUUsU0FBUztRQUNwQixtQkFBbUIsRUFBRSxNQUFNO0tBQzVCO0lBQ0Qsb0JBQW9CLEVBQUU7UUFDcEIsU0FBUyxFQUFFLFdBQVc7S0FDdkI7SUFDRCxZQUFZLEVBQUUsQ0FBQyxFQUFFLENBQUMsU0FBUyxDQUFDLGNBQWMsQ0FBQztJQUMzQyxjQUFjLEVBQUUsQ0FBQyxNQUFNLENBQUM7SUFDeEIsV0FBVyxFQUFFO1FBQ1gsYUFBYSxFQUFFLDJCQUFhLENBQUMsT0FBTztLQUNyQztJQUNELGVBQWUsRUFBRSxLQUFLO0NBQ3ZCLENBQUM7QUFFRixNQUFNLFNBQVMsR0FBRyxJQUFJLGFBQU8sQ0FBQyxLQUFLLEVBQUUsYUFBYSxFQUFFLEtBQUssQ0FBQyxDQUFDO0FBQzNELE1BQU0sUUFBUSxHQUFHLFNBQVMsQ0FBQyxRQUFxQixDQUFDO0FBRWpELFFBQVEsQ0FBQyxtQkFBbUIsQ0FBQyxRQUFRLEVBQUU7SUFDckMsRUFBRSxFQUFFLEVBQUUsS0FBSztRQUNULE1BQU0sRUFBRSx3RUFBd0UsRUFBRTtDQUNyRixDQUFDLENBQUM7QUFFSCxRQUFRO0FBQ1IsR0FBRyxDQUFDLEtBQUssRUFBRSxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiAgQ29weXJpZ2h0IDIwMjIgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiAgTGljZW5zZWQgdW5kZXIgdGhlIEFwYWNoZSBMaWNlbnNlLCBWZXJzaW9uIDIuMCAodGhlIFwiTGljZW5zZVwiKS4gWW91IG1heSBub3QgdXNlIHRoaXMgZmlsZSBleGNlcHQgaW4gY29tcGxpYW5jZVxuICogIHdpdGggdGhlIExpY2Vuc2UuIEEgY29weSBvZiB0aGUgTGljZW5zZSBpcyBsb2NhdGVkIGF0XG4gKlxuICogICAgICBodHRwOi8vd3d3LmFwYWNoZS5vcmcvbGljZW5zZXMvTElDRU5TRS0yLjBcbiAqXG4gKiAgb3IgaW4gdGhlICdsaWNlbnNlJyBmaWxlIGFjY29tcGFueWluZyB0aGlzIGZpbGUuIFRoaXMgZmlsZSBpcyBkaXN0cmlidXRlZCBvbiBhbiAnQVMgSVMnIEJBU0lTLCBXSVRIT1VUIFdBUlJBTlRJRVNcbiAqICBPUiBDT05ESVRJT05TIE9GIEFOWSBLSU5ELCBleHByZXNzIG9yIGltcGxpZWQuIFNlZSB0aGUgTGljZW5zZSBmb3IgdGhlIHNwZWNpZmljIGxhbmd1YWdlIGdvdmVybmluZyBwZXJtaXNzaW9uc1xuICogIGFuZCBsaW1pdGF0aW9ucyB1bmRlciB0aGUgTGljZW5zZS5cbiAqL1xuXG4vLyBJbXBvcnRzXG5pbXBvcnQgeyBBcHAsIFN0YWNrLCBSZW1vdmFsUG9saWN5IH0gZnJvbSBcImF3cy1jZGstbGliXCI7XG5pbXBvcnQgeyBTM1RvU3FzLCBTM1RvU3FzUHJvcHMgfSBmcm9tIFwiLi4vbGliXCI7XG5pbXBvcnQgKiBhcyBrbXMgZnJvbSAnYXdzLWNkay1saWIvYXdzLWttcyc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdhd3MtY2RrLWxpYi9hd3MtczMnO1xuaW1wb3J0IHsgZ2VuZXJhdGVJbnRlZ1N0YWNrTmFtZSB9IGZyb20gJ0Bhd3Mtc29sdXRpb25zLWNvbnN0cnVjdHMvY29yZSc7XG5pbXBvcnQgKiBhcyBkZWZhdWx0cyBmcm9tICdAYXdzLXNvbHV0aW9ucy1jb25zdHJ1Y3RzL2NvcmUnO1xuXG4vLyBTZXR1cFxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuY29uc3Qgc3RhY2sgPSBuZXcgU3RhY2soYXBwLCBnZW5lcmF0ZUludGVnU3RhY2tOYW1lKF9fZmlsZW5hbWUpKTtcbnN0YWNrLnRlbXBsYXRlT3B0aW9ucy5kZXNjcmlwdGlvbiA9ICdJbnRlZ3JhdGlvbiBUZXN0IGZvciBhd3MtczMtc3FzIHdpdGggc3RhbmRhcmQgUXVldWUnO1xuXG4vLyBGb3IgUzMgdG8gU1FTIGJ1Y2tldCBub3RpZmljYXRpb24gYSBjdXN0b21lciBtYW5hZ2VkIENNSyBtdXN0IGJlIHVzZWQ6XG5jb25zdCBlbmNyeXB0aW9uS2V5UHJvcHM6IGttcy5LZXlQcm9wcyA9IHtcbiAgZW5hYmxlS2V5Um90YXRpb246IHRydWVcbn07XG5jb25zdCBrbXNLZXkgPSBuZXcga21zLktleShzdGFjaywgJ0ltcG9ydGVkRW5jcnlwdGlvbktleScsIGVuY3J5cHRpb25LZXlQcm9wcyk7XG5cbi8vIENvbmZpZ3VyZSBub3RpZmljYXRpb24gZmlsdGVyXG5jb25zdCBmaWx0ZXI6IHMzLk5vdGlmaWNhdGlvbktleUZpbHRlciA9IHtcbiAgcHJlZml4OiAndGhlL3BsYWNlJyxcbiAgc3VmZml4OiAnKi5tcDMnXG59O1xuXG4vLyBEZWZpbmUgY29uc3RydWN0IHByb3BlcnRpZXMgc28gdGhhdCBhIG5ldyBxdWV1ZSBteVF1ZXVlIGlzIGNyZWF0ZWRcbmNvbnN0IHByb3BzOiBTM1RvU3FzUHJvcHMgPSB7XG4gIHF1ZXVlUHJvcHM6IHtcbiAgICBxdWV1ZU5hbWU6IGBteVF1ZXVlYCxcbiAgICBlbmNyeXB0aW9uTWFzdGVyS2V5OiBrbXNLZXlcbiAgfSxcbiAgZGVhZExldHRlclF1ZXVlUHJvcHM6IHtcbiAgICBxdWV1ZU5hbWU6IGBteURMUXVldWVgXG4gIH0sXG4gIHMzRXZlbnRUeXBlczogW3MzLkV2ZW50VHlwZS5PQkpFQ1RfUkVNT1ZFRF0sXG4gIHMzRXZlbnRGaWx0ZXJzOiBbZmlsdGVyXSxcbiAgYnVja2V0UHJvcHM6IHtcbiAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gIH0sXG4gIGxvZ1MzQWNjZXNzTG9nczogZmFsc2Vcbn07XG5cbmNvbnN0IGNvbnN0cnVjdCA9IG5ldyBTM1RvU3FzKHN0YWNrLCAndGVzdC1zMy1zcXMnLCBwcm9wcyk7XG5jb25zdCBzM0J1Y2tldCA9IGNvbnN0cnVjdC5zM0J1Y2tldCBhcyBzMy5CdWNrZXQ7XG5cbmRlZmF1bHRzLmFkZENmblN1cHByZXNzUnVsZXMoczNCdWNrZXQsIFtcbiAgeyBpZDogJ1czNScsXG4gICAgcmVhc29uOiAnVGhpcyBTMyBidWNrZXQgaXMgY3JlYXRlZCBmb3IgdW5pdC8gaW50ZWdyYXRpb24gdGVzdGluZyBwdXJwb3NlcyBvbmx5LicgfSxcbl0pO1xuXG4vLyBTeW50aFxuYXBwLnN5bnRoKCk7XG4iXX0=