# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['lmproof']

package_data = \
{'': ['*'], 'lmproof': ['resources/*']}

install_requires = \
['lemminflect>=0.2.0',
 'spacy>=2.0',
 'symspellpy>=6.0',
 'torch>=1.2.0',
 'transformers>=2.0']

extras_require = \
{':python_version >= "3.6" and python_version < "3.7"': ['dataclasses>=0.7']}

setup_kwargs = {
    'name': 'lmproof',
    'version': '0.2.1',
    'description': 'Language model powered proof reader for correcting contextual errors in natural language.',
    'long_description': '## lmproof - Language Model Proof Reader\n\nLibrary to do proof-reading corrections for Grammatical Errors, spelling errors, confused word errors and other errors using pre-trained Language Models.\n\n## Usage\nInstall spacy model by `python -m spacy download en`.\nThen try out this snippet.\n\n``` python\nimport lmproof\nproof_reader = lmproof.load("en")\nsource = "The foxes living on the Shire is brown.\'"\ncorrected = proof_reader.proofread(source) # "The foxes living in the Shire are brown."\n```\n\n## How it works?\n\nWe use the language model based scoring approach mentioned in [Christopher Bryant and Ted Briscoe. 2018](http://aclweb.org/anthology/W18-0529) with few changes.\n\nUnlike many approaches to GEC, this approach does NOT require annotated training data and mainly depends on a monolingual language model. The program works by iteratively comparing certain words in a text against alternative candidates and applying a correction if one of these candidates is more probable than the original word. These correction candidates are variously generated by a word inflection library or are otherwise defined manually. Currently, this system only corrects:\n\n    Non-words (e.g. freind and informations)\n    Morphology (e.g. eat, ate, eaten, eating, etc.)\n    Common Determiners and Prepositions (e.g. the, a, in, at, to, etc.)\n    Commonly Confused Words (e.g. bear/bare, lose/loose, etc.)\n\nThis work builds upon https://github.com/chrisjbryant/lmgec-lite/\n\n## Components\n\n### Language Models\n* [transformers](https://github.com/huggingface/transformers)\n### Inflection generators\n* [LemmInflect](https://github.com/bjascob/LemmInflect) is used to lemmatize and generate inflections for candidate proposals to the language model.\n### Spell Checker\n* [symspellpy](https://github.com/mammothb/symspellpy) is used for obtaining spell check candidates.\n\nThe components are highly modularised to facilitate experimentation with newer scorers and support more languages.\nPre-trained language models for other languages, inflectors, common error patterns can be easily added to support more languages.\n\n## TODOs\n\n* Use edits in existing GEC corpus to generate candidates.\n* Tests\n* Publish benchmarks of the model.\n* Think of simple ways to generate insertion candidates.\n* Add more languages.\n',
    'author': 'sai-prasanna',
    'author_email': 'sai.r.prasanna@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sai-prasanna/lmproof',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.6',
}


setup(**setup_kwargs)
