# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2018-05-25 08:00
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ContentType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('app_label', models.CharField(max_length=180, verbose_name='app\u540d')),
                ('model', models.CharField(max_length=180, verbose_name='\u6a21\u5757\u540d')),
                ('user_field', models.CharField(max_length=180, verbose_name='\u7528\u6237\u5b57\u6bb5\u540d')),
                ('info', models.CharField(max_length=180, null=True, verbose_name='\u5907\u6ce8')),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'bee_django_mission_content_type',
            },
        ),
        migrations.CreateModel(
            name='Line',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, verbose_name='\u6807\u9898')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('line_type', models.IntegerField(choices=[(1, '\u957f\u671f\u4efb\u52a1'), (2, '\u5468\u4efb\u52a1')], default=0)),
                ('auto_finish', models.BooleanField(default=True, verbose_name='\u662f\u5426\u81ea\u52a8\u5b8c\u6210')),
                ('auto_start', models.BooleanField(default=True, verbose_name='\u662f\u5426\u81ea\u52a8\u5f00\u542f\u4e0b\u4e00\u4e2a')),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'bee_django_mission_line',
                'verbose_name': '\u4efb\u52a1\u7ebf',
            },
        ),
        migrations.CreateModel(
            name='Mission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, verbose_name='\u6807\u9898')),
                ('count', models.IntegerField(verbose_name='\u6570\u91cf')),
                ('info', models.TextField(blank=True, null=True, verbose_name='\u5907\u6ce8')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('order_by', models.IntegerField(blank=True, null=True, verbose_name='\u987a\u5e8f')),
            ],
            options={
                'ordering': ['created_at'],
                'db_table': 'bee_django_mission',
                'verbose_name': '\u4efb\u52a1',
            },
        ),
        migrations.CreateModel(
            name='MissionType',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, unique=True, verbose_name='\u6807\u9898')),
                ('aggregate_type', models.IntegerField(choices=[(1, 'Count'), (2, 'Sum'), (3, 'TruncDay')], default=1, verbose_name='\u805a\u5408\u7c7b\u578b')),
                ('field_name', models.CharField(default='id', max_length=180, verbose_name='\u53d6\u503c\u5b57\u6bb5\u540d')),
                ('timestamp_field', models.CharField(blank=True, max_length=180, null=True, verbose_name='\u65f6\u95f4\u5b57\u6bb5\u540d')),
                ('comparison_type', models.IntegerField(choices=[(1, '>='), (2, '>')], default=1, verbose_name='\u6bd4\u8f83\u7c7b\u578b')),
                ('operator_type', models.IntegerField(choices=[(0, '\u65e0'), (1, '* 60')], default=0, verbose_name='\u5bf9\u503c\u8fd0\u7b97')),
                ('conditions', models.TextField(blank=True, help_text='\u683c\u5f0f\u4e3a\uff1a[\u6761\u4ef61\uff1a\u503c1\uff0c\u6761\u4ef62\uff1a\u503c2]\uff0c\u591a\u4e2a\u6761\u4ef6\u7528,\u5206\u5272', null=True, verbose_name='\u5176\u4ed6\u9644\u52a0\u6761\u4ef6')),
                ('link_url', models.CharField(blank=True, max_length=180, null=True, verbose_name='\u94fe\u63a5\u5730\u5740')),
                ('link_name', models.CharField(blank=True, max_length=180, null=True, verbose_name='\u94fe\u63a5\u540d\u5b57')),
                ('content_type', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='bee_django_mission.ContentType', verbose_name='app\u53camodel')),
            ],
            options={
                'ordering': ['id'],
                'db_table': 'bee_django_mission_type',
                'verbose_name': '\u4efb\u52a1\u7c7b\u578b',
            },
        ),
        migrations.CreateModel(
            name='Stage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('level', models.IntegerField(null=True, verbose_name='\u9636\u6bb5')),
                ('name', models.CharField(max_length=180, verbose_name='\u6807\u9898')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('line', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='bee_django_mission.Line')),
            ],
            options={
                'ordering': ['level'],
                'db_table': 'bee_django_mission_stage',
                'verbose_name': '\u9636\u6bb5\u4efb\u52a1',
            },
        ),
        migrations.CreateModel(
            name='UserLine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('start_at', models.DateTimeField(auto_now_add=True)),
                ('finish_at', models.DateTimeField(null=True)),
                ('line', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_mission.Line')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'ordering': ['start_at'],
                'db_table': 'bee_django_mission_user_line',
                'verbose_name': '\u5b66\u751f\u4efb\u52a1\u7ebf',
            },
        ),
        migrations.CreateModel(
            name='UserMission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('custom_name', models.CharField(blank=True, max_length=180, null=True, verbose_name='\u81ea\u5b9a\u4e49\u540d\u5b57')),
                ('custom_count', models.IntegerField(blank=True, null=True, verbose_name='\u81ea\u5b9a\u4e49\u6570\u91cf')),
                ('finish_at', models.DateTimeField(null=True)),
                ('mission', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_mission.Mission')),
            ],
            options={
                'ordering': ['finish_at'],
                'db_table': 'bee_django_mission_user_mission',
                'verbose_name': '\u5b66\u751f\u7684\u4efb\u52a1',
            },
        ),
        migrations.CreateModel(
            name='UserStage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=180, null=True, verbose_name='\u6807\u9898')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='\u6dfb\u52a0\u65f6\u95f4')),
                ('start_at', models.DateTimeField(default=django.utils.timezone.now, verbose_name='\u5f00\u59cb\u65f6\u95f4')),
                ('finish_at', models.DateTimeField(null=True, verbose_name='\u5b8c\u6210\u65f6\u95f4')),
                ('end_at', models.DateTimeField(null=True, verbose_name='\u7ed3\u675f\u65f6\u95f4')),
                ('stage', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_mission.Stage')),
                ('user_line', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_mission.UserLine')),
            ],
            options={
                'ordering': ['start_at'],
                'db_table': 'bee_django_mission_user_stage',
                'verbose_name': '\u5b66\u751f\u9636\u6bb5\u4efb\u52a1',
            },
        ),
        migrations.AddField(
            model_name='usermission',
            name='user_stage',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='bee_django_mission.UserStage'),
        ),
        migrations.AddField(
            model_name='mission',
            name='mission_type',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='bee_django_mission.MissionType'),
        ),
        migrations.AddField(
            model_name='mission',
            name='stage',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='bee_django_mission.Stage'),
        ),
        migrations.AlterUniqueTogether(
            name='contenttype',
            unique_together=set([('app_label', 'model')]),
        ),
        migrations.AlterUniqueTogether(
            name='stage',
            unique_together=set([('line', 'level')]),
        ),
    ]
