#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['svgis']

package_data = \
{'': ['*']}

install_requires = \
['six>=1.7.3,<2',
 'click>=6.2,<8',
 'pyproj>=2.6',
 'fiona>=1.8',
 'tinycss2>=1.0.2',
 'utm>=0.4.0,<1',
 'cssselect>=1.1.0',
 'lxml>=4.5.0']

extras_require = \
{'clip': ['shapely>=1.5.7'],
 'dev': ['coverage[toml]'],
 'doc': ['sphinx', 'sphinx-rtd-theme'],
 'numpy': ['numpy'],
 'simplify': ['visvalingamwyatt>=0.1.1']}

entry_points = \
{'console_scripts': ['svgis = svgis.cli:main']}

setup(name='svgis',
      version='0.5.0',
      description='Create SVG drawings from vector geodata files (SHP, geoJSON, etc).',
      author='Neil Freeman',
      author_email='contact@fakeisthenewreal.org',
      url='https://github.com/fitnr/svgis',
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      entry_points=entry_points,
     )
